/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.chart.ChartColor;
import com.scudata.chart.Utils;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.resources.EngineMessage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class DrawPie
extends DrawBase {
    public void draw(StringBuffer htmlLink) {
        DrawPie.drawing(this, htmlLink);
    }

    public static void drawing(DrawBase db, StringBuffer htmlLink) {
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        double radiusx = 0.0;
        double radiusy = 0.0;
        gp.coorWidth = 0;
        gp.pieHeight = 0;
        gp.pieRotation = 100;
        db.initGraphInset();
        if (gp.minValue < 0.0) {
            g.setColor(Color.black);
            g.setFont(gp.GFV_TITLE.font);
            MessageManager mm = EngineMessage.get();
            g.drawString(mm.getMessage("drawpie.negativedata", gp.minValue), 50, 50);
            return;
        }
        if (gp.pieHeight > 100) {
            gp.pieHeight = 100;
        }
        if (gp.pieHeight < 0) {
            gp.pieHeight = 0;
        }
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        gp.gRect2 = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        gp.gRect1 = (Rectangle2D.Double)gp.gRect2.clone();
        db.keepGraphSpace();
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return;
        }
        radiusx = gp.serNum == 0 ? gp.graphRect.width / 2.0 : gp.graphRect.width / (double)(2 * gp.serNum);
        radiusy = gp.graphRect.height / ((double)(2 * gp.serNum) + (double)gp.pieHeight / 100.0);
        if (gp.pieRotation < 10) {
            gp.pieRotation = 10;
        }
        if (gp.pieRotation > 100) {
            gp.pieRotation = 100;
        }
        if (radiusx * ((double)gp.pieRotation / 100.0) > radiusy) {
            radiusx = radiusy / ((double)gp.pieRotation / 100.0);
        } else {
            radiusy = radiusx * (double)gp.pieRotation / 100.0;
        }
        double dely = radiusy * ((double)gp.pieHeight / 100.0);
        double tmpInt1 = radiusx * (double)(2 * gp.serNum);
        double tmpInt2 = radiusy * (double)(2 * gp.serNum) + radiusy * ((double)gp.pieHeight / 100.0);
        gp.graphRect = new Rectangle2D.Double(gp.graphRect.x + (gp.graphRect.width - tmpInt1) / 2.0, gp.graphRect.y + (gp.graphRect.height - tmpInt2) / 2.0, tmpInt1, tmpInt2);
        double orgx = gp.graphRect.x + gp.graphRect.width / 2.0;
        double orgy = gp.graphRect.y + dely + (gp.graphRect.height - dely) / 2.0;
        boolean cut = gp.serNum == 1 && egp.isCutPie();
        for (int j = 0; j < gp.serNum; ++j) {
            int i;
            double y;
            double x;
            double angle;
            double amount;
            ExtGraphSery egs;
            String serName = (String)gp.serNames.get(j);
            double totAmount = 0.0;
            double totAngle = 0.0;
            double radx = (double)(gp.serNum - j) * radiusx;
            double rady = (double)(gp.serNum - j) * radiusy;
            double w = 2.0 * radx;
            double h = 2.0 * rady;
            double rxx = (double)(gp.serNum - j - 1) * radiusx;
            double ryy = (double)(gp.serNum - j - 1) * radiusy;
            double ww = 2.0 * rxx;
            double hh = 2.0 * ryy;
            double max = 0.0;
            double maxi = -1.0;
            double maxX = 0.0;
            double maxY = 0.0;
            ExtGraphCategory maxEgc = null;
            ExtGraphSery maxEgs = null;
            double maxAngle = 0.0;
            double movex = 0.0;
            double movey = 0.0;
            ArrayList cats = egp.categories;
            int cc = cats.size();
            for (int i2 = 0; i2 < cc; ++i2) {
                ExtGraphCategory egc = (ExtGraphCategory)cats.get(i2);
                ExtGraphSery egs2 = egc.getExtGraphSery(serName);
                double amount2 = egs2.getValue();
                if (amount2 > max) {
                    max = amount2;
                    maxi = i2;
                }
                totAmount += amount2;
            }
            if (totAmount == 0.0) continue;
            totAngle = 0.0;
            double cumulativeAmount = 0.0;
            if (egp.isDrawShade()) {
                for (int i3 = 0; i3 < cc; ++i3) {
                    ExtGraphCategory egc = (ExtGraphCategory)cats.get(i3);
                    egs = egc.getExtGraphSery(serName);
                    amount = 0.0;
                    angle = 0.0;
                    amount = egs.getValue();
                    angle = 360.0 * amount / totAmount;
                    if (i3 == gp.catNum - 1) {
                        angle = 360.0 - totAngle;
                    }
                    if (cut && maxi == (double)i3) {
                        movex = 20.0 * Math.cos(Math.toRadians(totAngle + angle / 2.0));
                        movey = -20.0 * Math.sin(Math.toRadians(totAngle + angle / 2.0));
                    } else {
                        movex = 0.0;
                        movey = 0.0;
                    }
                    x = orgx - radx + movex;
                    y = orgy - rady - dely + movey;
                    g.setColor(Color.lightGray);
                    Arc2D.Double ddd = new Arc2D.Double(x + (double)db.SHADE_SPAN, y + (double)db.SHADE_SPAN, w, h, totAngle, angle, 2);
                    g.fill(ddd);
                    totAngle += angle;
                }
            }
            totAngle = 0.0;
            cumulativeAmount = 0.0;
            for (i = 0; i < cc; ++i) {
                ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
                egs = egc.getExtGraphSery(serName);
                amount = 0.0;
                angle = 0.0;
                amount = egs.getValue();
                angle = 360.0 * amount / totAmount;
                if (i == gp.catNum - 1) {
                    angle = 360.0 - totAngle;
                }
                if (cut && maxi == (double)i) {
                    movex = 20.0 * Math.cos(Math.toRadians(totAngle + angle / 2.0));
                    movey = -20.0 * Math.sin(Math.toRadians(totAngle + angle / 2.0));
                } else {
                    movex = 0.0;
                    movey = 0.0;
                }
                x = orgx - radx + movex;
                y = orgy - rady - dely + movey;
                Color bc = egp.getAxisColor(0);
                int bs = 1;
                float bw = 1.0f;
                Color c = db.getColor(i);
                ChartColor tmpc = db.getChartColor(c);
                int dazzelCount = j != gp.serNum - 1 || gp.serNum > 1 ? 2 : 8;
                Rectangle2D.Double ellipseBounds = new Rectangle2D.Double(x, y, w, h);
                Utils.draw2DPie(g, ellipseBounds, totAngle, angle, bc, bs, bw, db.getTransparent(), tmpc, dazzelCount);
                Arc2D.Double ddd = new Arc2D.Double(x, y, w, h, totAngle, angle, 2);
                double xx = orgx - rxx + movex;
                double yy = orgy - ryy - dely + movey;
                Arc2D.Double ddd2 = null;
                if (ww != 0.0) {
                    ddd2 = new Arc2D.Double(xx, yy, ww, hh, totAngle, angle, 2);
                }
                db.htmlLink(ddd, htmlLink, egc.getNameString(), egs, ddd2);
                totAngle += angle;
            }
            totAngle = 0.0;
            for (i = 0; i < cc; ++i) {
                ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
                egs = egc.getExtGraphSery(serName);
                amount = 0.0;
                angle = 0.0;
                amount = egs.getValue();
                angle = 360.0 * amount / totAmount;
                if (i == gp.catNum - 1) {
                    angle = 360.0 - totAngle;
                }
                if (cut && maxi == (double)i) {
                    movex = 20.0 * Math.cos(Math.toRadians(totAngle + angle / 2.0));
                    movey = -20.0 * Math.sin(Math.toRadians(totAngle + angle / 2.0));
                } else {
                    movex = 0.0;
                    movey = 0.0;
                }
                if (gp.serNum == 1) {
                    double shiftx;
                    double tAngle = Math.toRadians(totAngle + angle / 2.0);
                    double x1 = orgx + (double)Math.round(radx * Math.cos(tAngle)) + movex;
                    double y1 = orgy - (double)Math.round(rady * Math.sin(tAngle)) + movey;
                    double shifty = shiftx = radx * (double)((float)gp.pieLine / 100.0f);
                    if (shiftx < 5.0) {
                        shiftx = 5.0;
                    }
                    if (shifty < 5.0) {
                        shifty = 5.0;
                    }
                    double x2 = orgx + (double)Math.round((radx + shiftx) * Math.cos(tAngle)) + movex;
                    double y2 = orgy - (double)Math.round((rady + shifty) * Math.sin(tAngle)) + movey;
                    g.setColor(gp.coorColor);
                    String text = "";
                    double tmpAngle = totAngle + angle / 2.0;
                    db.g.setStroke(new BasicStroke());
                    switch (gp.dispValueType) {
                        case 1: {
                            text = "";
                            break;
                        }
                        case 2: 
                        case 5: {
                            String fmt = StringUtils.isValidString(gp.dataMarkFormat) ? gp.dataMarkFormat : "";
                            db.drawLine(x1, y1, x2, y2, egp.getAxisColor(6));
                            text = db.getFormattedValue(amount, fmt);
                            if (gp.dispValueType != 5) break;
                            text = DrawPie.getDispName(egc, egs, gp.serNum) + "," + text;
                            break;
                        }
                        case 4: {
                            db.drawLine(x1, y1, x2, y2, egp.getAxisColor(6));
                            text = egs.getTips();
                            break;
                        }
                        default: {
                            String fmt;
                            db.drawLine(x1, y1, x2, y2, egp.getAxisColor(6));
                            if ((double)i != maxi) {
                                fmt = StringUtils.isValidString(gp.dataMarkFormat) ? gp.dataMarkFormat : "0.00%";
                                text = db.getFormattedValue(amount / totAmount, fmt);
                                String tmp = text.substring(0, text.length() - 1);
                                if (tmp.equals(".") || !StringUtils.isValidString(tmp)) {
                                    tmp = "0";
                                }
                                cumulativeAmount += Double.parseDouble(tmp);
                                if (gp.dispValueType != 6) break;
                                text = DrawPie.getDispName(egc, egs, gp.serNum) + "," + text;
                                break;
                            }
                            maxAngle = tmpAngle;
                            maxEgc = egc;
                            maxEgs = egs;
                            maxX = x2;
                            maxY = y2;
                        }
                    }
                    db.drawOutCircleText(gp.GFV_VALUE, text, tmpAngle, x2, y2);
                }
                totAngle += angle;
            }
            if (gp.serNum > 1) {
                int angle2 = Math.round(360 / gp.serNum) * j;
                double tAngle = Math.toRadians(angle2);
                g.setColor(gp.coorColor);
                double x1 = orgx + (double)Math.round((radx - radiusx / 2.0) * Math.cos(tAngle));
                double y1 = orgy - (double)Math.round((rady - radiusy / 2.0) * Math.sin(tAngle));
                double x2 = orgx + (double)Math.round((radiusx * (double)gp.serNum + 5.0) * Math.cos(tAngle));
                double y2 = orgy - (double)Math.round((radiusy * (double)gp.serNum + 5.0) * Math.sin(tAngle));
                db.drawLine(x1, y1, x2, y2, egp.getAxisColor(6));
                db.drawOutCircleText(gp.GFV_XLABEL, serName, angle2, x2, y2);
            } else if (gp.dispValueType == 3 || gp.dispValueType == 6) {
                String fmt = StringUtils.isValidString(gp.dataMarkFormat) ? gp.dataMarkFormat : "0.00%";
                String text = db.getFormattedValue((100.0 - cumulativeAmount) / 100.0, fmt);
                if (gp.dispValueType == 6) {
                    text = DrawPie.getDispName(maxEgc, maxEgs, gp.serNum) + "," + text;
                }
                db.drawOutCircleText(gp.GFV_VALUE, text, maxAngle, maxX, maxY);
            }
            orgy -= dely;
        }
        db.outLabels();
    }
}

