/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.chart.ChartColor;
import com.scudata.chart.CubeColor;
import com.scudata.chart.Utils;
import com.scudata.common.MessageManager;
import com.scudata.common.StringUtils;
import com.scudata.resources.EngineMessage;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class DrawPie3DObj
extends DrawBase {
    private static Color _$10;
    private static int _$9;

    public void draw(StringBuffer htmlLink) {
        DrawPie3DObj.drawing(this, htmlLink);
    }

    public static void drawing(DrawBase db, StringBuffer htmlLink) {
        boolean cut;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        double radiusx = 0.0;
        double radiusy = 0.0;
        gp.coorWidth = 0;
        _$10 = egp.getAxisColor(5);
        db.initGraphInset();
        if (gp.minValue < 0.0) {
            g.setColor(Color.black);
            g.setFont(gp.GFV_TITLE.font);
            MessageManager mm = EngineMessage.get();
            g.drawString(mm.getMessage("drawpie.negativedata", gp.minValue), 50, 50);
            return;
        }
        if (gp.pieHeight > 100) {
            gp.pieHeight = 100;
        }
        if (gp.pieHeight < 0) {
            gp.pieHeight = 0;
        }
        db.drawLegend(htmlLink);
        db.drawTitle();
        db.drawLabel();
        gp.gRect2 = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        gp.gRect1 = (Rectangle2D.Double)gp.gRect2.clone();
        db.keepGraphSpace();
        gp.graphRect = new Rectangle2D.Double(gp.leftInset, gp.topInset, gp.graphWidth - gp.leftInset - gp.rightInset, gp.graphHeight - gp.topInset - gp.bottomInset);
        if (gp.graphRect.width < 10.0 || gp.graphRect.height < 10.0) {
            return;
        }
        radiusx = gp.serNum == 0 ? gp.graphRect.width / 2.0 : gp.graphRect.width / (double)(2 * gp.serNum);
        radiusy = gp.graphRect.height / ((double)(2 * gp.serNum) + (double)gp.pieHeight / 100.0);
        if (gp.pieRotation < 10) {
            gp.pieRotation = 10;
        }
        if (gp.pieRotation > 100) {
            gp.pieRotation = 100;
        }
        if (radiusx * ((double)gp.pieRotation / 100.0) > radiusy) {
            radiusx = radiusy / ((double)gp.pieRotation / 100.0);
        } else {
            radiusy = radiusx * (double)gp.pieRotation / 100.0;
        }
        double dely = radiusy * ((double)gp.pieHeight / 100.0);
        double tmpInt1 = radiusx * (double)(2 * gp.serNum);
        double tmpInt2 = radiusy * (double)(2 * gp.serNum) + radiusy * ((double)gp.pieHeight / 100.0);
        gp.graphRect = new Rectangle2D.Double(gp.graphRect.x + (gp.graphRect.width - tmpInt1) / 2.0, gp.graphRect.y + (gp.graphRect.height - tmpInt2) / 2.0, tmpInt1, tmpInt2);
        double orgx = gp.graphRect.x + gp.graphRect.width / 2.0;
        double orgy = gp.graphRect.y + dely + (gp.graphRect.height - dely) / 2.0;
        boolean bl = cut = gp.serNum == 1 && gp.catNum > 1 && egp.isCutPie();
        if (gp.graphTransparent) {
            g.setComposite(AlphaComposite.getInstance(3, 0.6f));
        }
        for (int z = 0; z < gp.serNum; ++z) {
            ChartColor chartColor;
            double angle;
            double amount;
            ExtGraphSery egs;
            int i;
            Shape tmpShape;
            double amount2;
            ExtGraphSery egs2;
            ExtGraphCategory egc;
            int i2;
            String serName = (String)gp.serNames.get(z);
            double totAmount = 0.0;
            double totAngle = 0.0;
            double radx = (double)(gp.serNum - z) * radiusx;
            double rady = (double)(gp.serNum - z) * radiusy;
            double rxx = (double)(gp.serNum - z - 1) * radiusx;
            double ryy = (double)(gp.serNum - z - 1) * radiusy;
            double ww = 2.0 * rxx;
            double hh = 2.0 * ryy;
            double max = 0.0;
            double maxi = -1.0;
            double maxX = 0.0;
            double maxY = 0.0;
            double maxAngle = 0.0;
            ExtGraphCategory maxEgc = null;
            ExtGraphSery maxEgs = null;
            double movex = 0.0;
            double movey = 0.0;
            ArrayList cats = egp.categories;
            int cc = cats.size();
            for (i2 = 0; i2 < cc; ++i2) {
                egc = (ExtGraphCategory)cats.get(i2);
                egs2 = egc.getExtGraphSery(serName);
                amount2 = egs2.getValue();
                if (amount2 > max) {
                    max = amount2;
                    maxi = i2;
                }
                totAmount += amount2;
            }
            if (totAmount == 0.0) continue;
            totAngle = 0.0;
            for (i2 = 0; i2 < cc; ++i2) {
                egc = (ExtGraphCategory)cats.get(i2);
                egs2 = egc.getExtGraphSery(serName);
                amount2 = egs2.getValue();
                double angle2 = 0.0;
                angle2 = 360.0 * amount2 / totAmount;
                if (angle2 == 0.0) continue;
                if (i2 == gp.catNum - 1) {
                    angle2 = 360.0 - totAngle;
                }
                if (cut && maxi == (double)i2) {
                    movex = DrawPie3DObj._$2(radiusx, radiusy, dely * (double)0.67f, totAngle + angle2 / 2.0);
                    movey = DrawPie3DObj._$1(radiusx, radiusy, dely * (double)0.67f, totAngle + angle2 / 2.0);
                } else {
                    movex = 0.0;
                    movey = 0.0;
                }
                g.setColor(db.getColor(i2));
                tmpShape = new Arc2D.Double(orgx - radx + movex, orgy - rady + movey, 2.0 * radx, 2.0 * rady, totAngle, angle2, 2);
                g.fill(tmpShape);
                db.drawShape(tmpShape, _$10);
                if (totAngle < 180.0) {
                    DrawPie3DObj._$1(db, totAngle, orgx, radx, movex, orgy, rady, movey, dely, angle2, i2);
                }
                totAngle += angle2;
            }
            Color tmpc = egp.getAxisColor(6);
            db.g.setStroke(new BasicStroke(1.0f));
            db.drawShape(new Line2D.Double(orgx + radx, orgy - dely, orgx + radx, orgy), tmpc);
            totAngle = 0.0;
            double cumulativeAmount = 0.0;
            double curveY = 0.0;
            if (egp.isRaisedBorder()) {
                curveY = dely / 5.0;
            }
            for (int i3 = 0; i3 < cc; ++i3) {
                ExtGraphCategory egc2 = (ExtGraphCategory)cats.get(i3);
                ExtGraphSery egs3 = egc2.getExtGraphSery(serName);
                double amount3 = egs3.getValue();
                double angle3 = 0.0;
                angle3 = 360.0 * amount3 / totAmount;
                if (i3 == gp.catNum - 1) {
                    angle3 = 360.0 - totAngle;
                }
                if (angle3 == 0.0 && totAngle >= 90.0) continue;
                if (cut && maxi == (double)i3) {
                    movex = DrawPie3DObj._$2(radiusx, radiusy, dely * (double)0.67f, totAngle + angle3 / 2.0);
                    movey = DrawPie3DObj._$1(radiusx, radiusy, dely * (double)0.67f, totAngle + angle3 / 2.0);
                } else {
                    movex = 0.0;
                    movey = 0.0;
                }
                double bx1 = 0.0;
                double ex1 = 0.0;
                double by1 = 0.0;
                double ey1 = 0.0;
                Arc2D.Double ddd = new Arc2D.Double(orgx - radx + movex, orgy - rady + movey, 2.0 * radx, 2.0 * rady, (totAngle += angle3) - angle3, angle3, 2);
                bx1 = ddd.getStartPoint().getX();
                ex1 = ddd.getEndPoint().getX();
                by1 = ddd.getStartPoint().getY();
                ey1 = ddd.getEndPoint().getY();
                double bx2 = 0.0;
                double ex2 = 0.0;
                double by2 = 0.0;
                double ey2 = 0.0;
                if (egp.isRaisedBorder()) {
                    ddd = new Arc2D.Double(orgx - radx + movex + curveY / 2.0, orgy - rady - dely + movey, 2.0 * radx - curveY, 2.0 * rady - curveY, totAngle - angle3, angle3, 2);
                    bx2 = ddd.getStartPoint().getX();
                    ex2 = ddd.getEndPoint().getX();
                    by2 = ddd.getStartPoint().getY();
                    ey2 = ddd.getEndPoint().getY();
                }
                if (cut && maxi == (double)i3) {
                    if (bx1 > orgx + movex && ex1 >= orgx + movex && ey1 >= orgy + movey && by1 <= orgy + movey) {
                        DrawPie3DObj._$3(db, bx1, by1, orgx, orgy, movex, movey, dely, i3, bx2, by2, curveY);
                        DrawPie3DObj._$4(db, bx1, by1, orgx, orgy, movex, movey, dely, i3, bx2, by2, curveY);
                        DrawPie3DObj._$1(db, ex1, ey1, orgx, orgy, movex, movey, dely, i3, ex2, ey2, curveY);
                        DrawPie3DObj._$2(db, ex1, ey1, orgx, orgy, movex, movey, dely, i3, ex2, ey2, curveY);
                        continue;
                    }
                    if (bx1 > orgx + movex && ex1 >= orgx + movex) {
                        DrawPie3DObj._$1(db, ex1, ey1, orgx, orgy, movex, movey, dely, i3, ex2, ey2, curveY);
                        DrawPie3DObj._$2(db, ex1, ey1, orgx, orgy, movex, movey, dely, i3, ex2, ey2, curveY);
                        DrawPie3DObj._$3(db, bx1, by1, orgx, orgy, movex, movey, dely, i3, bx2, by2, curveY);
                        DrawPie3DObj._$4(db, bx1, by1, orgx, orgy, movex, movey, dely, i3, bx2, by2, curveY);
                        continue;
                    }
                    if (bx1 < orgx + movex && ex1 <= orgx + movex) {
                        DrawPie3DObj._$4(db, bx1, by1, orgx, orgy, movex, movey, dely, i3, bx2, by2, curveY);
                        DrawPie3DObj._$3(db, bx1, by1, orgx, orgy, movex, movey, dely, i3, bx2, by2, curveY);
                        DrawPie3DObj._$2(db, ex1, ey1, orgx, orgy, movex, movey, dely, i3, ex2, ey2, curveY);
                        DrawPie3DObj._$1(db, ex1, ey1, orgx, orgy, movex, movey, dely, i3, ex2, ey2, curveY);
                        continue;
                    }
                    if (ex1 > orgx + movex && bx1 < orgx + movex) {
                        DrawPie3DObj._$4(db, bx1, by1, orgx, orgy, movex, movey, dely, i3, bx2, by2, curveY);
                        DrawPie3DObj._$1(db, ex1, ey1, orgx, orgy, movex, movey, dely, i3, ex2, ey2, curveY);
                        DrawPie3DObj._$3(db, bx1, by1, orgx, orgy, movex, movey, dely, i3, bx2, by2, curveY);
                        DrawPie3DObj._$2(db, ex1, ey1, orgx, orgy, movex, movey, dely, i3, ex2, ey2, curveY);
                        continue;
                    }
                    if (!(ex1 < orgx + movex) || !(bx1 > orgx + movex)) continue;
                    DrawPie3DObj._$2(db, ex1, ey1, orgx, orgy, movex, movey, dely, i3, ex2, ey2, curveY);
                    DrawPie3DObj._$3(db, bx1, by1, orgx, orgy, movex, movey, dely, i3, bx2, by2, curveY);
                    DrawPie3DObj._$1(db, ex1, ey1, orgx, orgy, movex, movey, dely, i3, ex2, ey2, curveY);
                    DrawPie3DObj._$4(db, bx1, by1, orgx, orgy, movex, movey, dely, i3, bx2, by2, curveY);
                    continue;
                }
                if (!gp.graphTransparent || gp.catNum <= 1 || cut && ((double)i3 == maxi - 1.0 || i3 == gp.catNum - 1 && maxi == 0.0)) continue;
                if (ex1 > orgx + movex) {
                    DrawPie3DObj._$1(db, ex1, ey1, orgx, orgy, movex, movey, dely, i3, ex2, ey2, curveY);
                    DrawPie3DObj._$2(db, ex1, ey1, orgx, orgy, movex, movey, dely, i3, ex2, ey2, curveY);
                    continue;
                }
                DrawPie3DObj._$2(db, ex1, ey1, orgx, orgy, movex, movey, dely, i3, ex2, ey2, curveY);
                DrawPie3DObj._$1(db, ex1, ey1, orgx, orgy, movex, movey, dely, i3, ex2, ey2, curveY);
            }
            totAngle = 0.0;
            Color bc = egp.getAxisColor(5);
            int bs = 1;
            float bw = 1.0f;
            for (i = 0; i < cc; ++i) {
                Arc2D.Double topOval;
                ExtGraphCategory egc3 = (ExtGraphCategory)cats.get(i);
                egs = egc3.getExtGraphSery(serName);
                amount = egs.getValue();
                angle = 0.0;
                angle = 360.0 * amount / totAmount;
                if (i == gp.catNum - 1) {
                    angle = 360.0 - totAngle;
                }
                if (cut && maxi == (double)i) {
                    movex = DrawPie3DObj._$2(radiusx, radiusy, dely * (double)0.67f, totAngle + angle / 2.0);
                    movey = DrawPie3DObj._$1(radiusx, radiusy, dely * (double)0.67f, totAngle + angle / 2.0);
                } else {
                    movex = 0.0;
                    movey = 0.0;
                }
                if (totAngle + angle > 180.0) {
                    DrawPie3DObj._$1(db, totAngle, orgx, radx, movex, orgy, rady, movey, dely, angle, i, false);
                }
                Color c = db.getColor(i);
                chartColor = db.getChartColor(c);
                if (egp.isRaisedBorder()) {
                    if (totAngle + angle > 150.0 || totAngle == 0.0 || totAngle + angle < 45.0) {
                        DrawPie3DObj._$1(db, totAngle, orgx, radx, movex, orgy - dely, rady, movey, curveY / 2.0, angle, i, true);
                    }
                    topOval = new Arc2D.Double(orgx - radx + movex + curveY / 2.0, orgy - rady - dely + movey, 2.0 * radx - curveY, 2.0 * rady - curveY, totAngle, angle, 2);
                } else {
                    topOval = new Arc2D.Double(orgx - radx + movex, orgy - rady - dely + movey, 2.0 * radx, 2.0 * rady, totAngle, angle, 2);
                }
                Utils.drawCylinderTop(g, topOval, bc, bs, bw, db.getTransparent(), chartColor, true);
                Arc2D.Double ddd1 = egp.isRaisedBorder() ? new Arc2D.Double(orgx - radx + movex + curveY / 2.0, orgy - rady - dely + movey, 2.0 * radx - curveY, 2.0 * rady - curveY, totAngle, angle, 2) : new Arc2D.Double(orgx - radx + movex, orgy - rady - dely + movey, 2.0 * radx, 2.0 * rady, totAngle, angle, 2);
                if (egp.isRaisedBorder()) {
                    if (gp.catNum > 1) {
                        tmpShape = new Line2D.Double(orgx + movex, orgy - dely + movey - curveY / 2.0, ddd1.getStartPoint().getX(), ddd1.getStartPoint().getY());
                        db.drawShape(tmpShape, bc);
                    }
                    tmpShape = new Arc2D.Double(orgx - radx + movex + curveY / 2.0, orgy - rady - dely + movey, 2.0 * radx - curveY, 2.0 * rady - curveY, totAngle, angle, 0);
                    db.drawShape(tmpShape, bc);
                } else {
                    if (gp.catNum > 1) {
                        tmpShape = new Line2D.Double(orgx + movex, orgy - dely + movey, ddd1.getStartPoint().getX(), ddd1.getStartPoint().getY());
                        db.drawShape(tmpShape, bc);
                    }
                    tmpShape = new Arc2D.Double(orgx - radx + movex, orgy - rady - dely + movey, 2.0 * radx, 2.0 * rady, totAngle, angle, 0);
                    db.drawShape(tmpShape, bc);
                }
                double xx = orgx - rxx + movex;
                double yy = orgy - ryy - dely + movey;
                Arc2D.Double ddd2 = null;
                if (ww != 0.0) {
                    ddd2 = new Arc2D.Double(xx, yy, ww, hh, totAngle, angle, 2);
                }
                db.htmlLink(ddd1, htmlLink, egc3.getNameString(), egs, ddd2);
                totAngle += angle;
            }
            totAngle = 0.0;
            for (i = 0; i < cc; ++i) {
                ExtGraphCategory egc4 = (ExtGraphCategory)cats.get(i);
                egs = egc4.getExtGraphSery(serName);
                amount = egs.getValue();
                angle = 0.0;
                angle = 360.0 * amount / totAmount;
                if (i == gp.catNum - 1) {
                    angle = 360.0 - totAngle;
                }
                if (cut && maxi == (double)i) {
                    Arc2D.Double topOval;
                    movex = DrawPie3DObj._$2(radiusx, radiusy, dely * (double)0.67f, totAngle + angle / 2.0);
                    movey = DrawPie3DObj._$1(radiusx, radiusy, dely * (double)0.67f, totAngle + angle / 2.0);
                    if (totAngle + angle > 180.0) {
                        DrawPie3DObj._$1(db, totAngle, orgx, radx, movex, orgy, rady, movey, dely, angle, i, false);
                    }
                    if (egp.isRaisedBorder()) {
                        if (totAngle + angle > 150.0 || totAngle == 0.0 || totAngle + angle < 45.0) {
                            DrawPie3DObj._$1(db, totAngle, orgx, radx, movex, orgy - dely, rady, movey, curveY / 2.0, angle, i, true);
                        }
                        topOval = new Arc2D.Double(orgx - radx + movex + curveY / 2.0, orgy - rady - dely + movey, 2.0 * radx - curveY, 2.0 * rady - curveY, totAngle, angle, 2);
                    } else {
                        topOval = new Arc2D.Double(orgx - radx + movex, orgy - rady - dely + movey, 2.0 * radx, 2.0 * rady, totAngle, angle, 2);
                    }
                    Color c = db.getColor(i);
                    chartColor = db.getChartColor(c);
                    Utils.drawCylinderTop(g, topOval, bc, bs, bw, db.getTransparent(), chartColor, true);
                } else {
                    movex = 0.0;
                    movey = 0.0;
                }
                if (gp.serNum == 1) {
                    double dLen = radx;
                    if (egp.isRaisedBorder()) {
                        dLen = radx - 5.0;
                    }
                    double x1 = orgx + DrawPie3DObj._$2(radx, rady, dLen, totAngle + angle / 2.0) + movex;
                    double y1 = orgy + DrawPie3DObj._$1(radx, rady, dLen, totAngle + angle / 2.0) - dely - curveY / 2.0 + movey;
                    double depthR = radx * (double)((float)gp.pieLine / 100.0f);
                    if (totAngle + angle / 2.0 > 180.0) {
                        depthR += Math.abs(dely * Math.sin(Math.toRadians(totAngle + angle / 2.0)));
                    }
                    double x2 = orgx + (double)Math.round((radx + depthR) * Math.cos(Math.toRadians(totAngle + angle / 2.0))) + movex;
                    double y2 = orgy - (double)Math.round((rady + curveY / 2.0 + depthR) * Math.sin(Math.toRadians(totAngle + angle / 2.0))) + movey - dely - curveY / 2.0;
                    g.setColor(gp.coorColor);
                    String text = "";
                    double tmpAngle = totAngle + angle / 2.0;
                    switch (gp.dispValueType) {
                        case 1: {
                            text = "";
                            break;
                        }
                        case 2: 
                        case 5: {
                            String fmt = StringUtils.isValidString(gp.dataMarkFormat) ? gp.dataMarkFormat : "";
                            tmpc = egp.getAxisColor(6);
                            tmpShape = new Line2D.Double(x1, y1, x2, y2);
                            db.g.setStroke(new BasicStroke(1.0f));
                            db.drawShape(tmpShape, tmpc);
                            text = db.getFormattedValue(amount, fmt);
                            if (gp.dispValueType != 5) break;
                            text = DrawPie3DObj.getDispName(egc4, egs, gp.serNum) + "," + text;
                            break;
                        }
                        case 4: {
                            tmpc = egp.getAxisColor(6);
                            tmpShape = new Line2D.Double(x1, y1, x2, y2);
                            db.g.setStroke(new BasicStroke(1.0f));
                            db.drawShape(tmpShape, tmpc);
                            text = egs.getTips();
                            break;
                        }
                        default: {
                            String fmt = StringUtils.isValidString(gp.dataMarkFormat) ? gp.dataMarkFormat : "0.00%";
                            tmpc = egp.getAxisColor(6);
                            tmpShape = new Line2D.Double(x1, y1, x2, y2);
                            db.g.setStroke(new BasicStroke(1.0f));
                            db.drawShape(tmpShape, tmpc);
                            if ((double)i != maxi) {
                                text = db.getFormattedValue(amount / totAmount, fmt);
                                String tmp = text.substring(0, text.length() - 1);
                                if (tmp.equals(".") || !StringUtils.isValidString(tmp)) {
                                    tmp = "0";
                                }
                                cumulativeAmount += Double.parseDouble(tmp);
                                if (gp.dispValueType != 6) break;
                                text = DrawPie3DObj.getDispName(egc4, egs, gp.serNum) + "," + text;
                                break;
                            }
                            maxAngle = tmpAngle;
                            maxEgc = egc4;
                            maxEgs = egs;
                            maxX = x2;
                            maxY = y2;
                        }
                    }
                    db.drawOutCircleText(gp.GFV_VALUE, text, tmpAngle, x2, y2);
                }
                totAngle += angle;
            }
            if (gp.serNum > 1) {
                int angle4 = Math.round(360 / gp.serNum) * z;
                g.setColor(gp.coorColor);
                double x1 = orgx + (double)Math.round((radx - radiusx / 2.0) * Math.cos(Math.toRadians(angle4)));
                double y1 = orgy - (double)Math.round((rady - radiusy / 2.0) * Math.sin(Math.toRadians(angle4)));
                double x2 = orgx + (double)Math.round((radiusx * (double)gp.serNum + 5.0) * Math.cos(Math.toRadians(angle4)));
                double y2 = orgy - (double)Math.round((radiusy * (double)gp.serNum + 5.0) * Math.sin(Math.toRadians(angle4)));
                tmpc = egp.getAxisColor(6);
                tmpShape = new Line2D.Double(x1, y1, x2, y2);
                db.g.setStroke(new BasicStroke(1.0f));
                db.drawShape(tmpShape, tmpc);
                db.drawOutCircleText(gp.GFV_XLABEL, serName, angle4, x2, y2);
            } else if (gp.dispValueType == 3 || gp.dispValueType == 6) {
                String fmt = StringUtils.isValidString(gp.dataMarkFormat) ? gp.dataMarkFormat : "0.00%";
                String text = db.getFormattedValue((100.0 - cumulativeAmount) / 100.0, fmt);
                if (gp.dispValueType == 6) {
                    text = DrawPie3DObj.getDispName(maxEgc, maxEgs, gp.serNum) + "," + text;
                }
                db.drawOutCircleText(gp.GFV_VALUE, text, maxAngle, maxX, maxY);
            }
            orgy -= dely;
        }
        db.outLabels();
    }

    private static double _$2(double radx, double rady, double len, double angle) {
        return Math.round(len * Math.cos(Math.toRadians(angle)));
    }

    private static double _$1(double radx, double rady, double len, double angle) {
        return -Math.round(len * rady / radx * Math.sin(Math.toRadians(angle)));
    }

    public ChartColor getChartColor(Color c) {
        ChartColor cc = new ChartColor(c);
        if (DrawPie3DObj._$1(this.egp)) {
            cc.setColor1(c);
            cc.setColor2(c);
            cc.setGradient(true);
        } else {
            cc.setGradient(false);
        }
        return cc;
    }

    private static boolean _$1(ExtGraphProperty egp) {
        return egp.isRaisedBorder() && egp.getImageFormat() != 2 || egp.isGradientColor();
    }

    private static Shape _$1(double[] x, double[] y) {
        return Utils.newPolygon2DShape(x, y);
    }

    private static void _$1(DrawBase db, double totAngle, double orgx, double radx, double movex, double orgy, double rady, double movey, double dely, double angle, int i, boolean isCurve) {
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        double ex1 = 0.0;
        double bx1 = 0.0;
        double ey1 = 0.0;
        double by1 = 0.0;
        double totAngle1 = totAngle;
        if (!isCurve && totAngle < 180.0) {
            totAngle1 = 180.0;
        }
        Rectangle2D.Double shinningRange = new Rectangle2D.Double(orgx - radx + movex, orgy - rady + movey, 2.0 * radx, 2.0 * rady);
        Arc2D.Double ddd = new Arc2D.Double(orgx - radx + movex, orgy - rady + movey, 2.0 * radx, 2.0 * rady, totAngle1, totAngle + angle - totAngle1, 2);
        Arc2D.Double dddd = new Arc2D.Double(orgx - radx + movex, orgy - rady + movey, 2.0 * radx, 2.0 * rady, totAngle1 - 1.0, totAngle + angle - totAngle1 + 2.0, 2);
        Arc2D.Double ddd1 = null;
        if (isCurve) {
            double curveY = dely;
            ddd1 = new Arc2D.Double(orgx - radx + movex + curveY, orgy - rady + movey - dely + curveY, 2.0 * (radx - curveY) - 1.0, 2.0 * (rady - curveY) - 1.0, totAngle1, totAngle + angle - totAngle1, 2);
        } else {
            ddd1 = new Arc2D.Double(orgx - radx + movex, orgy - rady + movey - dely, 2.0 * radx, 2.0 * rady, totAngle1, totAngle + angle - totAngle1, 2);
        }
        ex1 = ddd.getEndPoint().getX();
        bx1 = ddd.getStartPoint().getX();
        ey1 = ddd.getEndPoint().getY();
        by1 = ddd.getStartPoint().getY();
        double aa = dddd.getEndPoint().getX();
        double aa1 = dddd.getStartPoint().getX();
        double bb = dddd.getEndPoint().getY();
        double bb1 = dddd.getStartPoint().getY();
        double[] ptx1 = new double[]{ddd1.getStartPoint().getX(), bx1, ex1, ddd1.getEndPoint().getX()};
        double[] pty1 = new double[]{ddd1.getStartPoint().getY(), by1, ey1, ddd1.getEndPoint().getY()};
        Shape pp1 = DrawPie3DObj._$1(ptx1, pty1);
        double[] ptx2 = new double[]{orgx + movex, aa1, aa};
        double[] pty2 = new double[]{orgy + movey, bb1, bb};
        Shape pp2 = DrawPie3DObj._$1(ptx2, pty2);
        Area area = new Area(ddd);
        Area area1 = new Area(ddd1);
        Area area2 = new Area(pp1);
        Area area3 = new Area(pp2);
        area.subtract(area3);
        area.add(area1);
        area.add(area2);
        area.subtract(area1);
        Color c = db.getColor(i);
        ChartColor chartColor = db.getChartColor(c);
        if (!chartColor.isGradient()) {
            c = new CubeColor(c).getF2();
            chartColor = db.getChartColor(c);
        }
        Color bc = egp.getAxisColor(5);
        int bs = 1;
        float bw = 1.0f;
        if (bc == null) {
            bw = 0.0f;
        }
        Utils.drawCylinderFront(g, area, bc, bs, bw, db.getTransparent(), chartColor, true, shinningRange, isCurve);
    }

    private static void _$1(DrawBase db, double totAngle, double orgx, double radx, double movex, double orgy, double rady, double movey, double dely, double angle, int i) {
        Graphics2D g = db.g;
        double ex1 = 0.0;
        double bx1 = 0.0;
        double ey1 = 0.0;
        double by1 = 0.0;
        Arc2D.Double ddd = null;
        Arc2D.Double ddd1 = null;
        double totAngle1 = totAngle + angle;
        if (totAngle + angle > 180.0) {
            totAngle1 = 180.0;
        }
        ddd = new Arc2D.Double(orgx - radx + movex, orgy - rady + movey, 2.0 * radx, 2.0 * rady, totAngle, totAngle1 - totAngle, 2);
        ddd1 = new Arc2D.Double(orgx - radx + movex, orgy - rady + movey - dely, 2.0 * radx, 2.0 * rady, totAngle, totAngle1 - totAngle, 2);
        ex1 = ddd.getEndPoint().getX();
        bx1 = ddd.getStartPoint().getX();
        ey1 = ddd.getEndPoint().getY();
        by1 = ddd.getStartPoint().getY();
        double[] ptx1 = new double[]{bx1, bx1, ex1, ex1};
        double[] pty1 = new double[]{-dely + by1, by1, ey1, -dely + ey1};
        Shape pp1 = DrawPie3DObj._$1(ptx1, pty1);
        double[] ptx2 = new double[]{orgx + movex, bx1, ex1};
        double[] pty2 = new double[]{orgy + movey - dely, by1 - dely, ey1 - dely};
        Shape pp2 = DrawPie3DObj._$1(ptx2, pty2);
        Area area = new Area(ddd);
        Area area1 = new Area(ddd1);
        Area area2 = new Area(pp1);
        Area area3 = new Area(pp2);
        area1.subtract(area3);
        area1.add(area);
        area1.add(area2);
        area1.subtract(area);
        g.setColor(db.getColor(i));
        g.fill(area1);
        db.drawShape(area1, _$10);
    }

    private static void _$4(DrawBase db, double bx1, double by1, double orgx, double orgy, double movex, double movey, double dely, int i, double bx2, double by2, double curveY) {
        double[] pty1;
        double[] ptx1;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        curveY = Math.ceil(curveY / 2.0);
        if (egp.isRaisedBorder()) {
            ptx1 = new double[]{bx1 - movex, bx1 - movex, bx2 - movex, orgx, orgx};
            pty1 = new double[]{by1 - movey, -dely + by1 - movey, by2 - movey, -dely - curveY + orgy, orgy};
        } else {
            ptx1 = new double[]{bx1 - movex, bx1 - movex, orgx, orgx};
            pty1 = new double[]{by1 - movey, -dely + by1 - movey, -dely + orgy, orgy};
        }
        Color c = i == 0 ? db.getColor(gp.catNum - 1) : db.getColor(i - 1);
        CubeColor ccr = new CubeColor(c);
        g.setColor(ccr.getRelativeDarker("F2", _$9));
        Shape s = DrawPie3DObj._$1(ptx1, pty1);
        g.fill(s);
        db.drawShape(s, _$10);
    }

    private static void _$3(DrawBase db, double bx1, double by1, double orgx, double orgy, double movex, double movey, double dely, int i, double bx2, double by2, double curveY) {
        double[] pty1;
        double[] ptx1;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        curveY /= 2.0;
        if (egp.isRaisedBorder()) {
            ptx1 = new double[]{bx1, bx1, bx2, orgx + movex, orgx + movex};
            pty1 = new double[]{by1, -dely + by1, by2, -dely - curveY + orgy + movey, orgy + movey};
        } else {
            ptx1 = new double[]{bx1, bx1, orgx + movex, orgx + movex};
            pty1 = new double[]{by1, -dely + by1, -dely + orgy + movey, orgy + movey};
        }
        Color c = db.getColor(i);
        CubeColor ccr = new CubeColor(c);
        g.setColor(ccr.getRelativeDarker("F2", _$9));
        Shape s = DrawPie3DObj._$1(ptx1, pty1);
        g.fill(s);
        db.drawShape(s, _$10);
    }

    private static void _$2(DrawBase db, double ex1, double ey1, double orgx, double orgy, double movex, double movey, double dely, int i, double ex2, double ey2, double curveY) {
        double[] pty1;
        double[] ptx1;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        curveY /= 2.0;
        if (egp.isRaisedBorder()) {
            ptx1 = new double[]{ex1, ex1, ex2, orgx + movex, orgx + movex};
            pty1 = new double[]{ey1, -dely + ey1, ey2, -dely - curveY + orgy + movey, orgy + movey};
            g.setColor(db.getColor(i).darker().darker());
        } else {
            ptx1 = new double[]{ex1, ex1, orgx + movex, orgx + movex};
            pty1 = new double[]{ey1, -dely + ey1, -dely + orgy + movey, orgy + movey};
            g.setColor(db.getColor(i).darker());
        }
        Color c = db.getColor(i);
        CubeColor ccr = new CubeColor(c);
        g.setColor(ccr.getRelativeDarker("F2", _$9));
        Shape s = DrawPie3DObj._$1(ptx1, pty1);
        g.fill(s);
        db.drawShape(s, _$10);
    }

    private static void _$1(DrawBase db, double ex1, double ey1, double orgx, double orgy, double movex, double movey, double dely, int i, double ex2, double ey2, double curveY) {
        double[] pty1;
        double[] ptx1;
        GraphParam gp = db.gp;
        ExtGraphProperty egp = db.egp;
        Graphics2D g = db.g;
        curveY /= 2.0;
        if (egp.isRaisedBorder()) {
            ptx1 = new double[]{ex1 - movex, ex1 - movex, ex2 - movex, orgx, orgx};
            pty1 = new double[]{ey1 - movey, -dely + ey1 - movey, ey2 - movey, -dely - curveY + orgy, orgy};
        } else {
            ptx1 = new double[]{ex1 - movex, ex1 - movex, orgx, orgx};
            pty1 = new double[]{ey1 - movey, -dely + ey1 - movey, -dely + orgy, orgy};
        }
        Color c = i + 1 == gp.catNum ? db.getColor(0) : db.getColor(i + 1);
        CubeColor ccr = new CubeColor(c);
        Shape s = DrawPie3DObj._$1(ptx1, pty1);
        g.setColor(ccr.getRelativeDarker("F2", _$9));
        g.fill(s);
        db.drawShape(s, _$10);
    }

    static {
        _$9 = -2;
    }
}

