/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.cellset.graph.draw;

import com.scudata.cellset.BackGraphConfig;
import com.scudata.cellset.graph.config.AlarmLine;
import com.scudata.cellset.graph.config.GraphFonts;
import com.scudata.cellset.graph.config.IGraphProperty;
import com.scudata.cellset.graph.config.Palette;
import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.ExtAlarmLine;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.cellset.graph.draw.GraphParam;
import com.scudata.chart.Consts;
import com.scudata.common.StringUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;

public class ExtGraphProperty {
    public ArrayList categories;
    public ArrayList category2 = null;
    private BackGraphConfig _$39 = null;
    private boolean _$38 = false;
    private String _$37;
    private String _$36;
    private String _$35;
    private double _$34 = 0.0;
    private int _$33 = 0;
    private ArrayList _$32 = null;
    private String _$31;
    private String _$30;
    private Palette _$29;
    private double _$28;
    private ArrayList _$27;
    private int _$26;
    private static final short _$25 = 1;
    private static final short _$24 = 2;
    private static final short _$23 = 4;
    private static final short _$22 = 8;
    private static final short _$21 = 16;
    private static final short _$20 = 32;
    private static final short _$19 = 64;
    private static final short _$18 = 128;
    private static final short _$17 = 256;
    private static final short _$16 = 512;
    private static final short _$15 = 1024;
    private static final short _$14 = 2048;
    private short _$13 = 0;
    private double _$12 = 0.0;
    private double _$11 = 0.0;
    private double _$10 = 0.0;
    private double _$9 = 0.0;
    private double _$8 = 0.0;
    private double _$7 = 0.0;
    private int _$6 = 0;
    private double _$5 = 0.0;
    private String _$4;
    private String _$3;
    private byte _$2;
    private IGraphProperty _$1;

    public IGraphProperty getIGraphProperty() {
        return this._$1;
    }

    public Vector getCategoryNames() {
        return this.listCategoryNames(this.categories);
    }

    public static ArrayList getArrayList(ExtGraphCategory[] cats) {
        ArrayList<ExtGraphCategory> list = new ArrayList<ExtGraphCategory>();
        for (int i = 0; i < cats.length; ++i) {
            list.add(cats[i]);
        }
        return list;
    }

    public Vector listCategoryNames(ExtGraphCategory[] categories) {
        return this.listCategoryNames(ExtGraphProperty.getArrayList(categories));
    }

    public Vector listCategoryNames(ArrayList categories) {
        Vector<Object> v = new Vector<Object>();
        if (categories == null) {
            return v;
        }
        for (int i = 0; i < categories.size(); ++i) {
            ExtGraphCategory egc = (ExtGraphCategory)categories.get(i);
            v.add(egc.getName());
        }
        return v;
    }

    public Vector listSeriesNames(ExtGraphCategory[] cats) {
        return this.listSeriesNames(ExtGraphProperty.getArrayList(cats));
    }

    protected String getReportASeriesName(Object series) {
        return null;
    }

    public Vector listSeriesNames(ArrayList cats) {
        Vector<String> names = new Vector<String>();
        for (int c = 0; c < cats.size(); ++c) {
            ArrayList series = ((ExtGraphCategory)cats.get(c)).getSeries();
            for (int i = 0; i < series.size(); ++i) {
                Object ser = series.get(i);
                String name = "";
                if (ExtGraphProperty._instanceof(ser, "ExtGraphSery")) {
                    ExtGraphSery egs = (ExtGraphSery)ser;
                    name = egs.getName();
                } else {
                    name = this.getReportASeriesName(ser);
                }
                if (names.contains(name)) continue;
                names.add(name);
            }
        }
        return names;
    }

    public ExtGraphSery getEGS(String sname) {
        ArrayList cats = this.categories;
        for (int c = 0; c < cats.size(); ++c) {
            ArrayList series = ((ExtGraphCategory)cats.get(c)).getSeries();
            for (int i = 0; i < series.size(); ++i) {
                Object ser = series.get(i);
                String name = "";
                if (ExtGraphProperty._instanceof(ser, "ExtGraphSery")) {
                    ExtGraphSery egs = (ExtGraphSery)ser;
                    name = egs.getName();
                } else {
                    name = this.getReportASeriesName(ser);
                }
                if (!sname.equals(name)) continue;
                return (ExtGraphSery)ser;
            }
        }
        return null;
    }

    protected Vector getReportSeriesNames(ArrayList cats) {
        return null;
    }

    public Vector getSeriesNames(ArrayList cats) {
        if (cats == null) {
            return new Vector();
        }
        Vector v = this.getReportSeriesNames(cats);
        if (v != null) {
            return v;
        }
        return this.listSeriesNames(cats);
    }

    public ExtGraphProperty(IGraphProperty graph) {
        if (graph == null) {
            return;
        }
        this._$1 = graph;
        this._$2 = this._$1.getType();
    }

    public byte getCurveType() {
        return this._$1.getCurveType();
    }

    public boolean isCutPie() {
        return this._$1.isPieSpacing();
    }

    public boolean isMeterColorEnd() {
        return this._$1.isMeterColorEnd();
    }

    public boolean isMeterTick() {
        return this._$1.isMeterTick();
    }

    public int getMeter3DEdge() {
        return this._$1.getMeter3DEdge();
    }

    public int getMeterRainbowEdge() {
        return this._$1.getMeterRainbowEdge();
    }

    public int getPieLine() {
        return this._$1.getPieLine();
    }

    public boolean is2YGraph() {
        byte type = this.getType();
        return type == 20 || type == 21 || type == 30;
    }

    public boolean isNormalStacked() {
        return ExtGraphProperty.isNormalStacked(this.getType());
    }

    public static boolean isNormalStacked(byte type) {
        return type == 5 || type == 6 || type == 10 || type == 11;
    }

    public boolean isStackedGraph(DrawBase instance) {
        if (instance == null) {
            byte type = this.getType();
            return type == 5 || type == 6 || type == 10 || type == 30 || type == 11;
        }
        String className = instance.getClass().getName();
        boolean isStacked = className.indexOf("Stacked") > 0;
        return isStacked;
    }

    public boolean isBarGraph(DrawBase instance) {
        if (instance == null) {
            byte type = this.getType();
            return type == 2 || type == 3 || type == 4 || type == 5 || type == 6;
        }
        String className = instance.getClass().getName();
        boolean isBar = className.indexOf("Bar") > 0;
        return isBar;
    }

    public ExtGraphCategory getExtGraphCategory(Object catName) {
        for (int i = 0; i < this.categories.size(); ++i) {
            ExtGraphCategory egc = (ExtGraphCategory)this.categories.get(i);
            if (!catName.equals(egc.getName())) continue;
            return egc;
        }
        return null;
    }

    public static boolean isNormalGraph(byte type) {
        return type != 19 && type != 18 && type != 23 && type != 27 && type != 26 && type != 25;
    }

    protected void reportRecalcProperty() {
    }

    public void recalcProperty() {
        this._$2();
        if (ExtGraphProperty.isNormalGraph(this.getType()) && this._$33 > 0) {
            this._$1();
        }
        if (this.is2YGraph()) {
            this._$4();
        }
        this.reportRecalcProperty();
    }

    protected void splitCategory(Vector seriesName1, Vector seriesName2) {
        ArrayList<ExtGraphCategory> newCat1 = new ArrayList<ExtGraphCategory>();
        ArrayList<ExtGraphCategory> newCat2 = new ArrayList<ExtGraphCategory>();
        for (int i = 0; i < this.categories.size(); ++i) {
            ExtGraphCategory egc = (ExtGraphCategory)this.categories.get(i);
            ExtGraphCategory egc1 = new ExtGraphCategory();
            egc1.setName(egc.getName());
            ArrayList<ExtGraphSery> ser1 = new ArrayList<ExtGraphSery>();
            for (int j = 0; j < seriesName1.size(); ++j) {
                String name = (String)seriesName1.get(j);
                ExtGraphSery egs = egc.getExtGraphSery(name);
                ser1.add(egs);
            }
            egc1.setSeries(ser1);
            newCat1.add(egc1);
            ExtGraphCategory egc2 = new ExtGraphCategory();
            egc2.setName(egc.getName());
            ArrayList<ExtGraphSery> ser2 = new ArrayList<ExtGraphSery>();
            for (int j = 0; j < seriesName2.size(); ++j) {
                String name = (String)seriesName2.get(j);
                ExtGraphSery egs = egc.getExtGraphSery(name);
                ser2.add(egs);
            }
            egc2.setSeries(ser2);
            newCat2.add(egc2);
        }
        this.categories = newCat1;
        this.category2 = newCat2;
    }

    public void setSplitByAxis(boolean set) {
        this._$38 = set;
    }

    protected boolean isSplitByAxis() {
        return this._$38;
    }

    private void _$4() {
        if (this.isSplitByAxis()) {
            Vector allSeriesName = this.getSeriesNames(this.categories);
            int total = allSeriesName.size();
            Vector seriesName1 = new Vector();
            Vector seriesName2 = new Vector();
            for (int i = 0; i < total; ++i) {
                Object sName = allSeriesName.get(i);
                ExtGraphSery egs = this.getEGS(sName.toString());
                if (egs.getAxis() == Consts.AXIS_RIGHT) {
                    seriesName2.add(sName);
                    continue;
                }
                seriesName1.add(sName);
            }
            this.splitCategory(seriesName1, seriesName2);
        } else {
            this._$3();
        }
    }

    private void _$3() {
        Vector allSeriesName = this.getSeriesNames(this.categories);
        int total = allSeriesName.size();
        Vector seriesName1 = new Vector();
        Vector seriesName2 = new Vector();
        int s = (total + 1) / 2;
        for (int i = 0; i < allSeriesName.size(); ++i) {
            if (i >= s) {
                seriesName2.add(allSeriesName.get(i));
                continue;
            }
            seriesName1.add(allSeriesName.get(i));
        }
        ArrayList<ExtGraphCategory> newCat1 = new ArrayList<ExtGraphCategory>();
        ArrayList<ExtGraphCategory> newCat2 = new ArrayList<ExtGraphCategory>();
        for (int i = 0; i < this.categories.size(); ++i) {
            ExtGraphCategory egc = (ExtGraphCategory)this.categories.get(i);
            ExtGraphCategory egc1 = new ExtGraphCategory();
            egc1.setName(egc.getName());
            ArrayList<ExtGraphSery> ser1 = new ArrayList<ExtGraphSery>();
            for (int j = 0; j < seriesName1.size(); ++j) {
                String name = (String)seriesName1.get(j);
                ExtGraphSery egs = egc.getExtGraphSery(name);
                ser1.add(egs);
            }
            egc1.setSeries(ser1);
            newCat1.add(egc1);
            ExtGraphCategory egc2 = new ExtGraphCategory();
            egc2.setName(egc.getName());
            ArrayList<ExtGraphSery> ser2 = new ArrayList<ExtGraphSery>();
            for (int j = 0; j < seriesName2.size(); ++j) {
                String name = (String)seriesName2.get(j);
                ExtGraphSery egs = egc.getExtGraphSery(name);
                ser2.add(egs);
            }
            egc2.setSeries(ser2);
            newCat2.add(egc2);
        }
        this.categories = newCat1;
        this.category2 = newCat2;
    }

    private void _$2() {
        if (this.categories == null || this.categories.size() == 0) {
            throw new RuntimeException("Error\uff01Graph does not define categories!");
        }
        for (int i = this.categories.size() - 1; i >= 0; --i) {
            ExtGraphCategory egc = (ExtGraphCategory)this.categories.get(i);
            if (!StringUtils.isValidString(egc.getNameString())) {
                this.categories.remove(i);
                continue;
            }
            ArrayList series = egc.getSeries();
            for (int j = series.size() - 1; j >= 0; --j) {
                ExtGraphSery egs;
                Object objSer = series.get(j);
                String className = objSer.getClass().getName();
                if (!ExtGraphProperty._instanceof(objSer, "ExtGraphSery") || StringUtils.isValidString((egs = (ExtGraphSery)objSer).getName()) || !egs.isNull()) continue;
                series.remove(j);
            }
        }
    }

    public static boolean _instanceof(Object ins, String className) {
        return ins.getClass().getName().endsWith(className);
    }

    private void _$1() {
        int originCatNum = this.categories.size();
        if (this._$33 <= 0 || this._$33 > originCatNum - 2) {
            return;
        }
        Collections.sort(this.categories);
        Collections.reverse(this.categories);
        ArrayList dataCategory = new ArrayList();
        for (int i = 0; i < this._$33; ++i) {
            dataCategory.add(this.categories.get(i));
        }
        if (this.getFlag((byte)0)) {
            this.categories = dataCategory;
            return;
        }
        ExtGraphCategory otherCategoryData = new ExtGraphCategory();
        if (DrawBase.isChinese()) {
            otherCategoryData.setName("\u5176\u4ed6");
        } else {
            otherCategoryData.setName("Other");
        }
        HashMap<String, Double> otherSeriesData = new HashMap<String, Double>();
        for (int i = this._$33; i < this.categories.size(); ++i) {
            ExtGraphCategory egc = (ExtGraphCategory)this.categories.get(i);
            ArrayList series = egc.getSeries();
            for (int j = 0; j < series.size(); ++j) {
                ExtGraphSery egs = (ExtGraphSery)series.get(j);
                Double seriesValue = (Double)otherSeriesData.get(egs.getName());
                if (seriesValue == null) {
                    otherSeriesData.put(egs.getName(), new Double(egs.getValue()));
                    continue;
                }
                otherSeriesData.put(egs.getName(), new Double(seriesValue + egs.getValue()));
            }
        }
        ArrayList<ExtGraphSery> otherSeries = new ArrayList<ExtGraphSery>();
        for (String sName : otherSeriesData.keySet()) {
            ExtGraphSery sd = new ExtGraphSery();
            sd.setName(sName);
            sd.setValue((Number)otherSeriesData.get(sName));
            otherSeries.add(sd);
        }
        otherCategoryData.setSeries(otherSeries);
        dataCategory.add(otherCategoryData);
        this.categories = dataCategory;
    }

    public byte getType() {
        return this._$2;
    }

    public boolean isLegendOnSery() {
        return this._$1.getDrawLegendBySery();
    }

    public int getAxisColor() {
        return this._$1.getAxisColor();
    }

    public int getCanvasColor() {
        return this._$1.getCanvasColor();
    }

    public int getGraphBackColor() {
        return this._$1.getGraphBackColor();
    }

    public ArrayList getCategories() {
        return this.categories;
    }

    public String getXTitle() {
        return this._$37;
    }

    public byte getXTitleAlign() {
        return this._$1.getXTitleAlign();
    }

    public String getYTitle() {
        return this._$36;
    }

    public byte getYTitleAlign() {
        return this._$1.getYTitleAlign();
    }

    public String getGraphTitle() {
        return this._$35;
    }

    public byte getGraphTitleAlign() {
        return this._$1.getGraphTitleAlign();
    }

    public byte getGridLineType() {
        return this._$1.getGridLineType();
    }

    public byte getGridLocation() {
        return this._$1.getGridLocation();
    }

    public int getGridLineColor() {
        return this._$1.getGridLineColor();
    }

    public double getBarDistance() {
        return this._$34;
    }

    public byte getImageFormat() {
        return this._$1.getImageFormat();
    }

    public boolean isGraphTransparent() {
        return this._$1.isGraphTransparent();
    }

    public boolean isDrawDataTable() {
        return this._$1.isDrawDataTable();
    }

    public boolean isDataCenter() {
        return this._$1.isDataCenter();
    }

    public boolean isGradientColor() {
        return this._$1.isGradientColor();
    }

    public GraphFonts getFonts() {
        return this._$1.getFonts();
    }

    public ArrayList getAlarmLines() {
        if (this._$32 == null) {
            AlarmLine[] als = this._$1.getAlarmLines();
            if (als == null || als.length == 0) {
                return null;
            }
            this._$32 = new ArrayList();
            for (int i = 0; i < als.length; ++i) {
                ExtAlarmLine eal = new ExtAlarmLine();
                eal.setAlarmValue(Double.parseDouble(als[i].getAlarmValue()));
                eal.setColor(als[i].getColor());
                eal.setLineThick(GraphParam.getLineThick(als[i].getLineThick()));
                eal.setLineType(als[i].getLineType());
                eal.setName(als[i].getName());
                eal.setDrawAlarmValue(als[i].isDrawAlarmValue());
                this._$32.add(eal);
            }
        }
        return this._$32;
    }

    public void setAlarmLines(ArrayList alarm) {
        this._$32 = alarm;
    }

    public byte getDisplayData() {
        return this._$1.getDisplayData();
    }

    public byte getDisplayData2() {
        return this._$1.getDisplayData2();
    }

    public boolean isDispStackSumValue() {
        return this._$1.isDispStackSumValue();
    }

    public String getDisplayDataFormat1() {
        return this._$4;
    }

    public String getDisplayDataFormat2() {
        return this._$3;
    }

    public String getLink() {
        return this._$31;
    }

    public String getLegendLink() {
        return this._$1.getLegendLink();
    }

    public String getLinkTarget() {
        return this._$30;
    }

    public byte getLegendLocation() {
        return this._$1.getLegendLocation();
    }

    public int getLegendVerticalGap() {
        return this._$1.getLegendVerticalGap();
    }

    public int getLegendHorizonGap() {
        return this._$1.getLegendHorizonGap();
    }

    public Palette getPlatte() {
        return this._$29;
    }

    public double getYStartValue1() {
        return this._$12;
    }

    public double getYStartValue2() {
        return this._$11;
    }

    public double getYEndValue1() {
        return this._$10;
    }

    public double getYEndValue2() {
        return this._$9;
    }

    public double getYInterval1() {
        return this._$8;
    }

    public double getYInterval2() {
        return this._$7;
    }

    public double getDataUnit() {
        return this._$1.getDataUnit();
    }

    public int getYMinMarks() {
        return this._$6;
    }

    public double getTitleMargin() {
        return this._$28;
    }

    public boolean isDrawLineDot() {
        return this._$1.isDrawLineDot();
    }

    public boolean isOverlapOrigin() {
        return this._$1.isOverlapOrigin();
    }

    public boolean isDrawLineTrend() {
        return this._$1.isDrawLineTrend();
    }

    public boolean isIgnoreNull() {
        return this._$1.ignoreNull();
    }

    public String getCustomClass() {
        return this._$1.getCustomClass();
    }

    public String getCustomParam() {
        return this._$1.getCustomParam();
    }

    public byte getLineThick() {
        return this._$1.getLineThick();
    }

    public byte getLineStyle() {
        return this._$1.getLineStyle();
    }

    public boolean isShowOverlapText() {
        return this._$1.isShowOverlapText();
    }

    public double getXInterval() {
        return this._$5;
    }

    public ArrayList getTimeTrendXValues() {
        return this._$27;
    }

    public int getStatusBarWidth() {
        return this._$26;
    }

    public byte getStatusTimeType() {
        return this._$1.getStatusTimeType();
    }

    public String getStatusTimeFormat() {
        return this._$1.getStatusTimeFormat();
    }

    public boolean isUserSetBarDistance() {
        return (this._$13 & 1) == 1;
    }

    public boolean isUserSetTopData() {
        return (this._$13 & 2) == 2;
    }

    public boolean isUserSetYStartValue1() {
        return (this._$13 & 4) == 4;
    }

    public boolean isUserSetYStartValue2() {
        return (this._$13 & 8) == 8;
    }

    public boolean isUserSetYEndValue1() {
        return (this._$13 & 0x10) == 16;
    }

    public boolean isUserSetYEndValue2() {
        return (this._$13 & 0x20) == 32;
    }

    public boolean isUserSetYInterval1() {
        return (this._$13 & 0x40) == 64;
    }

    public boolean isUserSetYInterval2() {
        return (this._$13 & 0x80) == 128;
    }

    public boolean isUserSetYMinMarks() {
        return (this._$13 & 0x100) == 256;
    }

    public boolean isUserSetTitleMargin() {
        return (this._$13 & 0x200) == 512;
    }

    public boolean isUserSetXInterval() {
        return (this._$13 & 0x400) == 1024;
    }

    public boolean isUserSetStatusBarWidth() {
        return (this._$13 & 0x800) == 2048;
    }

    public boolean isDrawShade() {
        if (this.isStackedGraph(null)) {
            return false;
        }
        if (this._$2 == 8) {
            return false;
        }
        return this._$1.isDrawShade();
    }

    public boolean isRaisedBorder() {
        return this._$1.isRaisedBorder();
    }

    public boolean getFlag(byte key) {
        return this._$1.getFlag(key);
    }

    public BackGraphConfig getBackGraphConfig() {
        return this._$39;
    }

    public void setBackGraphConfig(BackGraphConfig bgc) {
        this._$39 = bgc;
    }

    public Color getAxisColor(int AXIS_ID) {
        int c = this._$1.getAxisColors()[AXIS_ID];
        if (c == 0xFFFFFF) {
            return null;
        }
        return new Color(c);
    }

    public void setType(byte type) {
        this._$2 = type;
    }

    public void setAxisColor(int color) {
        this._$1.setAxisColor(color);
    }

    public void setCanvasColor(int color) {
        this._$1.setCanvasColor(color);
    }

    public void setGraphBackColor(int color) {
        this._$1.setGraphBackColor(color);
    }

    public void setCategories(ArrayList categorys) {
        this.categories = categorys;
    }

    public void setXTitle(String title) {
        this._$37 = title;
    }

    public void setYTitle(String title) {
        this._$36 = title;
    }

    public void setGraphTitle(String title) {
        this._$35 = title;
    }

    public void setGridLineType(byte type) {
        this._$1.setGridLineType(type);
    }

    public void setGridLineColor(int color) {
        this._$1.setGridLineColor(color);
    }

    public void setBarDistance(double distance) {
        this._$13 = (short)(this._$13 | 1);
        this._$34 = distance;
    }

    public void setImageFormat(byte format) {
        this._$1.setImageFormat(format);
    }

    public void setGraphTransparent(boolean b) {
        this._$1.setGraphTransparent(b);
    }

    public void setGradientColor(boolean b) {
        this._$1.setGradientColor(b);
    }

    public void setTopData(int n) {
        this._$13 = (short)(this._$13 | 2);
        this._$33 = n;
    }

    public void setFonts(GraphFonts font) {
        this._$1.setFonts(font);
    }

    public void setDisplayData(byte data) {
        this._$1.setDisplayData(data);
    }

    public void setDisplayData2(byte data) {
        this._$1.setDisplayData2(data);
    }

    public void setDisplayDataFormat1(String format) {
        this._$4 = format;
    }

    public void setDisplayDataFormat2(String format) {
        this._$3 = format;
    }

    public void setLink(String link) {
        this._$31 = link;
    }

    public void setLinkTarget(String target) {
        this._$30 = target;
    }

    public void setLegendLocation(byte location) {
        this._$1.setLegendLocation(location);
    }

    public void setPalette(Palette palette) {
        this._$29 = palette;
    }

    public void setYStartValue1(double value) {
        this._$13 = (short)(this._$13 | 4);
        this._$12 = value;
    }

    public void setYStartValue2(double value) {
        this._$13 = (short)(this._$13 | 8);
        this._$11 = value;
    }

    public void setYEndValue1(double value) {
        this._$13 = (short)(this._$13 | 0x10);
        this._$10 = value;
    }

    public void setYEndValue2(double value) {
        this._$13 = (short)(this._$13 | 0x20);
        this._$9 = value;
    }

    public void setYInterval1(double interval) {
        this._$13 = (short)(this._$13 | 0x40);
        this._$8 = interval;
    }

    public void setYInterval2(double interval) {
        this._$13 = (short)(this._$13 | 0x80);
        this._$7 = interval;
    }

    public void setDataUnit(double unit) {
        this._$1.setDataUnit(unit);
    }

    public void setYMinMarks(int mark) {
        this._$13 = (short)(this._$13 | 0x100);
        this._$6 = mark;
    }

    public void setTitleMargin(double margin) {
        this._$13 = (short)(this._$13 | 0x200);
        this._$28 = margin;
    }

    public void setDrawLineDot(boolean b) {
        this._$1.setDrawLineDot(b);
    }

    public void setShowOverlapText(boolean b) {
        this._$1.setShowOverlapText(b);
    }

    public void setXInterval(double interval) {
        this._$13 = (short)(this._$13 | 0x400);
        this._$5 = interval;
    }

    public void setTimeTrendXValues(ArrayList value) {
        this._$27 = value;
    }

    public void setStatusBarWidth(int width) {
        this._$13 = (short)(this._$13 | 0x800);
        this._$26 = width;
    }

    public void setStatusTimeType(byte type) {
        this._$1.setStatusTimeType(type);
    }

    public double getStackedMaxValue() {
        double stackedVal;
        ExtGraphCategory egc;
        int i;
        if (this.categories == null) {
            return 0.0;
        }
        double val = 0.0;
        for (i = 0; i < this.categories.size(); ++i) {
            egc = (ExtGraphCategory)this.categories.get(i);
            stackedVal = egc.getPositiveSumSeries();
            if (!(stackedVal > val)) continue;
            val = stackedVal;
        }
        if (this.is2YGraph()) {
            return val;
        }
        if (this.category2 != null) {
            for (i = 0; i < this.category2.size(); ++i) {
                egc = (ExtGraphCategory)this.category2.get(i);
                stackedVal = egc.getPositiveSumSeries();
                if (!(stackedVal > val)) continue;
                val = stackedVal;
            }
        }
        return val;
    }

    public double getStackedMinValue() {
        double stackedVal;
        ExtGraphCategory egc;
        int i;
        if (this.categories == null) {
            return 0.0;
        }
        double val = 0.0;
        for (i = 0; i < this.categories.size(); ++i) {
            egc = (ExtGraphCategory)this.categories.get(i);
            stackedVal = egc.getNegativeSumSeries();
            if (!(stackedVal < val)) continue;
            val = stackedVal;
        }
        if (this.category2 != null) {
            for (i = 0; i < this.category2.size(); ++i) {
                egc = (ExtGraphCategory)this.category2.get(i);
                stackedVal = egc.getNegativeSumSeries();
                if (!(stackedVal < val)) continue;
                val = stackedVal;
            }
        }
        return val;
    }

    public double getMaxValue(ArrayList cats) {
        return this._$1(true, cats);
    }

    public double getMinValue(ArrayList cats) {
        return this._$1(false, cats);
    }

    public void setOtherStackedSeries(String other) {
        this._$1.setOtherStackedSeries(other);
    }

    public String getOtherStackedSeries() {
        return this._$1.getOtherStackedSeries();
    }

    private double _$1(boolean getMax) {
        if (this._$32 == null) {
            return 0.0;
        }
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this._$32.size(); ++i) {
            ExtAlarmLine eal = (ExtAlarmLine)this._$32.get(i);
            double d = eal.getAlarmValue();
            if (getMax) {
                max = Math.max(max, d);
                continue;
            }
            min = Math.min(min, d);
        }
        if (getMax) {
            return max;
        }
        return min;
    }

    private double _$1(boolean getMax, ArrayList cats) {
        double val = 0.0;
        if (cats != null) {
            for (int i = 0; i < cats.size(); ++i) {
                ExtGraphCategory egc = (ExtGraphCategory)cats.get(i);
                ArrayList series = egc.getSeries();
                for (int j = 0; j < series.size() && ExtGraphProperty._instanceof(series.get(j), "ExtGraphSery"); ++j) {
                    ExtGraphSery egs = (ExtGraphSery)series.get(j);
                    if (getMax) {
                        if (!(egs.getValue() > val)) continue;
                        val = egs.getValue();
                        continue;
                    }
                    if (!(egs.getValue() < val)) continue;
                    val = egs.getValue();
                }
            }
        }
        double tVal = this._$1(getMax);
        if (getMax) {
            return Math.max(tVal, val);
        }
        return Math.min(tVal, val);
    }
}

