/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart;

import com.scudata.chart.Engine;
import com.scudata.chart.ICoor;
import com.scudata.chart.LinkElement;
import com.scudata.chart.Utils;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.chart.element.Column;
import com.scudata.chart.element.DateAxis;
import com.scudata.chart.element.EnumAxis;
import com.scudata.chart.element.Line;
import com.scudata.chart.element.TickAxis;
import com.scudata.chart.element.TimeAxis;
import com.scudata.common.RQException;
import com.scudata.dm.Sequence;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public abstract class DataElement
extends LinkElement {
    public String axis1 = null;
    public String axis2 = null;
    public String axisTime = null;
    public Sequence data1 = null;
    public Sequence data2 = null;
    public Sequence dataTime = null;
    public boolean visible = true;
    public transient Sequence categories = null;
    public transient Sequence series = null;
    protected transient Engine e;

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    protected abstract String getText(int var1);

    @Override
    protected String getTipTitle(int index) {
        String superTitle = super.getTipTitle(index);
        if (superTitle != null) {
            return superTitle;
        }
        if (this.getText(index) != null) {
            return this.getText(index);
        }
        Object val1 = this.data1.get(index);
        Object val2 = this.data2.get(index);
        return String.valueOf(val1.toString()) + " " + val2.toString();
    }

    public ICoor getCoor() {
        ArrayList<ICoor> coorList = this.e.getCoorList();
        int size = coorList.size();
        int i = 0;
        while (i < size) {
            ICoor coor = coorList.get(i);
            if (coor.getAxis1().getName().equals(this.axis1) && coor.getAxis2().getName().equals(this.axis2)) {
                return coor;
            }
            ++i;
        }
        return null;
    }

    @Override
    public ParamInfoList getParamInfoList() {
        ParamInfoList paramInfos = new ParamInfoList();
        ParamInfo.setCurrent(DataElement.class, this);
        paramInfos.add(new ParamInfo("visible", 10));
        String group = "data";
        paramInfos.add(group, new ParamInfo("axis1", 1));
        paramInfos.add(group, new ParamInfo("data1", 1));
        paramInfos.add(group, new ParamInfo("axis2", 1));
        paramInfos.add(group, new ParamInfo("data2", 1));
        paramInfos.add(group, new ParamInfo("axisTime", 1));
        paramInfos.add(group, new ParamInfo("dataTime", 1));
        paramInfos.addAll(super.getParamInfoList());
        return paramInfos;
    }

    public String getAxis1Name() {
        return this.axis1;
    }

    public String getAxis2Name() {
        return this.axis2;
    }

    public String getAxisTimeName() {
        return this.axisTime;
    }

    private Object parseNumber(Object o) {
        if (o instanceof Number) {
            return o;
        }
        return new Double(o.toString());
    }

    private void normalizeNumber(Sequence seq, String desc) {
        int size = seq.length();
        int i = 1;
        while (i <= size) {
            Object o = seq.get(i);
            if (o == null) {
                throw new RuntimeException(String.valueOf(desc) + " can not contain null values.");
            }
            seq.set(i, this.parseNumber(o));
            ++i;
        }
    }

    public void parseNumericAxisData(String numericAxis) {
        Column col;
        Sequence data3;
        if (this.isPhysicalCoor()) {
            return;
        }
        Sequence seq = this.getAxisData(numericAxis);
        this.normalizeNumber(seq, String.valueOf(numericAxis) + " Data");
        if (this instanceof Column && (data3 = (col = (Column)this).getData3()) != null) {
            this.normalizeNumber(data3, String.valueOf(numericAxis) + " Data3");
        }
    }

    public Sequence getAxisData(String axisName) {
        if (axisName.equals(this.axis1)) {
            return this.data1;
        }
        if (axisName.equals(this.axis2)) {
            return this.data2;
        }
        return this.dataTime;
    }

    public void setAxisData(String axisName, Sequence data) {
        if (data == null) {
            return;
        }
        if (axisName.equals(this.axis1)) {
            this.data1 = data;
        } else if (axisName.equals(this.axis2)) {
            this.data2 = data;
        } else {
            this.dataTime = data;
        }
    }

    public Sequence getOppositeAxisData(String axisName) {
        if (axisName.equals(this.axis1)) {
            return this.data2;
        }
        return this.data1;
    }

    @Override
    public void beforeDraw() {
        if (this.isPhysicalCoor()) {
            return;
        }
        ICoor coor = this.getCoor();
        EnumAxis ea = coor.getEnumAxis();
        if (ea != null) {
            Sequence enumData = this.getAxisData(ea.getName());
            Sequence idED = enumData.id(null);
            if (enumData.length() != idED.length()) {
                throw new RQException("EnumAxis [ " + ea.getName() + " ]'s data exists duplicate item!");
            }
        }
    }

    public abstract boolean hasGradientColor();

    @Override
    public void setEngine(Engine e) {
        this.e = e;
    }

    @Override
    public Engine getEngine() {
        return this.e;
    }

    public boolean isPhysicalCoor() {
        return this.axis1 == null && this.axis2 == null;
    }

    public void prepare() {
        ICoor ic;
        Column col;
        Sequence data3;
        Utils.setParamsEngine(this);
        String msg = null;
        if (this.data1 == null) {
            msg = String.valueOf(this.mm.getMessage("data1")) + " can not be empty!";
        } else if (this.data2 == null) {
            msg = String.valueOf(this.mm.getMessage("data2")) + " can not be empty!";
        } else if (this.data1.length() != this.data2.length()) {
            msg = "DataElement property 'data' is not match: data1 length=" + this.data1.length() + " data2 length=" + this.data2.length();
        } else if (this.dataTime != null && this.data1.length() != this.dataTime.length()) {
            msg = "DataElement property 'data' is not match: data1 length=" + this.data1.length() + " dataTime length=" + this.dataTime.length();
        } else if (this instanceof Column && (data3 = (col = (Column)this).getData3()) != null && this.data1.length() != data3.length()) {
            msg = "DataElement property 'data' is not match: data1 length=" + this.data1.length() + " data3 length=" + data3.length();
        }
        if (this.dataTime != null && this.dataTime.length() < 2) {
            msg = "Animate chart requires at least 2 data.";
        }
        if (msg != null) {
            throw new RuntimeException(msg);
        }
        if (this.isPhysicalCoor()) {
            return;
        }
        TickAxis ta = this.e.getAxisByName(this.axis1);
        Sequence enumData = null;
        if (ta instanceof EnumAxis) {
            enumData = this.data1;
        } else {
            ta = this.e.getAxisByName(this.axis2);
            if (ta instanceof EnumAxis) {
                enumData = this.data2;
            }
        }
        if (enumData != null) {
            this.categories = EnumAxis.extractCatNames(enumData);
            this.series = EnumAxis.extractSerNames(enumData);
            if (enumData == this.data2) {
                ic = this.getCoor();
                if (ic != null) {
                    ta = ic.getAxis2();
                    ic.setAxis2(ic.getAxis1());
                    ic.setAxis1(ta);
                }
                this.data2 = this.data1;
                this.data1 = enumData;
                String tmp = this.axis2;
                this.axis2 = this.axis1;
                this.axis1 = tmp;
            }
        }
        ic = this.getCoor();
        ic.getAxis1().checkDataMatch(this.data1);
        ic.getAxis2().checkDataMatch(this.data2);
    }

    protected int pointSize() {
        return this.data1.length();
    }

    protected Point2D getScreenPoint(int index) {
        return this.getScreenPoint(index, false);
    }

    protected Point2D getScreenPoint(int index, boolean discardSeries) {
        Point2D p = this.getNumericPoint(index, discardSeries);
        if (!this.isPhysicalCoor()) {
            ICoor coor = this.getCoor();
            p = coor.getScreenPoint(p);
        }
        return p;
    }

    protected Point2D getNumericPoint(int index, boolean discardSeries) {
        Point2D p;
        if (this.isPhysicalCoor()) {
            double vx = ((Number)this.data1.get(index)).doubleValue();
            double vy = ((Number)this.data2.get(index)).doubleValue();
            double px = this.e.getXPixel(vx);
            double py = this.e.getYPixel(vy);
            p = new Point2D.Double(px, py);
        } else {
            Point2D n;
            ICoor coor = this.getCoor();
            Object v1 = this.data1.get(index);
            Object v2 = this.data2.get(index);
            if (discardSeries) {
                v1 = Column.discardSeries(v1);
                v2 = Column.discardSeries(v2);
            }
            p = n = coor.getNumericPoint(v1, v2);
        }
        return p;
    }

    public DataElement getFrame(double frameTime) {
        double y;
        double x;
        int index2;
        int index1;
        DataElement de = (DataElement)this.deepClone();
        de.setEngine(this.e);
        int size = this.dataTime.length();
        int index = 1;
        int i = 1;
        while (i <= size) {
            double tmp = DateAxis.getDoubleDate(this.dataTime.get(i));
            if (tmp > frameTime) break;
            index = i++;
        }
        if (index == size) {
            index1 = index - 1;
            index2 = index;
        } else {
            index1 = index;
            index2 = index + 1;
        }
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        TickAxis ta1 = null;
        TickAxis ta2 = null;
        if (this.isPhysicalCoor()) {
            x = ((Number)this.data1.get(index1)).doubleValue();
            y = ((Number)this.data2.get(index1)).doubleValue();
            p1.setLocation(x, y);
            x = ((Number)this.data1.get(index2)).doubleValue();
            y = ((Number)this.data2.get(index2)).doubleValue();
            p2.setLocation(x, y);
        } else {
            Object val;
            ta1 = this.e.getAxisByName(this.axis1);
            ta2 = this.e.getAxisByName(this.axis2);
            if (ta1.getLocation() == 1) {
                val = this.data1.get(index1);
                x = ta1.animateDoubleValue(val);
                val = this.data2.get(index1);
                y = ta2.animateDoubleValue(val);
                p1.setLocation(x, y);
                val = this.data1.get(index2);
                x = ta1.animateDoubleValue(val);
                val = this.data2.get(index2);
                y = ta2.animateDoubleValue(val);
                p2.setLocation(x, y);
            } else {
                val = this.data1.get(index1);
                y = ta1.animateDoubleValue(val);
                val = this.data2.get(index1);
                x = ta2.animateDoubleValue(val);
                p1.setLocation(x, y);
                val = this.data1.get(index2);
                y = ta1.animateDoubleValue(val);
                val = this.data2.get(index2);
                x = ta2.animateDoubleValue(val);
                p2.setLocation(x, y);
            }
        }
        TimeAxis ta = this.e.getTimeAxis(this.getAxisTimeName());
        double time1 = ta.animateDoubleValue(this.dataTime.get(index1));
        double time2 = ta.animateDoubleValue(this.dataTime.get(index2));
        double timeLength = time2 - time1;
        double ratio = (frameTime - time1) / timeLength;
        double xLength = p2.x - p1.x;
        double cx = p1.x + ratio * xLength;
        double cy = Utils.calcLineY(p1, p2, cx);
        Sequence d1 = new Sequence();
        Sequence d2 = new Sequence();
        if (ta.isKeepTrack()) {
            int i2 = 1;
            while (i2 <= index1) {
                d1.add(this.data1.get(i2));
                d2.add(this.data2.get(i2));
                ++i2;
            }
            if (ta1 != null && ta1.getLocation() == 2) {
                d1.add(cy);
                d2.add(cx);
            } else {
                d1.add(cx);
                d2.add(cy);
            }
        } else {
            if (this instanceof Line) {
                d1.add(this.data1.get(index1));
                d2.add(this.data2.get(index1));
            }
            if (ta1 != null && ta1.getLocation() == 2) {
                d1.add(cy);
                d2.add(cx);
            } else {
                d1.add(cx);
                d2.add(cy);
            }
        }
        de.data1 = d1;
        de.data2 = d2;
        return de;
    }

    public void clone(DataElement de) {
        de.axis1 = this.axis1;
        de.axis2 = this.axis2;
        de.axisTime = this.axisTime;
        de.data1 = this.data1;
        de.data2 = this.data2;
        de.dataTime = this.dataTime;
        de.visible = this.visible;
    }

    public abstract Object deepClone();
}

