/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart;

import com.scudata.chart.IElement;
import com.scudata.chart.Para;
import com.scudata.chart.resources.ChartMessage;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Sequence;
import com.scudata.expression.ChartParam;
import java.lang.reflect.Field;

public abstract class ObjectElement
implements IElement {
    MessageManager mm = ChartMessage.get();

    public void loadProperties(Sequence params) {
        this.setParams(this.getClass(), this, params);
    }

    private void setParams(Class elementClass, IElement elementObject, Sequence chartParams) {
        int size = chartParams.length();
        int i = 1;
        while (i <= size) {
            ChartParam cp = (ChartParam)chartParams.get(i);
            Para p = new Para(cp.getValue(), cp.getAxis(), cp.getName());
            Field f = null;
            try {
                f = elementClass.getField(cp.getName());
                if (p.getValue() == null) {
                    String cName = elementClass.getName();
                    int lastIndex = cName.lastIndexOf(46) + 1;
                    cName = cName.substring(lastIndex);
                    String pName = this.mm.getMessage(cp.getName());
                    throw new RQException(this.mm.getMessage("ObjectElement.nullvalue", cName, pName));
                }
                String className = f.getType().getName().toLowerCase();
                if (className.endsWith("boolean")) {
                    f.set(elementObject, new Boolean(p.booleanValue()));
                } else if (className.endsWith("byte")) {
                    f.set(elementObject, new Byte((byte)p.intValue()));
                } else if (className.endsWith("int") || className.endsWith("integer")) {
                    f.set(elementObject, new Integer(p.intValue()));
                } else if (className.endsWith("float")) {
                    f.set(elementObject, new Float(p.floatValue()));
                } else if (className.endsWith("double")) {
                    f.set(elementObject, new Double(p.doubleValue()));
                } else if (className.endsWith(".color")) {
                    f.set(elementObject, p.colorValue(0));
                } else if (className.endsWith("string")) {
                    f.set(elementObject, p.stringValue());
                } else if (className.endsWith("sequence")) {
                    f.set(elementObject, p.sequenceValue());
                } else if (className.endsWith("date")) {
                    f.set(elementObject, p.dateValue());
                } else if (className.endsWith("chartcolor")) {
                    f.set(elementObject, p.chartColorValue());
                } else if (className.endsWith("object")) {
                    f.set(elementObject, cp.getValue());
                } else {
                    Para defP = (Para)f.get(elementObject);
                    if (defP != null) {
                        p.setLegendProperty(defP.getLegendProperty());
                    }
                    f.set(elementObject, p);
                }
            }
            catch (NoSuchFieldException className) {
            }
            catch (RQException rqe) {
                throw rqe;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++i;
        }
    }
}

