/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.edit;

import com.scudata.chart.IElement;
import com.scudata.chart.ObjectElement;
import com.scudata.chart.edit.ElementLib;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.common.ArgumentTokenizer;
import com.scudata.common.Escape;
import com.scudata.expression.ChartParam;
import java.util.ArrayList;
import java.util.HashMap;

public class ElementInfo {
    private String name;
    private String title;
    private Class elementClass;
    private ArrayList chartParams;

    public ElementInfo() {
    }

    public ElementInfo(String name, String title, Class elementClass) {
        this.name = name;
        this.title = title;
        this.elementClass = elementClass;
    }

    private ParamInfoList listParamInfoList() {
        try {
            IElement element = (IElement)this.elementClass.newInstance();
            ParamInfoList pil = element.getParamInfoList();
            return pil;
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public ObjectElement getInstance() {
        try {
            return (ObjectElement)this.elementClass.newInstance();
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public void setPlotString(String plotString) {
        int len = plotString.length();
        String paramString = plotString.substring(5, len - 1);
        ArgumentTokenizer at = new ArgumentTokenizer(paramString, ',');
        this.name = Escape.removeEscAndQuote(at.next());
        ElementInfo ei = ElementLib.getElementInfo(this.name);
        this.title = ei.getTitle();
        this.elementClass = ei.getElementClass();
        this.chartParams = new ArrayList();
        while (at.hasNext()) {
            ChartParam cp = new ChartParam();
            cp.setPlotString(at.next());
            this.chartParams.add(cp);
        }
    }

    public String toPlotString(ParamInfoList pil) {
        StringBuffer sb = new StringBuffer("plot(");
        sb.append("\"" + this.name + "\"");
        ArrayList<ParamInfo> allParams = pil.getAllParams();
        int size = allParams.size();
        int i = 0;
        while (i < size) {
            ParamInfo pi = (ParamInfo)allParams.get(i);
            String paramPlot = pi.toPlotString(pi.getDefValue());
            if (paramPlot != null) {
                sb.append(",");
                sb.append(paramPlot);
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public void setProperties(String elementName, HashMap<String, Object> properties) {
        this.name = elementName;
        ElementInfo ei = ElementLib.getElementInfo(this.name);
        this.title = ei.getTitle();
        this.elementClass = ei.getElementClass();
        this.chartParams = new ArrayList();
        for (String pName : properties.keySet()) {
            Object pValue = properties.get(pName);
            ChartParam cp = new ChartParam(pName, pValue);
            this.chartParams.add(cp);
        }
    }

    public HashMap<String, Object> getProperties(ParamInfoList pil) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ArrayList<ParamInfo> allParams = pil.getAllParams();
        int size = allParams.size();
        int i = 0;
        while (i < size) {
            ParamInfo pi = (ParamInfo)allParams.get(i);
            String paramPlot = pi.toPlotString(pi.getDefValue());
            if (paramPlot != null) {
                properties.put(pi.getName(), pi.getValue());
            }
            ++i;
        }
        return properties;
    }

    public void setChartParams(ArrayList chartParams) {
        this.chartParams = chartParams;
    }

    public ParamInfoList getParamInfoList() {
        ParamInfoList paramInfos = this.listParamInfoList();
        if (this.chartParams == null) {
            return paramInfos;
        }
        int chartSize = this.chartParams.size();
        int i = 0;
        while (i < chartSize) {
            ChartParam cp = (ChartParam)this.chartParams.get(i);
            ParamInfo pi = paramInfos.getParamInfoByName(cp.getName());
            if (pi != null) {
                pi.setChartParam(cp);
            }
            ++i;
        }
        return paramInfos;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public Class getElementClass() {
        return this.elementClass;
    }
}

