/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.edit;

import com.scudata.chart.Para;
import com.scudata.chart.Utils;
import com.scudata.chart.resources.ChartMessage;
import com.scudata.common.MessageManager;
import com.scudata.dm.Sequence;
import com.scudata.expression.ChartParam;
import java.awt.Color;
import java.lang.reflect.Field;

public class ParamInfo
extends ChartParam {
    private String title;
    private int inputType;
    private boolean axisEnable = false;
    private Object defValue;
    private static transient Class currentClass;
    private static transient Object currentObj;
    private MessageManager mm = ChartMessage.get();

    public static void setCurrent(Class objClass, Object obj) {
        currentClass = objClass;
        currentObj = obj;
    }

    public ParamInfo(String name) {
        this(name, 1);
    }

    public ParamInfo(String name, int inputType) {
        this.name = name;
        try {
            Field f = currentClass.getDeclaredField(name);
            Object paraValue = f.get(currentObj);
            if (paraValue instanceof Para) {
                this.value = ((Para)paraValue).getValue();
                this.axisEnable = true;
            } else {
                this.value = paraValue instanceof Color ? new Integer(((Color)paraValue).getRGB()) : paraValue;
            }
            this.title = this.mm.getMessage(name);
            this.inputType = inputType;
            this.defValue = this.value;
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public Object getDefValue() {
        return this.defValue;
    }

    private String getSequenceEditExp(Sequence seq) {
        return "=" + seq.toString();
    }

    public void setChartParam(ChartParam cp) {
        Sequence seq;
        Object tmp = cp.getValue();
        if (tmp instanceof Sequence && (tmp = Utils.sequenceToChartColor(seq = (Sequence)tmp)) == null) {
            tmp = this.getSequenceEditExp(seq);
        }
        this.value = tmp;
        if (this.axisEnable) {
            this.axis = cp.getAxis();
        }
    }

    public boolean isAxisEnable() {
        return this.axisEnable;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getInputType() {
        return this.inputType;
    }
}

