/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.edit;

import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.resources.ChartMessage;
import com.scudata.common.MessageManager;
import java.util.ArrayList;

public class ParamInfoList {
    ArrayList<ArrayList<ParamInfo>> paramGroups = new ArrayList();
    ArrayList<String> groupNames = new ArrayList();
    ArrayList<ParamInfo> rootList = new ArrayList();
    private static final String ROOTGROUP = "RootGroup";
    private MessageManager mm = ChartMessage.get();

    private ArrayList<ArrayList<ParamInfo>> getParamGroups() {
        return this.paramGroups;
    }

    private ArrayList<ParamInfo> getrootList() {
        return this.rootList;
    }

    public void addAll(ParamInfoList pil) {
        ArrayList<String> groupNames = pil.getGroupNames();
        int i = 0;
        while (i < groupNames.size()) {
            String grpName = groupNames.get(i);
            ArrayList<ParamInfo> grpParams = pil.getParams(grpName);
            int n = 0;
            while (n < grpParams.size()) {
                this.add(grpName, grpParams.get(n));
                ++n;
            }
            ++i;
        }
        this.rootList.addAll(pil.getrootList());
    }

    public void add(String group, ParamInfo pi) {
        ArrayList<ParamInfo> pis = null;
        if (group == null || ROOTGROUP.equalsIgnoreCase(group)) {
            pis = this.rootList;
        } else {
            int index = this.groupNames.indexOf(group = this.mm.getMessage(group));
            if (index < 0) {
                this.groupNames.add(group);
                pis = new ArrayList();
                this.paramGroups.add(pis);
            } else {
                pis = this.paramGroups.get(index);
            }
        }
        if (pis == null) {
            pis = this.rootList;
        }
        pis.add(pi);
    }

    public void deleteGroup(String group) {
        int index = this.groupNames.indexOf(group = this.mm.getMessage(group));
        if (index >= 0) {
            this.groupNames.remove(index);
            this.paramGroups.remove(index);
        }
    }

    public void delete(String group, String name) {
        group = this.mm.getMessage(group);
        this.delete(this.getParams(group), name);
    }

    public void add(ParamInfo pi) {
        this.rootList.add(pi);
    }

    public void delete(String name) {
        this.delete(this.rootList, name);
    }

    public void delete(ArrayList<ParamInfo> list, String name) {
        int i = 0;
        while (i < list.size()) {
            ParamInfo pi = list.get(i);
            if (pi.getName().equalsIgnoreCase(name)) {
                list.remove(i);
                return;
            }
            ++i;
        }
    }

    public ArrayList<String> getGroupNames() {
        return this.groupNames;
    }

    public ArrayList<ParamInfo> getParams(String groupName) {
        ArrayList<ParamInfo> pis = null;
        int index = this.groupNames.indexOf(groupName);
        if (index >= 0) {
            pis = this.paramGroups.get(index);
        }
        if (pis != null) {
            return pis;
        }
        return this.rootList;
    }

    public ArrayList<ParamInfo> getRootParams() {
        return this.rootList;
    }

    public ParamInfo getParamInfoByName(String name) {
        ArrayList<ParamInfo> aps = this.getAllParams();
        int infoSize = aps.size();
        int i = 0;
        while (i < infoSize) {
            ParamInfo pi = aps.get(i);
            if (pi.getName().equalsIgnoreCase(name)) {
                return pi;
            }
            ++i;
        }
        return null;
    }

    public ArrayList<ParamInfo> getAllParams() {
        ArrayList<ParamInfo> aps = new ArrayList<ParamInfo>();
        int size = this.rootList == null ? 0 : this.rootList.size();
        int i = 0;
        while (i < size) {
            aps.add(this.rootList.get(i));
            ++i;
        }
        size = this.paramGroups == null ? 0 : this.paramGroups.size();
        i = 0;
        while (i < size) {
            ArrayList<ParamInfo> pis = this.paramGroups.get(i);
            int ps = pis == null ? 0 : pis.size();
            int j = 0;
            while (j < ps) {
                aps.add(pis.get(j));
                ++j;
            }
            ++i;
        }
        return aps;
    }
}

