/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.element;

import com.scudata.chart.CartesianCoor;
import com.scudata.chart.ChartColor;
import com.scudata.chart.ICoor;
import com.scudata.chart.Para;
import com.scudata.chart.Utils;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.chart.element.EnumAxis;
import com.scudata.chart.element.Ring;
import com.scudata.chart.element.TickAxis;
import com.scudata.common.StringUtils;
import com.scudata.dm.Sequence;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Column
extends Ring {
    public Sequence data3 = null;
    public Para columnWidth = new Para(new Double(0.9));
    public Para columnShape = new Para(new Integer(1));
    public Para horizontalAlign = new Para(new Integer(2));
    public Para verticalAlign = new Para(new Integer(8));
    public boolean shadow = true;
    public boolean convexEdge = false;

    @Override
    public void prepare() {
        super.prepare();
        if (this.data3 != null && this.data1.length() != this.data3.length()) {
            throw new RuntimeException("Column property 'data3' is not match to 'data1': data1 length=" + this.data1.length() + " data3 length=" + this.data3.length());
        }
    }

    @Override
    public double getColumnWidth(TickAxis ia, int index) {
        double colWidth = this.columnWidth.doubleValue(index);
        if (ia instanceof EnumAxis) {
            colWidth = ia.getValueRadius(colWidth);
        }
        if (colWidth == 0.0) {
            return 0.0;
        }
        if (colWidth < 1.0) {
            colWidth = 1.0;
        }
        return colWidth;
    }

    @Override
    public Sequence getData3() {
        return this.data3;
    }

    @Override
    protected Shape drawFreeColumn(int index, Point2D p1, Point2D p2, int step, boolean isVertical, int seriesIndex) {
        Shape linkShape = null;
        double leftX = Math.min(p1.getX(), p2.getX());
        double rightX = Math.max(p1.getX(), p2.getX());
        double topY = Math.min(p1.getY(), p2.getY());
        double bottomY = Math.max(p1.getY(), p2.getY());
        int x = (int)leftX;
        int y = (int)topY;
        int w = (int)rightX - x;
        int h = (int)bottomY - y;
        block0 : switch (step) {
            case 1: {
                int style = this.columnShape.intValue();
                switch (style) {
                    case 2: {
                        if (this.isPhysicalCoor()) {
                            throw new RuntimeException("Physical coordinates do not support 3D column.");
                        }
                        linkShape = this.draw3DColumn(x, y, w, h, seriesIndex, isVertical);
                        break block0;
                    }
                    case 3: {
                        if (this.isPhysicalCoor()) {
                            throw new RuntimeException("Physical coordinates do not support cylinder column.");
                        }
                        linkShape = this.drawCylinder(x, y, w, h, seriesIndex, isVertical);
                        break block0;
                    }
                }
                linkShape = this.draw2DColumn(x, y, w, h, seriesIndex, isVertical);
                break;
            }
            case 2: {
                String txt = this.text.stringValue(index);
                if (!StringUtils.isValidString(txt)) {
                    return null;
                }
                String fontName = this.textFont.stringValue(index);
                int fontStyle = this.textStyle.intValue(index);
                int fontSize = this.textSize.intValue(index);
                Font font = Utils.getFont(fontName, fontStyle, fontSize);
                Color tc = this.textColor.colorValue(index);
                int hAlign = this.horizontalAlign.intValue(index);
                int vAlign = this.verticalAlign.intValue(index);
                switch (hAlign) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        x += w / 2;
                        break;
                    }
                    case 4: {
                        x += w;
                    }
                }
                switch (vAlign) {
                    case 8: {
                        break;
                    }
                    case 16: {
                        y += h / 2;
                        break;
                    }
                    case 32: {
                        y += h;
                    }
                }
                int location = hAlign + vAlign;
                int coorShift = 0;
                if (!this.isPhysicalCoor()) {
                    int style = this.columnShape.intValue();
                    switch (style) {
                        case 3: {
                            ICoor coor = this.getCoor();
                            coorShift = ((CartesianCoor)coor).get3DShift() / 2;
                        }
                    }
                }
                Utils.drawText(this.e, txt, (double)(x + coorShift), (double)(y - coorShift), font, tc, fontStyle, 0, location, this.textOverlapping);
            }
        }
        return linkShape;
    }

    private Shape draw2DColumn(int x, int y, int w, int h, int index, boolean isVertical) {
        Graphics2D g = this.e.getGraphics();
        ChartColor cc = this.fillColor.chartColorValue(index);
        Color bc = this.borderColor.colorValue(index);
        int bs = this.borderStyle.intValue(index);
        float bw = this.borderWeight.floatValue(index);
        Utils.draw2DRect(g, x, y, w, h, bc, bs, bw, this.shadow, this.convexEdge, this.transparent, cc, isVertical);
        return new Rectangle(x, y, w, h);
    }

    private Shape draw3DColumn(int x, int y, int w, int h, int index, boolean isVertical) {
        Graphics2D g = this.e.getGraphics();
        CartesianCoor cc = (CartesianCoor)this.getCoor();
        int coorShift = cc.get3DShift();
        Color c = this.borderColor.colorValue(index);
        int style = this.borderStyle.intValue(index);
        float weight = this.borderWeight.floatValue(index);
        ChartColor chartColor = this.fillColor.chartColorValue(index);
        Utils.draw3DRect(g, x, y, w, h, c, style, weight, this.shadow, this.convexEdge, this.transparent, chartColor, isVertical, coorShift);
        int[] shapeX = new int[]{x, x + coorShift, x + coorShift + w, x + coorShift + w, x + w, x};
        int[] shapeY = new int[]{y, y - coorShift, y - coorShift, y - coorShift + h, y + h, y + h};
        return new Polygon(shapeX, shapeY, shapeX.length);
    }

    private Shape drawCylinder(int x, int y, int width, int height, int index, boolean isVertical) {
        Area sc2;
        Area sc1;
        Area sc;
        double yOval;
        double xOval;
        Graphics2D g = this.e.getGraphics();
        CartesianCoor cc = (CartesianCoor)this.getCoor();
        int coorShift = cc.get3DShift();
        double halfShift = coorShift / 2;
        ChartColor chartColor = this.fillColor.chartColorValue(index);
        double ovalRate = 0.5;
        if (isVertical) {
            xOval = (double)x + halfShift;
            yOval = (double)y - halfShift + (double)height - (double)width * ovalRate / 2.0;
        } else {
            xOval = (double)x + halfShift - (double)height * ovalRate / 2.0;
            yOval = (double)y - halfShift;
        }
        Color bc = this.borderColor.colorValue(index);
        int bs = this.borderStyle.intValue(index);
        float bw = this.borderWeight.floatValue(index);
        Arc2D.Double bottomOval = isVertical ? new Arc2D.Double(xOval, yOval, width, (double)width * ovalRate, 0.0, 360.0, 0) : new Arc2D.Double(xOval, yOval, (double)height * ovalRate, height, 0.0, 360.0, 0);
        if (this.transparent < 1.0f) {
            Utils.fill(g, bottomOval, this.transparent, chartColor.getColor1());
        }
        if (Utils.setStroke(g, bc, bs, bw)) {
            g.draw(bottomOval);
        }
        Arc2D.Double topOval = isVertical ? new Arc2D.Double(xOval, yOval - (double)height, width, (double)width * ovalRate, 0.0, 360.0, 0) : new Arc2D.Double(xOval + (double)width, yOval, (double)height * ovalRate, height, 0.0, 360.0, 0);
        Utils.drawCylinderTop(g, topOval, bc, bs, bw, this.transparent, chartColor, isVertical);
        if (isVertical) {
            double xRect = (double)x + halfShift;
            double yRect = (double)y - halfShift;
            sc = new Area(new Rectangle2D.Double(xRect, yRect, width, height + coorShift - 2));
            sc1 = new Area(new Rectangle2D.Double(xRect, yRect, width, height + coorShift - 2));
            sc2 = new Area(new Rectangle2D.Double(xRect, yRect, width, height));
        } else {
            double xRect = x - 2;
            double yRect = (double)y - halfShift;
            sc = new Area(new Rectangle2D.Double(xRect, yRect, (double)width + halfShift, height));
            sc1 = new Area(new Rectangle2D.Double(xRect, yRect, (double)width + halfShift, height));
            sc2 = new Area(new Rectangle2D.Double(xRect + halfShift, yRect, width, height));
        }
        Area or1 = new Area(bottomOval);
        Area or2 = new Area(topOval);
        sc2.subtract(or1);
        sc1.subtract(sc2);
        sc1.subtract(or1);
        sc.subtract(sc1);
        sc.subtract(or2);
        Utils.drawCylinderFront(g, sc, bc, bs, bw, this.transparent, chartColor, isVertical);
        Area outLine = new Area(sc);
        outLine.add(or2);
        return outLine;
    }

    @Override
    public ParamInfoList getParamInfoList() {
        ParamInfoList paramInfos = new ParamInfoList();
        ParamInfo.setCurrent(Column.class, this);
        paramInfos.add(new ParamInfo("shadow", 10));
        paramInfos.add(new ParamInfo("convexEdge", 10));
        paramInfos.add(new ParamInfo("data3", 1));
        String group = "appearance";
        paramInfos.add(group, new ParamInfo("columnWidth", 25));
        paramInfos.add(group, new ParamInfo("columnShape", 9));
        group = "text";
        paramInfos.add(group, new ParamInfo("horizontalAlign", 21));
        paramInfos.add(group, new ParamInfo("verticalAlign", 22));
        paramInfos.addAll(super.getParamInfoList());
        return paramInfos;
    }

    public void clone(Column c) {
        super.clone(c);
    }

    @Override
    public Object deepClone() {
        Column c = new Column();
        this.clone(c);
        return c;
    }
}

