/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.element;

import com.scudata.chart.DataElement;
import com.scudata.chart.Utils;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.chart.element.Dot;
import com.scudata.chart.element.TickAxis;
import com.scudata.common.RQException;
import com.scudata.dm.Sequence;
import java.awt.Shape;
import java.util.ArrayList;

public class EnumAxis
extends TickAxis {
    public Sequence categories;
    public Sequence series;
    public double gapRatio = 1.5;
    private transient int t_catNum = 0;
    private transient int t_serNum = 1;
    private transient double t_categorySpan = 190.0;
    private transient double t_seriesWidth = 0.0;

    @Override
    double getValueLength(Object val, boolean isAbsolute) {
        double len = 0.0;
        if (isAbsolute) {
            len = ((Number)val).doubleValue();
            len = this.getSeriesWidth() * len;
        } else {
            Object cat = Utils.parseCategory(val);
            Object ser = Utils.parseSeries(val);
            int catIndex = this.categories.firstIndexOf(cat);
            if (catIndex == 0) {
                throw new RuntimeException(String.valueOf(Dot.NOT_IN_DEFINE) + ":" + cat);
            }
            double j = 0.0;
            double serCount = this.t_serNum;
            if (ser == null) {
                j = serCount / 2.0;
            } else {
                int serIndex = this.series.firstIndexOf(ser);
                if (serIndex == 0) {
                    throw new RuntimeException(String.valueOf(Dot.NOT_IN_DEFINE) + ":" + ser);
                }
                j = (double)(serIndex - 1) + 0.5;
            }
            switch (this.location) {
                case 1: 
                case 2: 
                case 3: {
                    len = (double)catIndex * this.t_categorySpan + ((double)(catIndex - 1) * serCount + j) * this.t_seriesWidth;
                    break;
                }
                case 4: {
                    len = (double)catIndex * this.t_categorySpan + ((double)(catIndex - 1) * serCount + j) * this.t_seriesWidth;
                    if (!this.isCircleAngle()) break;
                    double tmp = this.t_categorySpan + serCount / 2.0 * this.t_seriesWidth;
                    len -= tmp;
                }
            }
        }
        return len;
    }

    private static void putAData(Sequence container, Object data, boolean putCategory) {
        if (data == null) {
            return;
        }
        Object tmp = null;
        Object cat = Utils.parseCategory(data);
        Object ser = Utils.parseSeries(data);
        if (putCategory) {
            tmp = cat;
        } else if (ser != null) {
            tmp = ser;
        }
        if (tmp != null && container.firstIndexOf(tmp) == 0) {
            container.add(tmp);
        }
    }

    @Override
    public void beforeDraw() {
        double length = this.getAxisLength();
        this.t_seriesWidth = this.location == 4 && this.isCircleAngle() ? length / ((double)this.t_catNum * this.gapRatio + (double)(this.t_catNum * this.t_serNum)) : length / ((double)(this.t_catNum + 1) * this.gapRatio + (double)(this.t_catNum * this.t_serNum));
        this.t_categorySpan = this.t_seriesWidth * this.gapRatio;
    }

    public static Sequence extractCatNames(Sequence data) {
        int dSize = data.length();
        Sequence catNames = new Sequence();
        int j = 1;
        while (j <= dSize) {
            Object one = data.get(j);
            EnumAxis.putAData(catNames, one, true);
            ++j;
        }
        return catNames;
    }

    public static Sequence extractSerNames(Sequence data) {
        int dSize = data.length();
        Sequence serNames = new Sequence();
        int j = 1;
        while (j <= dSize) {
            Object one = data.get(j);
            EnumAxis.putAData(serNames, one, false);
            ++j;
        }
        return serNames;
    }

    @Override
    public void prepare(ArrayList<DataElement> dataElements) {
        Object serVal;
        int n;
        Sequence data;
        DataElement de;
        int i;
        super.prepare(dataElements);
        if (this.categories == null) {
            this.categories = new Sequence();
            i = 0;
            while (i < dataElements.size()) {
                de = dataElements.get(i);
                if (!de.isPhysicalCoor() && (data = de.getAxisData(this.name)) != null) {
                    Sequence catNames = EnumAxis.extractCatNames(data);
                    n = 1;
                    while (n <= catNames.length()) {
                        Object cat = catNames.get(n);
                        if (!this.categories.contains(cat, false)) {
                            this.categories.add(cat);
                        }
                        ++n;
                    }
                }
                ++i;
            }
        }
        if (this.series == null) {
            this.series = new Sequence();
            i = 0;
            while (i < dataElements.size()) {
                de = dataElements.get(i);
                if (!de.isPhysicalCoor() && (data = de.getAxisData(this.name)) != null) {
                    Sequence serNames = EnumAxis.extractSerNames(data);
                    n = 1;
                    while (n <= serNames.length()) {
                        Object ser = serNames.get(n);
                        if (!this.series.contains(ser, false)) {
                            this.series.add(ser);
                        }
                        ++n;
                    }
                }
                ++i;
            }
        }
        this.t_catNum = this.categories.length();
        if (this.t_catNum == 0) {
            throw new RQException("Empty categories data of EnumAxis:[ " + this.name + " ]!");
        }
        Object catVal = this.categories.get(1);
        if (!(catVal instanceof String)) {
            throw new RQException("Category value must be 'String' type,current value is: " + catVal + ",  and it's type is: " + catVal.getClass().getName());
        }
        int n2 = this.t_serNum = this.series.length() == 0 ? 1 : this.series.length();
        if (this.series.length() > 0 && !((serVal = this.series.get(1)) instanceof String)) {
            throw new RQException("Series value must be 'String' type,current value is: " + serVal + ",  and it's type is: " + serVal.getClass().getName());
        }
        this.t_coorValue.addAll(this.categories);
    }

    public Shape getShape() {
        return null;
    }

    public double getSeriesWidth() {
        return this.t_seriesWidth;
    }

    @Override
    public ParamInfoList getParamInfoList() {
        ParamInfoList paramInfos = new ParamInfoList();
        ParamInfo.setCurrent(EnumAxis.class, this);
        String group = "enumaxis";
        paramInfos.add(group, new ParamInfo("categories"));
        paramInfos.add(group, new ParamInfo("series"));
        paramInfos.add(group, new ParamInfo("gapRatio", 25));
        paramInfos.addAll(super.getParamInfoList());
        return paramInfos;
    }

    @Override
    public boolean isEnumAxis() {
        return true;
    }

    @Override
    public boolean isDateAxis() {
        return false;
    }

    @Override
    public boolean isNumericAxis() {
        return false;
    }

    @Override
    public void checkDataMatch(Sequence data) {
        Object one;
        if (data != null && data.length() > 1 && !((one = data.get(1)) instanceof String)) {
            throw new RuntimeException("Axis " + this.name + " is enumeration axis, error data got:" + one);
        }
    }

    @Override
    public double animateDoubleValue(Object val) {
        throw new RuntimeException("Enumeration axis does not support animate double value.");
    }
}

