/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.element;

import com.scudata.chart.ChartColor;
import com.scudata.chart.Engine;
import com.scudata.chart.LinkElement;
import com.scudata.chart.Para;
import com.scudata.chart.Utils;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.chart.element.IMapAxis;
import com.scudata.chart.element.MapAxis;
import com.scudata.chart.resources.ChartMessage;
import com.scudata.common.RQException;
import com.scudata.common.StringUtils;
import com.scudata.dm.Sequence;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class Legend
extends LinkElement
implements IMapAxis {
    public String name;
    public double x = 0.82;
    public double y = 0.2;
    public double width = 0.0;
    public double height = 0.0;
    public boolean visible = true;
    public float transparent = 1.0f;
    public int iconWidth = 20;
    public int edgeIndent = 5;
    public Color backColor = new Color(255, 255, 255, 0);
    public int borderStyle = 1;
    public int borderWeight = 1;
    public Color borderColor = Color.black;
    public Para legendText = new Para();
    public String textFont;
    public Color textColor = Color.black;
    public int textStyle;
    public int textSize = 12;
    public int columns = 1;
    public Para legendType = new Para(new Integer(1));
    public Para legendLineStyle = new Para(new Integer(1));
    public Para legendLineWeight = new Para(new Float(1.0f));
    public Para legendLineColor = new Para(Color.lightGray);
    public Para legendFillColor = new Para();
    public Para legendMarkerShape = new Para(new Integer(1));
    private transient Engine e;
    private transient double px;
    private transient double py;
    private transient double pw;
    private transient double ph;

    @Override
    public void beforeDraw() {
    }

    public Sequence getLegendText() {
        return this.legendText.sequenceValue();
    }

    public void setLegendText(Sequence seq) {
        this.legendText.setValue(seq);
    }

    @Override
    public void drawBack() {
        if (!this.isVisible()) {
            return;
        }
        this.px = this.e.getXPixel(this.x);
        this.py = this.e.getYPixel(this.y);
        this.pw = this.width <= 0.0 ? this.autoWidth() : this.e.getXPixel(this.width);
        this.ph = this.height <= 0.0 ? this.drawLegend(false) + (double)this.edgeIndent : this.e.getYPixel(this.height);
        Graphics2D g = this.e.getGraphics();
        Rectangle2D.Double rect = new Rectangle2D.Double(this.px, this.py, this.pw, this.ph);
        Utils.fill(g, rect, this.transparent, this.backColor);
    }

    @Override
    public void draw() {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D g = this.e.getGraphics();
        if (Utils.setStroke(g, this.borderColor, this.borderStyle, this.borderWeight)) {
            g.drawRect((int)this.px, (int)this.py, (int)this.pw, (int)this.ph);
        }
    }

    private Shape drawIcon(int x, int y, int pos) {
        int type = this.legendType.intValue(pos);
        Graphics2D g = this.e.getGraphics();
        Color fColor = this.legendLineColor.colorValue(pos);
        if (fColor == null) {
            fColor = Para.defColorValue(pos);
        }
        int style = this.legendLineStyle.intValue(pos);
        float weight = this.legendLineWeight.floatValue(pos);
        ChartColor bColor = this.legendFillColor.chartColorValue(pos);
        int r = this.iconWidth / 3;
        int hr = this.iconWidth / 2;
        int cx = x + hr;
        int cy = y + hr;
        int shape = this.legendMarkerShape.intValue(pos);
        Rectangle rect = new Rectangle(x, y, this.iconWidth, this.iconWidth);
        switch (type) {
            case 1: {
                ChartColor backColor = bColor;
                Color foreColor = fColor;
                Point point = new Point(cx, cy);
                Utils.drawCartesianPoint2(g, point, 2, hr, hr, 0.0, style, weight, backColor, foreColor, this.transparent);
                break;
            }
            case 2: {
                Point point = new Point(cx, cy);
                Utils.drawCartesianPoint2(g, point, shape, r, r, r, style, weight, bColor, fColor, 1.0f);
                break;
            }
            case 3: {
                if (!Utils.setStroke(g, bColor.getColor1(), style, weight)) break;
                g.drawLine(x, cy, x + this.iconWidth, cy);
                break;
            }
            case 4: {
                r = this.iconWidth / 4;
                if (Utils.setStroke(g, fColor, style, weight)) {
                    g.drawLine(x, cy, x + this.iconWidth, cy);
                }
                Point p = new Point(cx, cy);
                Utils.drawCartesianPoint2(g, p, shape, r, r, r, style, weight, bColor, fColor, 1.0f);
                break;
            }
        }
        return rect;
    }

    private double autoWidth() {
        if (this.legendText == null) {
            String msg = ChartMessage.get().getMessage("legendTextEmpty");
            throw new RQException(msg);
        }
        Font font = Utils.getFont(this.textFont, this.textStyle, this.textSize);
        Graphics2D g = this.e.getGraphics();
        FontMetrics fm = g.getFontMetrics(font);
        double maxW = 0.0;
        int size = this.legendText.getLength();
        int i = 1;
        while (i <= size) {
            String text = this.legendText(i);
            int w = fm.stringWidth(text);
            if ((double)w > maxW) {
                maxW = w;
            }
            ++i;
        }
        if (this.columns < 1) {
            this.columns = 1;
        }
        return (maxW + (double)(this.edgeIndent * 3) + (double)this.iconWidth) * (double)this.columns;
    }

    private int drawLegend(ArrayList wrapText, int x, int y, int width, int txtHeight, int index, Font font, boolean reallyDraw) {
        Shape linkShape;
        int iconX = x + width - this.iconWidth - this.edgeIndent;
        int iconY = y + this.edgeIndent;
        int legendHeight = this.edgeIndent;
        StringBuffer linkBuf = new StringBuffer();
        if (wrapText.isEmpty()) {
            legendHeight += txtHeight;
        } else {
            int txtRows = wrapText.size();
            Graphics2D g = this.e.getGraphics();
            int sx = x + this.edgeIndent;
            int sy = y + this.edgeIndent;
            int i = 0;
            while (i < txtRows) {
                String str = (String)wrapText.get(i);
                if (reallyDraw) {
                    linkBuf.append(str);
                    Utils.drawText(g, str, sx, sy, font, this.textColor, this.textStyle, 0, 8);
                }
                sy = y + (legendHeight += txtHeight);
                ++i;
            }
        }
        if (reallyDraw && (linkShape = this.drawIcon(iconX, iconY, index)) != null) {
            String title = this.getTipTitle(index);
            this.addLink(linkShape, this.htmlLink.stringValue(index), title, this.linkTarget.stringValue(index));
        }
        return Math.max(legendHeight, this.iconWidth + this.edgeIndent);
    }

    @Override
    public void drawFore() {
        this.drawLegend(true);
    }

    private String legendText(int index) {
        return this.legendText.stringValue(index);
    }

    private double drawLegend(boolean reallyDraw) {
        double columnWidth;
        if (!this.isVisible()) {
            return 0.0;
        }
        if (this.columns < 1) {
            this.columns = 1;
        }
        if ((columnWidth = this.pw / (double)this.columns) - (double)(2 * this.edgeIndent) < (double)this.iconWidth) {
            return 0.0;
        }
        Font font = Utils.getFont(this.textFont, this.textStyle, this.textSize);
        Graphics2D g = this.e.getGraphics();
        FontMetrics fm = g.getFontMetrics(font);
        char aChar = '\u56fd';
        int textHeight = fm.getHeight();
        int aCharWidth = fm.charWidth(aChar);
        double textWidth = columnWidth - (double)(2 * this.edgeIndent) - (double)this.iconWidth;
        int size = this.legendText.getLength();
        double yy = this.py;
        double autoH = 0.0;
        int r = 0;
        while (true) {
            int tmpRowH = 0;
            int c = 0;
            while (c < this.columns) {
                int index = r * this.columns + c + 1;
                if (index > size) {
                    return autoH + (double)tmpRowH;
                }
                String text = this.legendText(index);
                double xx = this.px + columnWidth * (double)c;
                ArrayList<Object> wrapText = textWidth < (double)aCharWidth ? new ArrayList() : StringUtils.wrapString(text, fm, (float)textWidth);
                g.setFont(font);
                g.setColor(this.textColor);
                int h = this.drawLegend(wrapText, (int)xx, (int)yy, (int)columnWidth, textHeight, index, font, reallyDraw);
                if (h > tmpRowH) {
                    tmpRowH = h;
                }
                ++c;
            }
            yy += (double)tmpRowH;
            autoH += (double)tmpRowH;
            ++r;
        }
    }

    @Override
    public Engine getEngine() {
        return this.e;
    }

    @Override
    public ParamInfoList getParamInfoList() {
        ParamInfoList paramInfos = new ParamInfoList();
        ParamInfo.setCurrent(Legend.class, this);
        paramInfos.add(new ParamInfo("name"));
        paramInfos.add(new ParamInfo("legendText"));
        paramInfos.add(new ParamInfo("backColor", 3));
        paramInfos.add(new ParamInfo("columns", 24));
        paramInfos.add(new ParamInfo("transparent", 25));
        paramInfos.add(new ParamInfo("iconWidth", 24));
        paramInfos.add(new ParamInfo("edgeIndent", 24));
        paramInfos.add(new ParamInfo("visible", 10));
        String group = "coordinates";
        paramInfos.add(group, new ParamInfo("x", 25));
        paramInfos.add(group, new ParamInfo("y", 25));
        paramInfos.add(group, new ParamInfo("width", 25));
        paramInfos.add(group, new ParamInfo("height", 25));
        group = "border";
        paramInfos.add(group, new ParamInfo("borderStyle", 4));
        paramInfos.add(group, new ParamInfo("borderWeight", 24));
        paramInfos.add(group, new ParamInfo("borderColor", 3));
        group = "text";
        paramInfos.add(group, new ParamInfo("textFont", 5));
        paramInfos.add(group, new ParamInfo("textStyle", 8));
        paramInfos.add(group, new ParamInfo("textSize", 20));
        paramInfos.add(group, new ParamInfo("textColor", 3));
        group = "Legend";
        paramInfos.add(group, new ParamInfo("legendType", 23));
        paramInfos.add(group, new ParamInfo("legendLineStyle", 4));
        paramInfos.add(group, new ParamInfo("legendLineWeight", 25));
        paramInfos.add(group, new ParamInfo("legendLineColor", 3));
        paramInfos.add(group, new ParamInfo("legendFillColor", 12));
        paramInfos.add(group, new ParamInfo("legendMarkerShape", 7));
        paramInfos.addAll(super.getParamInfoList());
        return paramInfos;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setEngine(Engine e) {
        this.e = e;
        Utils.setParamsEngine(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getMapValue(Object val, byte mapProperty) {
        if (this.legendText == null) {
            String msg = ChartMessage.get().getMessage("legendTextEmpty");
            throw new RQException(msg);
        }
        switch (mapProperty) {
            case 3: {
                return MapAxis.getMapValue(this.legendText.sequenceValue(), val, this.legendFillColor);
            }
            case 1: {
                return MapAxis.getMapValue(this.legendText.sequenceValue(), val, this.legendLineColor);
            }
            case 2: {
                return MapAxis.getMapValue(this.legendText.sequenceValue(), val, this.legendMarkerShape);
            }
        }
        return null;
    }
}

