/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.element;

import com.scudata.chart.ChartColor;
import com.scudata.chart.ICoor;
import com.scudata.chart.Para;
import com.scudata.chart.PolarCoor;
import com.scudata.chart.Utils;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.chart.element.Column;
import com.scudata.chart.element.Dot;
import com.scudata.chart.element.EnumAxis;
import com.scudata.chart.element.TickAxis;
import com.scudata.chart.resources.ChartMessage;
import com.scudata.common.MessageManager;
import com.scudata.dm.Sequence;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class Line
extends Dot {
    public boolean endToHead = false;
    public boolean closedArea = false;
    public Para areaColor = new Para(null);
    public int stackType = 0;
    public boolean radiateLine = false;
    public boolean stairLine = false;
    public int arrow = 0;

    public boolean isStacked() {
        return this.stackType > 0;
    }

    @Override
    public ParamInfoList getParamInfoList() {
        ParamInfoList paramInfos = new ParamInfoList();
        ParamInfo.setCurrent(Line.class, this);
        paramInfos.add(new ParamInfo("endToHead", 10));
        paramInfos.add(new ParamInfo("closedArea", 10));
        paramInfos.add(new ParamInfo("areaColor", 12));
        paramInfos.add(new ParamInfo("stackType", 29));
        paramInfos.add(new ParamInfo("radiateLine", 10));
        paramInfos.add(new ParamInfo("stairLine", 10));
        ParamInfo arrowPI = new ParamInfo("arrow", 47);
        ParamInfoList superPF = super.getParamInfoList();
        MessageManager mm = ChartMessage.get();
        String groupName = mm.getMessage("point");
        superPF.getParams(groupName).add(2, arrowPI);
        paramInfos.addAll(superPF);
        return paramInfos;
    }

    @Override
    public void drawBack() {
        if (!this.isVisible() || !this.shadow) {
            return;
        }
        this.drawStep(1);
    }

    @Override
    public void draw() {
        if (!this.isVisible()) {
            return;
        }
        this.drawStep(2);
    }

    private Point2D getStairPoint(Point2D p1, Point2D p2) {
        if (p1 == null) {
            return null;
        }
        return new Point2D.Double(p1.getX(), p2.getY());
    }

    private void drawStep2(int index, ArrayList<Point2D> linePoints) {
        Color bc = this.lineColor.colorValueNullAsDef(index);
        int style = this.lineStyle.intValue(index);
        float weight = this.lineWeight.floatValue(index);
        ChartColor areaCcr = this.areaColor.chartColorValue(index);
        Graphics2D g = this.e.getGraphics();
        ICoor coor = this.getCoor();
        if (this.stairLine) {
            ArrayList<Point2D> stairPoints = new ArrayList<Point2D>();
            Point2D last = linePoints.get(0);
            int i = 1;
            while (i < linePoints.size()) {
                Point2D p = linePoints.get(i);
                Point2D m = this.getStairPoint(last, p);
                stairPoints.add(last);
                stairPoints.add(m);
                last = p;
                ++i;
            }
            stairPoints.add(last);
            linePoints = stairPoints;
        }
        if (this.closedArea) {
            if (!this.endToHead || this.stairLine) {
                if (this.isPhysicalCoor() || coor.isCartesianCoor()) {
                    Point2D.Double pe;
                    Point2D.Double p0;
                    Point2D p1 = linePoints.get(0);
                    Point2D pL = linePoints.get(linePoints.size() - 1);
                    if (this.isPhysicalCoor()) {
                        p0 = new Point2D.Double(p1.getX(), 0.0);
                        pe = new Point2D.Double(pL.getX(), 0.0);
                    } else {
                        TickAxis ta1 = coor.getAxis1();
                        Point2D pb = ta1.getBasePoint(coor);
                        if (ta1.getLocation() == 1) {
                            p0 = new Point2D.Double(p1.getX(), pb.getY());
                            pe = new Point2D.Double(pL.getX(), pb.getY());
                        } else {
                            p0 = new Point2D.Double(pb.getX(), p1.getY());
                            pe = new Point2D.Double(pb.getX(), pL.getY());
                        }
                    }
                    linePoints.add(0, p0);
                    linePoints.add(pe);
                } else {
                    PolarCoor pc = (PolarCoor)coor;
                    TickAxis ta = pc.getPolarAxis();
                    linePoints.add(ta.getBasePoint(coor));
                }
            }
            Path2D shape = Utils.getPath2D(linePoints, true);
            Rectangle rect = shape.getBounds();
            if (Utils.setPaint(g, rect.x, rect.y, rect.width, rect.height, areaCcr)) {
                Utils.fillPaint(g, shape, this.transparent);
            }
            if (Utils.setStroke(g, bc, style, weight)) {
                g.draw(shape);
            }
        } else if (Utils.setStroke(g, bc, style, weight)) {
            Point2D last = linePoints.get(0);
            int i = 1;
            while (i < linePoints.size()) {
                Point2D p = linePoints.get(i);
                Utils.drawLine(g, last, p, this.arrow);
                last = p;
                ++i;
            }
            if (this.endToHead) {
                Utils.drawLine(g, last, linePoints.get(0), this.arrow);
            }
        }
    }

    private void drawLine(int index, ArrayList<Point2D> linePoints, int step) {
        if (linePoints == null || linePoints.isEmpty()) {
            return;
        }
        Color bc = this.lineColor.colorValueNullAsDef(index);
        int style = this.lineStyle.intValue(index);
        float weight = this.lineWeight.floatValue(index);
        Graphics2D g = this.e.getGraphics();
        Point2D last = null;
        switch (step) {
            case 1: {
                if (this.stairLine) {
                    int i = 0;
                    while (i < linePoints.size()) {
                        Point2D p = linePoints.get(i);
                        Point2D m = this.getStairPoint(last, p);
                        Utils.drawLine1(g, last, m, style, weight);
                        Utils.drawLine1(g, m, p, style, weight);
                        last = p;
                        ++i;
                    }
                } else if (this.radiateLine) {
                    last = linePoints.get(0);
                    int i = 1;
                    while (i < linePoints.size()) {
                        Point2D p = linePoints.get(i);
                        Utils.drawLine1(g, last, p, style, weight);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < linePoints.size()) {
                        Point2D p = linePoints.get(i);
                        Utils.drawLine1(g, last, p, style, weight);
                        last = p;
                        ++i;
                    }
                }
                break;
            }
            case 2: {
                if (this.stairLine) {
                    this.drawStep2(index, linePoints);
                    break;
                }
                if (this.radiateLine) {
                    if (!Utils.setStroke(g, bc, style, weight)) break;
                    last = linePoints.get(0);
                    int i = 1;
                    while (i < linePoints.size()) {
                        Point2D p = linePoints.get(i);
                        Utils.drawLine(g, last, p, this.arrow);
                        ++i;
                    }
                    break;
                }
                this.drawStep2(index, linePoints);
                break;
            }
        }
    }

    private void drawEnumBasedLine(int step) {
        ICoor coor = this.getCoor();
        EnumAxis ea = (EnumAxis)coor.getAxis1();
        Sequence enumData = this.getAxisData(ea.getName());
        int catCount = this.categories.length();
        int serCount = this.series.length();
        if (serCount == 0) {
            ArrayList<Point2D> linePoints = new ArrayList<Point2D>();
            int c = 1;
            while (c <= catCount) {
                String catName = (String)this.categories.get(c);
                int index = Utils.indexOf(enumData, catName, null);
                if (index != 0) {
                    Object val1 = this.data1.get(index);
                    Object val2 = this.data2.get(index);
                    Point2D numericP = coor.getNumericPoint(val1, val2);
                    Point2D p = coor.getScreenPoint(numericP);
                    linePoints.add(p);
                }
                ++c;
            }
            this.drawLine(1, linePoints, step);
            this.drawDots(step, false);
            return;
        }
        ArrayList[] serLines = new ArrayList[serCount];
        int s = 0;
        while (s < serCount) {
            ArrayList linePoints;
            serLines[s] = linePoints = new ArrayList();
            ++s;
        }
        ArrayList<MarkerPoint> markerPoints = new ArrayList<MarkerPoint>();
        int c = 1;
        while (c <= catCount) {
            String catName = (String)this.categories.get(c);
            int index = 0;
            if (this.isStacked()) {
                Point2D basePoint = ea.getBasePoint(coor);
                Point2D lastPoint = null;
                double len = 0.0;
                int s2 = 1;
                while (s2 <= serCount) {
                    String serName = (String)this.series.get(s2);
                    index = Utils.indexOf(enumData, catName, serName);
                    if (index != 0) {
                        Point2D p;
                        Object val1 = Column.discardSeries(this.data1.get(index));
                        Object val2 = Column.discardSeries(this.data2.get(index));
                        if (this.stackType == 1) {
                            if (val2 instanceof Number) {
                                val2 = Column.getPercentValue(val1, val2, this.data1, this.data2);
                            } else {
                                val1 = Column.getPercentValue(val2, val1, this.data2, this.data1);
                            }
                        }
                        if (coor.isCartesianCoor()) {
                            p = coor.getScreenPoint(val1, val2);
                            if (s2 > 1) {
                                if (ea.getLocation() == 1) {
                                    len = basePoint.getY() - p.getY();
                                    p = new Point2D.Double(p.getX(), lastPoint.getY() - len);
                                } else {
                                    len = p.getX() - basePoint.getX();
                                    p = new Point2D.Double(lastPoint.getX() + len, p.getY());
                                }
                            }
                            serLines[s2 - 1].add(p);
                            lastPoint = p;
                        } else {
                            PolarCoor pc = (PolarCoor)coor;
                            p = pc.getPolarPoint(val1, val2);
                            if (s2 > 1) {
                                p = ea.getLocation() == 3 ? new Point2D.Double(p.getX(), p.getY() + lastPoint.getY()) : new Point2D.Double(lastPoint.getX() + p.getX(), p.getY());
                            }
                            serLines[s2 - 1].add(pc.getScreenPoint(p));
                            lastPoint = p;
                        }
                        markerPoints.add(new MarkerPoint(index, lastPoint));
                    }
                    ++s2;
                }
            } else {
                int s3 = 1;
                while (s3 <= serCount) {
                    String serName = (String)this.series.get(s3);
                    index = Utils.indexOf(enumData, catName, serName);
                    if (index != 0) {
                        Point2D p;
                        Object val1 = Column.discardSeries(this.data1.get(index));
                        Object val2 = Column.discardSeries(this.data2.get(index));
                        if (coor.isCartesianCoor()) {
                            p = coor.getScreenPoint(val1, val2);
                            serLines[s3 - 1].add(p);
                        } else {
                            PolarCoor pc = (PolarCoor)coor;
                            p = pc.getPolarPoint(val1, val2);
                            serLines[s3 - 1].add(pc.getScreenPoint(p));
                        }
                        markerPoints.add(new MarkerPoint(index, p));
                    }
                    ++s3;
                }
            }
            ++c;
        }
        int i = serCount - 1;
        while (i >= 0) {
            this.drawLine(i + 1, serLines[i], step);
            --i;
        }
        i = 0;
        while (i < markerPoints.size()) {
            MarkerPoint sp = (MarkerPoint)markerPoints.get(i);
            Shape shape = this.drawADot(sp.index, sp.p, step, true);
            if (shape != null) {
                int index = sp.index;
                String title = this.getTipTitle(index);
                this.addLink(shape, this.htmlLink.stringValue(index), title, this.linkTarget.stringValue(index));
            }
            ++i;
        }
    }

    private void drawDots(int step, boolean discardSeries) {
        int size = this.pointSize();
        int i = 1;
        while (i <= size) {
            Point2D p = this.getNumericPoint(i, discardSeries);
            Shape shape = this.drawADot(i, p, step);
            if (shape != null) {
                String title = this.getTipTitle(i);
                this.addLink(shape, this.htmlLink.stringValue(i), title, this.linkTarget.stringValue(i));
            }
            ++i;
        }
    }

    private void drawStep(int step) {
        ICoor coor = this.getCoor();
        if (coor != null && coor.isEnumBased()) {
            this.drawEnumBasedLine(step);
        } else {
            ArrayList<Point2D> linePoints = new ArrayList<Point2D>();
            int size = this.pointSize();
            int i = 1;
            while (i <= size) {
                Point2D p = this.getScreenPoint(i);
                linePoints.add(p);
                ++i;
            }
            this.drawLine(1, linePoints, step);
            this.drawDots(step, false);
        }
    }

    @Override
    public void drawFore() {
        if (!this.isVisible()) {
            return;
        }
        this.drawStep(3);
    }

    @Override
    public void prepare() {
        super.prepare();
        Column.checkStackProperties(this);
    }

    public void clone(Line l) {
        super.clone(l);
        l.endToHead = this.endToHead;
        l.closedArea = this.closedArea;
        l.areaColor = this.areaColor;
        l.stackType = this.stackType;
        l.radiateLine = this.radiateLine;
        l.stairLine = this.stairLine;
        l.arrow = this.arrow;
    }

    @Override
    public Object deepClone() {
        Line l = new Line();
        this.clone(l);
        return l;
    }

    class MarkerPoint {
        int index;
        Point2D p;

        public MarkerPoint(int index, Point2D p) {
            this.index = index;
            this.p = p;
        }
    }
}

