/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.element;

import com.scudata.chart.ICoor;
import com.scudata.chart.Para;
import com.scudata.chart.PolarCoor;
import com.scudata.chart.Utils;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.chart.element.EnumAxis;
import com.scudata.chart.element.Ring;
import com.scudata.chart.element.TickAxis;
import com.scudata.common.StringUtils;
import com.scudata.dm.Sequence;
import com.scudata.util.Variant;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class Sector
extends Ring {
    public Para textLineStyle = new Para(new Integer(1));
    public Para textLineWeight = new Para(new Float(1.0f));
    public Para textLineColor = new Para(Color.lightGray);
    private transient double outerRadius = 0.0;

    public Sector() {
        this.stackType = 1;
    }

    @Override
    public void drawBack() {
        super.drawBack();
        ICoor coor = this.getCoor();
        if (coor.isPolarCoor()) {
            PolarCoor pc = (PolarCoor)coor;
            TickAxis ta = pc.getPolarAxis();
            double outLen = ta.getAxisLength() / 10.0;
            this.outerRadius = ta.getAxisLength() + outLen;
        }
    }

    @Override
    public void draw() {
        ICoor coor = this.getCoor();
        PolarCoor pc = (PolarCoor)coor;
        EnumAxis ea = coor.getEnumAxis();
        if (this.categories.length() == 1) {
            int serCount = this.series.length();
            Point2D lastPoint = null;
            String catName = this.categories.get(1).toString();
            int s = 1;
            while (s <= serCount) {
                String serName = (String)this.series.get(s);
                int index = Utils.indexOf(this.data1, catName, serName);
                if (index != 0) {
                    Object val1 = Sector.discardSeries(this.data1.get(index));
                    Object val2 = Sector.discardSeries(this.data2.get(index));
                    if (this.stackType == 1) {
                        if (val2 instanceof Number) {
                            val2 = Sector.getPercentValue(val1, val2, this.data1, this.data2);
                        } else {
                            val1 = Sector.getPercentValue(val2, val1, this.data2, this.data1);
                        }
                    }
                    Point2D p = pc.getPolarPoint(val1, val2);
                    TickAxis angleAxis = pc.getAngleAxis();
                    double start = lastPoint == null ? angleAxis.startAngle : lastPoint.getY();
                    double extent = p.getY();
                    double angle = start + extent / 2.0;
                    Point2D.Double txtP = new Point2D.Double(p.getX(), angle);
                    this.drawCategoryAndLine(s, txtP);
                    lastPoint = new Point2D.Double(p.getX(), start + extent);
                }
                ++s;
            }
        } else {
            int catCount = this.categories.length();
            TickAxis axisP = pc.getPolarAxis();
            TickAxis axisA = pc.getAngleAxis();
            double angleRange = axisA.getAxisLength();
            int i = 1;
            while (i <= catCount) {
                Object cat = this.categories.get(i);
                double pR = axisP.getValueLen(cat);
                double pA = axisA.startAngle + angleRange * (double)i / (double)(catCount + 1);
                Point2D.Double p = new Point2D.Double(pR, pA);
                this.drawCategoryAndLine(i, p);
                ++i;
            }
        }
    }

    @Override
    public double getColumnWidth(TickAxis ia, int index) {
        ICoor coor = this.getCoor();
        EnumAxis ea = coor.getEnumAxis();
        double colWidth = this.series.length();
        if (colWidth == 0.0) {
            colWidth = 1.0;
        }
        double tmp = ia.getValueRadius(colWidth);
        return tmp;
    }

    @Override
    protected boolean isFillPie() {
        return true;
    }

    protected void drawCategoryAndLine(int index, Point2D polarIn) {
        PolarCoor pc = (PolarCoor)this.getCoor();
        EnumAxis ea = pc.getEnumAxis();
        String txt = this.categories.length() == 1 ? Variant.toString(this.series.get(index)) : Variant.toString(this.categories.get(index));
        if (!StringUtils.isValidString(txt)) {
            return;
        }
        Graphics2D g = this.e.getGraphics();
        int style = this.textLineStyle.intValue(index);
        float weight = this.textLineWeight.intValue(index);
        Point2D pIn = pc.getScreenPoint(polarIn);
        Point2D.Double polarOut = new Point2D.Double(this.outerRadius, polarIn.getY());
        Point2D pOut = pc.getScreenPoint(polarOut);
        if (Utils.setStroke(g, this.textLineColor.colorValue(index), style, weight)) {
            Utils.drawLine(g, pIn, pOut);
        }
        String fontName = this.textFont.stringValue(index);
        int fontStyle = this.textStyle.intValue(index);
        int fontSize = this.textSize.intValue(index);
        Color c = this.textColor.colorValue(index);
        Utils.drawPolarPointText(this.e, txt, pc, polarOut, fontName, fontStyle, fontSize, c, this.textOverlapping);
    }

    @Override
    public ParamInfoList getParamInfoList() {
        ParamInfoList paramInfos = new ParamInfoList();
        ParamInfo.setCurrent(Sector.class, this);
        String group = "textline";
        paramInfos.add(group, new ParamInfo("textLineStyle", 4));
        paramInfos.add(group, new ParamInfo("textLineWeight", 24));
        paramInfos.add(group, new ParamInfo("textLineColor", 3));
        paramInfos.addAll(super.getParamInfoList());
        ParamInfo pi = paramInfos.getParamInfoByName("data1");
        String tmp = pi.getTitle();
        int i = tmp.indexOf(47);
        if (i > 0) {
            tmp = tmp.substring(0, i);
        }
        pi.setTitle(tmp);
        pi = paramInfos.getParamInfoByName("data2");
        tmp = pi.getTitle();
        i = tmp.indexOf(47);
        if (i > 0) {
            tmp = tmp.substring(0, i);
        }
        pi.setTitle(tmp);
        return paramInfos;
    }

    @Override
    public void prepare() {
        super.prepare();
        ICoor coor = this.getCoor();
        if (coor.isCartesianCoor()) {
            throw new RuntimeException("Sector graph does not support cartesian coordinate system.");
        }
        if (!this.isStacked()) {
            throw new RuntimeException("Sector graph must be stacked by value or percent.");
        }
        EnumAxis ea = coor.getEnumAxis();
        if (ea.getLocation() != 3) {
            throw new RuntimeException("Sector graph must specify an enumeration axis as polar axis.");
        }
        String eaName = ea.getName();
        Sequence enumData = this.getAxisData(eaName);
        Sequence data = null;
        int size = enumData.length();
        int i = 1;
        while (i <= size) {
            Object val = enumData.get(i);
            Object series = Utils.parseSeries(val);
            if (series != null) break;
            if (data == null) {
                data = new Sequence();
            }
            data.set(i, " ," + val);
            ++i;
        }
        this.setAxisData(eaName, data);
        ea.gapRatio = 0.0;
        super.prepare();
    }

    public void clone(Sector s) {
        super.clone(s);
    }

    @Override
    public Object deepClone() {
        Sector s = new Sector();
        this.clone(s);
        return s;
    }
}

