/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.graph;

import com.scudata.cellset.graph.PublicProperty;
import com.scudata.chart.Consts;
import com.scudata.chart.Para;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.chart.graph.GraphLine;
import com.scudata.dm.Sequence;

public class Graph2Axis
extends GraphLine {
    public int yLabelInterval2 = 0;
    public double yStartValue2 = 0.0;
    public double yEndValue2 = 0.0;
    public Para leftSeries = null;
    public Para rightSeries = null;
    public byte type = (byte)21;

    @Override
    protected PublicProperty getPublicProperty() {
        PublicProperty pp = super.getPublicProperty();
        if (this.yLabelInterval + this.yLabelInterval2 != 0) {
            pp.setYInterval(String.valueOf(this.yLabelInterval) + ";" + this.yLabelInterval2);
        }
        if (this.yStartValue + this.yStartValue2 != 0.0) {
            pp.setYStartValue(String.valueOf(this.yStartValue) + ";" + this.yStartValue2);
        }
        if (this.yEndValue + this.yEndValue2 != 0.0) {
            pp.setYEndValue(String.valueOf(this.yEndValue) + ";" + this.yEndValue2);
        }
        pp.setType(this.type);
        return pp;
    }

    @Override
    public ParamInfoList getParamInfoList() {
        ParamInfoList paramInfos = super.getParamInfoList();
        paramInfos.delete("lineType");
        paramInfos.delete("line", "drawLineTrend");
        ParamInfo.setCurrent(Graph2Axis.class, this);
        paramInfos.add(new ParamInfo("type", 45));
        paramInfos.add(new ParamInfo("leftSeries", 1));
        paramInfos.add(new ParamInfo("rightSeries", 1));
        String group = "YAxisLabels";
        paramInfos.add(group, new ParamInfo("yLabelInterval2", 24));
        paramInfos.add(group, new ParamInfo("yStartValue2", 25));
        paramInfos.add(group, new ParamInfo("yEndValue2", 25));
        return paramInfos;
    }

    @Override
    protected boolean isSplitByAxis() {
        return this.leftSeries != null || this.rightSeries != null;
    }

    private boolean containsName(Para series, String serName) {
        Object val = series.getValue();
        if (val instanceof String) {
            String str = "," + (String)val + ",";
            return str.indexOf(serName) > 0;
        }
        if (val instanceof Sequence) {
            Sequence seq = series.sequenceValue();
            Object pos = seq.pos(serName, null);
            return pos != null;
        }
        throw new RuntimeException("Invalid series name:" + series);
    }

    @Override
    protected byte getSeriesAxis(String serName) {
        if (this.leftSeries != null) {
            if (this.containsName(this.leftSeries, serName)) {
                return Consts.AXIS_LEFT;
            }
            return Consts.AXIS_RIGHT;
        }
        if (this.rightSeries != null) {
            if (!this.containsName(this.rightSeries, serName)) {
                return Consts.AXIS_LEFT;
            }
            return Consts.AXIS_RIGHT;
        }
        return Consts.AXIS_LEFT;
    }
}

