/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.graph;

import com.scudata.cellset.graph.PublicProperty;
import com.scudata.cellset.graph.StatisticGraph;
import com.scudata.cellset.graph.config.AlarmLine;
import com.scudata.cellset.graph.config.GraphFont;
import com.scudata.cellset.graph.config.GraphFonts;
import com.scudata.cellset.graph.draw.DrawBase;
import com.scudata.cellset.graph.draw.ExtGraphCategory;
import com.scudata.cellset.graph.draw.ExtGraphProperty;
import com.scudata.cellset.graph.draw.ExtGraphSery;
import com.scudata.chart.Consts;
import com.scudata.chart.Engine;
import com.scudata.chart.ObjectElement;
import com.scudata.chart.Utils;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.chart.element.EnumAxis;
import com.scudata.common.StringUtils;
import com.scudata.common.control.BorderStyleBase;
import com.scudata.common.control.CellBorderBase;
import com.scudata.dm.Sequence;
import com.scudata.util.Variant;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.ArrayList;

public class GraphBase
extends ObjectElement {
    public Sequence categories = null;
    public Sequence values = null;
    public int borderStyle = 1;
    public float borderWidth = 0.75f;
    public Color borderColor = Color.lightGray;
    public boolean borderShadow = false;
    public String graphTitle;
    public String graphTitleFont;
    public boolean graphTitleBold = false;
    public boolean graphTitleVertical = false;
    public int graphTitleSize = 16;
    public Color graphTitleColor = Color.black;
    public int graphTitleAngle = 0;
    public int graphTitleMargin = 5;
    public String dataFont;
    public boolean dataBold = false;
    public boolean dataVertical = false;
    public int dataSize = 12;
    public Color dataColor = Color.black;
    public int dataAngle;
    public int displayData = 1;
    public int displayData2 = 1;
    public String displayDataFormat;
    public byte legendLocation = (byte)2;
    public int legendVerticalGap = 4;
    public int legendHorizonGap = 4;
    public boolean drawLegendBySery = false;
    public String legendFont;
    public boolean legendBold = false;
    public boolean legendVertical = false;
    public int legendSize = 12;
    public Color legendColor = Color.black;
    public int legendAngle;
    public boolean graphTransparent = false;
    public boolean gradientColor = true;
    public int topData;
    public boolean showOverlapText = true;
    public Color canvasColor = Color.white;
    public Color legendBorderColor = Color.darkGray;
    protected transient Engine e;

    @Override
    public ParamInfoList getParamInfoList() {
        ParamInfoList paramInfos = new ParamInfoList();
        ParamInfo.setCurrent(GraphBase.class, this);
        paramInfos.add(null, new ParamInfo("categories", 1));
        paramInfos.add(null, new ParamInfo("values", 1));
        String group = "border";
        paramInfos.add(group, new ParamInfo("borderStyle", 4));
        paramInfos.add(group, new ParamInfo("borderWidth", 25));
        paramInfos.add(group, new ParamInfo("borderColor", 3));
        paramInfos.add(group, new ParamInfo("borderShadow", 10));
        group = "graphTitle";
        paramInfos.add(group, new ParamInfo("graphTitle", 1));
        paramInfos.add(group, new ParamInfo("graphTitleFont", 5));
        paramInfos.add(group, new ParamInfo("graphTitleBold", 10));
        paramInfos.add(group, new ParamInfo("graphTitleVertical", 10));
        paramInfos.add(group, new ParamInfo("graphTitleSize", 20));
        paramInfos.add(group, new ParamInfo("graphTitleColor", 3));
        paramInfos.add(group, new ParamInfo("graphTitleAngle", 24));
        paramInfos.add(group, new ParamInfo("graphTitleMargin", 24));
        group = "dataMarks";
        paramInfos.add(group, new ParamInfo("displayData", 40));
        paramInfos.add(group, new ParamInfo("displayData2", 40));
        paramInfos.add(group, new ParamInfo("displayDataFormat", 1));
        paramInfos.add(group, new ParamInfo("dataFont", 5));
        paramInfos.add(group, new ParamInfo("dataBold", 10));
        paramInfos.add(group, new ParamInfo("dataVertical", 10));
        paramInfos.add(group, new ParamInfo("dataSize", 20));
        paramInfos.add(group, new ParamInfo("dataColor", 3));
        paramInfos.add(group, new ParamInfo("dataAngle", 24));
        group = "legend";
        paramInfos.add(group, new ParamInfo("legendLocation", 41));
        paramInfos.add(group, new ParamInfo("drawLegendBySery", 10));
        paramInfos.add(group, new ParamInfo("legendFont", 5));
        paramInfos.add(group, new ParamInfo("legendBold", 10));
        paramInfos.add(group, new ParamInfo("legendVertical", 10));
        paramInfos.add(group, new ParamInfo("legendSize", 20));
        paramInfos.add(group, new ParamInfo("legendColor", 3));
        paramInfos.add(group, new ParamInfo("legendAngle", 24));
        group = "graphColor";
        paramInfos.add(group, new ParamInfo("canvasColor", 3));
        paramInfos.add(group, new ParamInfo("legendBorderColor", 3));
        group = "other";
        paramInfos.add(group, new ParamInfo("graphTransparent", 10));
        paramInfos.add(group, new ParamInfo("gradientColor", 10));
        paramInfos.add(group, new ParamInfo("showOverlapText", 10));
        paramInfos.add(group, new ParamInfo("topData", 24));
        return paramInfos;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void beforeDraw() {
    }

    @Override
    public void drawBack() {
    }

    protected GraphFont getGraphFont(String family, boolean bold, boolean vertical, int size, Color color, int angle) {
        GraphFont gf = new GraphFont();
        gf.setFamily(family);
        gf.setBold(bold);
        gf.setVerticalText(vertical);
        gf.setSize(size);
        gf.setColor(color.getRGB());
        gf.setAngle(angle);
        return gf;
    }

    protected GraphFonts getGraphFonts() {
        GraphFonts gfs = new GraphFonts();
        GraphFont gf = this.getGraphFont(this.graphTitleFont, this.graphTitleBold, this.graphTitleVertical, this.graphTitleSize, this.graphTitleColor, this.graphTitleAngle);
        gfs.setTitleFont(gf);
        gf = this.getGraphFont(this.dataFont, this.dataBold, this.dataVertical, this.dataSize, this.dataColor, this.dataAngle);
        gfs.setDataFont(gf);
        gf = this.getGraphFont(this.legendFont, this.legendBold, this.legendVertical, this.legendSize, this.legendColor, this.legendAngle);
        gfs.setLegendFont(gf);
        return gfs;
    }

    protected AlarmLine[] getWarnLines() {
        return null;
    }

    protected PublicProperty getPublicProperty() {
        PublicProperty pp = new PublicProperty();
        pp.setBorder((byte)this.borderStyle, this.borderWidth, this.borderColor, this.borderShadow);
        pp.setGraphTitle(this.graphTitle);
        pp.setFonts(this.getGraphFonts());
        pp.setTitleMargin(this.graphTitleMargin);
        pp.setDisplayData((byte)this.displayData);
        pp.setDisplayData2((byte)this.displayData2);
        pp.setDisplayDataFormat(this.displayDataFormat);
        pp.setLegendLocation(this.legendLocation);
        pp.setLegendVerticalGap(this.legendVerticalGap);
        pp.setLegendHorizonGap(this.legendHorizonGap);
        pp.setDrawLegendBySery(this.drawLegendBySery);
        pp.setAlarmLines(this.getWarnLines());
        pp.setCanvasColor(this.canvasColor);
        pp.setGraphTransparent(this.graphTransparent);
        pp.setGradientColor(this.gradientColor);
        pp.setTopData(this.topData);
        pp.setShowOverlapText(this.showOverlapText);
        pp.setAxisColor(4, this.legendBorderColor);
        return pp;
    }

    protected boolean isSplitByAxis() {
        return false;
    }

    protected byte getSeriesAxis(String serName) {
        return Consts.AXIS_LEFT;
    }

    private void transferData(ExtGraphProperty egp) {
        ArrayList<ExtGraphCategory> egcList = new ArrayList<ExtGraphCategory>();
        if (this.categories == null) {
            egp.setGraphTitle("Demo data");
            ExtGraphCategory egc = new ExtGraphCategory();
            egc.setName("A");
            ArrayList<ExtGraphSery> series = new ArrayList<ExtGraphSery>();
            egc.setSeries(series);
            ExtGraphSery egs = new ExtGraphSery();
            egs.setName("Series1");
            egs.setValue(new Integer(80));
            series.add(egs);
            egcList.add(egc);
            egc = new ExtGraphCategory();
            egc.setName("B");
            series = new ArrayList();
            egc.setSeries(series);
            egs = new ExtGraphSery();
            egs.setName("Series1");
            egs.setValue(new Integer(55));
            series.add(egs);
            egcList.add(egc);
            egc = new ExtGraphCategory();
            egc.setName("C");
            series = new ArrayList();
            egc.setSeries(series);
            egs = new ExtGraphSery();
            egs.setName("Series1");
            egs.setValue(new Integer(70));
            series.add(egs);
            egcList.add(egc);
        } else {
            int c = this.categories.length();
            int i = 1;
            while (i <= c) {
                Object obj = this.categories.get(i);
                if (!(obj instanceof String)) {
                    this.categories.set(i, Variant.toString(obj));
                }
                ++i;
            }
            Sequence catNames = EnumAxis.extractCatNames(this.categories);
            Sequence serNames = EnumAxis.extractSerNames(this.categories);
            if (serNames.length() == 0) {
                serNames.add(null);
            }
            c = 1;
            while (c <= catNames.length()) {
                ExtGraphCategory egc = new ExtGraphCategory();
                String catName = Variant.toString(catNames.get(c));
                egc.setName(catName);
                ArrayList<ExtGraphSery> series = new ArrayList<ExtGraphSery>();
                egc.setSeries(series);
                int s = 1;
                while (s <= serNames.length()) {
                    ExtGraphSery egs = new ExtGraphSery();
                    String serName = Variant.toString(serNames.get(s));
                    egs.setName(serName);
                    int index = Utils.indexOf(this.categories, catName, serName);
                    if (index != 0) {
                        egs.setValue((Number)this.values.get(index));
                        if (this.isSplitByAxis()) {
                            egs.setAxis(this.getSeriesAxis(serName));
                        }
                        series.add(egs);
                    }
                    ++s;
                }
                egcList.add(egc);
                ++c;
            }
        }
        egp.setSplitByAxis(this.isSplitByAxis());
        egp.setCategories(egcList);
    }

    @Override
    public void draw() {
        PublicProperty pp = this.getPublicProperty();
        ExtGraphProperty egp = StatisticGraph.calc1(pp);
        this.transferData(egp);
        egp.recalcProperty();
        DrawBase graph = (DrawBase)DrawBase.getInstance(egp);
        graph.transProperty(egp);
        if (!StringUtils.isValidString(egp.getLinkTarget())) {
            egp.setLinkTarget("_blank");
        }
        int i = egp.getCanvasColor();
        int dShadow = 5;
        Graphics2D g = this.e.getGraphics();
        int w = this.e.getW();
        int h = this.e.getH();
        if (i != 0xFFFFFF) {
            if (pp.getBorderShadow()) {
                g.setBackground(Color.LIGHT_GRAY);
                g.clearRect(dShadow, dShadow, w, h);
            }
            g.setBackground(new Color(i));
            g.clearRect(0, 0, w - dShadow, h - dShadow);
        }
        StatisticGraph.drawBackGraph(g, egp, w - dShadow, h - dShadow);
        if (pp.getBorderStyle() != 0 && pp.getBorderWidth() > 0.0f && pp.getBorderColor() != 0xFFFFFF) {
            BorderStyleBase bs = new BorderStyleBase();
            bs.setTBStyle(pp.getBorderStyle());
            bs.setBBStyle(pp.getBorderStyle());
            bs.setLBStyle(pp.getBorderStyle());
            bs.setRBStyle(pp.getBorderStyle());
            bs.setTBWidth(pp.getBorderWidth());
            bs.setBBWidth(pp.getBorderWidth());
            bs.setLBWidth(pp.getBorderWidth());
            bs.setRBWidth(pp.getBorderWidth());
            bs.setTBColor(pp.getBorderColor());
            bs.setBBColor(pp.getBorderColor());
            bs.setLBColor(pp.getBorderColor());
            bs.setRBColor(pp.getBorderColor());
            CellBorderBase.setEnv(g, bs, 1, 1, 1, 1, false);
            CellBorderBase.drawBorder(0, 0, w - dShadow, h - dShadow);
        }
        if (w > 50 && h > 50) {
            g.setStroke(new BasicStroke(1.0f, 1, 1, 0.1f));
            DrawBase db = graph;
            db.setGraphics2D(g);
            db.setGraphWH(w - dShadow, h - dShadow);
            db.draw(null);
        }
    }

    @Override
    public void drawFore() {
    }

    public void prepare() {
        Utils.setParamsEngine(this);
    }

    @Override
    public void setEngine(Engine e) {
        this.e = e;
    }

    @Override
    public Engine getEngine() {
        return this.e;
    }

    @Override
    public ArrayList<Shape> getShapes() {
        return null;
    }

    @Override
    public ArrayList<String> getLinks() {
        return null;
    }
}

