/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.chart.graph;

import com.scudata.cellset.graph.PublicProperty;
import com.scudata.cellset.graph.config.AlarmLine;
import com.scudata.cellset.graph.config.GraphFont;
import com.scudata.cellset.graph.config.GraphFonts;
import com.scudata.chart.Para;
import com.scudata.chart.edit.ParamInfo;
import com.scudata.chart.edit.ParamInfoList;
import com.scudata.chart.graph.GraphBase;
import com.scudata.dm.Sequence;
import com.scudata.util.Variant;
import java.awt.Color;

public class GraphElement
extends GraphBase {
    public String xTitle;
    public String xTitleFont;
    public boolean xTitleBold = false;
    public boolean xTitleVertical = false;
    public int xTitleSize = 12;
    public Color xTitleColor = Color.black;
    public int xTitleAngle = 0;
    public String yTitle;
    public String yTitleFont;
    public boolean yTitleBold = false;
    public boolean yTitleVertical = false;
    public int yTitleSize = 12;
    public Color yTitleColor = Color.black;
    public int yTitleAngle;
    public String xLabelFont;
    public boolean xLabelBold = false;
    public boolean xLabelVertical = false;
    public int xLabelSize = 12;
    public Color xLabelColor = Color.black;
    public int xLabelAngle = 0;
    public int xLabelInterval = 0;
    public String yLabelFont;
    public boolean yLabelBold = false;
    public boolean yLabelVertical = false;
    public int yLabelSize = 12;
    public Color yLabelColor = Color.black;
    public int yLabelAngle = 0;
    public int yLabelInterval = 0;
    public double yStartValue = 0.0;
    public double yEndValue = 0.0;
    public double dataUnit = 1.0;
    public int yMinMarks = 2;
    public int gridLineType = 2;
    public Color gridLineColor = Color.lightGray;
    public Para warnLineStyle = new Para(new Integer(2));
    public Para warnLineWeight = new Para(new Float(1.0f));
    public Para warnLineColor = new Para(Color.red);
    public Sequence warnLineData = null;
    public Color axisTopColor = Color.white;
    public Color axisBottomColor = Color.lightGray;
    public Color axisLeftColor = Color.lightGray;
    public Color axisRightColor = Color.white;
    public Color graphBackColor = Color.white;

    @Override
    public ParamInfoList getParamInfoList() {
        ParamInfoList paramInfos = new ParamInfoList();
        ParamInfo.setCurrent(GraphElement.class, this);
        String group = "XAxisTitle";
        paramInfos.add(group, new ParamInfo("xTitle", 1));
        paramInfos.add(group, new ParamInfo("xTitleFont", 5));
        paramInfos.add(group, new ParamInfo("xTitleBold", 10));
        paramInfos.add(group, new ParamInfo("xTitleVertical", 10));
        paramInfos.add(group, new ParamInfo("xTitleSize", 20));
        paramInfos.add(group, new ParamInfo("xTitleColor", 3));
        paramInfos.add(group, new ParamInfo("xTitleAngle", 24));
        group = "YAxisTitle";
        paramInfos.add(group, new ParamInfo("yTitle", 1));
        paramInfos.add(group, new ParamInfo("yTitleFont", 5));
        paramInfos.add(group, new ParamInfo("yTitleBold", 10));
        paramInfos.add(group, new ParamInfo("yTitleVertical", 10));
        paramInfos.add(group, new ParamInfo("yTitleSize", 20));
        paramInfos.add(group, new ParamInfo("yTitleColor", 3));
        paramInfos.add(group, new ParamInfo("yTitleAngle", 24));
        group = "XAxisLabels";
        paramInfos.add(group, new ParamInfo("xLabelFont", 5));
        paramInfos.add(group, new ParamInfo("xLabelBold", 10));
        paramInfos.add(group, new ParamInfo("xLabelVertical", 10));
        paramInfos.add(group, new ParamInfo("xLabelSize", 20));
        paramInfos.add(group, new ParamInfo("xLabelColor", 3));
        paramInfos.add(group, new ParamInfo("xLabelAngle", 24));
        paramInfos.add(group, new ParamInfo("xLabelInterval", 24));
        group = "YAxisLabels";
        paramInfos.add(group, new ParamInfo("yLabelFont", 5));
        paramInfos.add(group, new ParamInfo("yLabelBold", 10));
        paramInfos.add(group, new ParamInfo("yLabelVertical", 10));
        paramInfos.add(group, new ParamInfo("yLabelSize", 20));
        paramInfos.add(group, new ParamInfo("yLabelColor", 3));
        paramInfos.add(group, new ParamInfo("yLabelAngle", 24));
        paramInfos.add(group, new ParamInfo("yLabelInterval", 24));
        paramInfos.add(group, new ParamInfo("yStartValue", 25));
        paramInfos.add(group, new ParamInfo("yEndValue", 25));
        paramInfos.add(group, new ParamInfo("yMinMarks", 24));
        group = "GridLine";
        paramInfos.add(group, new ParamInfo("gridLineType", 4));
        paramInfos.add(group, new ParamInfo("gridLineColor", 3));
        group = "WarnLines";
        paramInfos.add(group, new ParamInfo("warnLineData", 1));
        paramInfos.add(group, new ParamInfo("warnLineStyle", 4));
        paramInfos.add(group, new ParamInfo("warnLineWeight", 25));
        paramInfos.add(group, new ParamInfo("warnLineColor", 3));
        group = "axisColor";
        paramInfos.add(group, new ParamInfo("axisTopColor", 3));
        paramInfos.add(group, new ParamInfo("axisBottomColor", 3));
        paramInfos.add(group, new ParamInfo("axisLeftColor", 3));
        paramInfos.add(group, new ParamInfo("axisRightColor", 3));
        group = "graphColor";
        paramInfos.add(group, new ParamInfo("graphBackColor", 3));
        paramInfos.addAll(super.getParamInfoList());
        return paramInfos;
    }

    @Override
    protected GraphFonts getGraphFonts() {
        GraphFonts gfs = super.getGraphFonts();
        GraphFont gf = this.getGraphFont(this.xTitleFont, this.xTitleBold, this.xTitleVertical, this.xTitleSize, this.xTitleColor, this.xTitleAngle);
        gfs.setXTitleFont(gf);
        gf = this.getGraphFont(this.yTitleFont, this.yTitleBold, this.yTitleVertical, this.yTitleSize, this.yTitleColor, this.yTitleAngle);
        gfs.setYTitleFont(gf);
        gf = this.getGraphFont(this.xLabelFont, this.xLabelBold, this.xLabelVertical, this.xLabelSize, this.xLabelColor, this.xLabelAngle);
        gfs.setXLabelFont(gf);
        gf = this.getGraphFont(this.yLabelFont, this.yLabelBold, this.yLabelVertical, this.yLabelSize, this.yLabelColor, this.yLabelAngle);
        gfs.setYLabelFont(gf);
        return gfs;
    }

    @Override
    protected AlarmLine[] getWarnLines() {
        if (this.warnLineData == null) {
            return null;
        }
        AlarmLine[] als = new AlarmLine[this.warnLineData.length()];
        int i = 1;
        while (i <= this.warnLineData.length()) {
            AlarmLine al = new AlarmLine();
            al.setAlarmValue(Variant.toString(this.warnLineData.get(i)));
            al.setLineType((byte)this.warnLineStyle.intValue(i));
            al.setLineThick((byte)this.warnLineWeight.floatValue(i));
            al.setColor(this.warnLineColor.colorValue(i).getRGB());
            als[i - 1] = al;
            ++i;
        }
        return als;
    }

    @Override
    protected PublicProperty getPublicProperty() {
        PublicProperty pp = super.getPublicProperty();
        pp.setXTitle(this.xTitle);
        pp.setYTitle(this.yTitle);
        pp.setXInterval(this.xLabelInterval);
        String buf = String.valueOf(this.yLabelInterval);
        if (this.yLabelInterval != 0) {
            pp.setYInterval(String.valueOf(this.yLabelInterval));
        }
        buf = String.valueOf(this.yStartValue);
        if (this.yStartValue != 0.0) {
            pp.setYStartValue(buf);
        }
        buf = String.valueOf(this.yEndValue);
        if (this.yEndValue != 0.0) {
            pp.setYEndValue(buf);
        }
        pp.setYMinMarks(this.yMinMarks);
        pp.setGridLineType((byte)this.gridLineType);
        pp.setGridLineColor(this.gridLineColor.getRGB());
        pp.setAxisColor(0, this.axisTopColor);
        pp.setAxisColor(1, this.axisBottomColor);
        pp.setAxisColor(2, this.axisLeftColor);
        pp.setAxisColor(3, this.axisRightColor);
        pp.setGraphBackColor(this.graphBackColor);
        return pp;
    }
}

