/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.Sentence;
import java.util.Enumeration;

public final class ArgumentTokenizer
implements Enumeration<String> {
    private String str;
    private int len;
    private int index;
    private char delim = (char)44;
    private boolean parentheses = false;
    private boolean brackets = false;
    private boolean braces = false;
    private boolean singleQuotation = false;
    private boolean count;

    public ArgumentTokenizer(String s) {
        this(s, ',', false, false, false);
    }

    public ArgumentTokenizer(String s, char delim) {
        this(s, delim, false, false, false);
    }

    public ArgumentTokenizer(String s, boolean ignoreParentheses, boolean ignoreBrackets, boolean ignoreBraces) {
        this(s, ',', ignoreParentheses, ignoreBrackets, ignoreBraces);
    }

    public ArgumentTokenizer(String s, char delim, boolean ignoreParentheses, boolean ignoreBrackets, boolean ignoreBraces) {
        this(s, delim, ignoreParentheses, ignoreBrackets, ignoreBraces, false);
    }

    public ArgumentTokenizer(String s, char delim, boolean ignoreParentheses, boolean ignoreBrackets, boolean ignoreBraces, boolean ignoreSingleQuotation) {
        this.str = s;
        this.delim = delim;
        this.parentheses = !ignoreParentheses;
        this.brackets = !ignoreBrackets;
        this.braces = !ignoreBraces;
        this.singleQuotation = !ignoreSingleQuotation;
        this.len = this.str == null || this.str.length() == 0 ? -1 : this.str.length();
    }

    public String next() {
        if (this.str == null || this.index > this.len) {
            return null;
        }
        int old = this.index;
        while (this.index <= this.len) {
            int tmp;
            if (this.index == this.len) {
                ++this.index;
                if (this.len <= 1 || this.str.charAt(this.len - 1) != this.delim) break;
                return this.count ? null : "";
            }
            char ch = this.str.charAt(this.index);
            if (ch == '\"' || this.singleQuotation && ch == '\'') {
                tmp = Sentence.scanQuotation(this.str, this.index);
                if (tmp < 0) {
                    this.index = this.len + 1;
                    return this.count ? null : this.str.substring(old);
                }
                this.index = tmp + 1;
                continue;
            }
            if (this.parentheses && ch == '(') {
                tmp = Sentence.scanParenthesis(this.str, this.index);
                if (tmp < 0) {
                    this.index = this.len + 1;
                    return this.count ? null : this.str.substring(old);
                }
                this.index = tmp + 1;
                continue;
            }
            if (this.brackets && ch == '[') {
                tmp = Sentence.scanBracket(this.str, this.index);
                if (tmp < 0) {
                    this.index = this.len + 1;
                    return this.count ? null : this.str.substring(old);
                }
                this.index = tmp + 1;
                continue;
            }
            if (this.braces && ch == '{') {
                tmp = Sentence.scanBrace(this.str, this.index);
                if (tmp < 0) {
                    this.index = this.len + 1;
                    return this.count ? null : this.str.substring(old);
                }
                this.index = tmp + 1;
                continue;
            }
            ++this.index;
            if (ch == this.delim) break;
        }
        return this.count ? null : this.str.substring(old, this.index - 1);
    }

    public String nextToken() {
        return this.next();
    }

    @Override
    public String nextElement() {
        return this.next();
    }

    public int countTokens() {
        int j = this.index;
        this.count = true;
        int i = 0;
        while (this.index <= this.len) {
            this.next();
            ++i;
        }
        this.index = j;
        this.count = false;
        return i;
    }

    public boolean hasNext() {
        return this.index <= this.len;
    }

    public boolean hasMoreTokens() {
        return this.hasNext();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasNext();
    }
}

