/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.IRecord;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;

public class ByteArrayInputRecord {
    private ByteArrayInputStream in;

    public ByteArrayInputRecord(byte[] buf) {
        this.in = new ByteArrayInputStream(buf);
    }

    public boolean readBoolean() throws IOException {
        int ch = this.in.read();
        return ch == 1;
    }

    public byte readByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public byte[] readBytes() throws IOException {
        int len = this.readInt();
        if (len <= 0) {
            return null;
        }
        byte[] buf = new byte[len];
        this.readFully(buf);
        return buf;
    }

    public ArrayList<Byte> readByteArray() throws IOException {
        int len = this.readShort();
        if (len <= 0) {
            return null;
        }
        ArrayList<Byte> buf = new ArrayList<Byte>(len);
        int i = 0;
        while (i < len) {
            buf.add(new Byte(this.readByte()));
            ++i;
        }
        return buf;
    }

    public short readShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public final int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 8) + (ch2 << 0);
    }

    public int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readString() throws IOException {
        int size = this.readInt();
        if (size == -1) {
            return null;
        }
        StringBuffer str = new StringBuffer(size);
        byte[] bytearr = new byte[size];
        int count = 0;
        this.readFully(bytearr, 0, size);
        while (count < size) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > size) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    break;
                }
                case 14: {
                    if ((count += 3) > size) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(str);
    }

    public String[] readStrings() throws IOException {
        int size = this.readShort();
        if (size <= 0) {
            return null;
        }
        String[] buf = new String[size];
        int i = 0;
        while (i < size) {
            buf[i] = this.readString();
            ++i;
        }
        return buf;
    }

    public ArrayList<String> readStringArray() throws IOException {
        int size = this.readShort();
        if (size <= 0) {
            return null;
        }
        ArrayList<String> buf = new ArrayList<String>(size);
        int i = 0;
        while (i < size) {
            buf.add(this.readString());
            ++i;
        }
        return buf;
    }

    public int readFully(byte[] b, int off, int len) throws IOException {
        int got;
        int total = 0;
        do {
            if ((got = this.in.read(b, off + total, len - total)) >= 0) continue;
            return total == 0 ? -1 : total;
        } while ((total += got) != len);
        return total;
    }

    public int readFully(byte[] b) throws IOException {
        return this.readFully(b, 0, b.length);
    }

    public String readUTF() throws IOException {
        int utflen = this.readUnsignedShort();
        StringBuffer str = new StringBuffer(utflen);
        byte[] bytearr = new byte[utflen];
        int count = 0;
        this.readFully(bytearr, 0, utflen);
        while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(str);
    }

    public IRecord readRecord(IRecord r) throws IOException, ClassNotFoundException {
        int size = this.readInt();
        if (size <= 0) {
            return null;
        }
        byte[] s = new byte[size];
        this.readFully(s);
        r.fillRecord(s);
        return r;
    }

    public Object readObject(boolean test) throws IOException, ClassNotFoundException {
        byte b = this.readByte();
        switch (b) {
            case -1: {
                return null;
            }
            case 0: {
                String className = this.readString();
                IRecord rec = null;
                try {
                    rec = (IRecord)Class.forName(className).newInstance();
                }
                catch (Exception e) {
                    if (className.startsWith("com.raqsoft.")) {
                        try {
                            className = "com.scudata." + className.substring(12);
                            rec = (IRecord)Class.forName(className).newInstance();
                        }
                        catch (Exception e2) {
                            e.printStackTrace();
                        }
                    }
                    e.printStackTrace();
                }
                return this.readRecord(rec);
            }
            case 1: {
                return this.readUTF();
            }
            case 2: {
                int scale = this.readInt();
                byte[] bb = this.readBytes();
                return new BigDecimal(new BigInteger(bb), scale);
            }
            case 31: {
                return new Timestamp(this.readLong());
            }
            case 32: {
                return new Time(this.readLong());
            }
            case 33: {
                return new Date(this.readLong());
            }
            case 3: {
                return new java.util.Date(this.readLong());
            }
            case 4: {
                return new Integer(this.readInt());
            }
            case 5: {
                return new Long(this.readLong());
            }
            case 6: {
                return this.readByte() == 1 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return new BigInteger(this.readBytes());
            }
            case 8: {
                return this.readBytes();
            }
            case 9: {
                return new Double(this.readDouble());
            }
            case 10: {
                return new Float(this.readFloat());
            }
            case 11: {
                return new Byte(this.readByte());
            }
            case 12: {
                return new Short(this.readShort());
            }
            case 13: {
                return this.readString();
            }
        }
        return this.readBytes();
    }

    public boolean readBoolean2() throws IOException, EOFException {
        if (this.in.available() > 0) {
            int ch = this.in.read();
            return ch == 1;
        }
        throw new EOFException();
    }

    public byte readByte2() throws IOException, EOFException, EOFException {
        if (this.in.available() > 0) {
            int ch = this.in.read();
            if (ch < 0) {
                throw new EOFException();
            }
            return (byte)ch;
        }
        throw new EOFException();
    }

    public byte[] readBytes2() throws IOException, EOFException {
        if (this.in.available() > 0) {
            int len = this.readInt();
            if (len <= 0) {
                return null;
            }
            byte[] buf = new byte[len];
            this.readFully(buf);
            return buf;
        }
        throw new EOFException();
    }

    public ArrayList<Byte> readByteArray2() throws IOException, EOFException {
        if (this.in.available() > 0) {
            int len = this.readShort();
            if (len <= 0) {
                return null;
            }
            ArrayList<Byte> buf = new ArrayList<Byte>(len);
            int i = 0;
            while (i < len) {
                buf.add(new Byte(this.readByte()));
                ++i;
            }
            return buf;
        }
        throw new EOFException();
    }

    public short readShort2() throws IOException, EOFException {
        if (this.in.available() > 0) {
            int ch2;
            int ch1 = this.in.read();
            if ((ch1 | (ch2 = this.in.read())) < 0) {
                throw new EOFException();
            }
            return (short)((ch1 << 8) + (ch2 << 0));
        }
        throw new EOFException();
    }

    public int readInt2() throws IOException, EOFException {
        if (this.in.available() > 0) {
            int ch4;
            int ch3;
            int ch2;
            int ch1 = this.in.read();
            if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
                throw new EOFException();
            }
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        }
        throw new EOFException();
    }

    public float readFloat2() throws IOException, EOFException {
        if (this.in.available() > 0) {
            return Float.intBitsToFloat(this.readInt());
        }
        throw new EOFException();
    }

    public long readLong2() throws IOException, EOFException {
        if (this.in.available() > 0) {
            return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
        }
        throw new EOFException();
    }

    public double readDouble2() throws IOException, EOFException {
        if (this.in.available() > 0) {
            return Double.longBitsToDouble(this.readLong());
        }
        throw new EOFException();
    }

    public String readString2() throws IOException, EOFException {
        if (this.in.available() > 0) {
            return this.readString();
        }
        throw new EOFException();
    }

    public String[] readStrings2() throws IOException, EOFException {
        if (this.in.available() > 0) {
            int size = this.readShort();
            if (size <= 0) {
                return null;
            }
            String[] buf = new String[size];
            int i = 0;
            while (i < size) {
                buf[i] = this.readString();
                ++i;
            }
            return buf;
        }
        throw new EOFException();
    }

    public ArrayList<String> readStringArray2() throws IOException, EOFException {
        if (this.in.available() > 0) {
            int size = this.readShort();
            if (size <= 0) {
                return null;
            }
            ArrayList<String> buf = new ArrayList<String>(size);
            int i = 0;
            while (i < size) {
                buf.add(this.readString());
                ++i;
            }
            return buf;
        }
        throw new EOFException();
    }

    public int readFully2(byte[] b, int off, int len) throws IOException, EOFException {
        if (this.in.available() > 0) {
            int got;
            int total = 0;
            do {
                if ((got = this.in.read(b, off + total, len - total)) >= 0) continue;
                return total == 0 ? -1 : total;
            } while ((total += got) != len);
            return total;
        }
        throw new EOFException();
    }

    public int readFully2(byte[] b) throws IOException, EOFException {
        if (this.in.available() > 0) {
            return this.readFully(b, 0, b.length);
        }
        throw new EOFException();
    }

    public String readUTF2() throws IOException {
        if (this.in.available() > 0) {
            int utflen = this.readShort();
            StringBuffer str = new StringBuffer(utflen);
            byte[] bytearr = new byte[utflen];
            int count = 0;
            this.readFully(bytearr, 0, utflen);
            while (count < utflen) {
                int c = bytearr[count] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++count;
                        str.append((char)c);
                        break;
                    }
                    case 12: 
                    case 13: {
                        if ((count += 2) > utflen) {
                            throw new UTFDataFormatException();
                        }
                        byte char2 = bytearr[count - 1];
                        if ((char2 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                        break;
                    }
                    case 14: {
                        if ((count += 3) > utflen) {
                            throw new UTFDataFormatException();
                        }
                        byte char2 = bytearr[count - 2];
                        byte char3 = bytearr[count - 1];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new UTFDataFormatException();
                        }
                        str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                        break;
                    }
                    default: {
                        throw new UTFDataFormatException();
                    }
                }
            }
            return new String(str);
        }
        throw new EOFException();
    }

    public IRecord readRecord2(IRecord r) throws IOException, ClassNotFoundException, EOFException {
        if (this.in.available() > 0) {
            int size = this.readInt();
            if (size <= 0) {
                return null;
            }
            byte[] s = new byte[size];
            this.in.read(s);
            r.fillRecord(s);
            return r;
        }
        throw new EOFException();
    }

    public Object readObject2(boolean test) throws IOException, ClassNotFoundException, EOFException {
        if (this.in.available() > 0) {
            byte b = this.readByte();
            switch (b) {
                case -1: {
                    return null;
                }
                case 1: {
                    return this.readUTF();
                }
                case 2: {
                    int scale = this.readInt();
                    byte[] bb = this.readBytes();
                    return new BigDecimal(new BigInteger(bb), scale);
                }
                case 3: {
                    return new java.util.Date(this.readLong());
                }
                case 4: {
                    return new Integer(this.readInt());
                }
                case 5: {
                    return new Long(this.readLong());
                }
                case 6: {
                    return this.readByte() == 1 ? Boolean.TRUE : Boolean.FALSE;
                }
                case 7: {
                    return new BigInteger(this.readBytes());
                }
                case 8: {
                    return this.readBytes();
                }
                case 9: {
                    return new Double(this.readDouble());
                }
                case 10: {
                    return new Float(this.readFloat());
                }
                case 11: {
                    return new Byte(this.readByte());
                }
                case 12: {
                    return new Short(this.readShort());
                }
            }
            return this.readBytes();
        }
        throw new EOFException();
    }

    public int available() {
        return this.in.available();
    }
}

