/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.IRecord;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;

public class ByteArrayOutputRecord {
    private ByteArrayOutputStream out = new ByteArrayOutputStream();

    public void writeBoolean(boolean b) throws IOException {
        if (b) {
            this.out.write(1);
        } else {
            this.out.write(0);
        }
    }

    public void writeByte(byte v) throws IOException {
        this.out.write(v);
    }

    public void writeByte(int v) throws IOException {
        this.out.write(v);
    }

    public void writeBytes(byte[] v) throws IOException {
        if (v == null) {
            this.writeInt(0);
        } else {
            this.writeInt(v.length);
            this.out.write(v);
        }
    }

    public void writeByteArray(ArrayList<Byte> v) throws IOException {
        if (v == null) {
            this.writeShort((short)0);
        } else {
            int size = v.size();
            this.writeShort((short)size);
            int i = 0;
            while (i < size) {
                this.writeByte(v.get(i));
                ++i;
            }
        }
    }

    public void writeStrings(String[] v) throws IOException {
        if (v == null) {
            this.writeShort((short)0);
        } else {
            int size = v.length;
            this.writeShort((short)size);
            int i = 0;
            while (i < size) {
                this.writeString(v[i]);
                ++i;
            }
        }
    }

    public void writeStringArray(ArrayList<String> v) throws IOException {
        if (v == null) {
            this.writeShort((short)0);
        } else {
            int size = v.size();
            this.writeShort((short)size);
            int i = 0;
            while (i < size) {
                this.writeString(v.get(i));
                ++i;
            }
        }
    }

    public void writeShort(short v) throws IOException {
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
    }

    public void writeInt(int v) throws IOException {
        this.out.write(v >>> 24 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeLong(long v) throws IOException {
        this.out.write((int)(v >>> 56) & 0xFF);
        this.out.write((int)(v >>> 48) & 0xFF);
        this.out.write((int)(v >>> 40) & 0xFF);
        this.out.write((int)(v >>> 32) & 0xFF);
        this.out.write((int)(v >>> 24) & 0xFF);
        this.out.write((int)(v >>> 16) & 0xFF);
        this.out.write((int)(v >>> 8) & 0xFF);
        this.out.write((int)(v >>> 0) & 0xFF);
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeString(String s) throws IOException {
        if (s == null) {
            this.writeInt(-1);
        } else {
            char c;
            int slen = s.length();
            int utflen = 0;
            char[] chars = new char[slen];
            int count = 0;
            s.getChars(0, slen, chars, 0);
            int i = 0;
            while (i < slen) {
                c = chars[i];
                utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
                ++i;
            }
            byte[] bytearr = new byte[utflen];
            this.writeInt(utflen);
            int i2 = 0;
            while (i2 < slen) {
                c = chars[i2];
                if (c >= '\u0001' && c <= '\u007f') {
                    bytearr[count++] = (byte)c;
                } else if (c > '\u07ff') {
                    bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                    bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                    bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                } else {
                    bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                    bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                }
                ++i2;
            }
            this.out.write(bytearr);
        }
    }

    public int writeUTF(String str) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        str.getChars(0, strlen, charr, 0);
        int i = 0;
        while (i < strlen) {
            c = charr[i];
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        int i2 = 0;
        while (i2 < strlen) {
            c = charr[i2];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i2;
        }
        this.out.write(bytearr);
        return utflen + 2;
    }

    public void writeRecord(IRecord r) throws IOException {
        if (r == null) {
            this.writeInt(-1);
        } else {
            byte[] b = r.serialize();
            this.writeBytes(b);
        }
    }

    public void writeObject(Object o, boolean test) throws IOException {
        if (o == null) {
            this.out.write(-1);
        } else if (o instanceof IRecord) {
            this.out.write(0);
            this.writeString(o.getClass().getName());
            this.writeRecord((IRecord)o);
        } else if (o instanceof String) {
            String s = (String)o;
            int len = s.length();
            if (len > 65535) {
                this.out.write(13);
                this.writeString(s);
            } else {
                this.out.write(1);
                this.writeUTF((String)o);
            }
        } else if (o instanceof BigDecimal) {
            this.out.write(2);
            BigDecimal bd = (BigDecimal)o;
            this.writeInt(bd.scale());
            this.writeBytes(bd.unscaledValue().toByteArray());
        } else if (o instanceof Timestamp) {
            this.out.write(31);
            this.writeLong(((Timestamp)o).getTime());
        } else if (o instanceof Time) {
            this.out.write(32);
            this.writeLong(((Time)o).getTime());
        } else if (o instanceof java.sql.Date) {
            this.out.write(33);
            this.writeLong(((java.sql.Date)o).getTime());
        } else if (o instanceof Date) {
            this.out.write(3);
            this.writeLong(((Date)o).getTime());
        } else if (o instanceof Integer) {
            this.out.write(4);
            this.writeInt((Integer)o);
        } else if (o instanceof Long) {
            this.out.write(5);
            this.writeLong((Long)o);
        } else if (o instanceof Boolean) {
            this.out.write(6);
            this.out.write((Boolean)o != false ? 1 : 0);
        } else if (o instanceof BigInteger) {
            this.out.write(7);
            this.writeBytes(((BigInteger)o).toByteArray());
        } else if (o instanceof byte[]) {
            this.out.write(8);
            this.writeBytes((byte[])o);
        } else if (o instanceof Double) {
            this.out.write(9);
            this.writeDouble((Double)o);
        } else if (o instanceof Float) {
            this.out.write(10);
            this.writeFloat(((Float)o).floatValue());
        } else if (o instanceof Byte) {
            this.out.write(11);
            this.out.write(((Byte)o).byteValue());
        } else if (o instanceof Short) {
            this.out.write(12);
            this.writeShort((Short)o);
        } else {
            this.out.write(-1);
        }
    }

    public byte[] toByteArray() {
        return this.out.toByteArray();
    }

    public int size() {
        return this.out.size();
    }
}

