/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.DBConfig;
import com.scudata.common.DBInfo;
import com.scudata.common.DBTypes;
import com.scudata.common.RQException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.HashMap;

public class DBSession {
    private Object session = null;
    private DBInfo info = null;
    private SQLException error;
    private boolean registerCause = false;
    private HashMap<String, Savepoint> map = null;

    public DBSession(Object session, DBInfo info) {
        this.session = session;
        this.info = info;
        if (session != null && info != null) {
            this.detectDBType(session, info);
        }
    }

    public Object getSession() {
        return this.session;
    }

    public void setSession(Object session) {
        this.session = session;
    }

    public DBInfo getInfo() {
        return this.info;
    }

    public void setInfo(DBInfo info) {
        this.info = info;
    }

    public void close() {
        if (this.session == null) {
            return;
        }
        try {
            if (this.info.getDBType() == 101) {
                Method m = this.session.getClass().getMethod("disconnect", new Class[0]);
                m.invoke(this.session, new Object[0]);
            } else {
                this.map = null;
                Method m = this.session.getClass().getMethod("close", new Class[0]);
                m.setAccessible(true);
                m.invoke(this.session, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new RQException(e);
        }
    }

    public boolean getAutoCommit() {
        if (this.session instanceof Connection) {
            try {
                return ((Connection)this.session).getAutoCommit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return true;
    }

    public String isolate(String option) throws SQLException {
        if (!(this.session instanceof Connection)) {
            return null;
        }
        Connection conn = (Connection)this.session;
        String si = "n";
        try {
            int i = conn.getTransactionIsolation();
            switch (i) {
                case 0: {
                    si = "n";
                    break;
                }
                case 2: {
                    si = "c";
                    break;
                }
                case 1: {
                    si = "u";
                    break;
                }
                case 4: {
                    si = "r";
                    break;
                }
                case 8: {
                    si = "s";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (option == null) {
            return si;
        }
        try {
            if (option.indexOf(110) >= 0) {
                conn.setTransactionIsolation(0);
            } else if (option.indexOf(99) >= 0) {
                conn.setTransactionIsolation(2);
            } else if (option.indexOf(117) >= 0) {
                conn.setTransactionIsolation(1);
            } else if (option.indexOf(114) >= 0) {
                conn.setTransactionIsolation(4);
            } else if (option.indexOf(115) >= 0) {
                conn.setTransactionIsolation(8);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return si;
    }

    public boolean savepoint(String name) throws SQLException {
        if (!(this.session instanceof Connection)) {
            return false;
        }
        Connection conn = (Connection)this.session;
        Savepoint sp = conn.setSavepoint(name);
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(name, sp);
        return true;
    }

    public boolean rollback(String name) throws SQLException {
        if (!(this.session instanceof Connection)) {
            return false;
        }
        Connection conn = (Connection)this.session;
        if (name == null) {
            conn.rollback();
            return true;
        }
        if (this.map == null) {
            return false;
        }
        Savepoint sp = this.map.get(name);
        if (sp == null) {
            return false;
        }
        conn.rollback(sp);
        return true;
    }

    public boolean isClosed() {
        if (this.session == null) {
            return true;
        }
        try {
            if (this.info.getDBType() == 101) {
                Method m = this.session.getClass().getDeclaredMethod("isConnected", new Class[0]);
                Object o = m.invoke(this.session, new Object[0]);
                return (Boolean)o;
            }
            Method m = this.session.getClass().getDeclaredMethod("isClosed", new Class[0]);
            m.setAccessible(true);
            Object o = m.invoke(this.session, new Object[0]);
            return (Boolean)o;
        }
        catch (NoSuchMethodException noMethodE) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public String getField(String field) {
        DBConfig dbc;
        if (this.getInfo() instanceof DBConfig && (dbc = (DBConfig)this.getInfo()).isAddTilde()) {
            int dbType = dbc.getDBType();
            return String.valueOf(DBTypes.getLeftTilde(dbType)) + field + DBTypes.getRightTilde(dbType);
        }
        return field;
    }

    public void setError(SQLException error) {
        this.error = error;
    }

    public SQLException error() {
        return this.error;
    }

    public void setErrorMode(boolean registerCause) {
        this.registerCause = registerCause;
    }

    public boolean getErrorMode() {
        return this.registerCause;
    }

    private void detectDBType(Object session, DBInfo info) {
        if (info.getDBType() != 0) {
            return;
        }
        String className = session.getClass().getName();
        int t = this.getType(className);
        if (t != 0) {
            info.setDBType(t);
            return;
        }
        if (session instanceof Connection) {
            String product = null;
            try {
                DatabaseMetaData dmd = ((Connection)session).getMetaData();
                product = dmd.getDatabaseProductName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (product == null) {
                return;
            }
            t = this.getType(product);
            info.setDBType(t);
        }
    }

    private int getType(String name) {
        if ((name = name.toLowerCase()).indexOf("oracle") >= 0) {
            return 1;
        }
        if (name.indexOf("sqlserver") >= 0) {
            return 2;
        }
        if (name.indexOf("db2") >= 0) {
            return 9;
        }
        if (name.indexOf("mysql") >= 0) {
            return 10;
        }
        if (name.indexOf("informix") >= 0) {
            return 5;
        }
        if (name.indexOf("derby") >= 0) {
            return 12;
        }
        if (name.indexOf("essbase") >= 0) {
            return 101;
        }
        if (name.indexOf("access") >= 0) {
            return 7;
        }
        if (name.indexOf("anywhere") >= 0) {
            return 4;
        }
        return 0;
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

