/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.DBConfig;
import com.scudata.common.DBSession;
import com.scudata.common.ISessionFactory;
import com.scudata.common.Logger;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Map;
import java.util.Properties;

public class DBSessionFactory
implements ISessionFactory {
    String url;
    Properties info = new Properties();
    DBConfig cfg;

    public DBSessionFactory(DBConfig cfg) throws Exception {
        String driverClass;
        this.cfg = cfg;
        this.url = cfg.getUrl();
        if (cfg.getInfo() != null) {
            this.info.putAll((Map<?, ?>)cfg.getInfo());
        }
        if (cfg.getUser() != null) {
            this.info.put("user", cfg.getUser());
        }
        if (cfg.getPassword() != null) {
            this.info.put("password", cfg.getPassword());
        }
        if (cfg.getDBType() == 1) {
            this.info.put("remarksReporting", "true");
        }
        if ((driverClass = cfg.getDriver()) != null && driverClass.trim().length() > 0) {
            try {
                Driver d = (Driver)Class.forName(driverClass).newInstance();
                DriverManager.registerDriver(d);
            }
            catch (Exception e) {
                Logger.error("Database driver " + driverClass + " is not found!");
                throw e;
            }
        }
    }

    @Override
    public DBSession getSession() throws Exception {
        Driver d = DriverManager.getDriver(this.url);
        Connection con = d.connect(this.url, this.info);
        try {
            con.setAutoCommit(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new DBSession(con, this.cfg);
    }

    public DBConfig getDBConfig() {
        return this.cfg;
    }
}

