/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.DateFormatX;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;

public class DateFormatFactory {
    private static String dateFormat = "yyyy-MM-dd";
    private static String timeFormat = "HH:mm:ss";
    private static String dateTimeFormat = "yyyy-MM-dd HH:mm:ss";
    private static ThreadLocal<DateFormatFactory> local = new ThreadLocal<DateFormatFactory>(){

        @Override
        protected synchronized DateFormatFactory initialValue() {
            return new DateFormatFactory();
        }
    };
    private HashMap<String, DateFormat> map = new HashMap();
    private HashMap<String, DateFormatX> xmap = new HashMap();

    public static DateFormatFactory get() {
        return local.get();
    }

    public static String getDefaultTimeFormat() {
        return timeFormat;
    }

    public static void setDefaultTimeFormat(String format) {
        timeFormat = format;
    }

    public static String getDefaultDateFormat() {
        return dateFormat;
    }

    public static void setDefaultDateFormat(String format) {
        dateFormat = format;
    }

    public static String getDefaultDateTimeFormat() {
        return dateTimeFormat;
    }

    public static void setDefaultDateTimeFormat(String format) {
        dateTimeFormat = format;
    }

    public DateFormat getFormat(String fmt) {
        DateFormat df = this.map.get(fmt);
        if (df == null) {
            df = new SimpleDateFormat(fmt);
            df.getCalendar().setLenient(false);
            this.map.put(fmt, df);
        }
        return df;
    }

    public DateFormat getFormat(String fmt, String locale) {
        if (locale == null) {
            return this.getFormat(fmt);
        }
        String key = String.valueOf(locale) + fmt;
        DateFormat df = this.map.get(key);
        if (df == null) {
            df = new SimpleDateFormat(fmt, Locale.forLanguageTag(locale));
            df.getCalendar().setLenient(false);
            this.map.put(key, df);
        }
        return df;
    }

    public DateFormat getDateFormat() {
        return this.getFormat(dateFormat);
    }

    public DateFormat getTimeFormat() {
        return this.getFormat(timeFormat);
    }

    public DateFormat getDateTimeFormat() {
        return this.getFormat(dateTimeFormat);
    }

    public DateFormatX getFormatX(String fmt) {
        DateFormatX df = this.xmap.get(fmt);
        if (df == null) {
            df = new DateFormatX(fmt);
            df.getCalendar().setLenient(false);
            this.xmap.put(fmt, df);
        }
        return df;
    }

    public DateFormatX getDateFormatX() {
        return this.getFormatX(dateFormat);
    }

    public DateFormatX getTimeFormatX() {
        return this.getFormatX(timeFormat);
    }

    public DateFormatX getDateTimeFormatX() {
        return this.getFormatX(dateTimeFormat);
    }

    public static DateFormatX newFormatX(String fmt) {
        DateFormatX df = new DateFormatX(fmt);
        df.getCalendar().setLenient(false);
        return df;
    }

    public static DateFormatX newDateFormatX() {
        return DateFormatFactory.newFormatX(dateFormat);
    }

    public static DateFormatX newDateTimeFormatX() {
        return DateFormatFactory.newFormatX(dateTimeFormat);
    }

    public static DateFormatX newTimeFormatX() {
        return DateFormatFactory.newFormatX(timeFormat);
    }
}

