/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class FilteredObjectInputStream
extends ObjectInputStream {
    private static final byte STATUS_ALLOWED = 1;
    private static final byte STATUS_REJECTED = 0;
    private static final byte STATUS_UNDECIDED = -1;
    private byte status = (byte)-1;
    private String allowedClassName = null;

    public FilteredObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    protected FilteredObjectInputStream() throws IOException {
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (this.allowedClassName != null && this.status == -1 && !desc.getName().equals(this.allowedClassName)) {
            this.status = 0;
            throw new InvalidClassException("Unauthorized deserialization attempt", desc.getName());
        }
        this.status = 1;
        return super.resolveClass(desc);
    }

    public void setAllowedClassName(String allowedClassName) {
        this.allowedClassName = allowedClassName;
    }
}

