/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtils {
    private static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean isAbsolutePath(String fileName) {
        int len = fileName.length();
        if (len == 0) {
            return false;
        }
        char c0 = (fileName = fileName.replace('\\', '/')).charAt(0);
        return c0 == '/' || len >= 3 && IOUtils.isLetter(c0) && fileName.charAt(1) == ':' && fileName.charAt(2) == '/';
    }

    public static String getPath(String parent, String child) {
        if (parent == null || child == null || IOUtils.isAbsolutePath(child)) {
            return child;
        }
        return new File(parent, child).getPath().replace('\\', '/');
    }

    public static InputStream findResource(String fileName) {
        ClassLoader cl;
        InputStream in = null;
        try {
            if (IOUtils.isAbsolutePath(fileName)) {
                in = new FileInputStream(fileName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (in == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                in = cl.getResourceAsStream(fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (in == null) {
            try {
                in = IOUtils.class.getResourceAsStream(fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return in;
    }

    public static InputStream findResource(String fileName, String path) {
        ClassLoader cl;
        if (path == null) {
            return IOUtils.findResource(fileName);
        }
        InputStream in = null;
        try {
            in = new FileInputStream(fileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (in == null) {
            try {
                in = new FileInputStream(new File(path, fileName));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (in == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
            try {
                in = cl.getResourceAsStream(fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (in == null) {
            try {
                in = IOUtils.class.getResourceAsStream(fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return in;
    }

    public static void readFully(InputStream in, byte[] bytes) throws IOException {
        int count = bytes.length;
        int offset = 0;
        while (offset < count) {
            int read = in.read(bytes, offset, count - offset);
            if (read < 0) {
                throw new EOFException();
            }
            offset += read;
        }
    }

    public static int readBytes(InputStream in, byte[] bytes) throws IOException {
        int count = bytes.length;
        int offset = 0;
        while (offset < count) {
            int read = in.read(bytes, offset, count - offset);
            if (read < 0) break;
            offset += read;
        }
        return offset;
    }

    public static byte readByte(InputStream in) throws IOException {
        int ch = in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public static short readShort(InputStream in) throws IOException {
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public static void writeInt(OutputStream out, int v) throws IOException {
        out.write(v >>> 24 & 0xFF);
        out.write(v >>> 16 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        out.write(v >>> 0 & 0xFF);
    }

    public static int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static long readLong(InputStream in) throws IOException {
        return ((long)IOUtils.readInt(in) << 32) + ((long)IOUtils.readInt(in) & 0xFFFFFFFFL);
    }

    public static byte[] readByteArray(InputStream in, byte[] v) throws IOException {
        if (v.length != in.read(v)) {
            throw new IOException("byte array len invalid");
        }
        return v;
    }

    public static String readString(InputStream in) throws IOException {
        int len = IOUtils.readShort(in);
        if (len == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            buf.append((char)IOUtils.readShort(in));
            ++i;
        }
        return buf.toString();
    }

    public static final void dump(byte[] buf) {
        int n = 0;
        byte[] byArray = buf;
        int n2 = buf.length;
        int n3 = 0;
        while (n3 < n2) {
            byte b = byArray[n3];
            ++n;
            String s = Integer.toHexString(b);
            int len = s.length();
            if (len == 1) {
                System.out.print('0');
                System.out.print(s);
            } else {
                System.out.print(s.substring(len - 2, len));
            }
            System.out.print(' ');
            if (n % 16 == 0) {
                System.out.println();
            }
            ++n3;
        }
        if (n % 16 != 0) {
            System.out.println();
        }
    }
}

