/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.DBSession;
import com.scudata.common.ISessionFactory;
import com.scudata.common.JNDIConfig;
import java.sql.Connection;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class JNDISessionFactory
implements ISessionFactory {
    private JNDIConfig cfg;
    private DataSource ds;

    public JNDISessionFactory(JNDIConfig cfg) throws Exception {
        this.cfg = cfg;
        InitialContext ctx = new InitialContext();
        this.ds = (DataSource)ctx.lookup(cfg.getJNDI());
        if (this.ds == null) {
            throw new Exception("not found JNDI: " + cfg.getJNDI());
        }
    }

    @Override
    public DBSession getSession() throws Exception {
        Connection con = this.ds.getConnection();
        try {
            con.setAutoCommit(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new DBSession(con, this.cfg);
    }
}

