/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import java.util.EmptyStackException;
import java.util.Vector;

public final class LimitedQueue {
    private int maxSize = Integer.MAX_VALUE;
    private Vector<Object> stack = new Vector();
    private boolean changed = false;

    public LimitedQueue() {
    }

    public LimitedQueue(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("limit must be bigger than 0");
        }
        this.maxSize = maxSize;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setUnChanged() {
        this.changed = false;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("limit must be bigger than 0");
        }
        this.maxSize = maxSize;
        while (maxSize < this.size()) {
            this.stack.removeElementAt(this.size() - 1);
        }
        this.changed = true;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int size() {
        return this.stack.size();
    }

    public Object add(Object item) {
        if (this.size() >= this.maxSize) {
            this.stack.removeElementAt(0);
        }
        this.stack.addElement(item);
        this.changed = true;
        return item;
    }

    public Object get(int index) {
        return this.stack.get(index);
    }

    public Object poll() {
        Object obj = this.peek();
        this.stack.removeElementAt(0);
        this.changed = true;
        return obj;
    }

    public Object peek() {
        int len = this.size();
        if (len == 0) {
            throw new EmptyStackException();
        }
        return this.stack.elementAt(0);
    }

    public void clear() {
        this.stack.clear();
        this.changed = true;
    }

    public boolean empty() {
        return this.size() == 0;
    }

    public boolean isFull() {
        return this.size() == this.maxSize;
    }

    public String toString() {
        int len = this.size();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < len) {
            sb.append(this.stack.elementAt(i)).append(';');
            ++i;
        }
        return sb.toString();
    }
}

