/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import java.util.EmptyStackException;
import java.util.Vector;

public final class LimitedStack {
    private int maxSize = Integer.MAX_VALUE;
    private Vector<Object> stack = new Vector();

    public LimitedStack() {
    }

    public LimitedStack(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("limit must be bigger than 0");
        }
        this.maxSize = maxSize;
    }

    public void setMaxSize(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("limit must be bigger than 0");
        }
        this.maxSize = maxSize;
        while (maxSize < this.size()) {
            this.stack.removeElementAt(0);
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int size() {
        return this.stack.size();
    }

    public Object push(Object item) {
        if (this.size() >= this.maxSize) {
            this.stack.removeElementAt(0);
        }
        this.stack.addElement(item);
        return item;
    }

    public Object pop() {
        Object obj = this.peek();
        this.stack.removeElementAt(this.size() - 1);
        return obj;
    }

    public Object peek() {
        int len = this.size();
        if (len == 0) {
            throw new EmptyStackException();
        }
        return this.stack.elementAt(len - 1);
    }

    public void clear() {
        this.stack.clear();
    }

    public boolean empty() {
        return this.size() == 0;
    }

    public boolean isFull() {
        return this.size() == this.maxSize;
    }

    public String toString() {
        int len = this.size();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < len) {
            sb.append(this.stack.elementAt(i)).append(';');
            ++i;
        }
        return sb.toString();
    }
}

