/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class MessageEditor
extends JFrame
implements ListSelectionListener {
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton jBFile = new JButton();
    JPanel panelValue = new JPanel();
    JLabel labelZh = new JLabel("\u7b80\u4f53\u4e2d\u6587");
    JLabel labelEn = new JLabel("\u82f1\u6587");
    JLabel labelTw = new JLabel("\u7e41\u4f53\u4e2d\u6587");
    JTextPane textZh = new JTextPane();
    JTextPane textEn = new JTextPane();
    JTextPane textTw = new JTextPane();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList keyList = new JList();
    JLabel labelFile = new JLabel();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel labelKey = new JLabel();
    JPanel jPanel2 = new JPanel();
    JButton jBAdd = new JButton();
    FlowLayout flowLayout1 = new FlowLayout();
    JButton jBDelete = new JButton();
    JButton jBSave = new JButton();
    JButton jBExit = new JButton();
    JLabel labelValue = new JLabel();
    private String currFile;
    private File currDir;
    private Properties props_zh;
    private Properties props_en;
    private Properties props_tw;
    private final String S_ZH = "zh";
    private final String S_EN = "en";
    private final String S_TW = "zh_TW";
    private String currKey;
    JButton buttonNext = new JButton();

    public MessageEditor() {
        try {
            this.jbInit();
            this.init();
            this.buttonNext.setVisible(false);
            this.getRootPane().setDefaultButton(this.buttonNext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() {
        this.initJText(this.textZh);
        this.initJText(this.textEn);
        this.initJText(this.textTw);
        this.initProperties();
    }

    private void initProperties() {
        this.props_zh = new Properties();
        this.props_en = new Properties();
        this.props_tw = new Properties();
        this.setEditEnabled(false);
    }

    private void setEditEnabled(boolean enabled) {
        this.jBAdd.setEnabled(enabled);
        this.jBDelete.setEnabled(enabled);
        this.jBSave.setEnabled(enabled);
        this.textZh.setEnabled(enabled);
        this.textEn.setEnabled(enabled);
        this.textTw.setEnabled(enabled);
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(3);
        this.setTitle("\u4fe1\u606f\u6587\u4ef6\u7f16\u8f91\u5668");
        this.setSize(new Dimension(700, 525));
        this.initButton(this.jBFile);
        this.jBFile.setText("\u6253\u5f00\u6587\u4ef6");
        this.jBFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageEditor.this.jBFile_actionPerformed(e);
            }
        });
        JPanel panelZh = new JPanel();
        JPanel panelEn = new JPanel();
        JPanel panelTw = new JPanel();
        panelZh.setLayout(new BorderLayout());
        panelEn.setLayout(new BorderLayout());
        panelTw.setLayout(new BorderLayout());
        panelZh.add((Component)this.labelZh, "North");
        panelZh.add((Component)this.textZh, "Center");
        panelEn.add((Component)this.labelEn, "North");
        panelEn.add((Component)this.textEn, "Center");
        panelTw.add((Component)this.labelTw, "North");
        panelTw.add((Component)this.textTw, "Center");
        this.panelValue.setLayout(new GridLayout(3, 1));
        this.panelValue.add(panelZh);
        this.panelValue.add(panelEn);
        this.panelValue.add(panelTw);
        this.initFont(this.labelZh);
        this.initFont(this.textZh);
        this.initFont(this.labelEn);
        this.initFont(this.labelTw);
        this.initFont(this.textTw);
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.initFont(this.labelFile);
        this.labelFile.setAlignmentX(20.0f);
        this.labelFile.setMaximumSize(new Dimension(42, 15));
        this.labelFile.setText("\u3000\u6ca1\u6253\u5f00\u6587\u4ef6");
        this.jPanel1.setLayout(this.borderLayout1);
        this.initFont(this.labelKey);
        this.labelKey.setText("\u952e\u540d\u5217\u8868");
        this.initButton(this.jBAdd);
        this.jBAdd.setText("\u6dfb\u52a0A");
        this.jBAdd.setMnemonic('A');
        this.jBAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageEditor.this.jBAdd_actionPerformed(e);
            }
        });
        this.jPanel2.setLayout(this.flowLayout1);
        this.initButton(this.jBDelete);
        this.jBDelete.setText("\u5220\u9664");
        this.jBDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageEditor.this.jBDelete_actionPerformed(e);
            }
        });
        this.initButton(this.jBSave);
        this.jBSave.setText("\u4fdd\u5b58S");
        this.jBSave.setMnemonic('s');
        this.jBSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageEditor.this.jBSave_actionPerformed(e);
            }
        });
        this.initButton(this.jBExit);
        this.jBExit.setText("\u9000\u51fa");
        this.jBExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageEditor.this.jBExit_actionPerformed(e);
            }
        });
        this.initFont(this.labelValue);
        this.labelValue.setText("\u952e\u503c");
        this.initFont(this.keyList);
        this.keyList.setModel(new DefaultListModel());
        this.keyList.setSelectionMode(0);
        this.keyList.addListSelectionListener(this);
        this.jPanel2.setMinimumSize(new Dimension(320, 35));
        this.buttonNext.setMnemonic('N');
        this.buttonNext.setText("Next");
        this.buttonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageEditor.this.buttonNext_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.panelValue, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 25, 0, 20), 0, 0));
        this.getContentPane().add((Component)this.jScrollPane1, new GridBagConstraints(0, 2, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 20, 20, 0), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.keyList, null);
        this.getContentPane().add((Component)this.jPanel1, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(20, 20, 0, 20), 0, 0));
        this.jPanel1.add((Component)this.jBFile, "West");
        this.jPanel1.add((Component)this.labelFile, "Center");
        this.getContentPane().add((Component)this.labelKey, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 5, 0), 0, 0));
        this.getContentPane().add((Component)this.jPanel2, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(9, 25, 20, 20), 0, 9));
        this.jPanel2.add((Component)this.jBAdd, null);
        this.jPanel2.add((Component)this.jBDelete, null);
        this.jPanel2.add((Component)this.jBSave, null);
        this.jPanel2.add((Component)this.jBExit, null);
        this.jPanel2.add((Component)this.buttonNext, null);
        this.getContentPane().add((Component)this.labelValue, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 0), 0, 0));
        Dimension size = this.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int newX = (screenSize.width - size.width) / 2;
        int newY = (screenSize.height - size.height) / 2;
        this.setLocation(newX, newY);
    }

    private void initButton(JButton b) {
        b.setMaximumSize(new Dimension(74, 25));
        b.setMinimumSize(new Dimension(74, 25));
        b.setPreferredSize(new Dimension(74, 25));
        b.setMargin(new Insets(2, 10, 2, 10));
        this.initFont(b);
    }

    private void initFont(Component c) {
        c.setFont(new Font("\u5b8b\u4f53", 0, 12));
    }

    public static void main(String[] args) {
        try {
            MessageEditor me = new MessageEditor();
            me.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void jBFile_actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        this.initFont(chooser);
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".properties");
            }

            @Override
            public String getDescription() {
                return "\u5c5e\u6027\u6587\u4ef6 (*.properties)";
            }
        };
        chooser.setFileFilter(fileFilter);
        String configFile = String.valueOf(System.getProperty("user.home")) + File.separator + "MessageEditorDir.txt";
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(configFile)));
            this.currDir = new File(br.readLine());
            br.close();
        }
        catch (Exception br) {
            // empty catch block
        }
        if (this.currDir != null) {
            chooser.setCurrentDirectory(this.currDir);
        }
        if (chooser.showOpenDialog(this) == 0) {
            File file = chooser.getSelectedFile();
            this.currFile = file.getAbsolutePath();
            this.currDir = file.getParentFile();
            try {
                PrintWriter pw = new PrintWriter(new FileOutputStream(configFile));
                pw.println(this.currDir.getAbsolutePath());
                pw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.labelFile.setText("\u3000\u5f53\u524d\u6587\u4ef6" + this.currFile);
            this.load();
        }
    }

    private void load() {
        this.initProperties();
        String preName = this.getPreName();
        this.loadPorperties(preName, "zh");
        this.loadPorperties(preName, "en");
        this.loadPorperties(preName, "zh_TW");
        this.setKeyList();
        this.setEditEnabled(true);
    }

    private void loadPorperties(String preName, String suffix) {
        Properties props = this.getPropertiesBySuffix(suffix);
        try {
            String sFile = String.valueOf(preName) + "_" + suffix + ".properties";
            FileInputStream is = new FileInputStream(sFile);
            props.load(is);
            ((InputStream)is).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getPreName() {
        int index = this.currFile.lastIndexOf(".");
        String preName = this.currFile.substring(0, index - 3);
        if (preName.endsWith("zh")) {
            preName = this.currFile.substring(0, index - "zh_TW".length() - 1);
        }
        return preName;
    }

    private Properties getPropertiesBySuffix(String suffix) {
        if (suffix.equals("zh")) {
            return this.props_zh;
        }
        if (suffix.equals("en")) {
            return this.props_en;
        }
        if (suffix.equals("zh_TW")) {
            return this.props_tw;
        }
        return null;
    }

    private void setKeyList() {
        HashSet allKeys = new HashSet();
        this.addKeyList(allKeys, this.props_zh);
        this.addKeyList(allKeys, this.props_en);
        this.addKeyList(allKeys, this.props_tw);
        Object[] keys = allKeys.toArray();
        Arrays.sort(keys);
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        int i = 0;
        while (i < keys.length) {
            model.addElement(keys[i]);
            ++i;
        }
        this.keyList.setModel(model);
        this.currKey = null;
    }

    private void addKeyList(HashSet allKeys, Properties props) {
        Object[] keys = props.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            allKeys.add(keys[i]);
            ++i;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.keyList.getSelectedIndex() < 0) {
            return;
        }
        this.acceptValue();
        this.currKey = this.keyList.getSelectedValue().toString();
        String val = this.props_zh.getProperty(this.currKey);
        this.textZh.setText(val == null ? null : val);
        val = this.props_en.getProperty(this.currKey);
        this.textEn.setText(val == null ? null : val);
        val = this.props_tw.getProperty(this.currKey);
        this.textTw.setText(val == null ? null : val);
    }

    private void initJText(final JTextPane jText) {
        jText.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\t') {
                    MessageEditor.this.gotoNextFocus(jText);
                    jText.setEditable(false);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        jText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                MessageEditor.this.textZh.setEditable(true);
                MessageEditor.this.textEn.setEditable(true);
                MessageEditor.this.textTw.setEditable(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    private void gotoNextFocus(JTextPane jText) {
        if (jText.equals(this.textZh)) {
            this.textEn.requestFocusInWindow();
        } else if (jText.equals(this.textEn)) {
            this.textTw.requestFocusInWindow();
        } else if (jText.equals(this.textTw)) {
            this.jBAdd.requestFocusInWindow();
        }
    }

    private void acceptValue() {
        if (this.currKey != null) {
            this.props_zh.put(this.currKey, this.textZh.getText());
            this.props_en.put(this.currKey, this.textEn.getText());
            this.props_tw.put(this.currKey, this.textTw.getText());
        }
    }

    void jBDelete_actionPerformed(ActionEvent e) {
        if (this.currKey == null) {
            return;
        }
        int index = this.keyList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        this.delete();
        ((DefaultListModel)this.keyList.getModel()).remove(index);
        if (index > this.keyList.getModel().getSize() - 1) {
            --index;
        }
        this.keyList.setSelectedIndex(index);
    }

    private void delete() {
        this.props_zh.remove(this.currKey);
        this.props_en.remove(this.currKey);
        this.props_tw.remove(this.currKey);
        this.currKey = null;
    }

    void jBAdd_actionPerformed(ActionEvent e) {
        String val;
        Object oldval = this.keyList.getSelectedValue();
        if (oldval != null) {
            val = oldval.toString();
            int dot = val.indexOf(".");
            val = val.substring(0, dot + 1);
        } else {
            val = "";
        }
        String key = JOptionPane.showInputDialog("\u8bf7\u8f93\u5165\u65b0\u952e\u540d", (Object)val);
        if (key == null || key.trim().length() == 0) {
            return;
        }
        if (this.props_zh.contains(key) || this.props_en.contains(key) || this.props_tw.contains(key)) {
            return;
        }
        this.add(key);
        ((DefaultListModel)this.keyList.getModel()).addElement(key);
        this.keyList.setSelectedIndex(this.keyList.getModel().getSize() - 1);
    }

    private void add(String key) {
        this.props_zh.put(key, "");
        this.props_en.put(key, "");
        this.props_tw.put(key, "");
    }

    void jBSave_actionPerformed(ActionEvent e) {
        this.acceptValue();
        if (this.currFile == null) {
            return;
        }
        this.save();
    }

    private void save() {
        String preName = this.getPreName();
        this.save(preName, "zh");
        this.save(preName, "en");
        this.save(preName, "zh_TW");
    }

    private void save(String preName, String suffix) {
        String sFile = String.valueOf(preName) + "_" + suffix + ".properties";
        try {
            Properties props = this.getPropertiesBySuffix(suffix);
            File f = new File(sFile);
            if (!f.exists()) {
                if (props.isEmpty()) {
                    return;
                }
                f.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(f);
            props.store(fos, "");
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, ex.getMessage(), "\u9519\u8bef", 0);
        }
    }

    void jBExit_actionPerformed(ActionEvent e) {
        this.hide();
        this.dispose();
        System.exit(0);
    }

    void buttonNext_actionPerformed(ActionEvent e) {
        int i = this.keyList.getSelectedIndex();
        i = i < this.keyList.getModel().getSize() - 1 ? ++i : 0;
        this.keyList.setSelectedIndex(i);
    }
}

