/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageManager {
    private static List<ClassLoader> clList = new ArrayList<ClassLoader>(8);
    private ResourceBundle bundle;
    private static Hashtable mgrs;

    static {
        clList.add(MessageManager.class.getClassLoader());
        mgrs = new Hashtable();
    }

    public static synchronized void addClassLoader(ClassLoader cl) {
        for (ClassLoader tmp : clList) {
            if (cl != tmp) continue;
            return;
        }
        clList.add(cl);
    }

    private MessageManager(String fileName) {
        this(fileName, Locale.getDefault());
    }

    private MessageManager(String fileName, Locale loc) {
        for (ClassLoader tmp : clList) {
            try {
                this.bundle = ResourceBundle.getBundle(fileName, loc, tmp);
                if (this.bundle == null) continue;
                break;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (this.bundle != null) {
            return;
        }
        for (ClassLoader tmp : clList) {
            try {
                this.bundle = ResourceBundle.getBundle(fileName, Locale.US, tmp);
                if (this.bundle == null) continue;
                break;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (this.bundle == null) {
            throw new MissingResourceException("Can't find bundle for base name " + fileName, "", null);
        }
    }

    private MessageManager(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public String getMessage(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key may not be a null value");
        }
        String msg = key;
        try {
            msg = this.bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return msg;
    }

    /*
     * Unable to fully structure code
     */
    public String getMessage(String key, Object[] args) {
        value = this.getMessage(key);
        try {
            if (args == null) {
                return value;
            }
            return MessageFormat.format(value, args);
        }
        catch (IllegalArgumentException e) {
            buf = new StringBuffer(64);
            buf.append(value);
            buf.append('\n');
            i = 0;
            ** while (i < args.length)
        }
lbl-1000:
        // 1 sources

        {
            if (i > 0) {
                buf.append(',');
            }
            buf.append("arg[").append(i).append("]=").append(args[i]);
            ++i;
            continue;
        }
lbl21:
        // 1 sources

        throw new IllegalArgumentException(buf.toString());
    }

    public String getMessage(String key, Object arg1) {
        return this.getMessage(key, new Object[]{arg1});
    }

    public String getMessage(String key, Object arg1, Object arg2) {
        return this.getMessage(key, new Object[]{arg1, arg2});
    }

    public String getMessage(String key, Object arg1, Object arg2, Object arg3) {
        return this.getMessage(key, new Object[]{arg1, arg2, arg3});
    }

    public String getMessage(String key, Object arg1, Object arg2, Object arg3, Object arg4) {
        return this.getMessage(key, new Object[]{arg1, arg2, arg3, arg4});
    }

    public String getMessage(String key, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return this.getMessage(key, new Object[]{arg1, arg2, arg3, arg4, arg5});
    }

    public String getMessage(String key, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        return this.getMessage(key, new Object[]{arg1, arg2, arg3, arg4, arg5, arg6});
    }

    public static synchronized void clearManagers() {
        mgrs.clear();
    }

    public static synchronized MessageManager getManager(String fileName) {
        MessageManager mgr = (MessageManager)mgrs.get(fileName);
        if (mgr == null) {
            mgr = new MessageManager(fileName);
            mgrs.put(fileName, mgr);
        }
        return mgr;
    }

    public static synchronized MessageManager getManager(ResourceBundle bundle) {
        return new MessageManager(bundle);
    }

    public static synchronized MessageManager getManager(String fileName, Locale loc) {
        String bundleName = String.valueOf(fileName) + "_" + loc.toString();
        MessageManager mgr = (MessageManager)mgrs.get(bundleName);
        if (mgr == null) {
            mgr = new MessageManager(fileName, loc);
            mgrs.put(bundleName, mgr);
        }
        return mgr;
    }
}

