/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.Logger;
import com.scudata.common.StringUtils;
import com.scudata.dm.Env;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;

public class ScudataLogger {
    public static String OFF = "OFF";
    public static String SEVERE = "SEVERE";
    public static String WARNING = "WARNING";
    public static String INFO = "INFO";
    public static String DEBUG = "DEBUG";
    public static int iDOLOG = -1;
    public static int iOFF = 0;
    public static int iSEVERE = 10;
    public static int iWARNING = 20;
    public static int iINFO = 30;
    public static int iDEBUG = 40;
    public static String lineSeparator = System.getProperty("line.separator", "\n");
    String currentMark;
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
    private SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private ArrayList<Handler> handlers = new ArrayList();
    private static int gateLevel = iDEBUG;
    private static ScudataLogger logger = new ScudataLogger();

    private ScudataLogger() {
        ConsoleHandler h = new ConsoleHandler();
        this.addHandler(h);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ScudataLogger.this.reset();
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void reset() {
        for (Handler h : this.handlers) {
            h.close();
        }
    }

    public void clearHandlers() {
        this.handlers.clear();
    }

    public static String[] listLevelNames() {
        return new String[]{OFF, SEVERE, WARNING, INFO, DEBUG};
    }

    public static int getLevel(String level) {
        if (!StringUtils.isValidString(level)) {
            level = INFO;
        }
        if ((level = level.toUpperCase()).equals(OFF)) {
            return iOFF;
        }
        if (level.equals(SEVERE)) {
            return iSEVERE;
        }
        if (level.equals(WARNING)) {
            return iWARNING;
        }
        if (level.equals(INFO)) {
            return iINFO;
        }
        if (level.equals(DEBUG)) {
            return iDEBUG;
        }
        return iINFO;
    }

    public static String getLevelName(int level) {
        if (level == iDOLOG) {
            return "";
        }
        if (level == iOFF) {
            return OFF;
        }
        if (level == iSEVERE) {
            return SEVERE;
        }
        if (level == iWARNING) {
            return WARNING;
        }
        if (level == iINFO) {
            return INFO;
        }
        if (level == iDEBUG) {
            return DEBUG;
        }
        return DEBUG;
    }

    private String format(int level, Object msg, Throwable t) {
        String message;
        StringBuffer sb = new StringBuffer();
        Date now = Calendar.getInstance().getTime();
        sb.append('[').append(this.fmt.format(now)).append("] ");
        sb.append(lineSeparator);
        String name = ScudataLogger.getLevelName(level);
        if (name != "") {
            sb.append(name);
            sb.append(": ");
        }
        String string = message = msg == null ? null : msg.toString();
        if (message != null) {
            sb.append(message);
            if (!message.endsWith(lineSeparator)) {
                sb.append(lineSeparator);
            }
        }
        if (t != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    void addHandler(Handler h) {
        this.handlers.add(h);
    }

    public static void addFileHandler(FileHandler fh) {
        ScudataLogger.logger.handlers.add(fh);
    }

    public static void addConsoleHandler(ConsoleHandler ch) {
        ScudataLogger.logger.handlers.add(ch);
    }

    private synchronized void doLog(int level, Object msg, Throwable t) {
        String message = this.format(level, msg, t);
        for (Handler h : this.handlers) {
            h.log(level, message);
        }
    }

    public static FileHandler newFileHandler(String path) throws Exception {
        ScudataLogger scudataLogger = logger;
        scudataLogger.getClass();
        return scudataLogger.new FileHandler(path);
    }

    private static Handler getHandler(String name, Properties p) throws Exception {
        String tmp = p.getProperty(name);
        if (tmp == null) {
            return null;
        }
        Handler h = null;
        if (tmp.equalsIgnoreCase("Console")) {
            h = logger.new ConsoleHandler();
        } else {
            String file = tmp;
            tmp = p.getProperty(String.valueOf(name) + ".encoding");
            String buf = p.getProperty(String.valueOf(name) + ".isFixedFileName");
            String maxSize = p.getProperty(String.valueOf(name) + ".maxSize");
            boolean isFixedFileName = false;
            if (StringUtils.isValidString(buf)) {
                isFixedFileName = Boolean.parseBoolean(buf);
            }
            ScudataLogger scudataLogger = logger;
            scudataLogger.getClass();
            h = scudataLogger.new FileHandler(file, tmp, isFixedFileName, maxSize);
        }
        tmp = p.getProperty(String.valueOf(name) + ".level");
        if (StringUtils.isValidString(tmp)) {
            int l = ScudataLogger.getLevel(tmp);
            h.setLevel(l);
        }
        return h;
    }

    public static void setPropertyConfig(Properties p) throws Exception {
        logger.clearHandlers();
        String key = "Logger";
        String val = p.getProperty(key);
        if (!StringUtils.isValidString(val)) {
            throw new Exception("Can not find key 'Logger'.");
        }
        StringTokenizer st = new StringTokenizer(val, ",");
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            try {
                Handler h = ScudataLogger.getHandler(tmp, p);
                if (h == null) continue;
                logger.addHandler(h);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    private static Throwable isException(Object msg) {
        Throwable t = null;
        if (msg instanceof Throwable) {
            t = (Throwable)msg;
        }
        return t;
    }

    public static void error(Object msg) {
        ScudataLogger.error(msg, ScudataLogger.isException(msg));
    }

    public static void error(Object msg, Throwable t) {
        ScudataLogger.severe(msg, t);
    }

    public static void doLog(Object msg, Throwable t) {
        logger.doLog(iDOLOG, msg, t);
    }

    public static void doLog(Object msg) {
        ScudataLogger.doLog(msg, null);
    }

    public static void severe(Object msg, Throwable t) {
        logger.doLog(iSEVERE, msg, t);
    }

    public static void severe(Object msg) {
        ScudataLogger.severe(msg, ScudataLogger.isException(msg));
    }

    public static void warn(Object msg) {
        ScudataLogger.warn(msg, ScudataLogger.isException(msg));
    }

    public static void warn(Object msg, Throwable t) {
        ScudataLogger.warning(msg, t);
    }

    public static void warning(Object msg, Throwable t) {
        logger.doLog(iWARNING, msg, t);
    }

    public static void warning(Object msg) {
        ScudataLogger.warning(msg, ScudataLogger.isException(msg));
    }

    public static void info(Object msg, Throwable t) {
        logger.doLog(iINFO, msg, t);
    }

    public static void info(Object msg) {
        ScudataLogger.info(msg, ScudataLogger.isException(msg));
    }

    public static void debug(Object msg, Throwable t) {
        logger.doLog(iDEBUG, msg, t);
    }

    public static void debug(Object msg) {
        ScudataLogger.debug(msg, ScudataLogger.isException(msg));
    }

    public static boolean isDebugLevel() {
        int level = gateLevel;
        return level == iDEBUG;
    }

    public static boolean isAllLevel() {
        return ScudataLogger.isDebugLevel();
    }

    public static void setLevel(String level) {
        int l;
        gateLevel = l = ScudataLogger.getLevel(level);
    }

    public static int getLevel() {
        return gateLevel;
    }

    private synchronized String getDateMark() {
        return this.formatter.format(new Date());
    }

    public void otelMessage(String msg) {
    }

    public static void main(String[] args) throws Exception {
        boolean c = false;
        ScudataLogger.setLevel(OFF);
        int i = 0;
        while (i < 10) {
            ScudataLogger.doLog(i);
            ++i;
        }
        System.exit(0);
        File file = new File("D:/logger.properties");
        FileInputStream is = new FileInputStream(file);
        Properties p = new Properties();
        p.load(is);
        ScudataLogger.setPropertyConfig(p);
        Logger.setLevel("severe");
        Thread t1 = new Thread(){

            @Override
            public void run() {
                String name = "t1:";
                Logger.severe(String.valueOf(name) + "severe");
                Logger.warning(String.valueOf(name) + "warning");
                Logger.info(String.valueOf(name) + "info");
                Logger.debug(String.valueOf(name) + "debug");
            }
        };
        Thread t2 = new Thread(){

            @Override
            public void run() {
                String name = "t2:";
                Logger.severe(String.valueOf(name) + "severe");
                Logger.warning(String.valueOf(name) + "warning");
                Logger.info(String.valueOf(name) + "info");
                Logger.debug(String.valueOf(name) + "debug");
            }
        };
        Thread t3 = new Thread(){

            @Override
            public void run() {
                String name = "t3:";
                Logger.severe(String.valueOf(name) + "\u4e25\u91cd");
                Logger.warning(String.valueOf(name) + "\u8b66\u544a");
                Logger.info(String.valueOf(name) + "\u4fe1\u606f");
                Logger.debug(String.valueOf(name) + "\u8c03\u8bd5");
            }
        };
        t1.start();
        t2.start();
        t3.start();
        t1.join();
        t2.join();
        t3.join();
        Logger.info("info test");
        System.exit(0);
    }

    public class ConsoleHandler
    extends Handler {
        @Override
        void doLog(int level, String msg) {
            if (level > this.logLevel) {
                return;
            }
            System.err.println(msg);
            ScudataLogger.this.otelMessage(msg);
        }

        @Override
        void close() {
        }

        public String toString() {
            return "Console," + ScudataLogger.getLevelName(this.logLevel);
        }
    }

    public class FileHandler
    extends Handler {
        String fileName;
        String encoding;
        boolean isFixedFileName;
        int maxFileSize;
        String absolutePath;
        File currentFile;
        BufferedWriter br;
        FileOutputStream fos;
        private ArrayList<String> bufFiles;

        public FileHandler(String file) throws Exception {
            this(file, null, false, null);
        }

        public FileHandler(String file, String encode, boolean isFixedFileName, String maxSize) throws Exception {
            this.encoding = "UTF-8";
            this.isFixedFileName = false;
            this.maxFileSize = 0xA00000;
            this.absolutePath = null;
            this.currentFile = null;
            this.br = null;
            this.fos = null;
            this.bufFiles = new ArrayList();
            this.fileName = file;
            this.isFixedFileName = isFixedFileName;
            this.setMaxFileSize(maxSize);
            if (encode != null && !encode.isEmpty()) {
                this.encoding = encode;
            }
            Object[] files = this.getLogFile(this.getBaseFile(), isFixedFileName);
            this.currentFile = (File)files[0];
            this.absolutePath = (String)files[1];
            this.fos = new FileOutputStream(this.currentFile, true);
            this.br = new BufferedWriter(new OutputStreamWriter((OutputStream)this.fos, this.encoding));
        }

        private String getBaseFile() {
            String baseFile = this.fileName;
            if (this.absolutePath != null) {
                baseFile = this.absolutePath;
            }
            return baseFile;
        }

        public void setFixedFileName(boolean fix) {
            this.isFixedFileName = fix;
        }

        public void setMaxFileSize(String maxSize) {
            if (StringUtils.isValidString(maxSize)) {
                try {
                    if (maxSize.toLowerCase().endsWith("m")) {
                        int len = maxSize.length();
                        maxSize = maxSize.substring(0, len - 1);
                    }
                    this.maxFileSize = Integer.parseInt(maxSize) * 1024 * 1024;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        void doLog(int level, String msg) {
            String mark;
            if (level > this.logLevel) {
                return;
            }
            if (!this.isFixedFileName && (!ScudataLogger.this.currentMark.equals(mark = ScudataLogger.this.getDateMark()) || this.currentFile != null && this.currentFile.length() > (long)this.maxFileSize)) {
                try {
                    this.br.close();
                    this.currentFile = (File)this.getLogFile(this.getBaseFile(), this.isFixedFileName)[0];
                    this.fos = new FileOutputStream(this.currentFile, true);
                    this.br = new BufferedWriter(new OutputStreamWriter((OutputStream)this.fos, this.encoding));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            try {
                this.br.newLine();
                this.br.write(msg);
                this.br.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        void close() {
            try {
                this.br.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private Object[] getLogFile(String fileName, boolean isFixedFileName) {
            File p;
            String filePath;
            Object[] files = new Object[2];
            File f = new File(fileName);
            if (!f.isAbsolute()) {
                String home = System.getProperty("start.home");
                if (home != null) {
                    f = new File(home, fileName);
                } else {
                    ServletContext sc = Env.getApplication();
                    if (sc != null) {
                        home = sc.getRealPath("/");
                    }
                    f = home != null ? new File(home, fileName) : new File(f.getAbsolutePath());
                }
                files[1] = f.getAbsolutePath();
            }
            if (isFixedFileName) {
                filePath = f.getAbsolutePath();
            } else {
                String parentPath = f.getParent();
                String file = f.getName();
                if (!parentPath.endsWith(File.separator)) {
                    parentPath = String.valueOf(parentPath) + File.separator;
                }
                String pattern = parentPath;
                pattern = file.endsWith(".log") ? String.valueOf(pattern) + file.substring(0, file.length() - 4) : String.valueOf(pattern) + file;
                ScudataLogger.this.currentMark = ScudataLogger.this.getDateMark();
                int count = 0;
                filePath = String.valueOf(pattern) + "_" + ScudataLogger.this.currentMark + count + ".log";
                File tmp = new File(filePath);
                while (tmp.length() > (long)this.maxFileSize) {
                    filePath = String.valueOf(pattern) + "_" + ScudataLogger.this.currentMark + ++count + ".log";
                    tmp = new File(filePath);
                }
            }
            if (!this.bufFiles.contains(filePath)) {
                if (!Logger.isUseSLF4J()) {
                    System.err.println("The current log file:\r\n" + filePath + "\r\n");
                }
                this.bufFiles.add(filePath);
                if (this.bufFiles.size() > 1024) {
                    this.bufFiles.clear();
                }
            }
            if (!(p = (f = new File(filePath)).getParentFile()).exists()) {
                p.mkdirs();
            }
            files[0] = f;
            return files;
        }

        public String toString() {
            return String.valueOf(this.fileName) + "," + ScudataLogger.getLevelName(this.logLevel) + "," + this.maxFileSize / 0x100000 + "M";
        }
    }

    abstract class Handler {
        int logLevel = iDEBUG;

        Handler() {
        }

        void setLevel(int level) {
            this.logLevel = level;
        }

        int getLevel() {
            return this.logLevel;
        }

        void log(int level, String msg) {
            if (level > gateLevel) {
                return;
            }
            this.doLog(level, msg);
        }

        abstract void doLog(int var1, String var2);

        abstract void close();
    }
}

