/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import com.scudata.common.ArgumentTokenizer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class SegmentSet {
    private LinkedHashMap segs = new LinkedHashMap();
    private char delim = (char)59;
    private boolean caseSensitive = false;
    private boolean trimBlank = true;

    public SegmentSet() {
        this(null, false, ';', true);
    }

    public SegmentSet(String str) {
        this(str, false, ';', true);
    }

    public SegmentSet(String str, char delim) {
        this(str, false, delim, true);
    }

    public SegmentSet(String keys, String values, char delim) {
        this(keys, values, false, delim);
    }

    public SegmentSet(boolean caseSensitive) {
        this(null, caseSensitive, ';', true);
    }

    public SegmentSet(String str, boolean caseSensitive) {
        this(str, caseSensitive, ';', true);
    }

    public SegmentSet(String str, boolean caseSensitive, char delim) {
        this(str, caseSensitive, delim, true);
    }

    public SegmentSet(String str, boolean caseSensitive, char delim, boolean trimBlank) {
        this.caseSensitive = caseSensitive;
        this.delim = delim;
        this.trimBlank = trimBlank;
        this.parseSegmentSet(str);
    }

    public SegmentSet(String keys, String values, boolean caseSensitive, char delim) {
        this(keys, values, caseSensitive, delim, true);
    }

    public SegmentSet(String keys, String values, boolean caseSensitive, char delim, boolean trimBlank) {
        this.caseSensitive = caseSensitive;
        this.delim = delim;
        this.trimBlank = trimBlank;
        ArgumentTokenizer atkey = new ArgumentTokenizer(keys, delim);
        ArgumentTokenizer atval = new ArgumentTokenizer(values, delim);
        while (atkey.hasNext() && atval.hasNext()) {
            String key = this.checkKey(atkey.next());
            String value = this.checkValue(atval.next());
            this.put(key, value);
        }
    }

    private String checkKey(String key) {
        if (key == null) {
            return "";
        }
        if (this.trimBlank) {
            key = key.trim();
        }
        if (!this.caseSensitive) {
            key = key.toLowerCase();
        }
        return key;
    }

    private String checkValue(String value) {
        if (value == null) {
            return "";
        }
        if (this.trimBlank) {
            value = value.trim();
        }
        return value;
    }

    public void clear() {
        this.segs.clear();
    }

    public boolean containsKey(String key) {
        key = this.checkKey(key);
        return this.segs.containsKey(key);
    }

    public boolean containsValue(String value) {
        value = this.checkValue(value);
        return this.segs.containsValue(value);
    }

    public Set entrySet() {
        return this.segs.entrySet();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.segs.equals(obj);
    }

    public String get(String key) {
        key = this.checkKey(key);
        return (String)this.segs.get(key);
    }

    public int hashCode() {
        return this.segs.hashCode();
    }

    public boolean isEmpty() {
        return this.segs.isEmpty();
    }

    public Set keySet() {
        return this.segs.keySet();
    }

    public String put(String key, String value) {
        key = this.checkKey(key);
        value = this.checkValue(value);
        return this.segs.put(key, value);
    }

    public void putAll(Map t) {
        if (t == null || t.isEmpty()) {
            return;
        }
        Iterator it = t.keySet().iterator();
        while (it.hasNext()) {
            String key = this.checkKey((String)it.next());
            String value = this.checkValue((String)t.get(key));
            this.segs.put(key, value);
        }
    }

    public String remove(String key) {
        key = this.checkKey(key);
        return (String)this.segs.remove(key);
    }

    public int size() {
        return this.segs.size();
    }

    public Collection values() {
        return this.segs.values();
    }

    public String toString() {
        return this.toString(";");
    }

    public boolean containsKeys(String keys, char delim) {
        ArgumentTokenizer at = new ArgumentTokenizer(keys, delim);
        while (at.hasNext()) {
            if (this.containsKey(at.next())) continue;
            return false;
        }
        return true;
    }

    public boolean containsKeys(Set keys) {
        if (keys == null || keys.isEmpty()) {
            return true;
        }
        for (String key : keys) {
            if (this.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public void putAll(String keys, String values, char delim) {
        ArgumentTokenizer atkey = new ArgumentTokenizer(keys, delim);
        ArgumentTokenizer atval = new ArgumentTokenizer(values, delim);
        while (atkey.hasNext() && atval.hasNext()) {
            this.put(this.checkKey(atkey.next()), this.checkValue(atval.next()));
        }
    }

    public void putAll(SegmentSet segs) {
        for (String key : segs.keySet()) {
            this.put(key, segs.get(key));
        }
    }

    public String getValues(String keys, String valueIfBlank, char delim) {
        if (keys == null || valueIfBlank == null) {
            return null;
        }
        StringBuffer values = new StringBuffer(200);
        ArgumentTokenizer atkey = new ArgumentTokenizer(keys, delim);
        while (atkey.hasNext()) {
            String key = atkey.next();
            String val = this.get(key);
            if (val.equals("")) {
                val = valueIfBlank;
            }
            values.append(delim).append(val);
        }
        if (values.length() > 0) {
            return values.substring(1);
        }
        return null;
    }

    public String toString(String delim) {
        StringBuffer str = new StringBuffer(300);
        Iterator it = this.segs.keySet().iterator();
        while (it.hasNext()) {
            String key = ((String)it.next()).trim();
            str.append(delim).append(key).append("=").append(this.get(key));
        }
        if (str.length() > 0) {
            return str.substring(delim.length());
        }
        return null;
    }

    public Map toMap() {
        return (Map)this.segs.clone();
    }

    private void parseSegmentSet(String str) {
        if (str == null) {
            return;
        }
        ArgumentTokenizer at = new ArgumentTokenizer(str, this.delim);
        while (at.hasNext()) {
            String oneSeg;
            int pos = (oneSeg = at.next()).indexOf(61);
            String key = oneSeg.substring(0, pos < 0 ? oneSeg.length() : pos);
            String value = pos < 0 ? null : oneSeg.substring(pos + 1);
            this.segs.put(this.checkKey(key), this.checkValue(value));
        }
    }

    public static void main(String[] args) {
        SegmentSet ss = new SegmentSet("a = 13;;=343;=; Bc = 234;", true, ';', true);
        for (String key : ss.keySet()) {
            System.out.println("[" + key + "=" + ss.get(key) + "]");
        }
    }
}

