/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import java.io.BufferedReader;
import java.io.FileReader;

public final class Sentence {
    public static final int IGNORE_CASE = 1;
    public static final int IGNORE_PARS = 2;
    public static final int ONLY_FIRST = 4;
    public static final int ONLY_PHRASE = 8;
    public static final int IGNORE_QUOTE = 16;
    public static final int UPPER_WHEN_TRIM = 16;
    public static final int LOWER_WHEN_TRIM = 32;
    private static final boolean LOG = false;
    private String str;
    private char escapeChar = (char)92;

    public static void log(Object o) {
    }

    public Sentence(String str) {
        this.str = str;
    }

    public Sentence(String str, char escapeChar) {
        this.str = str;
        this.escapeChar = escapeChar;
    }

    public static int scanIdentifier(String str, int start) {
        int len = str.length();
        char ch = str.charAt(start);
        if (!Character.isJavaIdentifierStart(ch)) {
            return -1;
        }
        int i = start + 1;
        while (i < len) {
            ch = str.charAt(i);
            if (ch == '\u0000' || ch == '\u0001' || !Character.isJavaIdentifierPart(ch)) break;
            ++i;
        }
        return i - 1;
    }

    public static boolean checkIdentifier(String ident) {
        if (ident == null) {
            return false;
        }
        int len = ident.length();
        if (len == 0) {
            return false;
        }
        char c = ident.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            return false;
        }
        int i = 1;
        while (i < len) {
            c = ident.charAt(i);
            if (c == '\u0000') {
                return false;
            }
            if (c == '\u0001') {
                return false;
            }
            if (!Character.isJavaIdentifierPart(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int scanQuotation(String str, int start, char escapeChar) {
        char quote = str.charAt(start);
        if (quote != '\"' && quote != '\'') {
            return -1;
        }
        int idx = start + 1;
        int len = str.length();
        while (idx < len) {
            char ch = str.charAt(idx);
            if (ch == escapeChar) {
                idx += 2;
                continue;
            }
            if (ch == quote) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static int scanQuotation(String str, int start) {
        return Sentence.scanQuotation(str, start, '\\');
    }

    public static int scanParenthesis(String str, int start, char escapeChar) {
        if (str.charAt(start) != '(') {
            return -1;
        }
        int len = str.length();
        int i = start + 1;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '(': {
                    i = Sentence.scanParenthesis(str, i, escapeChar);
                    if (i < 0) {
                        return -1;
                    }
                    ++i;
                    break;
                }
                case '\"': 
                case '\'': {
                    int q = Sentence.scanQuotation(str, i, escapeChar);
                    if (q < 0) {
                        ++i;
                        break;
                    }
                    i = q + 1;
                    break;
                }
                case '[': {
                    int q;
                    if (i > start && str.charAt(i - 1) == '$') {
                        q = Sentence.scanBracket(str, i, escapeChar);
                        if (q < 0) {
                            ++i;
                            break;
                        }
                        i = q + 1;
                        break;
                    }
                    ++i;
                    break;
                }
                case ')': {
                    return i;
                }
                default: {
                    if (ch == escapeChar) {
                        ++i;
                    }
                    ++i;
                }
            }
        }
        return -1;
    }

    public static int scanParenthesis(String str, int start) {
        return Sentence.scanParenthesis(str, start, '\\');
    }

    public static int scanBracket(String str, int start, char escapeChar) {
        if (str.charAt(start) != '[') {
            return -1;
        }
        int len = str.length();
        int i = start + 1;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '[': {
                    i = Sentence.scanBracket(str, i, escapeChar);
                    if (i < 0) {
                        return -1;
                    }
                    ++i;
                    break;
                }
                case '\"': 
                case '\'': {
                    int q = Sentence.scanQuotation(str, i, escapeChar);
                    if (q < 0) {
                        ++i;
                        break;
                    }
                    i = q + 1;
                    break;
                }
                case ']': {
                    return i;
                }
                default: {
                    if (ch == escapeChar) {
                        ++i;
                    }
                    ++i;
                }
            }
        }
        return -1;
    }

    public static int scanBracket(String str, int start) {
        return Sentence.scanBracket(str, start, '\\');
    }

    public static int scanBrace(String str, int start, char escapeChar) {
        if (str.charAt(start) != '{') {
            return -1;
        }
        int len = str.length();
        int i = start + 1;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '{': {
                    i = Sentence.scanBrace(str, i, escapeChar);
                    if (i < 0) {
                        return -1;
                    }
                    ++i;
                    break;
                }
                case '\"': 
                case '\'': {
                    int q = Sentence.scanQuotation(str, i, escapeChar);
                    if (q < 0) {
                        ++i;
                        break;
                    }
                    i = q + 1;
                    break;
                }
                case '}': {
                    return i;
                }
                default: {
                    if (ch == escapeChar) {
                        ++i;
                    }
                    ++i;
                }
            }
        }
        return -1;
    }

    public static int scanBrace(String str, int start) {
        return Sentence.scanBrace(str, start, '\\');
    }

    public static int scanChineseBracket(String str, int start) {
        char cb = str.charAt(start);
        char matchChar = cb == '\uff08' ? (char)'\uff09' : (cb == '\u3010' ? (char)'\u3011' : (cb == '\u300a' ? (char)'\u300b' : '>'));
        int len = str.length();
        int i = start + 1;
        while (i < len) {
            char c = str.charAt(i);
            if (c == matchChar) {
                return i;
            }
            if (c == '\"' || c == '\'') {
                int q = Sentence.scanQuotation(str, i, '\\');
                if (q < 0) {
                    ++i;
                    continue;
                }
                i = q + 1;
                continue;
            }
            if (c == cb) {
                if ((i = Sentence.scanChineseBracket(str, i)) < 0) {
                    return -1;
                }
                ++i;
                continue;
            }
            if (c == '\\') {
                i += 2;
                continue;
            }
            ++i;
        }
        return -1;
    }

    public static String trim(String str, int ifcase, char escapeChar) {
        int idx = 0;
        int len = str.length();
        int flag = 0;
        StringBuffer dst = new StringBuffer(len);
        while (idx < len) {
            char ch = str.charAt(idx);
            if ((ch == '\"' || ch == '\'') && (idx > 0 && str.charAt(idx - 1) != escapeChar || idx == 0)) {
                int i;
                if (flag == 2) {
                    dst.append(' ');
                }
                if ((i = Sentence.scanQuotation(str, idx, escapeChar)) < 0) {
                    throw new RuntimeException("\u672a\u627e\u5230\u4f4d\u7f6e" + idx + "\u5904\u5bf9\u5e94\u7684\u5f15\u53f7");
                }
                ++i;
                int j = idx;
                while (j < i) {
                    dst.append(str.charAt(j));
                    ++j;
                }
                idx = i;
                continue;
            }
            if (Character.isWhitespace(ch)) {
                while (++idx < len && Character.isWhitespace(str.charAt(idx))) {
                }
                if (flag <= 0) continue;
                flag = 2;
                continue;
            }
            if (Sentence.isWordChar(ch)) {
                if (flag == 2) {
                    dst.append(' ');
                }
                flag = 1;
            } else {
                flag = 0;
            }
            switch (ifcase) {
                case 16: {
                    dst.append(Character.toUpperCase(ch));
                    break;
                }
                case 32: {
                    dst.append(Character.toLowerCase(ch));
                    break;
                }
                default: {
                    dst.append(ch);
                }
            }
            ++idx;
        }
        return dst.toString();
    }

    public static String trim(String str, int ifcase) {
        return Sentence.trim(str, ifcase, '\\');
    }

    public static int phraseAt(String str, String phrase, int start, int flag, char escapeChar) {
        int slen = str.length();
        int plen = phrase.length();
        boolean iswordchar = false;
        int i = start;
        while (i < slen) {
            char ch = str.charAt(i);
            if ((ch == '\"' || ch == '\'') && (i > 0 && str.charAt(i - 1) != '\\' || i == 0)) {
                if ((i = Sentence.scanQuotation(str, i, escapeChar)) < 0) {
                    return -1;
                }
                ++i;
                iswordchar = false;
                continue;
            }
            if ((flag & 2) == 0 && ch == '(') {
                if ((i = Sentence.scanParenthesis(str, i, escapeChar)) < 0) {
                    return -1;
                }
                ++i;
                iswordchar = false;
                continue;
            }
            if (!(iswordchar || !phrase.regionMatches((flag & 1) > 0, 0, str, i, plen) || i + plen < slen && Sentence.isWordChar(str.charAt(i + plen)))) {
                return i;
            }
            iswordchar = Sentence.isWordChar(ch);
            ++i;
        }
        return -1;
    }

    public static int phraseAt(String str, String phrase, int start, int flag) {
        return Sentence.phraseAt(str, phrase, start, flag, '\\');
    }

    public static String replace(String str, int start, String sold, String snew, int flag, char escapeChar) {
        int strlen = str.length();
        int len = sold.length();
        StringBuffer dst = null;
        char preChar = '*';
        int i = start;
        while (i < strlen) {
            int j;
            int idx;
            char ch = str.charAt(i);
            if ((ch == '\'' || ch == '\"') && (flag & 0x10) == 0 && (i == 0 || i > 0 && str.charAt(i - 1) != escapeChar)) {
                idx = Sentence.scanQuotation(str, i, escapeChar);
                if (idx < 0) {
                    throw new RuntimeException("\u672a\u627e\u5230\u4f4d\u7f6e" + i + "\u5904\u5bf9\u5e94\u7684\u5f15\u53f7");
                }
                ++idx;
                if (dst != null) {
                    j = i;
                    while (j < idx) {
                        dst.append(str.charAt(j));
                        ++j;
                    }
                }
                i = idx;
                preChar = '*';
                continue;
            }
            if ((flag & 2) == 0 && ch == '(') {
                idx = Sentence.scanParenthesis(str, i, escapeChar);
                if (idx < 0) {
                    throw new RuntimeException("\u672a\u627e\u5230\u4f4d\u7f6e" + i + "\u5904\u5bf9\u5e94\u7684\u5706\u62ec\u53f7");
                }
                ++idx;
                if (dst != null) {
                    j = i;
                    while (j < idx) {
                        dst.append(str.charAt(j));
                        ++j;
                    }
                }
                i = idx;
                preChar = '*';
                continue;
            }
            boolean lb = sold.regionMatches((flag & 1) > 0, 0, str, i, len);
            if (lb && (flag & 8) > 0) {
                boolean bl = lb = !Sentence.isWordChar(sold.charAt(0)) || !Sentence.isWordChar(preChar);
                if (i + len < strlen) {
                    boolean bl2 = lb = lb && (!Sentence.isWordChar(sold.charAt(len - 1)) || !Sentence.isWordChar(str.charAt(i + len)));
                }
            }
            if (lb) {
                if (dst == null) {
                    dst = new StringBuffer(strlen << 2);
                    j = 0;
                    while (j < i) {
                        dst.append(str.charAt(j));
                        ++j;
                    }
                }
                dst.append(snew);
                preChar = str.charAt((i += len) - 1);
                if ((flag & 4) <= 0) continue;
                while (i < strlen) {
                    dst.append(str.charAt(i++));
                }
                break;
            }
            if (dst != null) {
                dst.append(ch);
            }
            preChar = ch;
            ++i;
        }
        return dst == null ? str : dst.toString();
    }

    public static String replace(String str, int start, String sold, String snew, int flag) {
        return Sentence.replace(str, start, sold, snew, flag, '\\');
    }

    public static String replace(String str, String sold, String snew, int flag) {
        return Sentence.replace(str, 0, sold, snew, flag, '\\');
    }

    public int scanQuotation(int start) {
        return Sentence.scanQuotation(this.str, start, this.escapeChar);
    }

    public void trim(int ifcase) {
        this.str = Sentence.trim(this.str, ifcase, this.escapeChar);
    }

    public int phraseAt(String phrase, int start, int flag) {
        return Sentence.phraseAt(this.str, phrase, start, flag, this.escapeChar);
    }

    public int replace(int start, String sold, String snew, int flag) {
        int strlen = this.str.length();
        int len = sold.length();
        int count = 0;
        StringBuffer dst = null;
        char preChar = '*';
        int i = start;
        while (i < strlen) {
            int j;
            int idx;
            char ch = this.str.charAt(i);
            if ((ch == '\"' || ch == '\'') && (i > 0 && this.str.charAt(i - 1) != '\\' || i == 0)) {
                idx = Sentence.scanQuotation(this.str, i, this.escapeChar);
                if (idx < 0) {
                    return 0;
                }
                ++idx;
                if (dst != null) {
                    j = i;
                    while (j < idx) {
                        dst.append(this.str.charAt(j));
                        ++j;
                    }
                }
                i = idx;
                preChar = '*';
                continue;
            }
            if ((flag & 2) == 0 && ch == '(') {
                idx = Sentence.scanParenthesis(this.str, i, this.escapeChar);
                if (idx < 0) {
                    return 0;
                }
                ++idx;
                if (dst != null) {
                    j = i;
                    while (j < idx) {
                        dst.append(this.str.charAt(j));
                        ++j;
                    }
                }
                i = idx;
                preChar = '*';
                continue;
            }
            boolean lb = sold.regionMatches((flag & 1) > 0, 0, this.str, i, len);
            if (lb && (flag & 8) > 0) {
                boolean bl = lb = !Sentence.isWordChar(sold.charAt(0)) || !Sentence.isWordChar(preChar);
                if (i + len < strlen) {
                    boolean bl2 = lb = lb && (!Sentence.isWordChar(sold.charAt(len - 1)) || !Sentence.isWordChar(this.str.charAt(i + len)));
                }
            }
            if (lb) {
                if (dst == null) {
                    dst = new StringBuffer(strlen << 2);
                    j = 0;
                    while (j < i) {
                        dst.append(this.str.charAt(j));
                        ++j;
                    }
                }
                dst.append(snew);
                preChar = this.str.charAt((i += len) - 1);
                ++count;
                if ((flag & 4) <= 0) continue;
                while (i < strlen) {
                    dst.append(this.str.charAt(i++));
                }
                break;
            }
            if (dst != null) {
                dst.append(ch);
            }
            ++i;
        }
        if (dst != null) {
            this.str = dst.toString();
        }
        return count;
    }

    public String toString() {
        return this.str;
    }

    public String getSentence() {
        return this.str;
    }

    public static int indexOf(String str, String find, int start, int flag, char escapeChar) {
        int slen = str.length();
        int plen = find.length();
        int i = start;
        while (i < slen) {
            char ch = str.charAt(i);
            if ((flag & 0x10) == 0 && (ch == '\"' || ch == '\'') && (i > 0 && str.charAt(i - 1) != '\\' || i == 0)) {
                if ((i = Sentence.scanQuotation(str, i, escapeChar)) < 0) {
                    return -1;
                }
                ++i;
                continue;
            }
            if ((flag & 2) == 0 && ch == '(') {
                if ((i = Sentence.scanParenthesis(str, i, escapeChar)) < 0) {
                    return -1;
                }
                ++i;
                continue;
            }
            if (find.regionMatches((flag & 1) > 0, 0, str, i, plen)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(String find, int start, int flag) {
        return Sentence.indexOf(this.str, find, start, flag, this.escapeChar);
    }

    public static int indexOf(String str, String find, int start, int flag) {
        return Sentence.indexOf(str, find, start, flag, '\\');
    }

    public static int indexOf(String str, int start, String find, int flag) {
        char escapeChar = '\\';
        int slen = str.length();
        int plen = find.length();
        char preChar = '*';
        int i = start;
        while (i < slen) {
            char ch = str.charAt(i);
            if ((flag & 0x10) == 0 && (ch == '\"' || ch == '\'') && (i > 0 && str.charAt(i - 1) != '\\' || i == 0)) {
                if ((i = Sentence.scanQuotation(str, i, escapeChar)) < 0) {
                    return -1;
                }
                ++i;
                preChar = ch;
                continue;
            }
            if ((flag & 2) == 0 && ch == '(') {
                if ((i = Sentence.scanParenthesis(str, i, escapeChar)) < 0) {
                    return -1;
                }
                ++i;
                preChar = ch;
                continue;
            }
            if (find.regionMatches((flag & 1) > 0, 0, str, i, plen)) {
                if ((flag & 8) > 0) {
                    boolean lb;
                    boolean bl = lb = !Sentence.isWordChar(find.charAt(0)) || !Sentence.isWordChar(preChar);
                    if (i + plen < slen) {
                        boolean bl2 = lb = lb && (!Sentence.isWordChar(find.charAt(plen - 1)) || !Sentence.isWordChar(str.charAt(i + plen)));
                    }
                    if (!lb) {
                        preChar = ch;
                        ++i;
                        continue;
                    }
                }
                return i;
            }
            ++i;
            preChar = ch;
        }
        return -1;
    }

    public static int lastIndexOf(String src, String find) {
        int end = src.length() - 1;
        int findLen = find.length();
        if (findLen == 1) {
            char tc = find.charAt(0);
            while (end >= 0) {
                char c = src.charAt(end);
                if (c == tc) {
                    if (end > 0 && src.charAt(end - 1) == '\\') break;
                    return end;
                }
                if (c == '\"' || c == '\'' || c == ')' || c == ']' || c == '}' || c == '\\') break;
                --end;
            }
        }
        int pos = -1;
        int i = 0;
        while (i <= end) {
            char c = src.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': {
                    int match = Sentence.scanQuotation(src, i, '\\');
                    if (match == -1) {
                        return -1;
                    }
                    i = match + 1;
                    break;
                }
                case '(': {
                    int match = Sentence.scanParenthesis(src, i, '\\');
                    if (match == -1) {
                        return -1;
                    }
                    i = match + 1;
                    break;
                }
                case '[': {
                    int match = Sentence.scanBracket(src, i, '\\');
                    if (match == -1) {
                        return -1;
                    }
                    i = match + 1;
                    break;
                }
                case '{': {
                    int match = Sentence.scanBrace(src, i, '\\');
                    if (match == -1) {
                        return -1;
                    }
                    i = match + 1;
                    break;
                }
                case '\\': {
                    i += 2;
                    break;
                }
                default: {
                    if (src.startsWith(find, i)) {
                        pos = i;
                        i += findLen;
                        break;
                    }
                    ++i;
                }
            }
        }
        return pos;
    }

    public static boolean isWordChar(char ch) {
        return Character.isJavaIdentifierStart(ch) || Character.isJavaIdentifierPart(ch);
    }

    private static int scanCRLF(String str, int start) {
        int len = str.length();
        while (start < len) {
            char ch = str.charAt(start);
            if (ch == '\r' || ch == '\n') {
                return start;
            }
            ++start;
        }
        return len;
    }

    private static int scanCommentEnd(String str, int start) {
        int len = str.length();
        while (start < len) {
            char ch = str.charAt(start);
            if (ch == '*' && start < len - 1 && str.charAt(start + 1) == '/') {
                return start;
            }
            ++start;
        }
        return len;
    }

    public static String removeComment(String str) {
        int idx = 0;
        int len = str.length();
        StringBuffer buf = new StringBuffer(len);
        while (idx < len) {
            char ch = str.charAt(idx);
            if (ch == '\'' || ch == '\"') {
                int tmp = Sentence.scanQuotation(str, idx);
                if (tmp < 0) {
                    buf.append(str.substring(idx));
                    break;
                }
                buf.append(str.substring(idx, tmp + 1));
                idx = tmp + 1;
                continue;
            }
            if (ch == '/') {
                if (idx == len - 1) {
                    buf.append('/');
                    break;
                }
                char ch2 = str.charAt(idx + 1);
                if (ch2 == '/') {
                    idx = Sentence.scanCRLF(str, idx + 2);
                    continue;
                }
                if (ch2 == '*') {
                    idx = Sentence.scanCommentEnd(str, idx + 2) + 2;
                    continue;
                }
                buf.append('/');
                ++idx;
                continue;
            }
            buf.append(ch);
            ++idx;
        }
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        String line;
        StringBuffer buf = new StringBuffer();
        BufferedReader br = new BufferedReader(new FileReader("d:\\1.txt"));
        while ((line = br.readLine()) != null) {
            buf.append(line).append("\r\n");
        }
        br.close();
        String s = Sentence.removeComment(buf.toString());
        System.out.println(s);
        System.out.println("..." + System.getProperty("line.separator"));
    }
}

