/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class UUID
implements Serializable,
Comparable {
    private static final long serialVersionUID = -4856846361193249489L;
    private final long mostSigBits;
    private final long leastSigBits;
    private transient int version = -1;
    private transient int variant = -1;
    private volatile transient long timestamp = -1L;
    private transient int sequence = -1;
    private transient long node = -1L;
    private transient int hashCode = -1;
    private static volatile SecureRandom numberGenerator = null;

    public static void main(String[] args) {
        System.out.println(UUID.randomUUID());
        ArrayList<String> list = new ArrayList<String>();
        String uid = "";
        int i = 0;
        while (i < 100000) {
            uid = UUID.randomUUID().toString();
            list.add(uid);
            ++i;
        }
        System.out.println(list.size());
        UUID.removeDuplicateObj(list);
    }

    private static void removeDuplicateObj(List list) {
        HashSet someSet = new HashSet(list);
        Iterator iterator = someSet.iterator();
        ArrayList<String> tempList = new ArrayList<String>();
        int i = 0;
        while (iterator.hasNext()) {
            tempList.add(iterator.next().toString());
            ++i;
        }
        System.out.println(tempList.size());
    }

    private UUID(byte[] abyte0) {
        long l = 0L;
        long l1 = 0L;
        int i = 0;
        while (i < 8) {
            l = l << 8 | (long)(abyte0[i] & 0xFF);
            ++i;
        }
        int j = 8;
        while (j < 16) {
            l1 = l1 << 8 | (long)(abyte0[j] & 0xFF);
            ++j;
        }
        this.mostSigBits = l;
        this.leastSigBits = l1;
    }

    public UUID(long l, long l1) {
        this.mostSigBits = l;
        this.leastSigBits = l1;
    }

    public static UUID randomUUID() {
        SecureRandom securerandom = numberGenerator;
        if (securerandom == null) {
            numberGenerator = securerandom = new SecureRandom();
        }
        byte[] abyte0 = new byte[16];
        securerandom.nextBytes(abyte0);
        abyte0[6] = (byte)(abyte0[6] & 0xF);
        abyte0[6] = (byte)(abyte0[6] | 0x40);
        abyte0[8] = (byte)(abyte0[8] & 0x3F);
        abyte0[8] = (byte)(abyte0[8] | 0x80);
        UUID uuid = new UUID(abyte0);
        return new UUID(abyte0);
    }

    public static UUID nameUUIDFromBytes(byte[] abyte0) {
        MessageDigest messagedigest;
        try {
            messagedigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nosuchalgorithmexception) {
            throw new InternalError("MD5 not supported");
        }
        byte[] abyte1 = messagedigest.digest(abyte0);
        abyte1[6] = (byte)(abyte1[6] & 0xF);
        abyte1[6] = (byte)(abyte1[6] | 0x30);
        abyte1[8] = (byte)(abyte1[8] & 0x3F);
        abyte1[8] = (byte)(abyte1[8] | 0x80);
        return new UUID(abyte1);
    }

    public static UUID fromString(String s) {
        String[] as = s.split("-");
        if (as.length != 5) {
            throw new IllegalArgumentException("Invalid UUID string: " + s);
        }
        int i = 0;
        while (i < 5) {
            as[i] = new StringBuffer().append("0x").append(as[i]).toString();
            ++i;
        }
        long l = Long.decode(as[0]);
        l <<= 16;
        l |= Long.decode(as[1]).longValue();
        l <<= 16;
        long l1 = Long.decode(as[3]);
        l1 <<= 48;
        return new UUID(l |= Long.decode(as[2]).longValue(), l1 |= Long.decode(as[4]).longValue());
    }

    public long getLeastSignificantBits() {
        return this.leastSigBits;
    }

    public long getMostSignificantBits() {
        return this.mostSigBits;
    }

    public int version() {
        if (this.version < 0) {
            this.version = (int)(this.mostSigBits >> 12 & 0xFL);
        }
        return this.version;
    }

    public int variant() {
        if (this.variant < 0) {
            this.variant = this.leastSigBits >>> 63 == 0L ? 0 : (this.leastSigBits >>> 62 == 2L ? 2 : (int)(this.leastSigBits >>> 61));
        }
        return this.variant;
    }

    public long timestamp() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
        long l = this.timestamp;
        if (l < 0L) {
            l = (this.mostSigBits & 0xFFFL) << 48;
            l |= (this.mostSigBits >> 16 & 0xFFFFL) << 32;
            this.timestamp = l |= this.mostSigBits >>> 32;
        }
        return l;
    }

    public int clockSequence() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
        if (this.sequence < 0) {
            this.sequence = (int)((this.leastSigBits & 0x3FFF000000000000L) >>> 48);
        }
        return this.sequence;
    }

    public long node() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
        if (this.node < 0L) {
            this.node = this.leastSigBits & 0xFFFFFFFFFFFFL;
        }
        return this.node;
    }

    public String toString() {
        return String.valueOf(UUID.digits(this.mostSigBits >> 32, 8)) + "-" + UUID.digits(this.mostSigBits >> 16, 4) + "-" + UUID.digits(this.mostSigBits, 4) + "-" + UUID.digits(this.leastSigBits >> 48, 4) + "-" + UUID.digits(this.leastSigBits, 12);
    }

    private static String digits(long l, int i) {
        long l1 = 1L << i * 4;
        return Long.toHexString(l1 | l & l1 - 1L).substring(1);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = (int)(this.mostSigBits >> 32 ^ this.mostSigBits ^ this.leastSigBits >> 32 ^ this.leastSigBits);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UUID)) {
            return false;
        }
        if (((UUID)obj).variant() != this.variant()) {
            return false;
        }
        UUID uuid = (UUID)obj;
        return this.mostSigBits == uuid.mostSigBits && this.leastSigBits == uuid.leastSigBits;
    }

    public int compareTo(UUID uuid) {
        return this.mostSigBits >= uuid.mostSigBits ? (this.mostSigBits <= uuid.mostSigBits ? (this.leastSigBits >= uuid.leastSigBits ? (int)(this.leastSigBits > uuid.leastSigBits ? 1 : 0) : -1) : 1) : -1;
    }

    private void readObject(ObjectInputStream objectinputstream) throws IOException, ClassNotFoundException {
        objectinputstream.defaultReadObject();
        this.version = -1;
        this.variant = -1;
        this.timestamp = -1L;
        this.sequence = -1;
        this.node = -1L;
        this.hashCode = -1;
    }

    public int compareTo(Object obj) {
        return this.compareTo((UUID)obj);
    }
}

