/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common;

import java.lang.reflect.Method;

final class WinRegisterUtil {
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int HKEY_USERS = -2147483645;
    public static final int HKEY_PERFORMANCE_DATA = -2147483644;
    public static final int HKEY_CURRENT_CONFIG = -2147483643;
    public static final int NATIVE_HANDLE = 0;
    public static final int ERROR_CODE = 1;
    public static final int DELETE = 65536;
    public static final int KEY_QUERY_VALUE = 1;
    public static final int KEY_SET_VALUE = 2;
    public static final int KEY_CREATE_SUB_KEY = 4;
    public static final int KEY_ENUMERATE_SUB_KEYS = 8;
    public static final int KEY_READ = 131097;
    public static final int KEY_WRITE = 131078;
    public static final int KEY_ALL_ACCESS = 983103;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_FAILED = -1;
    private static final Integer MAX_KEY_LENGHT = new Integer(100);
    private static final Class theClass = WinRegisterUtil.getUtilClass();

    WinRegisterUtil() {
    }

    private static Class getUtilClass() {
        try {
            return Class.forName("java.util.prefs.WindowsPreferences");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int[] windowsRegOpenKeyEx(int hKey, String subKey, int securityMask) {
        try {
            Method m = theClass.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            m.setAccessible(true);
            Object ret = m.invoke(null, new Integer(hKey), WinRegisterUtil.stringToByteArray(subKey), new Integer(securityMask));
            return (int[])ret;
        }
        catch (Exception e) {
            System.out.println("Exception windowsRegOpenKeyEx!");
            int[] nArray = new int[2];
            nArray[1] = -1;
            return nArray;
        }
    }

    public static void windowsRegCloseKey(int hKey) {
        try {
            Method m = theClass.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            m.setAccessible(true);
            m.invoke(null, new Integer(hKey));
        }
        catch (Exception e) {
            System.out.println("Exception windowsRegCloseKey!");
        }
    }

    public static String windowsRegQueryValueEx(int hKey, String key) {
        Object value;
        block3: {
            try {
                Method m = theClass.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
                m.setAccessible(true);
                value = m.invoke(null, new Integer(hKey), WinRegisterUtil.stringToByteArray(key));
                if (value != null) break block3;
                return null;
            }
            catch (Exception e) {
                System.out.println("Exception windowsRegQueryValueEx!");
                return null;
            }
        }
        return WinRegisterUtil.winByteArrayToString((byte[])value);
    }

    public static String windowsRegEnumValue(int hKey, int valueIndex) {
        try {
            Method m = theClass.getDeclaredMethod("WindowsRegEnumValue", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            m.setAccessible(true);
            Object value = m.invoke(null, new Integer(hKey), new Integer(valueIndex), MAX_KEY_LENGHT);
            return WinRegisterUtil.winByteArrayToString((byte[])value);
        }
        catch (Exception e) {
            System.out.println("Exception windowsRegEnumValue!");
            return null;
        }
    }

    private static byte[] stringToByteArray(String str) {
        byte[] result = new byte[str.length() + 1];
        int i = 0;
        while (i < str.length()) {
            result[i] = (byte)str.charAt(i);
            ++i;
        }
        result[str.length()] = 0;
        return result;
    }

    private static final String winByteArrayToString(byte[] array) {
        if (array == null) {
            return null;
        }
        int pos = array.length - 1;
        while (pos >= 0) {
            if (array[pos] != 0) break;
            --pos;
        }
        if (pos >= 0) {
            return new String(array, 0, pos + 1);
        }
        return null;
    }
}

