/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.common.control;

import com.scudata.app.common.AppUtil;
import com.scudata.common.Area;
import com.scudata.common.control.BorderStyleBase;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.HashMap;

public class CellBorderBase {
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int MERGE_NOT = 0;
    private static final int MERGE_LEFTTOP = 1;
    private static final int MERGE_RIGHTTOP = 2;
    private static final int MERGE_LEFTBOTTOM = 4;
    private static final int MERGE_RIGHTBOTTOM = 8;
    private static int row;
    private static int col;
    private static boolean isEditing;
    private static int startRow;
    private static int endRow;
    private static int colCount;
    private static Graphics g;
    private static BorderStyleBase borderStyle;
    private static HashMap<Short, BasicStroke> strokeMap;

    static {
        strokeMap = new HashMap();
    }

    public static void setEnv(Graphics graphics, BorderStyleBase bs, int r, int c, int rc, int cc, boolean isEdit) {
        g = graphics;
        borderStyle = bs;
        row = r;
        col = c;
        startRow = 1;
        endRow = rc;
        colCount = cc;
        isEditing = isEdit;
    }

    public static void setPageHeaderAndFooter(Area pageHeader, Area pageFooter) {
        if (!isEditing) {
            if (pageHeader != null) {
                startRow = pageHeader.getEndRow() + 1;
            }
            if (pageFooter != null) {
                endRow = pageFooter.getBeginRow() - 1;
            }
        }
    }

    public static void drawBorder(int x, int y, int width, int height) {
        int x1 = x;
        int y1 = y;
        int x2 = x + width;
        int y2 = y;
        CellBorderBase.drawBorder(x1, y1, x2, y2, 1, 0);
        x1 = x;
        y1 = y + height;
        x2 = x + width;
        y2 = y + height;
        CellBorderBase.drawBorder(x1, y1, x2, y2, 2, 0);
        x1 = x;
        y1 = y;
        x2 = x;
        y2 = y + height;
        CellBorderBase.drawBorder(x1, y1, x2, y2, 3, 0);
        x1 = x + width;
        y1 = y;
        x2 = x + width;
        y2 = y + height;
        CellBorderBase.drawBorder(x1, y1, x2, y2, 4, 0);
    }

    public static void drawBorder(int x1, int y1, int x2, int y2, int location, int mergeLocation) {
        float[] dash;
        BasicStroke bs;
        float weight = 0.75f;
        byte style = 0;
        int color = Color.lightGray.getRGB();
        switch (location) {
            case 3: {
                weight = borderStyle.getLBWidth();
                style = borderStyle.getLBStyle();
                color = borderStyle.getLBColor();
                break;
            }
            case 4: {
                weight = borderStyle.getRBWidth();
                style = borderStyle.getRBStyle();
                color = borderStyle.getRBColor();
                break;
            }
            case 1: {
                weight = borderStyle.getTBWidth();
                style = borderStyle.getTBStyle();
                color = borderStyle.getTBColor();
                break;
            }
            case 2: {
                weight = borderStyle.getBBWidth();
                style = borderStyle.getBBStyle();
                color = borderStyle.getBBColor();
            }
        }
        if (AppUtil.getColor(color) == null) {
            return;
        }
        if (style == 0 && !isEditing) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(AppUtil.getColor(color));
        if (style == 0) {
            bs = CellBorderBase.getStroke(0.5f);
            g2d.setColor(Color.lightGray);
        } else if (style == 2) {
            dash = new float[]{5.0f, 3.0f};
            bs = new BasicStroke(weight, 0, 0, 1.0f, dash, 0.0f);
        } else if (style == 3) {
            dash = new float[]{10.0f, 3.0f, 2.0f, 3.0f};
            bs = new BasicStroke(weight, 0, 0, 1.0f, dash, 0.0f);
        } else if (style == 0) {
            g2d.setColor(Color.lightGray);
            weight = 2.0f;
            dash = new float[]{1.0f, 1.0f};
            bs = new BasicStroke(weight, 0, 0, 1.0f, dash, 0.0f);
        } else {
            bs = CellBorderBase.getStroke(weight);
        }
        Stroke bsOld = g2d.getStroke();
        g2d.setStroke(bs);
        if (style == 4) {
            float maxW = (double)weight > 1.0 ? 1.0f : weight;
            g2d.setStroke(CellBorderBase.getStroke(maxW));
            switch (location) {
                case 3: {
                    if (CellBorderBase.isFirstCol()) {
                        g2d.drawLine(x1, y1, x2, y2);
                        ++x1;
                        ++x2;
                    }
                    ++x1;
                    ++x2;
                    if (CellBorderBase.isBorderDouble(1) && (mergeLocation == 0 || (1 & mergeLocation) != 0)) {
                        ++y1;
                        if (CellBorderBase.isFirstRow()) {
                            ++y1;
                        }
                    }
                    if (!CellBorderBase.isBorderDouble(2) || mergeLocation != 0 && (4 & mergeLocation) == 0) break;
                    --y2;
                    if (!CellBorderBase.isLastRow()) break;
                    --y2;
                    break;
                }
                case 1: {
                    if (CellBorderBase.isFirstRow()) {
                        g2d.drawLine(x1, y1, x2, y2);
                        ++y1;
                        ++y2;
                    }
                    ++y1;
                    ++y2;
                    if (CellBorderBase.isBorderDouble(3) && (mergeLocation == 0 || (1 & mergeLocation) != 0)) {
                        ++x1;
                        if (CellBorderBase.isFirstCol()) {
                            ++x1;
                        }
                    }
                    if (!CellBorderBase.isBorderDouble(4) || mergeLocation != 0 && (2 & mergeLocation) == 0) break;
                    --x2;
                    if (!CellBorderBase.isLastCol()) break;
                    --x2;
                    break;
                }
                case 2: {
                    if (CellBorderBase.isLastRow()) {
                        g2d.drawLine(x1, y1, x2, y2);
                        --y1;
                        --y2;
                    }
                    --y1;
                    --y2;
                    if (CellBorderBase.isBorderDouble(3) && (mergeLocation == 0 || (4 & mergeLocation) != 0)) {
                        ++x1;
                        if (CellBorderBase.isFirstCol()) {
                            ++x1;
                        }
                    }
                    if (!CellBorderBase.isBorderDouble(4) || mergeLocation != 0 && (8 & mergeLocation) == 0) break;
                    --x2;
                    if (!CellBorderBase.isLastCol()) break;
                    --x2;
                    break;
                }
                case 4: {
                    if (CellBorderBase.isLastCol()) {
                        g2d.drawLine(x1, y1, x2, y2);
                        --x1;
                        --x2;
                    }
                    --x1;
                    --x2;
                    if (CellBorderBase.isBorderDouble(1) && (mergeLocation == 0 || (2 & mergeLocation) != 0)) {
                        ++y1;
                        if (CellBorderBase.isFirstRow()) {
                            ++y1;
                        }
                    }
                    if (!CellBorderBase.isBorderDouble(2) || mergeLocation != 0 && (8 & mergeLocation) == 0) break;
                    --y2;
                    if (!CellBorderBase.isLastRow()) break;
                    --y2;
                }
            }
        }
        g2d.drawLine(x1, y1, x2, y2);
        g2d.setStroke(bsOld);
    }

    private static BasicStroke getStroke(float w) {
        short s = (short)(w * 100.0f);
        BasicStroke bs = strokeMap.get(s);
        if (bs == null) {
            bs = new BasicStroke(w, 0, 0);
            strokeMap.put(s, bs);
        }
        return bs;
    }

    private static boolean isBorderDouble(int location) {
        byte style = 0;
        switch (location) {
            case 3: {
                style = borderStyle.getLBStyle();
                break;
            }
            case 4: {
                style = borderStyle.getRBStyle();
                break;
            }
            case 1: {
                style = borderStyle.getTBStyle();
                break;
            }
            case 2: {
                style = borderStyle.getBBStyle();
            }
        }
        return style == 4;
    }

    private static boolean isLastRow() {
        return row == endRow;
    }

    private static boolean isLastCol() {
        return col == colCount;
    }

    private static boolean isFirstRow() {
        return row == startRow;
    }

    private static boolean isFirstCol() {
        return col == 1;
    }
}

