/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.array.IArray;
import com.scudata.array.IntArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BFileWriter;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.BlockInputStream;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.LongArray;
import com.scudata.dm.ObjectReader;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.BFileCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MemoryCursor;
import com.scudata.dm.cursor.PFileCursor;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BFileReader {
    private FileObject _$18;
    private int _$17;
    private long[] _$16;
    private int _$15;
    private long _$14;
    private long _$13;
    private long _$12;
    private DataStruct _$11;
    private DataStruct _$10;
    private String[] _$9;
    private int[] _$8;
    private boolean _$7;
    private boolean _$6;
    private boolean _$5 = true;
    private int _$4;
    private int _$3;
    private long _$2 = -1L;
    private ObjectReader _$1;

    public BFileReader(FileObject file) {
        this(file, null, null);
    }

    public BFileReader(FileObject file, String[] fields, String opt) {
        this(file, fields, 1, 1, opt);
    }

    public BFileReader(FileObject file, String[] fields, int segSeq, int segCount, String opt) {
        this._$18 = file;
        this._$4 = segSeq;
        this._$3 = segCount;
        if (fields != null) {
            this._$9 = new String[fields.length];
            System.arraycopy(fields, 0, this._$9, 0, fields.length);
        }
        if (opt != null) {
            if (opt.indexOf(105) != -1) {
                this._$7 = true;
            }
            if (opt.indexOf(101) != -1) {
                this._$5 = false;
            }
            if (opt.indexOf(119) != -1) {
                this._$6 = true;
            }
        }
        if (segCount > 1 && (segSeq < 0 || segSeq > segCount)) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(segSeq + mm.getMessage("function.invalidParam"));
        }
    }

    public DataStruct getFileDataStruct() {
        return this._$11;
    }

    private void _$1() throws IOException {
        int segSeq = this._$4 - 1;
        int avg = (this._$15 + 1) / this._$3;
        if (avg < 1) {
            if (segSeq > this._$15) {
                this._$2 = 0L;
            } else {
                this._$2 = this._$16[segSeq];
                if (segSeq > 0) {
                    this._$1.seek(this._$16[segSeq - 1]);
                }
            }
        } else if (segSeq > 0) {
            int s = segSeq * avg - 1;
            int e = s + avg;
            int mod = (this._$15 + 1) % this._$3;
            int n = mod - (this._$3 - segSeq - 1);
            if (n > 0) {
                e += n;
                s += n - 1;
            }
            this._$2 = this._$16[e];
            this._$1.seek(this._$16[s]);
        } else {
            this._$2 = this._$16[avg - 1];
        }
    }

    public long position() {
        return this._$1.position();
    }

    public void seek(long pos) throws IOException {
        this._$1.seek(pos);
    }

    public boolean isOpen() {
        return this._$1 != null;
    }

    public void open() throws IOException {
        this.open(Env.FILE_BUFSIZE);
    }

    private void _$2(int bufSize) {
        ObjectReader importer;
        BlockInputStream in = this._$18.getBlockInputStream(bufSize);
        this._$1 = importer = new ObjectReader(in, bufSize);
    }

    public void open(int bufSize) throws IOException {
        int i;
        long[] blocks;
        int count;
        ObjectReader importer;
        BlockInputStream in = this._$18.getBlockInputStream(bufSize);
        this._$1 = importer = new ObjectReader(in, bufSize);
        if (importer.read() != 114 || importer.read() != 113 || importer.read() != 116 || importer.read() != 98 || importer.read() != 120) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("license.fileFormatError"));
        }
        this._$17 = importer.read();
        int ver = importer.readInt32();
        if (this._$17 == BFileWriter.TYPE_NORMAL) {
            if (this._$3 > 1 && this._$4 > 1) {
                this._$2 = 0L;
            }
            this._$14 = importer.readLong64();
            this._$11 = new DataStruct(importer.readStrings());
            this._$12 = this.position();
        } else if (this._$17 == BFileWriter.TYPE_BLOCK) {
            this._$14 = importer.readLong64();
            this._$13 = importer.readLong64();
            importer.readLong64();
            this._$15 = importer.readInt32();
            count = importer.readInt32();
            blocks = new long[count];
            this._$16 = blocks;
            for (i = 0; i < count; ++i) {
                blocks[i] = importer.readLong64();
            }
            this._$11 = new DataStruct(importer.readStrings());
            this._$12 = this.position();
            if (this._$3 > 1) {
                this._$1();
            }
        } else if (this._$17 == BFileWriter.TYPE_GROUP) {
            this._$14 = importer.readLong64();
            if (ver > 0) {
                this._$13 = importer.readLong64();
                importer.readLong64();
            }
            this._$15 = importer.readInt32();
            count = importer.readInt32();
            blocks = new long[count];
            this._$16 = blocks;
            for (i = 0; i < count; ++i) {
                blocks[i] = importer.readLong64();
            }
            this._$11 = new DataStruct(importer.readStrings());
            this._$12 = this.position();
            if (this._$3 > 1) {
                this._$1();
            }
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("license.fileFormatError"));
        }
        String[] fields = this._$11.getFieldNames();
        int fcount = fields.length;
        if (this._$9 != null) {
            if (this._$7) {
                this._$7 = this._$9.length == 1;
            }
            this._$8 = new int[fcount];
            for (i = 0; i < fcount; ++i) {
                this._$8[i] = -1;
            }
            int count2 = this._$9.length;
            for (i = 0; i < count2; ++i) {
                int q = this._$11.getFieldIndex(this._$9[i]);
                if (q >= 0) {
                    if (this._$8[q] != -1) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(this._$9[i] + mm.getMessage("ds.colNameRepeat"));
                    }
                    this._$8[q] = i;
                    this._$9[i] = fields[q];
                    continue;
                }
                if (!this._$5) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException(this._$9[i] + mm.getMessage("ds.fieldNotExist"));
            }
            this._$10 = new DataStruct(this._$9);
        } else if (this._$7) {
            this._$7 = fcount == 1;
        }
    }

    public void close() throws IOException {
        if (this._$1 != null) {
            this._$1.close();
            this._$1 = null;
        }
    }

    public Sequence readAll() throws IOException {
        return this.read(0x7FFFFFFE);
    }

    public Sequence read(int n) throws IOException {
        Table table;
        long endPos = this._$2;
        ObjectReader importer = this._$1;
        if (n < 1 || endPos != -1L && importer.position() >= endPos) {
            return null;
        }
        int fcount = this._$11.getFieldCount();
        int initSize = n <= ICursor.FETCHCOUNT ? n : ((long)n >= this._$14 && this._$14 > 0L ? (int)this._$14 : (n < 0x7FFFFFFE ? n : ICursor.INITSIZE));
        if (this._$7) {
            Sequence seq = new Sequence(initSize);
            if (this._$9 == null) {
                for (int i = 0; i < n && importer.hasNext() && (endPos == -1L || importer.position() < endPos); ++i) {
                    seq.add(importer.readObject());
                }
            } else {
                int[] readIndex = this._$8;
                for (int i = 0; i < n && importer.hasNext() && (endPos == -1L || importer.position() < endPos); ++i) {
                    for (int f = 0; f < fcount; ++f) {
                        if (readIndex[f] != -1) {
                            seq.add(importer.readObject());
                            continue;
                        }
                        importer.skipObject();
                    }
                }
            }
            if (seq.length() != 0) {
                return seq;
            }
            return null;
        }
        if (this._$6) {
            Sequence seq = new Sequence(initSize);
            if (this._$9 == null) {
                Sequence tmp = new Sequence(this._$11.getFieldNames());
                seq.add(tmp);
                Object[] values = new Object[fcount];
                for (int i = 0; i < n && importer.hasNext() && (endPos == -1L || importer.position() < endPos); ++i) {
                    for (int f = 0; f < fcount; ++f) {
                        values[f] = importer.readObject();
                    }
                    seq.add(new Sequence(values));
                }
            } else {
                Sequence tmp = new Sequence(this._$9);
                seq.add(tmp);
                Object[] values = new Object[this._$9.length];
                int[] readIndex = this._$8;
                for (int i = 0; i < n && importer.hasNext() && (endPos == -1L || importer.position() < endPos); ++i) {
                    for (int f = 0; f < fcount; ++f) {
                        if (readIndex[f] != -1) {
                            values[readIndex[f]] = importer.readObject();
                            continue;
                        }
                        importer.skipObject();
                    }
                    seq.add(new Sequence(values));
                }
            }
            if (seq.length() != 0) {
                return seq;
            }
            return null;
        }
        if (this._$9 == null) {
            table = new Table(this._$11, initSize);
            for (int i = 0; i < n && importer.hasNext() && (endPos == -1L || importer.position() < endPos); ++i) {
                BaseRecord cur = table.newLast();
                for (int f = 0; f < fcount; ++f) {
                    cur.setNormalFieldValue(f, importer.readObject());
                }
            }
        } else {
            int[] readIndex = this._$8;
            table = new Table(this._$10, initSize);
            for (int i = 0; i < n && importer.hasNext() && (endPos == -1L || importer.position() < endPos); ++i) {
                BaseRecord cur = table.newLast();
                for (int f = 0; f < fcount; ++f) {
                    if (readIndex[f] != -1) {
                        cur.setNormalFieldValue(readIndex[f], importer.readObject());
                        continue;
                    }
                    importer.skipObject();
                }
            }
        }
        if (table.length() != 0) {
            return table;
        }
        return null;
    }

    public long skip(long n) throws IOException {
        if (this._$14 > 0L && this._$3 <= 1 && this._$12 == this.position() && this._$2 == -1L) {
            if (this._$14 <= n) {
                this.seek(this._$18.size());
                return this._$14;
            }
            if (this._$17 == BFileWriter.TYPE_BLOCK && this._$13 < n) {
                int i = (int)(n / this._$13);
                this.seek(this._$16[i - 1]);
                this.skip(n - this._$13 * (long)i);
                return n;
            }
        }
        ObjectReader importer = this._$1;
        if (n < 1L || this._$2 != -1L && importer.position() >= this._$2) {
            return 0L;
        }
        int fcount = this._$11.getFieldCount();
        for (long i = 0L; i < n; ++i) {
            if (importer.hasNext() && (this._$2 == -1L || importer.position() < this._$2)) {
                for (int f = 0; f < fcount; ++f) {
                    importer.skipObject();
                }
                continue;
            }
            return i;
        }
        return n;
    }

    public boolean readRecord(int[] fields, Object[] values) throws IOException {
        ObjectReader importer = this._$1;
        if (importer.hasNext()) {
            int fcount = fields.length;
            for (int f = 0; f < fcount; ++f) {
                if (fields[f] != -1) {
                    values[fields[f]] = importer.readObject();
                    continue;
                }
                importer.skipObject();
            }
            return true;
        }
        return false;
    }

    private Object _$1(int field) throws IOException {
        ObjectReader importer = this._$1;
        for (int f = 0; f < field; ++f) {
            importer.skipObject();
        }
        return importer.readObject();
    }

    public boolean readRecord(Object[] values) throws IOException {
        ObjectReader importer = this._$1;
        if (importer.hasNext()) {
            int fcount = values.length;
            for (int f = 0; f < fcount; ++f) {
                values[f] = importer.readObject();
            }
            return true;
        }
        return false;
    }

    public boolean skipRecord() throws IOException {
        ObjectReader importer = this._$1;
        if (importer.hasNext()) {
            int fcount = this._$11.getFieldCount();
            for (int f = 0; f < fcount; ++f) {
                importer.skipObject();
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public ICursor iselect(String key, Sequence values, String[] fields, String opt, Context ctx) {
        count = values.length();
        if (count == 0) {
            return new MemoryCursor(null);
        }
        try {
            this.open(1024);
            blocks = this._$16;
            if (blocks == null) {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("license.fileFormatError"));
            }
            keyField = this._$11.getFieldIndex(key);
            if (keyField < 0) {
                mm = EngineMessage.get();
                throw new RQException(key + mm.getMessage("ds.fieldNotExist"));
            }
            lastBlock = this._$15;
            fcount = this._$11.getFieldCount();
            vals = new Object[fcount];
            posArray = new LongArray(count > 5 ? count * 2 : 10);
            prevEnd = this.position();
            nextBlock = 0;
            nextBlockVal = null;
            if (lastBlock > 0) {
                this.seek(blocks[0]);
                this.readRecord(vals);
                nextBlockVal = vals[keyField];
            }
            i = 1;
            block12: while (i <= count && nextBlock < lastBlock) {
                block30: {
                    block29: {
                        val = values.getMem(i);
                        cmp = Variant.compare(val, nextBlockVal);
                        if (cmp > 0) break block30;
                        if (this.position() > prevEnd) {
                            this.close();
                            this._$2(1024);
                            this.seek(prevEnd);
                        }
                        do lbl-1000:
                        // 3 sources

                        {
                            block31: {
                                this.readRecord(vals);
                                cmp = Variant.compare(val, vals[keyField]);
                                if (cmp <= 0) break block31;
                                prevEnd = this.position();
                                if (prevEnd != blocks[nextBlock]) ** GOTO lbl-1000
                                if (++nextBlock >= lastBlock) continue block12;
                                this.seek(blocks[nextBlock]);
                                this.readRecord(vals);
                                nextBlockVal = vals[keyField];
                                continue block12;
                            }
                            if (cmp != 0) break block29;
                            posArray.add(prevEnd);
                        } while ((prevEnd = this.position()) != blocks[nextBlock]);
                        if (++nextBlock >= lastBlock) continue;
                        this.seek(blocks[nextBlock]);
                        this.readRecord(vals);
                        nextBlockVal = vals[keyField];
                        continue;
                    }
                    ++i;
                    while (i <= count && (cmp = Variant.compare(val = values.getMem(i), vals[keyField])) <= 0) {
                        if (cmp == 0) {
                            posArray.add(prevEnd);
                            break;
                        }
                        ++i;
                    }
                    if ((prevEnd = this.position()) != blocks[nextBlock] || ++nextBlock >= lastBlock) continue;
                    this.seek(blocks[nextBlock]);
                    this.readRecord(vals);
                    nextBlockVal = vals[keyField];
                    continue;
                }
                prevEnd = blocks[nextBlock];
                if (++nextBlock >= lastBlock) continue;
                this.seek(blocks[nextBlock]);
                this.readRecord(vals);
                nextBlockVal = vals[keyField];
            }
            if (i <= count) {
                if (this.position() > prevEnd) {
                    this.close();
                    this._$2(1024);
                    this.seek(prevEnd);
                }
                val = values.getMem(i);
                while (i <= count && this.readRecord(vals)) {
                    cmp = Variant.compare(val, vals[keyField]);
                    if (cmp > 0) {
                        prevEnd = this.position();
                        continue;
                    }
                    if (cmp == 0) {
                        posArray.add(prevEnd);
                        prevEnd = this.position();
                        continue;
                    }
                    ++i;
                    while (i <= count && (cmp = Variant.compare(val = values.getMem(i), vals[keyField])) <= 0) {
                        if (cmp == 0) {
                            posArray.add(prevEnd);
                            break;
                        }
                        ++i;
                    }
                    prevEnd = this.position();
                }
            }
            if (posArray.size() == 0) {
                var18_20 /* !! */  = new MemoryCursor(null);
                return var18_20 /* !! */ ;
            }
            var18_20 /* !! */  = new PFileCursor(this._$18, posArray.toArray(), 1024, fields, opt, ctx);
            return var18_20 /* !! */ ;
        }
        catch (IOException e) {
            throw new RQException(e);
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICursor iselect(String key, Object startVal, Object endVal, String[] fields, String opt, Context ctx) {
        int endBlock;
        int startBlock;
        int keyField;
        long[] blocks;
        long firstPos;
        block37: {
            try {
                Object val;
                int i;
                int lastBlock;
                this.open(1024);
                firstPos = this.position();
                blocks = this._$16;
                if (blocks == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("license.fileFormatError"));
                }
                keyField = this._$11.getFieldIndex(key);
                if (keyField < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(key + mm.getMessage("ds.fieldNotExist"));
                }
                startBlock = lastBlock = this._$15;
                endBlock = lastBlock;
                for (i = 0; i < lastBlock; ++i) {
                    this.seek(blocks[i]);
                    val = this._$1(keyField);
                    if (Variant.compare(val, startVal) < 0) continue;
                    startBlock = i;
                    if (endVal == null || Variant.compare(val, endVal) <= 0) break;
                    endBlock = i;
                    break;
                }
                if (endVal == null || endBlock == startBlock) break block37;
                for (i = startBlock + 1; i < lastBlock; ++i) {
                    this.seek(blocks[i]);
                    val = this._$1(keyField);
                    if (Variant.compare(val, endVal) <= 0) continue;
                    endBlock = i;
                    break;
                }
            }
            catch (IOException e) {
                throw new RQException(e);
            }
            finally {
                try {
                    this.close();
                }
                catch (IOException e) {}
            }
        }
        try {
            this._$2(1024);
            this.seek(firstPos);
            blocks = this._$16;
            long startPos = blocks[startBlock];
            int fcount = this._$11.getFieldCount();
            Object[] vals = new Object[fcount];
            if (startBlock > 0) {
                this.seek(blocks[startBlock - 1]);
            }
            long pos = firstPos;
            while (pos < startPos) {
                this.readRecord(vals);
                if (Variant.compare(vals[keyField], startVal) >= 0) {
                    if (endVal != null && Variant.compare(vals[keyField], endVal) > 0) {
                        MemoryCursor memoryCursor = new MemoryCursor(null);
                        return memoryCursor;
                    }
                    startPos = pos;
                    break;
                }
                pos = this.position();
            }
            long endPos = blocks[endBlock];
            if (endVal != null) {
                if (endBlock > 0 && this.position() < blocks[endBlock - 1]) {
                    this.seek(blocks[endBlock - 1]);
                }
                pos = this.position();
                while (pos < endPos) {
                    this.readRecord(vals);
                    if (Variant.compare(vals[keyField], endVal) > 0) {
                        endPos = pos;
                        break;
                    }
                    pos = this.position();
                }
            }
            if (startPos < endPos) {
                BFileCursor cursor = new BFileCursor(this._$18, fields, opt, ctx);
                cursor.setPosRange(startPos, endPos);
                BFileCursor bFileCursor = cursor;
                return bFileCursor;
            }
            MemoryCursor memoryCursor = new MemoryCursor(null);
            return memoryCursor;
        }
        catch (IOException e) {
            throw new RQException(e);
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {}
        }
    }

    public void setEndPos(long pos) {
        this._$2 = pos;
    }

    public DataStruct getResultSetDataStruct() {
        if (this._$10 == null) {
            return this._$11;
        }
        return this._$10;
    }

    private int _$1(Object[] fieldsValue, Object refValues) {
        Object refObj = null;
        for (int i = 0; i < fieldsValue.length; ++i) {
            refObj = refValues instanceof Sequence ? ((Sequence)refValues).get(i + 1) : refValues;
            int res = Variant.compare(fieldsValue[i], refObj);
            if (res > 0) {
                return 1;
            }
            if (res >= 0) continue;
            return -1;
        }
        return 0;
    }

    private int _$1(Object refValues, Object[] fieldsValue) {
        Object refObj = null;
        for (int i = 0; i < fieldsValue.length; ++i) {
            refObj = refValues instanceof Sequence ? ((Sequence)refValues).get(i + 1) : refValues;
            int res = Variant.compare(fieldsValue[i], refObj);
            if (res > 0) {
                return -1;
            }
            if (res >= 0) continue;
            return 1;
        }
        return 0;
    }

    public ICursor iselect(Expression exp, Sequence values, String[] fields, String opt, Context ctx) {
        String[] fieldNames;
        block26: {
            if (exp == null) {
                return new MemoryCursor(null);
            }
            fieldNames = exp.toFields();
            try {
                this.open(1024);
                if (this._$16 == null) {
                    Sequence result = this.readAll();
                    Sequence fieldValues = result.calc(exp, ctx);
                    IArray valueArray = fieldValues.getMems();
                    IntArray seqArray = null;
                    int len = values.length();
                    for (int i = 1; i <= len; ++i) {
                        IntArray array = valueArray.indexOfAll(values.getMem(i), 1, true, true);
                        if (seqArray == null) {
                            seqArray = array;
                            continue;
                        }
                        seqArray.addAll(array);
                    }
                    if (seqArray == null || seqArray.size() == 0) {
                        MemoryCursor memoryCursor = new MemoryCursor(null);
                        return memoryCursor;
                    }
                    if (fields == null) {
                        result = result.get(new Sequence(seqArray));
                        MemoryCursor memoryCursor = new MemoryCursor(result);
                        return memoryCursor;
                    }
                    result = result.get(new Sequence(seqArray));
                    result = result.fieldsValues(fields, opt);
                    MemoryCursor memoryCursor = new MemoryCursor(result);
                    return memoryCursor;
                }
                if (fieldNames == null) break block26;
                for (String name : fieldNames) {
                    if (this._$11.getFieldIndex(name) != -1) continue;
                    fieldNames = null;
                    break;
                }
            }
            catch (IOException e) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("file.fileNotExist", this._$18.getFileName()));
            }
            finally {
                try {
                    this.close();
                }
                catch (IOException e) {}
            }
        }
        if (fieldNames != null) {
            return this.iselectFields(fieldNames, values, fields, opt, ctx);
        }
        return this._$1(exp, values, fields, opt, ctx);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public ICursor iselectFields(String[] refFields, Sequence values, String[] fields, String opt, Context ctx) {
        fcount = this._$11.getFieldCount();
        selFields = new int[fcount];
        for (i = 0; i < fcount; ++i) {
            selFields[i] = -1;
        }
        fcou = 0;
        for (i = 0; i < refFields.length; ++i) {
            index = this._$11.getFieldIndex(refFields[i]);
            if (0 > index) {
                mm = EngineMessage.get();
                throw new RQException(refFields[i] + mm.getMessage("ds.fieldNotExist"));
            }
            selFields[index] = fcou++;
        }
        count = values.length();
        if (count == 0) {
            return new MemoryCursor(null);
        }
        try {
            this.open(1024);
            blocks = this._$16;
            if (blocks == null) {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("license.fileFormatError"));
            }
            lastBlock = this._$15;
            vals = new Object[fcou];
            posArray = new LongArray(count > 5 ? count * 2 : 10);
            prevEnd = this.position();
            nextBlock = 0;
            nextBlockVal = null;
            if (lastBlock > 0) {
                this.seek(blocks[0]);
                this.readRecord(selFields, vals);
                nextBlockVal = (Object[])vals.clone();
            }
            i = 1;
            block14: while (i <= count && nextBlock < lastBlock) {
                block32: {
                    block31: {
                        val = values.getMem(i);
                        cmp = this._$1(val, nextBlockVal);
                        if (cmp > 0) break block32;
                        if (this.position() > prevEnd) {
                            this.close();
                            this._$2(1024);
                            this.seek(prevEnd);
                        }
                        do lbl-1000:
                        // 3 sources

                        {
                            block33: {
                                this.readRecord(selFields, vals);
                                cmp = this._$1(val, vals);
                                if (cmp <= 0) break block33;
                                prevEnd = this.position();
                                if (prevEnd != blocks[nextBlock]) ** GOTO lbl-1000
                                if (++nextBlock >= lastBlock) continue block14;
                                this.seek(blocks[nextBlock]);
                                this.readRecord(selFields, vals);
                                nextBlockVal = (Object[])vals.clone();
                                continue block14;
                            }
                            if (cmp != 0) break block31;
                            posArray.add(prevEnd);
                        } while ((prevEnd = this.position()) != blocks[nextBlock]);
                        if (++nextBlock >= lastBlock) continue;
                        this.seek(blocks[nextBlock]);
                        this.readRecord(selFields, vals);
                        nextBlockVal = (Object[])vals.clone();
                        continue;
                    }
                    ++i;
                    while (i <= count && (cmp = this._$1(val = values.getMem(i), vals)) <= 0) {
                        if (cmp == 0) {
                            posArray.add(prevEnd);
                            break;
                        }
                        ++i;
                    }
                    if ((prevEnd = this.position()) != blocks[nextBlock] || ++nextBlock >= lastBlock) continue;
                    this.seek(blocks[nextBlock]);
                    this.readRecord(selFields, vals);
                    nextBlockVal = (Object[])vals.clone();
                    continue;
                }
                prevEnd = blocks[nextBlock];
                if (++nextBlock >= lastBlock) continue;
                this.seek(blocks[nextBlock]);
                this.readRecord(selFields, vals);
                nextBlockVal = (Object[])vals.clone();
            }
            if (i <= count) {
                if (this.position() > prevEnd) {
                    this.close();
                    this._$2(1024);
                    this.seek(prevEnd);
                }
                val = values.getMem(i);
                while (i <= count && this.readRecord(selFields, vals)) {
                    cmp = this._$1(val, vals);
                    if (cmp > 0) {
                        prevEnd = this.position();
                        continue;
                    }
                    if (cmp == 0) {
                        posArray.add(prevEnd);
                        prevEnd = this.position();
                        continue;
                    }
                    ++i;
                    while (i <= count && (cmp = this._$1(val = values.getMem(i), vals)) <= 0) {
                        if (cmp == 0) {
                            posArray.add(prevEnd);
                            break;
                        }
                        ++i;
                    }
                    prevEnd = this.position();
                }
            }
            if (posArray.size() == 0) {
                var19_22 /* !! */  = new MemoryCursor(null);
                return var19_22 /* !! */ ;
            }
            var19_22 /* !! */  = new PFileCursor(this._$18, posArray.toArray(), 1024, fields, opt, ctx);
            return var19_22 /* !! */ ;
        }
        catch (IOException e) {
            throw new RQException(e);
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private ICursor _$1(Expression exp, Sequence values, String[] fields, String opt, Context ctx) {
        count = values.length();
        if (count == 0) {
            return new MemoryCursor(null);
        }
        try {
            this.open(1024);
            blocks = this._$16;
            if (blocks == null) {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("license.fileFormatError"));
            }
            lastBlock = this._$15;
            fcount = this._$11.getFieldCount();
            vals = new Object[fcount];
            rec = new Record(this._$11);
            posArray = new LongArray(count > 5 ? count * 2 : 10);
            prevEnd = this.position();
            nextBlock = 0;
            nextBlockVal = null;
            if (lastBlock > 0) {
                this.seek(blocks[0]);
                this.readRecord(vals);
                rec.values = vals;
                nextBlockVal = rec.calc(exp, ctx);
            }
            i = 1;
            block12: while (i <= count && nextBlock < lastBlock) {
                block29: {
                    block28: {
                        val = values.getMem(i);
                        cmp = Variant.compare(val, nextBlockVal);
                        if (cmp > 0) break block29;
                        if (this.position() > prevEnd) {
                            this.close();
                            this._$2(1024);
                            this.seek(prevEnd);
                        }
                        do lbl-1000:
                        // 3 sources

                        {
                            block30: {
                                this.readRecord(vals);
                                rec.values = vals;
                                reCal = rec.calc(exp, ctx);
                                cmp = Variant.compare(val, reCal);
                                if (cmp <= 0) break block30;
                                prevEnd = this.position();
                                if (prevEnd != blocks[nextBlock]) ** GOTO lbl-1000
                                if (++nextBlock >= lastBlock) continue block12;
                                this.seek(blocks[nextBlock]);
                                this.readRecord(vals);
                                rec.values = vals;
                                nextBlockVal = rec.calc(exp, ctx);
                                continue block12;
                            }
                            if (cmp != 0) break block28;
                            posArray.add(prevEnd);
                        } while ((prevEnd = this.position()) != blocks[nextBlock]);
                        if (++nextBlock >= lastBlock) continue;
                        this.seek(blocks[nextBlock]);
                        this.readRecord(vals);
                        rec.values = vals;
                        nextBlockVal = rec.calc(exp, ctx);
                        continue;
                    }
                    ++i;
                    while (i <= count && (cmp = Variant.compare(val = values.getMem(i), rec.calc(exp, ctx))) <= 0) {
                        if (cmp == 0) {
                            posArray.add(prevEnd);
                            break;
                        }
                        ++i;
                    }
                    if ((prevEnd = this.position()) != blocks[nextBlock] || ++nextBlock >= lastBlock) continue;
                    this.seek(blocks[nextBlock]);
                    this.readRecord(vals);
                    rec.values = vals;
                    nextBlockVal = rec.calc(exp, ctx);
                    continue;
                }
                prevEnd = blocks[nextBlock];
                if (++nextBlock >= lastBlock) continue;
                this.seek(blocks[nextBlock]);
                this.readRecord(vals);
                rec.values = vals;
                nextBlockVal = rec.calc(exp, ctx);
            }
            if (i <= count) {
                if (this.position() > prevEnd) {
                    this.close();
                    this._$2(1024);
                    this.seek(prevEnd);
                }
                val = values.getMem(i);
                while (i <= count && this.readRecord(vals)) {
                    rec.values = vals;
                    cmp = Variant.compare(val, rec.calc(exp, ctx));
                    if (cmp > 0) {
                        prevEnd = this.position();
                        continue;
                    }
                    if (cmp == 0) {
                        posArray.add(prevEnd);
                        prevEnd = this.position();
                        continue;
                    }
                    ++i;
                    while (i <= count && (cmp = Variant.compare(val = values.getMem(i), rec.calc(exp, ctx))) <= 0) {
                        if (cmp == 0) {
                            posArray.add(prevEnd);
                            break;
                        }
                        ++i;
                    }
                    prevEnd = this.position();
                }
            }
            if (posArray.size() == 0) {
                var18_19 /* !! */  = new MemoryCursor(null);
                return var18_19 /* !! */ ;
            }
            var18_19 /* !! */  = new PFileCursor(this._$18, posArray.toArray(), 1024, fields, opt, ctx);
            return var18_19 /* !! */ ;
        }
        catch (IOException e) {
            throw new RQException(e);
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {}
        }
    }

    public ICursor iselect(Expression exp, Object startVal, Object endVal, String[] fields, String opt, Context ctx) {
        if (exp == null) {
            return new MemoryCursor(null);
        }
        try {
            this.open(1024);
            if (this._$16 == null) {
                Sequence result = this.readAll();
                Sequence values = result.calc(exp, ctx);
                int len = values.length();
                int start = -1;
                for (int i = 1; i <= len; ++i) {
                    if (Variant.compare(values.getMem(i), startVal) < 0) continue;
                    start = i;
                    break;
                }
                if (start == -1) {
                    return new MemoryCursor(null);
                }
                int end = -1;
                for (int i = len; i >= 1; --i) {
                    if (Variant.compare(values.getMem(i), endVal) > 0) continue;
                    end = i;
                    break;
                }
                if (end < start) {
                    return new MemoryCursor(null);
                }
                if (fields == null) {
                    return new MemoryCursor(result, start, end + 1);
                }
                result = result.get(start, end + 1);
                result = result.fieldsValues(fields, opt);
                return new MemoryCursor(result);
            }
        }
        catch (IOException e) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("file.fileNoExist", this._$18.getFileName()));
        }
        String[] fieldNames = exp.toFields();
        if (null != fieldNames) {
            boolean multi = true;
            block4: for (int i = 0; i < fieldNames.length; ++i) {
                for (int j = 0; j < this._$11.getFieldCount(); ++j) {
                    if (fieldNames[i].equals(this._$11.getFieldName(j))) continue block4;
                }
                multi = false;
                break;
            }
            if (multi) {
                return this._$1(fieldNames, startVal, endVal, fields, opt, ctx);
            }
        }
        return this._$1(exp, startVal, endVal, fields, opt, ctx);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ICursor _$1(String[] refFields, Object startVal, Object endVal, String[] fields, String opt, Context ctx) {
        int endBlock;
        int startBlock;
        long[] blocks;
        long firstPos;
        int[] selFields;
        Object[] vals;
        block39: {
            vals = null;
            int fcount = this._$11.getFieldCount();
            selFields = new int[fcount];
            for (int i = 0; i < fcount; ++i) {
                selFields[i] = -1;
            }
            int fcou = 0;
            for (int i = 0; i < refFields.length; ++i) {
                int index = this._$11.getFieldIndex(refFields[i]);
                if (0 > index) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(refFields[i] + mm.getMessage("ds.fieldNotExist"));
                }
                selFields[index] = fcou++;
            }
            try {
                int i;
                int lastBlock;
                this.open(1024);
                firstPos = this.position();
                blocks = this._$16;
                if (blocks == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("license.fileFormatError"));
                }
                startBlock = lastBlock = this._$15;
                endBlock = lastBlock;
                vals = new Object[fcou];
                for (i = 0; i < lastBlock; ++i) {
                    this.seek(blocks[i]);
                    this.readRecord(selFields, vals);
                    if (this._$1(vals, startVal) < 0) continue;
                    startBlock = i;
                    if (endVal == null || this._$1(vals, endVal) <= 0) break;
                    endBlock = i;
                    break;
                }
                if (endVal == null || endBlock == startBlock) break block39;
                for (i = startBlock + 1; i < lastBlock; ++i) {
                    this.seek(blocks[i]);
                    this.readRecord(selFields, vals);
                    if (this._$1(vals, endVal) <= 0) continue;
                    endBlock = i;
                    break;
                }
            }
            catch (IOException e) {
                throw new RQException(e);
            }
            finally {
                try {
                    this.close();
                }
                catch (IOException e) {}
            }
        }
        try {
            this._$2(1024);
            this.seek(firstPos);
            blocks = this._$16;
            long startPos = blocks[startBlock];
            if (startBlock > 0) {
                this.seek(blocks[startBlock - 1]);
            }
            long pos = firstPos;
            while (pos < startPos) {
                this.readRecord(selFields, vals);
                if (this._$1(vals, startVal) >= 0) {
                    if (endVal != null && this._$1(vals, endVal) > 0) {
                        MemoryCursor memoryCursor = new MemoryCursor(null);
                        return memoryCursor;
                    }
                    startPos = pos;
                    break;
                }
                pos = this.position();
            }
            long endPos = blocks[endBlock];
            if (endVal != null) {
                if (endBlock > 0 && this.position() < blocks[endBlock - 1]) {
                    this.seek(blocks[endBlock - 1]);
                }
                pos = this.position();
                while (pos < endPos) {
                    this.readRecord(selFields, vals);
                    if (this._$1(vals, endVal) > 0) {
                        endPos = pos;
                        break;
                    }
                    pos = this.position();
                }
            }
            if (startPos < endPos) {
                BFileCursor cursor = new BFileCursor(this._$18, fields, opt, ctx);
                cursor.setPosRange(startPos, endPos);
                BFileCursor bFileCursor = cursor;
                return bFileCursor;
            }
            MemoryCursor memoryCursor = new MemoryCursor(null);
            return memoryCursor;
        }
        catch (IOException e) {
            throw new RQException(e);
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ICursor _$1(Expression exp, Object startVal, Object endVal, String[] fields, String opt, Context ctx) {
        int endBlock;
        int startBlock;
        long[] blocks;
        long firstPos;
        Record rec;
        Object[] vals;
        block36: {
            vals = null;
            rec = new Record(this._$11);
            try {
                int i;
                int lastBlock;
                this.open(1024);
                firstPos = this.position();
                blocks = this._$16;
                if (blocks == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("license.fileFormatError"));
                }
                startBlock = lastBlock = this._$15;
                endBlock = lastBlock;
                vals = new Object[this._$11.getFieldCount()];
                for (i = 0; i < lastBlock; ++i) {
                    this.seek(blocks[i]);
                    this.readRecord(vals);
                    rec.values = vals;
                    if (Variant.compare(rec.calc(exp, ctx), startVal) < 0) continue;
                    startBlock = i;
                    if (endVal == null || Variant.compare(rec.calc(exp, ctx), endVal) <= 0) break;
                    endBlock = i;
                    break;
                }
                if (endVal == null || endBlock == startBlock) break block36;
                for (i = startBlock + 1; i < lastBlock; ++i) {
                    this.seek(blocks[i]);
                    this.readRecord(vals);
                    rec.values = vals;
                    if (Variant.compare(rec.calc(exp, ctx), endVal) <= 0) continue;
                    endBlock = i;
                    break;
                }
            }
            catch (IOException e) {
                throw new RQException(e);
            }
            finally {
                try {
                    this.close();
                }
                catch (IOException e) {}
            }
        }
        try {
            this._$2(1024);
            this.seek(firstPos);
            blocks = this._$16;
            long startPos = blocks[startBlock];
            if (startBlock > 0) {
                this.seek(blocks[startBlock - 1]);
            }
            long pos = firstPos;
            while (pos < startPos) {
                this.readRecord(vals);
                rec.values = vals;
                if (Variant.compare(rec.calc(exp, ctx), startVal) >= 0) {
                    if (endVal != null && Variant.compare(rec.calc(exp, ctx), endVal) > 0) {
                        MemoryCursor memoryCursor = new MemoryCursor(null);
                        return memoryCursor;
                    }
                    startPos = pos;
                    break;
                }
                pos = this.position();
            }
            long endPos = blocks[endBlock];
            if (endVal != null) {
                if (endBlock > 0 && this.position() < blocks[endBlock - 1]) {
                    this.seek(blocks[endBlock - 1]);
                }
                pos = this.position();
                while (pos < endPos) {
                    this.readRecord(vals);
                    rec.values = vals;
                    if (Variant.compare(rec.calc(exp, ctx), endVal) > 0) {
                        endPos = pos;
                        break;
                    }
                    pos = this.position();
                }
            }
            if (startPos < endPos) {
                BFileCursor cursor = new BFileCursor(this._$18, fields, opt, ctx);
                cursor.setPosRange(startPos, endPos);
                BFileCursor bFileCursor = cursor;
                return bFileCursor;
            }
            MemoryCursor memoryCursor = new MemoryCursor(null);
            return memoryCursor;
        }
        catch (IOException e) {
            throw new RQException(e);
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {}
        }
    }

    public void getSegmentInfo(ArrayList<Integer> list, Sequence values, int n) throws IOException {
        this.open();
        long[] blocks = this._$16;
        if (blocks == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("license.fileFormatError"));
        }
        int blockCount = this._$15 + 1;
        long blockRecordCount = this._$13;
        int sum = (int)blockRecordCount;
        int colCount = this._$9.length;
        for (int i = 1; i < blockCount; ++i) {
            if ((long)sum + blockRecordCount > (long)n) {
                list.add(sum);
                sum = (int)blockRecordCount;
                this.seek(blocks[i - 1]);
                Object[] vals = new Object[colCount];
                this.readRecord(this._$8, vals);
                values.add(vals);
                continue;
            }
            sum = (int)((long)sum + blockRecordCount);
        }
        list.add(sum);
        this.close();
    }

    public int[] getReadIndex() {
        return this._$8;
    }

    public ObjectReader getImporter() {
        return this._$1;
    }

    public long getFirstRecordPos() {
        return this._$12;
    }

    public long[] getBlocks() {
        return this._$16;
    }

    public int getLastBlock() {
        return this._$15;
    }

    public long getTotalRecordCount() {
        return this._$14;
    }

    public DataStruct getDataStruct() {
        return this._$11;
    }
}

