/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BFileReader;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DataStruct;
import com.scudata.dm.FileObject;
import com.scudata.dm.ObjectReader;
import com.scudata.dm.ObjectWriter;
import com.scudata.dm.RandomObjectWriter;
import com.scudata.dm.RandomOutputStream;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BFileWriter {
    public static int TYPE_BLOCK = 16;
    public static int TYPE_NORMAL = 80;
    public static int TYPE_GROUP = 112;
    public static final int BLOCKCOUNT = 1024;
    public static final int MINBLOCKRECORDCOUNT = 1024;
    public static final String S_FIELDNAME = "_1";
    private FileObject _$13;
    private boolean _$12;
    private boolean _$11;
    private RandomOutputStream _$10;
    private RandomObjectWriter _$9;
    private ObjectWriter _$8;
    private DataStruct _$7;
    private long[] _$6;
    private int _$5;
    private long _$4;
    private long _$3;
    private long _$2;
    private long _$1;

    public BFileWriter(FileObject file, String opt) {
        this._$13 = file;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                this._$12 = true;
            }
            if (opt.indexOf(122) != -1) {
                this._$11 = true;
            }
        }
    }

    public static boolean isBtxOption(String opt) {
        return opt != null && (opt.indexOf(98) != -1 || opt.indexOf(122) != -1);
    }

    public FileObject getFile() {
        return this._$13;
    }

    public void writeHeader(boolean isGroup) throws IOException {
        RandomObjectWriter writer = this._$9;
        writer.position(0L);
        writer.write(114);
        writer.write(113);
        writer.write(116);
        writer.write(98);
        writer.write(120);
        if (isGroup) {
            writer.write(TYPE_GROUP);
            writer.writeInt32(1);
            writer.writeLong64(this._$4);
            writer.writeLong64(this._$3);
            writer.writeLong64(this._$2);
            writer.writeInt32(this._$5);
            long[] blocks = this._$6;
            writer.writeInt32(blocks.length);
            for (long b : blocks) {
                writer.writeLong64(b);
            }
        } else if (this._$11) {
            writer.write(TYPE_BLOCK);
            writer.writeInt32(0);
            writer.writeLong64(this._$4);
            writer.writeLong64(this._$3);
            writer.writeLong64(this._$2);
            writer.writeInt32(this._$5);
            long[] blocks = this._$6;
            writer.writeInt32(blocks.length);
            for (long b : blocks) {
                writer.writeLong64(b);
            }
        } else {
            writer.write(TYPE_NORMAL);
            writer.writeInt32(0);
            writer.writeLong64(this._$4);
        }
        writer.writeStrings(this._$7.getFieldNames());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$1(boolean isGroup) throws IOException {
        InputStream is = this._$10.getInputStream(0L);
        if (is == null) {
            is = this._$13.getInputStream();
        }
        ObjectReader in = new ObjectReader(is);
        try {
            if (in.read() != 114 || in.read() != 113 || in.read() != 116 || in.read() != 98 || in.read() != 120) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("license.fileFormatError"));
            }
            int type = in.read();
            int ver = in.readInt32();
            if (type == TYPE_NORMAL) {
                if (isGroup || this._$11) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("license.fileFormatError"));
                }
                this._$4 = in.readLong64();
            } else if (type == TYPE_BLOCK) {
                if (isGroup) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("license.fileFormatError"));
                }
                this._$11 = true;
                this._$4 = in.readLong64();
                this._$3 = in.readLong64();
                this._$2 = in.readLong64();
                this._$5 = in.readInt32();
                int count = in.readInt32();
                long[] blocks = new long[count];
                this._$6 = blocks;
                for (int i = 0; i < count; ++i) {
                    blocks[i] = in.readLong64();
                }
            } else if (type == TYPE_GROUP) {
                if (!isGroup || ver == 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("license.fileFormatError"));
                }
                this._$4 = in.readLong64();
                this._$3 = in.readLong64();
                this._$2 = in.readLong64();
                this._$5 = in.readInt32();
                int count = in.readInt32();
                long[] blocks = new long[count];
                this._$6 = blocks;
                for (int i = 0; i < count; ++i) {
                    blocks[i] = in.readLong64();
                }
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("license.fileFormatError"));
            }
            this._$7 = new DataStruct(in.readStrings());
        }
        finally {
            in.close();
        }
    }

    public void prepareWrite(DataStruct ds, boolean isGroup) throws IOException {
        if (this._$12) {
            this._$10 = this._$13.getRandomOutputStream(true);
            this._$9 = new RandomObjectWriter(this._$10);
            this._$1 = this._$13.size();
            if (this._$1 > 0L) {
                this._$1(isGroup);
                this._$9.position(this._$1);
            } else {
                if (this._$11) {
                    this._$6 = new long[1024];
                    this._$3 = isGroup ? 1L : 1024L;
                }
                this._$7 = ds;
                this.writeHeader(isGroup);
            }
        } else {
            this._$10 = this._$13.getRandomOutputStream(false);
            this._$9 = new RandomObjectWriter(this._$10);
            this._$1 = 0L;
            if (this._$11) {
                this._$6 = new long[1024];
                this._$3 = isGroup ? 1L : 1024L;
            }
            this._$7 = ds;
            this.writeHeader(isGroup);
        }
    }

    public void close() {
        if (this._$9 != null) {
            try {
                this._$9.close();
                this._$9 = null;
            }
            catch (IOException e) {
                throw new RQException(e);
            }
        }
        if (this._$8 != null) {
            try {
                this._$8.close();
                this._$8 = null;
            }
            catch (IOException e) {
                throw new RQException(e);
            }
        }
    }

    private DataStruct _$1(Sequence seq, Expression[] exps, String[] names) {
        int fcount = exps.length;
        String[] tmps = new String[fcount];
        if (names != null) {
            System.arraycopy(names, 0, tmps, 0, fcount);
        }
        seq.getNewFieldNames(exps, tmps, "export");
        return new DataStruct(tmps);
    }

    private Expression[] _$1(DataStruct ds, Expression[] exps, String[] names) {
        DataStruct srcDs = this._$7;
        if (srcDs.isCompatible(ds)) {
            return exps;
        }
        int fcount = srcDs.getFieldCount();
        if (fcount != ds.getFieldCount()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dsNotMatch"));
        }
        if (exps == null) {
            exps = new Expression[fcount];
            String[] fields = srcDs.getFieldNames();
            for (int i = 0; i < fcount; ++i) {
                int index = ds.getFieldIndex(fields[i]);
                if (index < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.dsNotMatch"));
                }
                exps[i] = new Expression("#" + (index + 1));
            }
            return exps;
        }
        if (names != null) {
            Expression[] tmp = new Expression[fcount];
            for (int i = 0; i < fcount; ++i) {
                if (names[i] != null) {
                    int index = ds.getFieldIndex(names[i]);
                    if (index < 0 || tmp[index] != null) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(mm.getMessage("engine.dsNotMatch"));
                    }
                    tmp[index] = exps[i];
                    continue;
                }
                if (tmp[i] != null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.dsNotMatch"));
                }
                tmp[i] = exps[i];
            }
            return tmp;
        }
        return exps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$1(Context ctx) throws IOException {
        Sequence seq = null;
        BFileReader reader = new BFileReader(this._$13);
        try {
            reader.open();
            seq = reader.readAll();
        }
        finally {
            reader.close();
        }
        BFileWriter writer = new BFileWriter(this._$13, "z");
        writer.export(seq, null, null, ctx);
    }

    public void export(Sequence data, Expression[] exps, String[] names, Context ctx) {
        DataStruct ds;
        if (data == null || data.length() == 0) {
            if (!this._$12) {
                this._$13.delete();
            }
            return;
        }
        if (!this._$12 && data.length() > 1024) {
            this._$11 = true;
        }
        if (exps != null) {
            ds = this._$1(data, exps, names);
        } else {
            ds = data.dataStruct();
            if (ds == null) {
                ds = new DataStruct(new String[]{S_FIELDNAME});
            }
        }
        try {
            this.prepareWrite(ds, false);
            if (this._$12 && !this._$11 && (long)data.length() + this._$4 > 1024L) {
                this.close();
                this._$1(ctx);
                this._$11 = true;
                this.prepareWrite(ds, false);
            }
            this._$1(ds, exps, names);
            if (this._$11) {
                this._$3(data, exps, ctx);
            } else {
                this._$1(data, exps, ctx);
            }
            this._$9.flush();
            this.writeHeader(false);
        }
        catch (Exception e) {
            this._$13.setFileSize(this._$1);
            if (e instanceof RQException) {
                throw (RQException)e;
            }
            throw new RQException(e);
        }
        finally {
            this.close();
        }
    }

    public void export(ICursor cursor, Expression[] exps, String[] names, Context ctx) {
        DataStruct ds;
        Sequence data = cursor.fetch(ICursor.FETCHCOUNT);
        if (data == null || data.length() == 0) {
            if (!this._$12) {
                this._$13.delete();
            }
            return;
        }
        if (!this._$12) {
            this._$11 = true;
        }
        if (exps != null) {
            ds = this._$1(data, exps, names);
        } else {
            ds = data.dataStruct();
            if (ds == null) {
                ds = new DataStruct(new String[]{S_FIELDNAME});
            }
        }
        try {
            this.prepareWrite(ds, false);
            if (this._$12 && !this._$11 && (long)data.length() + this._$4 > 1024L) {
                this.close();
                this._$1(ctx);
                this._$11 = true;
                this.prepareWrite(ds, false);
            }
            this._$1(ds, exps, names);
            if (this._$11) {
                while (data != null && data.length() > 0) {
                    this._$3(data, exps, ctx);
                    data = cursor.fetch(ICursor.FETCHCOUNT);
                }
            } else {
                while (data != null && data.length() > 0) {
                    this._$1(data, exps, ctx);
                    data = cursor.fetch(ICursor.FETCHCOUNT);
                }
            }
            this._$9.flush();
            this.writeHeader(false);
        }
        catch (Exception e) {
            this._$13.setFileSize(this._$1);
            if (e instanceof RQException) {
                throw (RQException)e;
            }
            throw new RQException(e);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$3(Sequence data, Expression[] exps, Context ctx) throws IOException {
        RandomObjectWriter writer = this._$9;
        long[] blocks = this._$6;
        int blockCount = blocks.length;
        int lastBlock = this._$5;
        long blockRecordCount = this._$3;
        long lastRecordCount = this._$2;
        int fcount = this._$7.getFieldCount();
        int len = data.length();
        if (exps == null) {
            boolean isTable = data.getMem(1) instanceof BaseRecord;
            for (int i = 1; i <= len; ++i) {
                if (lastRecordCount == blockRecordCount) {
                    blocks[lastBlock++] = writer.position();
                    lastRecordCount = 0L;
                    if (lastBlock == blockCount) {
                        blockRecordCount += blockRecordCount;
                        lastBlock = blockCount / 2;
                        int b = 0;
                        int j = 1;
                        while (b < lastBlock) {
                            blocks[b] = blocks[j];
                            ++b;
                            j += 2;
                        }
                    }
                }
                ++lastRecordCount;
                if (isTable) {
                    BaseRecord r = (BaseRecord)data.getMem(i);
                    Object[] vals = r.getFieldValues();
                    for (int f = 0; f < fcount; ++f) {
                        writer.writeObject(vals[f]);
                    }
                    continue;
                }
                writer.writeObject(data.getMem(i));
            }
        } else {
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(data);
            stack.push(current);
            try {
                for (int i = 1; i <= len; ++i) {
                    if (lastRecordCount == blockRecordCount) {
                        blocks[lastBlock++] = writer.position();
                        lastRecordCount = 0L;
                        if (lastBlock == blockCount) {
                            blockRecordCount += blockRecordCount;
                            lastBlock = blockCount / 2;
                            int b = 0;
                            int j = 1;
                            while (b < lastBlock) {
                                blocks[b] = blocks[j];
                                ++b;
                                j += 2;
                            }
                        }
                    }
                    ++lastRecordCount;
                    current.setCurrent(i);
                    for (int f = 0; f < fcount; ++f) {
                        writer.writeObject(exps[f].calculate(ctx));
                    }
                }
            }
            finally {
                stack.pop();
            }
        }
        blocks[lastBlock] = writer.position();
        this._$4 += (long)len;
        this._$5 = lastBlock;
        this._$3 = blockRecordCount;
        this._$2 = lastRecordCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$2(Sequence data, Expression[] exps, Context ctx) throws IOException {
        RandomObjectWriter writer = this._$9;
        int fcount = this._$7.getFieldCount();
        int len = data.length();
        if (exps == null) {
            boolean isTable = data.getMem(1) instanceof BaseRecord;
            for (int i = 1; i <= len; ++i) {
                if (isTable) {
                    BaseRecord r = (BaseRecord)data.getMem(i);
                    Object[] vals = r.getFieldValues();
                    for (int f = 0; f < fcount; ++f) {
                        writer.writeObject(vals[f]);
                    }
                    continue;
                }
                writer.writeObject(data.getMem(i));
            }
        } else {
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(data);
            stack.push(current);
            try {
                for (int i = 1; i <= len; ++i) {
                    current.setCurrent(i);
                    for (int f = 0; f < fcount; ++f) {
                        writer.writeObject(exps[f].calculate(ctx));
                    }
                }
            }
            finally {
                stack.pop();
            }
        }
        this._$4 += (long)len;
        long[] blocks = this._$6;
        if (this._$2 == this._$3) {
            ++this._$5;
            this._$2 = 0L;
            if (this._$5 == blocks.length) {
                this._$3 += this._$3;
                this._$5 = blocks.length / 2;
                int b = 0;
                int j = 1;
                while (b < this._$5) {
                    blocks[b] = blocks[j];
                    ++b;
                    j += 2;
                }
            }
        }
        ++this._$2;
        blocks[this._$5] = writer.position();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _$1(Sequence data, Expression[] exps, Context ctx) throws IOException {
        RandomObjectWriter writer = this._$9;
        int fcount = this._$7.getFieldCount();
        int len = data.length();
        if (exps == null) {
            boolean isTable = data.getMem(1) instanceof BaseRecord;
            if (isTable) {
                for (int i = 1; i <= len; ++i) {
                    BaseRecord r = (BaseRecord)data.getMem(i);
                    Object[] vals = r.getFieldValues();
                    for (int f = 0; f < fcount; ++f) {
                        writer.writeObject(vals[f]);
                    }
                }
            } else {
                for (int i = 1; i <= len; ++i) {
                    writer.writeObject(data.getMem(i));
                }
            }
        } else {
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(data);
            stack.push(current);
            try {
                for (int i = 1; i <= len; ++i) {
                    current.setCurrent(i);
                    for (int f = 0; f < fcount; ++f) {
                        writer.writeObject(exps[f].calculate(ctx));
                    }
                }
            }
            finally {
                stack.pop();
            }
        }
        this._$4 += (long)len;
    }

    public void export(ICursor cursor, Expression[] exps, String[] names, Expression gexp, Context ctx) {
        DataStruct ds;
        Sequence data = cursor.fetchGroup(gexp, ctx);
        if (data == null || data.length() == 0) {
            if (!this._$12) {
                this._$13.delete();
            }
            return;
        }
        if (!this._$12) {
            this._$11 = true;
        }
        if (exps != null) {
            ds = this._$1(data, exps, names);
        } else {
            ds = data.dataStruct();
            if (ds == null) {
                ds = new DataStruct(new String[]{S_FIELDNAME});
            }
        }
        try {
            this.prepareWrite(ds, true);
            this._$1(ds, exps, names);
            while (data != null && data.length() > 0) {
                this._$2(data, exps, ctx);
                data = cursor.fetchGroup(gexp, ctx);
            }
            this._$9.flush();
            this.writeHeader(true);
        }
        catch (Exception e) {
            this._$13.setFileSize(this._$1);
            if (e instanceof RQException) {
                throw (RQException)e;
            }
            throw new RQException(e);
        }
        finally {
            this.close();
        }
    }

    private static void _$1(ObjectWriter writer, DataStruct ds) throws IOException {
        writer.write(114);
        writer.write(113);
        writer.write(116);
        writer.write(98);
        writer.write(120);
        writer.write(TYPE_NORMAL);
        writer.writeInt32(0);
        writer.writeLong64(0L);
        if (ds != null) {
            writer.writeStrings(ds.getFieldNames());
        } else {
            writer.writeStrings(new String[]{S_FIELDNAME});
        }
    }

    public static void export(ObjectWriter writer, Sequence data, DataStruct ds, boolean writeHeader) throws IOException {
        if (writeHeader) {
            BFileWriter._$1(writer, ds);
        }
        int len = data.length();
        if (ds != null) {
            int fcount = ds.getFieldCount();
            for (int i = 1; i <= len; ++i) {
                BaseRecord r = (BaseRecord)data.getMem(i);
                Object[] vals = r.getFieldValues();
                for (int f = 0; f < fcount; ++f) {
                    writer.writeObject(vals[f]);
                }
            }
        } else {
            for (int i = 1; i <= len; ++i) {
                writer.writeObject(data.getMem(i));
            }
        }
    }

    public static void export(ObjectWriter writer, ICursor cursor, boolean writeHeader) throws IOException {
        Sequence data = cursor.fetch(ICursor.FETCHCOUNT);
        if (data == null || data.length() == 0) {
            return;
        }
        DataStruct ds = data.dataStruct();
        if (writeHeader) {
            BFileWriter._$1(writer, ds);
        }
        while (data != null && data.length() > 0) {
            BFileWriter.export(writer, data, ds, false);
            data = cursor.fetch(ICursor.FETCHCOUNT);
        }
    }

    public void write(Sequence data) throws IOException {
        RandomObjectWriter writer = this._$9;
        int fcount = this._$7.getFieldCount();
        int len = data.length();
        for (int i = 1; i <= len; ++i) {
            BaseRecord r = (BaseRecord)data.getMem(i);
            Object[] vals = r.getFieldValues();
            for (int f = 0; f < fcount; ++f) {
                writer.writeObject(vals[f]);
            }
        }
        this._$4 += (long)len;
    }

    public void writeBlock(Sequence data) throws IOException {
        RandomObjectWriter writer = this._$9;
        boolean isTable = data.getMem(1) instanceof BaseRecord;
        long[] blocks = this._$6;
        int blockCount = blocks.length;
        int lastBlock = this._$5;
        long blockRecordCount = this._$3;
        long lastRecordCount = this._$2;
        int fcount = this._$7.getFieldCount();
        int len = data.length();
        for (int i = 1; i <= len; ++i) {
            if (lastRecordCount == blockRecordCount) {
                blocks[lastBlock++] = writer.position();
                lastRecordCount = 0L;
                if (lastBlock == blockCount) {
                    blockRecordCount += blockRecordCount;
                    lastBlock = blockCount / 2;
                    int b = 0;
                    int j = 1;
                    while (b < lastBlock) {
                        blocks[b] = blocks[j];
                        ++b;
                        j += 2;
                    }
                }
            }
            ++lastRecordCount;
            if (isTable) {
                BaseRecord r = (BaseRecord)data.getMem(i);
                Object[] vals = r.getFieldValues();
                for (int f = 0; f < fcount; ++f) {
                    writer.writeObject(vals[f]);
                }
                continue;
            }
            writer.writeObject(data.getMem(i));
        }
        blocks[lastBlock] = writer.position();
        this._$4 += (long)len;
        this._$5 = lastBlock;
        this._$3 = blockRecordCount;
        this._$2 = lastRecordCount;
    }

    public void exportBinary(ICursor cursor, DataStruct ds, int fieldIndex, Context ctx) {
        Sequence data = cursor.fetch(ICursor.FETCHCOUNT);
        if (data == null || data.length() == 0) {
            if (!this._$12) {
                this._$13.delete();
            }
            return;
        }
        if (!this._$12) {
            this._$11 = true;
        }
        if (ds == null) {
            ds = new DataStruct(new String[]{S_FIELDNAME});
        }
        try {
            this.prepareWrite(ds, false);
            if (this._$12 && !this._$11 && (long)data.length() + this._$4 > 1024L) {
                this.close();
                this._$1(ctx);
                this._$11 = true;
                this.prepareWrite(ds, false);
            }
            if (this._$11) {
                while (data != null && data.length() > 0) {
                    this._$2(data, fieldIndex, ctx);
                    data = cursor.fetch(ICursor.FETCHCOUNT);
                }
            } else {
                while (data != null && data.length() > 0) {
                    this._$1(data, fieldIndex, ctx);
                    data = cursor.fetch(ICursor.FETCHCOUNT);
                }
            }
            this._$9.flush();
            this.writeHeader(false);
        }
        catch (Exception e) {
            this._$13.setFileSize(this._$1);
            if (e instanceof RQException) {
                throw (RQException)e;
            }
            throw new RQException(e);
        }
        finally {
            this.close();
        }
    }

    private void _$2(Sequence data, int fieldIndex, Context ctx) throws IOException {
        RandomObjectWriter writer = this._$9;
        long[] blocks = this._$6;
        int blockCount = blocks.length;
        int lastBlock = this._$5;
        long blockRecordCount = this._$3;
        long lastRecordCount = this._$2;
        int len = data.length();
        for (int i = 1; i <= len; ++i) {
            if (lastRecordCount == blockRecordCount) {
                blocks[lastBlock++] = writer.position();
                lastRecordCount = 0L;
                if (lastBlock == blockCount) {
                    blockRecordCount += blockRecordCount;
                    lastBlock = blockCount / 2;
                    int b = 0;
                    int j = 1;
                    while (b < lastBlock) {
                        blocks[b] = blocks[j];
                        ++b;
                        j += 2;
                    }
                }
            }
            ++lastRecordCount;
            BaseRecord r = (BaseRecord)data.getMem(i);
            byte[] bytes = (byte[])r.getNormalFieldValue(fieldIndex);
            writer.write(bytes);
        }
        blocks[lastBlock] = writer.position();
        this._$4 += (long)len;
        this._$5 = lastBlock;
        this._$3 = blockRecordCount;
        this._$2 = lastRecordCount;
    }

    private void _$1(Sequence data, int fieldIndex, Context ctx) throws IOException {
        RandomObjectWriter writer = this._$9;
        int len = data.length();
        for (int i = 1; i <= len; ++i) {
            BaseRecord r = (BaseRecord)data.getMem(i);
            byte[] bytes = (byte[])r.getNormalFieldValue(fieldIndex);
            writer.write(bytes);
        }
        this._$4 += (long)len;
    }

    public void prepareWriteNormal(DataStruct ds) throws IOException {
        this._$7 = ds;
        OutputStream os = this._$13.getOutputStream(false);
        this._$8 = new ObjectWriter(os);
        this._$8.write(114);
        this._$8.write(113);
        this._$8.write(116);
        this._$8.write(98);
        this._$8.write(120);
        this._$8.write(TYPE_NORMAL);
        this._$8.writeInt32(0);
        this._$8.writeLong64(this._$4);
        this._$8.writeStrings(ds.getFieldNames());
    }

    public void exportNormal(Sequence data) {
        if (data == null || data.length() == 0) {
            this._$13.delete();
            return;
        }
        this._$4 = data.length();
        this._$7 = data.dataStruct();
        if (this._$7 == null) {
            this._$7 = new DataStruct(new String[]{S_FIELDNAME});
        }
        try {
            this.prepareWriteNormal(this._$7);
            this.writeNormal(data);
        }
        catch (Exception e) {
            if (e instanceof RQException) {
                throw (RQException)e;
            }
            throw new RQException(e);
        }
        finally {
            this.close();
        }
    }

    public void writeNormal(Sequence data) throws IOException {
        ObjectWriter writer = this._$8;
        int fcount = this._$7.getFieldCount();
        int len = data.length();
        boolean isTable = data.getMem(1) instanceof BaseRecord;
        if (isTable) {
            for (int i = 1; i <= len; ++i) {
                BaseRecord r = (BaseRecord)data.getMem(i);
                Object[] vals = r.getFieldValues();
                for (int f = 0; f < fcount; ++f) {
                    writer.writeObject(vals[f]);
                }
            }
        } else {
            for (int i = 1; i <= len; ++i) {
                writer.writeObject(data.getMem(i));
            }
        }
    }
}

