/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.common.DBSession;
import com.scudata.common.ISessionFactory;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.IResource;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import com.scudata.util.DatabaseUtil;
import java.sql.Connection;
import java.sql.SQLException;

public class DBObject
implements IResource {
    private DBSession _$4;
    private Context _$3;
    private boolean _$2;
    private boolean _$1 = false;

    public DBObject(DBSession dbSession) {
        this._$4 = dbSession;
    }

    public DBObject(ISessionFactory dbsf, String opt, Context ctx) throws Exception {
        this._$4 = dbsf.getSession();
        this._$2 = true;
        this._$3 = ctx;
        if (ctx != null) {
            ctx.addResource(this);
        }
        if (opt != null) {
            if (opt.indexOf(101) != -1) {
                this._$4.setErrorMode(true);
            }
            if (opt.indexOf(108) != -1) {
                this._$1 = true;
            }
            this._$4.isolate(opt);
        }
    }

    public boolean canClose() {
        return this._$2;
    }

    public void close() {
        if (!this._$2) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dbCloseError"));
        }
        DBSession dbSession = this.getDbSession();
        if (!dbSession.isClosed()) {
            if (this._$3 != null) {
                this._$3.removeResource(this);
            }
            if (!dbSession.getAutoCommit()) {
                try {
                    this.rollback(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            dbSession.close();
        }
    }

    public Object error(String opt) {
        DBSession session = this.getDbSession();
        SQLException e = session.error();
        session.setError(null);
        if (e == null) {
            if (opt == null || opt.indexOf(109) == -1) {
                return new Integer(0);
            }
            return null;
        }
        if (opt == null || opt.indexOf(109) == -1) {
            return new Integer(e.getErrorCode());
        }
        String str = e.getMessage();
        if (str == null) {
            str = "SQLException error code\uff1a" + e.getErrorCode();
        }
        return str;
    }

    public void commit() {
        try {
            Connection con = (Connection)this._$4.getSession();
            con.commit();
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    public boolean rollback(String name) {
        try {
            return this._$4.rollback(name);
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    public String isolate(String opt) {
        try {
            return this._$4.isolate(opt);
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    public boolean isLower() {
        return this._$1;
    }

    public boolean savepoint(String name) {
        try {
            return this._$4.savepoint(name);
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    public DBSession getDbSession() {
        return this._$4;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DBObject)) {
            return false;
        }
        DBObject other = (DBObject)obj;
        return this._$4 == other._$4;
    }

    public Sequence query(String sql, Object[] params, byte[] types, String opt, Context ctx) {
        if (this._$1) {
            opt = opt == null ? "l" : opt + "l";
        }
        Sequence result = DatabaseUtil.query(sql, params, types, opt, ctx, this.getDbSession());
        if (opt != null && opt.indexOf(120) != -1 && this.canClose()) {
            this.close();
        }
        return result;
    }

    public Sequence query(Sequence srcSeries, String sql, Expression[] params, byte[] types, String opt, Context ctx) {
        if (this._$1) {
            opt = opt == null ? "l" : opt + "l";
        }
        Sequence result = DatabaseUtil.query(srcSeries, sql, params, types, opt, ctx, this.getDbSession());
        if (opt != null && opt.indexOf(120) != -1 && this.canClose()) {
            this.close();
        }
        return result;
    }

    public Object query1(String sql, Object[] params, byte[] types, String opt) {
        if (this._$1) {
            opt = opt == null ? "l" : opt + "l";
        }
        DBSession dbs = this.getDbSession();
        Sequence sequence = DatabaseUtil.query(sql, params, types, dbs, opt);
        if (opt != null && opt.indexOf(120) != -1 && this.canClose()) {
            this.close();
        }
        if (sequence == null || sequence.length() == 0) {
            return null;
        }
        Object obj = sequence.get(1);
        if (obj instanceof Record) {
            Record r = (Record)obj;
            Object[] vals = r.getFieldValues();
            if (vals.length == 1) {
                return vals[0];
            }
            return new Sequence(vals);
        }
        return obj;
    }

    public Sequence proc(String sql, Object[] params, byte[] types, byte[] modes, String[] outParams, Context ctx) {
        DBSession dbs = this.getDbSession();
        Sequence series = DatabaseUtil.proc(sql, params, modes, types, outParams, dbs, ctx);
        return series == null ? new Sequence(0) : series;
    }

    public Object execute(String sql, Object[] params, byte[] types, String opt) {
        if (this._$1) {
            opt = opt == null ? "l" : opt + "l";
        }
        DBSession dbs = this.getDbSession();
        Object ret = DatabaseUtil.execute(sql, params, types, dbs, opt);
        if (opt == null || opt.indexOf(107) == -1) {
            this.commit();
        }
        return ret;
    }

    public void execute(Sequence srcSeries, String sql, Expression[] params, byte[] types, String opt, Context ctx) {
        DBSession dbs = this.getDbSession();
        DatabaseUtil.execute(srcSeries, sql, params, types, ctx, dbs);
        if (opt == null || opt.indexOf(107) == -1) {
            this.commit();
        }
    }

    public void execute(ICursor cursor, String sql, Expression[] params, byte[] types, String opt, Context ctx) {
        DBSession dbs = this.getDbSession();
        DatabaseUtil.execute(cursor, sql, params, types, ctx, dbs);
        if (opt == null || opt.indexOf(107) == -1) {
            this.commit();
        }
    }

    public int update(Sequence srcSeries, String table, String[] fields, String[] fopts, Expression[] exps, String opt, Context ctx) {
        if (srcSeries == null || srcSeries.length() == 0) {
            return 0;
        }
        DBSession dbs = this.getDbSession();
        int count = DatabaseUtil.update(srcSeries, table, fields, fopts, exps, opt, dbs, ctx);
        if (opt == null || opt.indexOf(107) == -1) {
            this.commit();
        }
        return count;
    }

    public int update(ICursor cursor, String table, String[] fields, String[] fopts, Expression[] exps, String opt, Context ctx) {
        DBSession dbs = this.getDbSession();
        int count = DatabaseUtil.update(cursor, table, fields, fopts, exps, opt, dbs, ctx);
        if (opt == null || opt.indexOf(107) == -1) {
            this.commit();
        }
        return count;
    }

    public int update(Sequence seq1, Sequence seq2, String table, String[] fields, String[] fopts, Expression[] exps, String opt, Context ctx) {
        DBSession dbs = this.getDbSession();
        int count = DatabaseUtil.update(seq1, seq2, table, fields, fopts, exps, opt, dbs, ctx);
        if (opt == null || opt.indexOf(107) == -1) {
            this.commit();
        }
        return count;
    }
}

