/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.FileObject;
import com.scudata.dm.IFile;
import com.scudata.dm.LocalFile;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.cursor.MergeCursor;
import com.scudata.dm.cursor.UpdateIdCursor;
import com.scudata.dm.cursor.UpdateMergeCursor;
import com.scudata.dw.ColComTable;
import com.scudata.dw.ColPhyTable;
import com.scudata.dw.ColumnMetaData;
import com.scudata.dw.ComTable;
import com.scudata.dw.IPhyTable;
import com.scudata.dw.PhyTable;
import com.scudata.dw.PhyTableGroup;
import com.scudata.dw.RowComTable;
import com.scudata.dw.RowPhyTable;
import com.scudata.resources.EngineMessage;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;

public class FileGroup
implements Externalizable {
    private String _$3;
    private int[] _$2;
    private FileObject[] _$1;

    public FileGroup(String fileName, int[] partitions) {
        this._$3 = fileName;
        this._$2 = partitions;
    }

    public FileGroup(FileObject[] files, String fileName, int[] partitions) {
        this._$3 = fileName;
        this._$2 = partitions;
        this._$1 = files;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._$3);
        out.writeInt(this._$2.length);
        for (int p : this._$2) {
            out.writeInt(p);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._$3 = (String)in.readObject();
        int count = in.readInt();
        this._$2 = new int[count];
        for (int i = 0; i < count; ++i) {
            this._$2[i] = in.readInt();
        }
    }

    public String getFileName() {
        return this._$3;
    }

    public int[] getPartitions() {
        return this._$2;
    }

    public PhyTableGroup open(String opt, Context ctx) {
        int pcount = this._$2.length;
        IPhyTable[] tables = new PhyTable[pcount];
        if (this._$1 == null) {
            for (int i = 0; i < pcount; ++i) {
                File file = Env.getPartitionFile(this._$2[i], this._$3);
                tables[i] = ComTable.openBaseTable(file, ctx);
                ((PhyTable)tables[i]).getGroupTable().setPartition(this._$2[i]);
            }
        } else {
            for (int i = 0; i < pcount; ++i) {
                tables[i] = ComTable.openBaseTable(this._$1[i], ctx);
                ((PhyTable)tables[i]).getGroupTable().setPartition(this._$2[i]);
            }
        }
        return new PhyTableGroup(this._$3, tables, this._$2, opt, ctx);
    }

    public PhyTableGroup create(String[] colNames, String distribute, String opt, Integer blockSize, Context ctx) throws IOException {
        int pcount = this._$2.length;
        IPhyTable[] tables = new PhyTable[pcount];
        boolean yopt = opt != null && opt.indexOf(121) != -1;
        boolean ropt = opt != null && opt.indexOf(114) != -1;
        for (int i = 0; i < pcount; ++i) {
            ComTable table;
            File file = Env.getPartitionFile(this._$2[i], this._$3);
            if (file.exists()) {
                if (yopt) {
                    try {
                        table = ComTable.open(file, ctx);
                        table.delete();
                    }
                    catch (IOException e) {
                        throw new RQException(e.getMessage(), e);
                    }
                } else {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("file.fileAlreadyExist", this._$3));
                }
            }
            table = ropt ? new RowComTable(file, colNames, distribute, opt, blockSize, ctx) : new ColComTable(file, colNames, distribute, opt, blockSize, ctx);
            table.setPartition(this._$2[i]);
            tables[i] = table.getBaseTable();
        }
        return new PhyTableGroup(this._$3, tables, this._$2, opt, ctx);
    }

    private ICursor _$1(PhyTableGroup tableGroup, boolean hasW, ICursor cursor, Context ctx) {
        ICursor cs;
        IPhyTable[] tables = tableGroup.getTables();
        int tableCount = tables.length;
        if (tableCount == 0) {
            return cursor;
        }
        ICursor[] cursors = cursor != null ? new ICursor[tableCount + 1] : new ICursor[tableCount];
        for (int i = 0; i < tableCount; ++i) {
            cursors[i] = tables[i].cursor();
        }
        DataStruct ds1 = cursors[0].getDataStruct();
        if (cursor != null) {
            cursors[tableCount] = cursor;
        }
        if (hasW) {
            int deleteField = tableGroup.getDeleteFieldIndex(null, ds1.getFieldNames());
            cursor = new UpdateIdCursor(cursor, ds1.getPKIndex(), deleteField);
            cs = new UpdateMergeCursor(cursors, ds1.getPKIndex(), deleteField, ctx);
        } else {
            cs = new MergeCursor(cursors, ds1.getPKIndex(), null, ctx);
        }
        return cs;
    }

    public boolean resetGroupTable(String opt, Integer blockSize, ICursor cursor, Context ctx) {
        if (cursor != null) {
            FileGroup tempFileGroup = this._$1(opt, blockSize, ctx);
            this.resetGroupTable(tempFileGroup, opt, null, blockSize, cursor, ctx);
            this.delete(ctx);
            tempFileGroup.rename(this._$3, ctx);
        } else {
            int pcount = this._$2.length;
            for (int i = 0; i < pcount; ++i) {
                File file = Env.getPartitionFile(this._$2[i], this._$3);
                PhyTable tmd = ComTable.openBaseTable(file, ctx);
                boolean result = tmd.getGroupTable().reset(null, opt, ctx, null, blockSize, null);
                tmd.close();
                if (result) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException("reset" + mm.getMessage("file.deleteFailed"));
            }
        }
        return true;
    }

    public boolean resetGroupTable(File newFile, String opt, Integer blockSize, ICursor cursor, Context ctx) {
        PhyTableGroup tableGroup = this.open(null, ctx);
        PhyTable baseTable = (PhyTable)tableGroup.getTables()[0];
        boolean isCol = baseTable.getGroupTable() instanceof ColComTable;
        boolean hasN = false;
        boolean hasW = false;
        boolean compress = false;
        boolean uncompress = false;
        if (opt != null) {
            if (opt.indexOf(113) != -1) {
                return this._$1(newFile, ctx);
            }
            if (opt.indexOf(114) != -1) {
                isCol = false;
            } else if (opt.indexOf(99) != -1) {
                isCol = true;
            }
            if (opt.indexOf(117) != -1) {
                uncompress = true;
            }
            if (opt.indexOf(122) != -1) {
                compress = true;
            }
            if (opt.indexOf(119) != -1) {
                hasW = true;
            }
            if (compress && uncompress) {
                tableGroup.close();
                MessageManager mm = EngineMessage.get();
                throw new RQException(opt + mm.getMessage("engine.optConflict"));
            }
            if (newFile == null) {
                tableGroup.close();
                MessageManager mm = EngineMessage.get();
                throw new RQException("reset" + mm.getMessage("function.invalidParam"));
            }
        }
        if ((opt == null || opt.indexOf(121) == -1) && newFile.exists()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("file.fileAlreadyExist", newFile.getName()));
        }
        if (opt != null && opt.indexOf(121) != -1 && newFile.exists()) {
            try {
                ComTable table = ComTable.open(newFile, ctx);
                table.delete();
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        String[] srcColNames = baseTable.getColNames();
        int len = srcColNames.length;
        String[] colNames = new String[len];
        if (baseTable instanceof ColPhyTable) {
            for (int i = 0; i < len; ++i) {
                ColumnMetaData col = ((ColPhyTable)baseTable).getColumn(srcColNames[i]);
                colNames[i] = col.isDim() ? "#" + srcColNames[i] : srcColNames[i];
            }
        } else {
            boolean[] isDim = ((RowPhyTable)baseTable).getDimIndex();
            for (int i = 0; i < len; ++i) {
                colNames[i] = isDim[i] ? "#" + srcColNames[i] : srcColNames[i];
            }
        }
        String newOpt = "";
        String segmentCol = baseTable.getSegmentCol();
        if (segmentCol != null) {
            newOpt = newOpt + "p";
        }
        if (baseTable.getGroupTable().hasDeleteKey()) {
            newOpt = newOpt + "d";
        }
        ComTable newGroupTable = null;
        try {
            boolean needSeg;
            if (isCol) {
                newGroupTable = new ColComTable(newFile, colNames, null, newOpt, blockSize, ctx);
                if (compress) {
                    newGroupTable.setCompress(true);
                } else if (uncompress) {
                    newGroupTable.setCompress(false);
                } else {
                    newGroupTable.setCompress(baseTable.getGroupTable().isCompress());
                }
            } else {
                newGroupTable = new RowComTable(newFile, colNames, null, newOpt, blockSize, ctx);
            }
            boolean bl = needSeg = baseTable.getSegmentCol() != null;
            if (needSeg) {
                newGroupTable.getBaseTable().setSegmentCol(baseTable.getSegmentCol(), baseTable.getSegmentSerialLen());
            }
            if (hasN) {
                newGroupTable.close();
                boolean bl2 = Boolean.TRUE;
                return bl2;
            }
            PhyTable newBaseTable = newGroupTable.getBaseTable();
            ICursor cs = cursor != null ? this._$1(tableGroup, hasW, cursor, ctx) : (hasW ? tableGroup.cursor(null, null, null, null, null, null, "w", ctx) : tableGroup.merge(ctx));
            newBaseTable.append(cs);
            newBaseTable.appendCache();
            ArrayList<PhyTable> tableList = baseTable.getTableList();
            for (PhyTable t : tableList) {
                int i;
                colNames = t.getColNames();
                len = colNames.length;
                if (t instanceof ColPhyTable) {
                    for (i = 0; i < len; ++i) {
                        ColumnMetaData col = ((ColPhyTable)t).getColumn(colNames[i]);
                        if (!col.isDim()) continue;
                        colNames[i] = "#" + colNames[i];
                    }
                } else {
                    for (i = 0; i < len; ++i) {
                        boolean[] isDim = ((RowPhyTable)t).getDimIndex();
                        if (!isDim[i]) continue;
                        colNames[i] = "#" + colNames[i];
                    }
                }
                PhyTable newTable = newBaseTable.createAnnexTable(colNames, t.getSerialBytesLen(), t.getTableName());
                cs = ((PhyTableGroup)tableGroup.getAnnexTable(t.getTableName())).merge(ctx);
                newTable.append(cs);
            }
        }
        catch (Exception e) {
            if (newGroupTable != null) {
                newGroupTable.close();
            }
            newFile.delete();
            throw new RQException(e.getMessage(), e);
        }
        finally {
            tableGroup.close();
        }
        newGroupTable.close();
        try {
            newGroupTable = ComTable.open(newFile, ctx);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        newGroupTable.getBaseTable().resetIndex(ctx);
        newGroupTable.getBaseTable().resetCuboid(ctx);
        ArrayList<PhyTable> newTableList = newGroupTable.getBaseTable().getTableList();
        for (PhyTable table : newTableList) {
            table.resetIndex(ctx);
            table.resetCuboid(ctx);
        }
        newGroupTable.close();
        return Boolean.TRUE;
    }

    public boolean resetGroupTable(FileGroup newFileGroup, String opt, String distribute, Integer blockSize, ICursor cursor, Context ctx) {
        if ((distribute == null || distribute.length() == 0) && cursor == null) {
            int pcount = this._$2.length;
            if (pcount != newFileGroup._$2.length) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("reset" + mm.getMessage("function.paramCountNotMatch"));
            }
            for (int i = 0; i < pcount; ++i) {
                File file = this.getPartitionFile(i);
                File newFile = newFileGroup.getPartitionFile(i);
                PhyTable tmd = ComTable.openBaseTable(file, ctx);
                boolean result = tmd.getGroupTable().reset(newFile, opt, ctx, null);
                tmd.close();
                if (result) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException("reset" + mm.getMessage("file.deleteFailed"));
            }
        } else {
            PhyTableGroup tableGroup = this.open(null, ctx);
            PhyTable baseTable = (PhyTable)tableGroup.getTables()[0];
            boolean isCol = baseTable.getGroupTable() instanceof ColComTable;
            boolean uncompress = false;
            boolean hasW = false;
            if (opt != null) {
                if (opt.indexOf(114) != -1) {
                    isCol = false;
                } else if (opt.indexOf(99) != -1) {
                    isCol = true;
                }
                if (opt.indexOf(117) != -1) {
                    uncompress = true;
                }
                if (opt.indexOf(122) != -1) {
                    uncompress = false;
                }
                if (opt.indexOf(119) != -1) {
                    hasW = true;
                }
            }
            String[] srcColNames = baseTable.getColNames();
            int len = srcColNames.length;
            String[] colNames = new String[len];
            if (baseTable instanceof ColPhyTable) {
                for (int i = 0; i < len; ++i) {
                    ColumnMetaData col = ((ColPhyTable)baseTable).getColumn(srcColNames[i]);
                    colNames[i] = col.isDim() ? "#" + srcColNames[i] : srcColNames[i];
                }
            } else {
                boolean[] isDim = ((RowPhyTable)baseTable).getDimIndex();
                for (int i = 0; i < len; ++i) {
                    colNames[i] = isDim[i] ? "#" + srcColNames[i] : srcColNames[i];
                }
            }
            String newOpt = "y";
            String segmentCol = baseTable.getSegmentCol();
            if (segmentCol != null) {
                newOpt = "p";
            }
            newOpt = isCol ? newOpt + 'c' : newOpt + 'r';
            if (uncompress) {
                newOpt = newOpt + 'u';
            }
            if (baseTable.getGroupTable().hasDeleteKey()) {
                newOpt = newOpt + "d";
            }
            try {
                PhyTableGroup newTableGroup = newFileGroup.create(colNames, distribute, newOpt, blockSize, ctx);
                ICursor cs = this._$1(tableGroup, hasW, cursor, ctx);
                newTableGroup.append(cs, "xi");
                ArrayList<PhyTable> tableList = baseTable.getTableList();
                for (PhyTable t : tableList) {
                    len = t.getColNames().length;
                    colNames = Arrays.copyOf(t.getColNames(), len);
                    if (t instanceof ColPhyTable) {
                        for (int i = 0; i < len; ++i) {
                            ColumnMetaData col = ((ColPhyTable)t).getColumn(colNames[i]);
                            if (!col.isDim()) continue;
                            colNames[i] = "#" + colNames[i];
                        }
                    } else {
                        boolean[] isDim = ((RowPhyTable)t).getDimIndex();
                        for (int i = 0; i < len; ++i) {
                            if (!isDim[i]) continue;
                            colNames[i] = "#" + colNames[i];
                        }
                    }
                    IPhyTable newTable = newTableGroup.createAnnexTable(colNames, t.getSerialBytesLen(), t.getTableName());
                    String[] allColNames = Arrays.copyOf(srcColNames, srcColNames.length + t.getColNames().length);
                    System.arraycopy(t.getColNames(), 0, allColNames, srcColNames.length, t.getColNames().length);
                    cs = tableGroup.getAnnexTable(t.getTableName()).cursor(allColNames);
                    newTable.append(cs, "xi");
                }
                tableGroup.close();
                newTableGroup.close();
                return Boolean.TRUE;
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        return true;
    }

    public File getPartitionFile(int index) {
        return Env.getPartitionFile(this._$2[index], this._$3);
    }

    public int getPartitionCount() {
        return this._$2.length;
    }

    public void delete(Context ctx) {
        int pcount = this._$2.length;
        for (int i = 0; i < pcount; ++i) {
            File file = Env.getPartitionFile(this._$2[i], this._$3);
            if (!file.exists()) continue;
            try {
                ComTable table = ComTable.open(file, ctx);
                table.delete();
                continue;
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    public boolean isExist() {
        int pcount = this._$2.length;
        for (int i = 0; i < pcount; ++i) {
            File file = Env.getPartitionFile(this._$2[i], this._$3);
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    public void rename(String newName, Context ctx) {
        int pcount = this._$2.length;
        for (int i = 0; i < pcount; ++i) {
            FileObject fo = new FileObject(this._$3);
            fo.setPartition(this._$2[i]);
            FileObject file = new FileObject(newName);
            file.setPartition(this._$2[i]);
            if (!fo.isExists() || file.isExists()) {
                throw new RuntimeException();
            }
            String path = file.getFileName();
            fo.move(path, null);
        }
    }

    private FileGroup _$1(String opt, Integer blockSize, Context ctx) {
        String name;
        boolean exist;
        FileObject fo = new FileObject(this._$3);
        int pcount = this._$2.length;
        do {
            FileObject newFileObj = new FileObject(fo.createTempFile());
            IFile f = newFileObj.getFile();
            exist = false;
            for (int i = 0; i < pcount; ++i) {
                newFileObj.setPartition(this._$2[i]);
                if (!newFileObj.isExists()) continue;
                exist = true;
                break;
            }
            name = newFileObj.getFileName();
            f.delete();
        } while (exist);
        String tempFileName = name;
        String option = opt == null ? "" : opt;
        option = option + "n";
        for (int i = 0; i < pcount; ++i) {
            File file = Env.getPartitionFile(this._$2[i], this._$3);
            File newFile = Env.getPartitionFile(this._$2[i], tempFileName);
            PhyTable tmd = ComTable.openBaseTable(file, ctx);
            boolean result = tmd.getGroupTable().reset(newFile, option, ctx, null, blockSize, null);
            tmd.close();
            if (result) continue;
            return null;
        }
        return new FileGroup(tempFileName, this._$2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _$1(File newFile, Context ctx) {
        int pcount = this._$2.length;
        if (newFile.exists()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("file.fileAlreadyExist", newFile.getName()));
        }
        File file = this.getPartitionFile(0);
        LocalFile.copyFile(file, newFile);
        if (pcount == 1) {
            return false;
        }
        PhyTable resultTable = ComTable.openBaseTable(newFile, ctx);
        PhyTable table = null;
        try {
            for (int i = 1; i < pcount; ++i) {
                File f = this.getPartitionFile(i);
                table = ComTable.openBaseTable(f, ctx);
                resultTable.append(table);
                table.close();
            }
        }
        catch (IOException e) {
            if (table != null) {
                table.close();
            }
            newFile.delete();
            boolean bl = false;
            return bl;
        }
        finally {
            resultTable.close();
        }
        return true;
    }
}

