/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.app.common.AppUtil;
import com.scudata.cellset.ICellSet;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.common.Escape;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BFileWriter;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.BlockInputStream;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.HttpFile;
import com.scudata.dm.IFile;
import com.scudata.dm.ILineInput;
import com.scudata.dm.ILineOutput;
import com.scudata.dm.IQueryable;
import com.scudata.dm.LineExporter;
import com.scudata.dm.LocalFile;
import com.scudata.dm.MemoryFile;
import com.scudata.dm.RandomOutputStream;
import com.scudata.dm.RemoteFile;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.BFileCursor;
import com.scudata.dm.cursor.FileCursor;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.query.SimpleSQL;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import com.scudata.util.CellSetUtil;
import com.scudata.util.Variant;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class FileObject
implements Externalizable,
IQueryable {
    public static final String TEMPFILE_PREFIX = "tmpdata";
    public static final int FILETYPE_TEXT = 0;
    public static final int FILETYPE_BINARY = 1;
    public static final int FILETYPE_GROUPTABLE = 2;
    public static final int FILETYPE_GROUPTABLE_ROW = 3;
    public static final int LOCK_SLEEP_TIME = 100;
    public static final byte[] LINE_SEPARATOR = System.getProperty("line.separator").getBytes();
    public static final byte[] DM_LINE_SEPARATOR = new byte[]{13, 10};
    public static final byte[] COL_SEPARATOR = new byte[]{9};
    private static final int _$11 = 999;
    public static final String S_FIELDNAME = "_1";
    private String _$10;
    private String _$9;
    private String _$8;
    private Integer _$7;
    private String _$6;
    private int _$5;
    private boolean _$4;
    private transient IFile _$3;
    private transient Context _$2;
    private transient boolean _$1 = false;

    public FileObject() {
    }

    public FileObject(FileObject fo) {
        this._$10 = fo._$10;
        this._$9 = fo._$9;
        this._$8 = fo._$8;
        this._$7 = fo._$7;
        this._$6 = fo._$6;
        this._$5 = fo._$5;
        this._$3 = fo._$3;
        this._$2 = fo._$2;
    }

    public FileObject(String name) {
        this(name, null);
    }

    public FileObject(String name, String opt, Context ctx) {
        this(name, null, opt, ctx);
    }

    public FileObject(String name, String ip, int port) {
        this(name, null);
        this._$6 = ip;
        this._$5 = port;
    }

    public FileObject(String name, String opt) {
        this(name, null, opt, null);
    }

    public FileObject(IFile file, String name, String cs, String opt) {
        this(name, cs, opt, null);
        this._$3 = file;
    }

    public FileObject(String name, String cs, String opt, Context ctx) {
        this._$2 = ctx;
        this.setOption(opt);
        this.setCharset(cs);
        String remotePrefix = "remote://";
        if (name.startsWith("remote://")) {
            int index2;
            int start = "remote://".length();
            int index = name.indexOf(58, start);
            if (index == -1) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("file.fileNotExist", name));
            }
            this._$6 = name.substring(start, index).trim();
            if ((index2 = name.indexOf(47, ++index)) == -1) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("file.fileNotExist", name));
            }
            String port = name.substring(index, index2).trim();
            this._$5 = Integer.parseInt(port);
            this._$10 = name.substring(index2 + 1);
        } else {
            this._$10 = name;
        }
    }

    public void setIsSimpleSQL(boolean b) {
        this._$4 = b;
    }

    public boolean getIsSimpleSQL() {
        return this._$4;
    }

    public void setRemoteFileWritable() {
        this._$1 = true;
    }

    public void setContext(Context ctx) {
        this._$2 = ctx;
    }

    public String getOption() {
        return this._$8;
    }

    public void setOption(String opt) {
        this._$8 = opt;
    }

    public void setCharset(String cs) {
        this._$9 = cs == null || cs.length() == 0 ? Env.getDefaultCharsetName() : cs;
    }

    public void setPartition(Integer p) {
        this._$7 = p;
        this._$3 = null;
    }

    public Integer getPartition() {
        return this._$7;
    }

    public void setIP(String ip) {
        this._$6 = ip;
    }

    public String getIP() {
        return this._$6;
    }

    public void setPort(int port) {
        this._$5 = port;
    }

    public int getPort() {
        return this._$5;
    }

    public String getFileName() {
        return this._$10;
    }

    public void setFileName(String name) {
        this._$10 = name;
    }

    public String getCharset() {
        return this._$9;
    }

    public String toString() {
        return this._$10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence importSeries(String opt) throws IOException {
        ICursor cursor = opt != null && opt.indexOf(98) != -1 ? new BFileCursor(this, null, opt, null) : new FileCursor(this, 0, -1, null, opt, null);
        try {
            Sequence sequence = cursor.fetch();
            return sequence;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence importSeries(int segSeq, int segCount, String[] fields, byte[] types, Object s, String opt) throws IOException {
        ICursor cursor;
        if (opt != null && opt.indexOf(98) != -1) {
            cursor = new BFileCursor(this, fields, segSeq, segCount, opt, null);
        } else {
            String sep;
            if (s instanceof String) {
                sep = (String)s;
            } else if (s == null) {
                sep = null;
            } else {
                MessageManager mm = EngineMessage.get();
                throw new RQException("import" + mm.getMessage("function.paramTypeError"));
            }
            cursor = new FileCursor(this, segSeq, segCount, fields, types, sep, opt, null);
        }
        try {
            Sequence sequence = cursor.fetch();
            return sequence;
        }
        finally {
            cursor.close();
        }
    }

    public static Table import_x(ILineInput importer, String opt) throws IOException {
        int f;
        Table table;
        Object[] line = importer.readLine();
        if (line == null) {
            return null;
        }
        int fcount = line.length;
        if (fcount == 0) {
            return null;
        }
        if (opt != null && opt.indexOf(116) != -1) {
            String[] items = new String[fcount];
            for (int f2 = 0; f2 < fcount; ++f2) {
                items[f2] = Variant.toString(line[f2]);
            }
            table = new Table(items);
        } else {
            String[] items = new String[fcount];
            table = new Table(items);
            BaseRecord r = table.newLast();
            for (f = 0; f < fcount; ++f) {
                r.setNormalFieldValue(f, line[f]);
            }
        }
        while ((line = importer.readLine()) != null) {
            int curLen = line.length;
            if (curLen > fcount) {
                curLen = fcount;
            }
            BaseRecord r = table.newLast();
            for (f = 0; f < curLen; ++f) {
                r.setNormalFieldValue(f, line[f]);
            }
        }
        table.trimToSize();
        return table;
    }

    public static int getMaxMemberCount(Sequence seq) {
        int len = seq.length();
        int maxCount = -1;
        for (int i = 1; i <= len; ++i) {
            Object obj = seq.getMem(i);
            if (obj instanceof Sequence) {
                int count = ((Sequence)obj).length();
                if (maxCount >= count) continue;
                maxCount = count;
                continue;
            }
            if (obj == null) continue;
            return -1;
        }
        return maxCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void export_x(ILineOutput exporter, Sequence series, Expression[] exps, String[] names, boolean bTitle, Context ctx) throws IOException {
        if (exps == null) {
            int fcount = 1;
            DataStruct ds = series.dataStruct();
            if (ds == null) {
                int len = series.length();
                fcount = FileObject.getMaxMemberCount(series);
                if (fcount < 1) {
                    if (bTitle && len > 0) {
                        exporter.writeLine(new String[]{S_FIELDNAME});
                    }
                    Object[] lineObjs = new Object[1];
                    for (int i = 1; i <= len; ++i) {
                        lineObjs[0] = series.getMem(i);
                        exporter.writeLine(lineObjs);
                    }
                } else {
                    Object[] lineObjs = new Object[fcount];
                    for (int i = 1; i <= len; ++i) {
                        int f;
                        Sequence seq = (Sequence)series.getMem(i);
                        if (seq == null) {
                            for (f = 0; f < fcount; ++f) {
                                lineObjs[f] = null;
                            }
                        } else {
                            seq.toArray(lineObjs);
                            for (f = seq.length(); f < fcount; ++f) {
                                lineObjs[f] = null;
                            }
                        }
                        exporter.writeLine(lineObjs);
                    }
                }
            } else {
                fcount = ds.getFieldCount();
                if (bTitle) {
                    exporter.writeLine(ds.getFieldNames());
                }
                Object[] lineObjs = new Object[fcount];
                int len = series.length();
                for (int i = 1; i <= len; ++i) {
                    BaseRecord r = (BaseRecord)series.getMem(i);
                    Object[] vals = r.getFieldValues();
                    for (int f = 0; f < fcount; ++f) {
                        lineObjs[f] = vals[f] instanceof BaseRecord ? ((BaseRecord)vals[f]).value() : vals[f];
                    }
                    exporter.writeLine(lineObjs);
                }
            }
        } else {
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(series);
            stack.push(current);
            try {
                int fcount = exps.length;
                if (bTitle) {
                    if (names == null) {
                        names = new String[fcount];
                    }
                    series.getNewFieldNames(exps, names, "export");
                    exporter.writeLine(names);
                }
                Object[] lineObjs = new Object[fcount];
                int len = series.length();
                for (int i = 1; i <= len; ++i) {
                    current.setCurrent(i);
                    for (int f = 0; f < fcount; ++f) {
                        lineObjs[f] = exps[f].calculate(ctx);
                        if (!(lineObjs[f] instanceof BaseRecord)) continue;
                        lineObjs[f] = ((BaseRecord)lineObjs[f]).value();
                    }
                    exporter.writeLine(lineObjs);
                }
            }
            finally {
                stack.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void export_x(ILineOutput exporter, ICursor cursor, Expression[] exps, String[] names, boolean bTitle, Context ctx) throws IOException {
        Sequence table = cursor.fetch(999);
        if (table == null || table.length() == 0) {
            return;
        }
        if (exps == null) {
            int fcount = 1;
            DataStruct ds = table.dataStruct();
            if (ds == null) {
                if (bTitle) {
                    exporter.writeLine(new String[]{S_FIELDNAME});
                }
            } else {
                fcount = ds.getFieldCount();
                if (bTitle) {
                    exporter.writeLine(ds.getFieldNames());
                }
            }
            Object[] lineObjs = new Object[fcount];
            do {
                int i;
                int len;
                if (ds == null) {
                    len = table.length();
                    for (i = 1; i <= len; ++i) {
                        lineObjs[0] = table.getMem(i);
                        exporter.writeLine(lineObjs);
                    }
                } else {
                    len = table.length();
                    for (i = 1; i <= len; ++i) {
                        BaseRecord r = (BaseRecord)table.getMem(i);
                        Object[] vals = r.getFieldValues();
                        for (int f = 0; f < fcount; ++f) {
                            lineObjs[f] = vals[f] instanceof BaseRecord ? ((BaseRecord)vals[f]).value() : vals[f];
                        }
                        exporter.writeLine(lineObjs);
                    }
                }
            } while ((table = cursor.fetch(999)) != null && table.length() != 0);
        } else {
            int fcount = exps.length;
            Object[] lineObjs = new Object[fcount];
            if (bTitle) {
                if (names == null) {
                    names = new String[fcount];
                }
                table.getNewFieldNames(exps, names, "export");
                exporter.writeLine(names);
            }
            ComputeStack stack = ctx.getComputeStack();
            do {
                Current current = new Current(table);
                stack.push(current);
                try {
                    int len = table.length();
                    for (int i = 1; i <= len; ++i) {
                        current.setCurrent(i);
                        for (int f = 0; f < fcount; ++f) {
                            lineObjs[f] = exps[f].calculate(ctx);
                            if (!(lineObjs[f] instanceof BaseRecord)) continue;
                            lineObjs[f] = ((BaseRecord)lineObjs[f]).value();
                        }
                        exporter.writeLine(lineObjs);
                    }
                }
                finally {
                    stack.pop();
                }
            } while ((table = cursor.fetch(999)) != null && table.length() != 0);
        }
    }

    public void exportSeries(Sequence series, String opt, Object s) {
        this.exportSeries(series, null, null, opt, s, null);
    }

    public void exportSeries(Sequence series, Expression[] exps, String[] names, String opt, Object s, Context ctx) {
        OutputStream os;
        if (BFileWriter.isBtxOption(opt)) {
            if (opt.indexOf(119) != -1) {
                series = series.toTable();
            }
            BFileWriter writer = new BFileWriter(this, opt);
            writer.export(series, exps, names, ctx);
            return;
        }
        boolean isTitle = false;
        boolean isCsv = false;
        boolean isAppend = false;
        boolean isQuote = false;
        boolean isQuoteEscape = false;
        byte[] LINE_SEPARATOR = FileObject.LINE_SEPARATOR;
        if (opt != null) {
            if (opt.indexOf(116) != -1) {
                isTitle = true;
            }
            if (opt.indexOf(99) != -1) {
                isCsv = true;
            }
            if (opt.indexOf(97) != -1) {
                isAppend = true;
            }
            if (opt.indexOf(113) != -1) {
                isQuote = true;
            }
            if (opt.indexOf(111) != -1) {
                isQuote = true;
                isQuoteEscape = true;
            }
            if (opt.indexOf(119) != -1) {
                LINE_SEPARATOR = DM_LINE_SEPARATOR;
            }
        }
        if (series == null) {
            if (!isAppend) {
                this.delete();
            }
            return;
        }
        if (isAppend) {
            os = this.getBufferedOutputStream(true);
            if (this.size() > 0L) {
                isTitle = false;
            } else {
                isAppend = false;
            }
        } else {
            isAppend = false;
            os = this.getBufferedOutputStream(false);
        }
        try {
            byte[] colSeparator = COL_SEPARATOR;
            if (isCsv) {
                colSeparator = new byte[]{44};
            }
            if (s instanceof String) {
                String str = (String)s;
                colSeparator = str.getBytes(this._$9);
            } else if (s != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("import" + mm.getMessage("function.paramTypeError"));
            }
            LineExporter exporter = new LineExporter(os, this._$9, colSeparator, LINE_SEPARATOR, isAppend);
            exporter.setQuote(isQuote);
            if (isQuoteEscape) {
                exporter.setEscapeChar('\"');
            }
            FileObject.export_x((ILineOutput)exporter, series, exps, names, isTitle, ctx);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    public void exportCursor(ICursor cursor, Expression[] exps, String[] names, String opt, Object s, Context ctx) {
        OutputStream os;
        if (BFileWriter.isBtxOption(opt)) {
            BFileWriter writer = new BFileWriter(this, opt);
            writer.export(cursor, exps, names, ctx);
            return;
        }
        boolean isTitle = false;
        boolean isCsv = false;
        boolean isAppend = false;
        boolean isQuote = false;
        boolean isQuoteEscape = false;
        byte[] LINE_SEPARATOR = FileObject.LINE_SEPARATOR;
        if (opt != null) {
            if (opt.indexOf(116) != -1) {
                isTitle = true;
            }
            if (opt.indexOf(99) != -1) {
                isCsv = true;
            }
            if (opt.indexOf(97) != -1) {
                isAppend = true;
            }
            if (opt.indexOf(113) != -1) {
                isQuote = true;
            }
            if (opt.indexOf(111) != -1) {
                isQuote = true;
                isQuoteEscape = true;
            }
            if (opt.indexOf(119) != -1) {
                LINE_SEPARATOR = DM_LINE_SEPARATOR;
            }
        }
        if (cursor == null) {
            if (!isAppend) {
                this.delete();
            }
            return;
        }
        if (isAppend && this.size() > 0L) {
            os = this.getBufferedOutputStream(true);
            if (this.size() > 0L) {
                isTitle = false;
            } else {
                isAppend = false;
            }
        } else {
            isAppend = false;
            os = this.getBufferedOutputStream(false);
        }
        try {
            byte[] colSeparator = COL_SEPARATOR;
            if (isCsv) {
                colSeparator = new byte[]{44};
            }
            if (s instanceof String) {
                String str = (String)s;
                colSeparator = str.getBytes(this._$9);
            } else if (s != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("import" + mm.getMessage("function.paramTypeError"));
            }
            LineExporter exporter = new LineExporter(os, this._$9, colSeparator, LINE_SEPARATOR, isAppend);
            exporter.setQuote(isQuote);
            if (isQuoteEscape) {
                exporter.setEscapeChar('\"');
            }
            FileObject.export_x((ILineOutput)exporter, cursor, exps, names, isTitle, ctx);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    public void export_g(ICursor cursor, Expression[] exps, String[] names, Expression gexp, String opt, Context ctx) {
        BFileWriter writer = new BFileWriter(this, opt);
        writer.export(cursor, exps, names, gexp, ctx);
    }

    private static Object _$2(InputStream in, long start, long end) throws IOException {
        byte[] buf = new byte[Env.FILE_BUFSIZE];
        if (start != 0L) {
            long total;
            long cur = 0L;
            for (total = 0L; total < start && (cur = in.skip(start - total)) > 0L; total += cur) {
            }
            if (total < start) {
                return null;
            }
        }
        long size = 0L;
        if (end > 0L) {
            int cur;
            while ((cur = in.read(buf)) != -1 && (size += (long)cur) + start < end) {
            }
        } else {
            int cur;
            while ((cur = in.read(buf)) != -1) {
                size += (long)cur;
            }
        }
        return new Long(size);
    }

    private static byte[] _$1(InputStream in, long start, long end) throws IOException {
        if (start != 0L) {
            long total;
            long cur = 0L;
            for (total = 0L; total < start && (cur = in.skip(start - total)) > 0L; total += cur) {
            }
            if (total < start) {
                return null;
            }
        }
        if (end > 0L) {
            int rest;
            int cur;
            int count = (int)(end - start + 1L);
            ByteArrayOutputStream out = new ByteArrayOutputStream(count);
            byte[] buf = new byte[4096];
            for (int total = 0; total < count && (cur = in.read(buf, 0, (rest = count - total) < 4096 ? rest : 4096)) != -1; total += cur) {
                out.write(buf, 0, cur);
            }
            return out.toByteArray();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        int count = 0;
        byte[] buf = new byte[4096];
        while ((count = in.read(buf)) != -1) {
            out.write(buf, 0, count);
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(long start, long end, String opt) throws IOException {
        if (end > 0L && end < start) {
            return null;
        }
        boolean isMultiLine = false;
        boolean isBinary = false;
        boolean isValue = false;
        boolean isTest = false;
        if (opt != null) {
            if (opt.indexOf(110) != -1) {
                isMultiLine = true;
            }
            if (opt.indexOf(98) != -1) {
                isBinary = true;
            }
            if (opt.indexOf(118) != -1) {
                isValue = true;
            }
            if (opt.indexOf(48) != -1) {
                isTest = true;
            }
        }
        InputStream in = this.getInputStream();
        try {
            String str;
            if (isTest) {
                Object object = FileObject._$2(in, start, end);
                return object;
            }
            if (isBinary) {
                byte[] byArray = FileObject._$1(in, start, end);
                return byArray;
            }
            if (isMultiLine) {
                String str2;
                InputStreamReader isr = new InputStreamReader(in, this._$9);
                BufferedReader br = new BufferedReader(isr);
                Sequence retSeries = new Sequence();
                while ((str2 = br.readLine()) != null) {
                    if (isValue) {
                        retSeries.add(Variant.parse(str2, false));
                        continue;
                    }
                    retSeries.add(str2);
                }
                retSeries.trimToSize();
                Sequence sequence = retSeries;
                return sequence;
            }
            byte[] bts = FileObject._$1(in, start, end);
            if (bts == null) {
                Object br = null;
                return br;
            }
            if (start == 0L && bts.length > 3 && bts[0] == -17 && bts[1] == -69 && bts[2] == -65) {
                this._$9 = "UTF-8";
                str = new String(bts, 3, bts.length - 3, this._$9);
            } else {
                str = new String(bts, this._$9);
            }
            if (isValue) {
                Object object = Variant.parse(str, false);
                return object;
            }
            String string = str;
            return string;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object obj, String opt) throws IOException {
        boolean isAppend = false;
        boolean isBinary = false;
        byte[] LINE_SEPARATOR = FileObject.LINE_SEPARATOR;
        if (opt != null) {
            if (opt.indexOf(97) != -1) {
                isAppend = true;
            }
            if (opt.indexOf(98) != -1) {
                isBinary = true;
            }
            if (opt.indexOf(119) != -1) {
                LINE_SEPARATOR = DM_LINE_SEPARATOR;
            }
        }
        OutputStream os = this.getBufferedOutputStream(isAppend);
        try {
            if (isBinary) {
                if (obj instanceof byte[]) {
                    os.write((byte[])obj);
                } else {
                    String str = Variant.toString(obj);
                    if (str != null) {
                        os.write(str.getBytes(this._$9));
                    }
                }
            } else {
                if (isAppend && this.size() > 0L) {
                    os.write(LINE_SEPARATOR);
                }
                if (obj instanceof Sequence) {
                    Object mem;
                    String str;
                    Sequence series = (Sequence)obj;
                    int len = series.length();
                    if (len > 0 && (str = Variant.toString(mem = series.getMem(1))) != null) {
                        os.write(str.getBytes(this._$9));
                    }
                    for (int i = 2; i <= len; ++i) {
                        os.write(LINE_SEPARATOR);
                        Object mem2 = series.getMem(i);
                        String str2 = Variant.toString(mem2);
                        if (str2 == null) continue;
                        os.write(str2.getBytes(this._$9));
                    }
                } else {
                    String str = Variant.toString(obj);
                    if (str != null) {
                        os.write(str.getBytes(this._$9));
                    }
                }
            }
        }
        finally {
            os.close();
        }
    }

    public InputStream getInputStream() {
        return this.getFile().getInputStream();
    }

    public BlockInputStream getBlockInputStream() {
        return this.getBlockInputStream(Env.FILE_BUFSIZE);
    }

    public BlockInputStream getBlockInputStream(int bufSize) {
        InputStream is = this.getInputStream();
        return new BlockInputStream(is, bufSize);
    }

    public OutputStream getOutputStream(boolean isAppend) {
        OutputStream os = this.getFile().getOutputStream(isAppend);
        if (os instanceof FileOutputStream) {
            FileOutputStream fos = (FileOutputStream)os;
            FileLock lock = null;
            if (this._$8 == null || this._$8.indexOf(97) == -1) {
                try {
                    lock = fos.getChannel().tryLock();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (lock == null) {
                    throw new RQException("\u53e6\u4e00\u4e2a\u7a0b\u5e8f\u5df2\u9501\u5b9a\u6587\u4ef6\u7684\u4e00\u90e8\u5206\uff0c\u8fdb\u7a0b\u65e0\u6cd5\u8bbf\u95ee");
                }
            } else {
                FileChannel channel = fos.getChannel();
                while (true) {
                    try {
                        channel.lock();
                    }
                    catch (OverlappingFileLockException e) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ie) {}
                        continue;
                    }
                    catch (Exception e) {
                        throw new RQException(e.getMessage(), e);
                    }
                    break;
                }
            }
        }
        return os;
    }

    public OutputStream getBufferedOutputStream(boolean isAppend) {
        OutputStream os = this.getOutputStream(isAppend);
        return new BufferedOutputStream(os, Env.FILE_BUFSIZE);
    }

    public RandomOutputStream getRandomOutputStream(boolean isAppend) {
        RandomOutputStream os = this.getFile().getRandomOutputStream(isAppend);
        boolean lock = false;
        try {
            lock = this._$8 == null || this._$8.indexOf(97) == -1 ? os.tryLock() : os.lock();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!lock) {
            try {
                os.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new RQException("\u53e6\u4e00\u4e2a\u7a0b\u5e8f\u5df2\u9501\u5b9a\u6587\u4ef6\u7684\u4e00\u90e8\u5206\uff0c\u8fdb\u7a0b\u65e0\u6cd5\u8bbf\u95ee");
        }
        return os;
    }

    public LocalFile getLocalFile() {
        if (this._$7 == null) {
            return new LocalFile(this._$10, this._$8, this._$2);
        }
        return new LocalFile(this._$10, this._$8, this._$7);
    }

    public IFile getFile() {
        if (this._$3 != null) {
            return this._$3;
        }
        if (this._$6 == null) {
            this._$3 = this._$7 == null ? new LocalFile(this._$10, this._$8, this._$2) : new LocalFile(this._$10, this._$8, this._$7);
        } else {
            String pathFile = this._$10;
            RemoteFile rf = new RemoteFile(this._$6, this._$5, pathFile, this._$7);
            rf.setOpt(this._$8);
            if (this._$1) {
                rf.setWritable();
            }
            this._$3 = rf;
        }
        if (this._$8 != null && this._$8.indexOf(105) != -1) {
            this._$3 = new MemoryFile(this._$3);
        }
        return this._$3;
    }

    public boolean isRemoteFile() {
        return this._$6 != null;
    }

    public boolean isExists() {
        return this.getFile().exists();
    }

    public long size() {
        return this.getFile().size();
    }

    public Timestamp lastModified() {
        long date = this.getFile().lastModified();
        if (date > 0L) {
            return new Timestamp(date);
        }
        return null;
    }

    public boolean delete() {
        return this.getFile().delete();
    }

    public boolean deleteDir() {
        return this.getFile().deleteDir();
    }

    public boolean move(String dest, String opt) {
        return this.getFile().move(dest, opt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String key, String opt) throws IOException {
        boolean isValue;
        boolean bl = isValue = opt != null && opt.indexOf(118) != -1;
        if (this._$3 instanceof HttpFile) {
            String str = ((HttpFile)this._$3).getResponseHeader(key);
            if (isValue) {
                return Variant.parse(str);
            }
            return str;
        }
        InputStream in = this.getInputStream();
        try {
            Properties properties = new Properties();
            properties.load(new InputStreamReader(in, this._$9));
            String str = properties.getProperty(key);
            if (isValue) {
                Object object = Variant.parse(str);
                return object;
            }
            String string = str;
            return string;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getProperties(String opt) throws IOException {
        InputStream in = null;
        try {
            in = this.getInputStream();
            Properties properties = new Properties();
            properties.load(new InputStreamReader(in, this._$9));
            Table table = FileObject.getProperties(properties, opt);
            return table;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static Table getProperties(Properties properties, String opt) {
        boolean isValue = opt != null && opt.indexOf(118) != -1;
        boolean isQuote = opt != null && opt.indexOf(113) != -1;
        Table table = new Table(new String[]{"name", "value"});
        Iterator<Map.Entry<Object, Object>> itr = properties.entrySet().iterator();
        if (isValue || isQuote) {
            while (itr.hasNext()) {
                Map.Entry<Object, Object> entry = itr.next();
                BaseRecord r = table.newLast();
                r.setNormalFieldValue(0, entry.getKey());
                Object v = entry.getValue();
                if (v instanceof String) {
                    v = isValue ? Variant.parse((String)v) : Escape.addEscAndQuote((String)v);
                }
                r.setNormalFieldValue(1, v);
            }
        } else {
            while (itr.hasNext()) {
                Map.Entry<Object, Object> entry = itr.next();
                BaseRecord r = table.newLast();
                r.setNormalFieldValue(0, entry.getKey());
                r.setNormalFieldValue(1, entry.getValue());
            }
        }
        return table;
    }

    public String createTempFile(String prefix) {
        return this.getFile().createTempFile(prefix);
    }

    public String createTempFile() {
        return this.getFile().createTempFile(TEMPFILE_PREFIX);
    }

    public static FileObject createTempFileObject() {
        String path = Env.getTempPath();
        if (path != null && path.length() > 0) {
            FileObject fo = new FileObject(path);
            return new FileObject(fo.createTempFile(TEMPFILE_PREFIX));
        }
        try {
            File tmpFile = File.createTempFile(TEMPFILE_PREFIX, "");
            return new FileObject(tmpFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    public PgmCellSet readPgmCellSet() {
        InputStream is = this.getInputStream();
        try {
            is = new BufferedInputStream(is);
            PgmCellSet pcs = this._$10.toLowerCase().endsWith(".spl") ? AppUtil.readSPL(is) : CellSetUtil.readPgmCellSet(is);
            File file = new File(this._$10);
            pcs.setName(file.getPath());
            PgmCellSet pgmCellSet = pcs;
            return pgmCellSet;
        }
        catch (Exception e) {
            if (e instanceof RQException) {
                throw (RQException)e;
            }
            throw new RQException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this._$10);
        out.writeObject(this._$9);
        out.writeObject(this._$8);
        out.writeObject(this._$7);
        out.writeObject(this._$6);
        out.writeInt(this._$5);
        out.writeBoolean(this._$4);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this._$10 = (String)in.readObject();
        this._$9 = (String)in.readObject();
        this._$8 = (String)in.readObject();
        this._$7 = (Integer)in.readObject();
        this._$6 = (String)in.readObject();
        this._$5 = in.readInt();
        this._$4 = in.readBoolean();
    }

    public void setFileSize(long size) {
        IFile file = this.getFile();
        if (file instanceof LocalFile) {
            ((LocalFile)file).setFileSize(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileType() {
        block24: {
            int n;
            InputStream is = null;
            try {
                is = this.getFile().getInputStream();
                if (is.read() != 114 || is.read() != 113) break block24;
                int b = is.read();
                if (b == 100) {
                    if (is.read() == 119 && is.read() == 103 && is.read() == 116) {
                        b = is.read();
                        if (b == 99) {
                            int n2 = 2;
                            return n2;
                        }
                        if (b == 114) {
                            int n3 = 3;
                            return n3;
                        }
                    }
                    break block24;
                }
                if (b != 116 || is.read() != 98 || is.read() != 120) break block24;
                n = 1;
            }
            catch (Exception e) {
                break block24;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
            return n;
        }
        return 0;
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.getFile().getRandomAccessFile();
    }

    public static FileObject createSimpleQuery() {
        FileObject fo = new FileObject();
        fo.setIsSimpleSQL(true);
        return fo;
    }

    public Object query(String sql, Object[] params, ICellSet cs, Context ctx) {
        SimpleSQL lq;
        Object val;
        ArrayList<Object> list = null;
        if (params != null) {
            list = new ArrayList<Object>(params.length);
            for (Object obj : params) {
                list.add(obj);
            }
        }
        if ((val = (lq = new SimpleSQL(cs, sql, list, ctx)).execute()) instanceof ICursor) {
            return ((ICursor)val).fetch();
        }
        return val;
    }
}

