/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.common.RQException;
import com.scudata.dm.ChannelInputStream;
import com.scudata.dm.ObjectReader;
import com.scudata.dm.RandomOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;

public class FileRandomOutputStream
extends RandomOutputStream {
    private RandomAccessFile _$2;
    private FileChannel _$1;

    public FileRandomOutputStream(RandomAccessFile file) {
        this._$2 = file;
    }

    public FileChannel getChannel() {
        if (this._$1 == null) {
            this._$1 = this._$2.getChannel();
        }
        return this._$1;
    }

    public InputStream getInputStream(long pos) throws IOException {
        FileChannel channel = this.getChannel();
        channel.position(pos);
        return new ObjectReader(new ChannelInputStream(channel));
    }

    public boolean tryLock() throws IOException {
        return this.getChannel().tryLock() != null;
    }

    /*
     * Loose catch block
     */
    public boolean lock() throws IOException {
        FileChannel channel = this.getChannel();
        while (true) {
            try {
                channel.lock();
                return true;
            }
            catch (OverlappingFileLockException e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    public void position(long newPosition) throws IOException {
        this._$2.seek(newPosition);
    }

    public long position() throws IOException {
        return this._$2.getFilePointer();
    }

    public void write(int b) throws IOException {
        this._$2.write(b);
    }

    public void write(byte[] b) throws IOException {
        this._$2.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this._$2.write(b, off, len);
    }

    public void close() throws IOException {
        this._$2.close();
    }
}

