/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.Expression;
import com.scudata.expression.Gather;
import com.scudata.resources.EngineMessage;
import com.scudata.util.HashUtil;
import com.scudata.util.Variant;
import java.util.ArrayList;

class HashPrimaryJoin {
    private Sequence srcSequence;
    private Expression[] srcKeyExps;
    private Expression[] srcNewExps;
    private String[] srcNewNames;
    private Sequence[] sequences;
    private String[] options;
    private Expression[][] keyExps;
    private Expression[][] newExps;
    private String[][] newNames;
    private String opt;
    private Context ctx;
    private HashUtil hashUtil;
    private PrimaryJoinNode[] hashTable;
    private int tableCount;
    private int srcRefCount;
    private DataStruct resultDs;
    private int[] newSeqs;
    private int[] keySeqs;

    public HashPrimaryJoin(Sequence srcSequence, Expression[] srcKeyExps, Expression[] srcNewExps, String[] srcNewNames, Sequence[] sequences, String[] options, Expression[][] keyExps, Expression[][] newExps, String[][] newNames, String opt, Context ctx) {
        this.srcSequence = srcSequence;
        this.srcKeyExps = srcKeyExps;
        this.srcNewExps = srcNewExps;
        this.srcNewNames = srcNewNames;
        this.sequences = sequences;
        this.options = options;
        this.keyExps = keyExps;
        this.newExps = newExps;
        this.newNames = newNames;
        this.opt = opt;
        this.ctx = ctx;
        this.tableCount = sequences.length;
    }

    private void init() {
        int n;
        int keyCount = this.srcKeyExps.length;
        this.keySeqs = new int[keyCount];
        ArrayList<String> fieldList = new ArrayList<String>();
        DataStruct srcDs = null;
        if (this.srcNewExps == null || this.srcNewExps.length == 0) {
            srcDs = this.srcSequence.dataStruct();
            if (srcDs == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needPurePmt"));
            }
            String[] names = srcDs.getFieldNames();
            this.srcRefCount = names.length;
            String[] stringArray = names;
            n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                fieldList.add(name);
                ++n2;
            }
            int k = 0;
            while (k < keyCount) {
                this.keySeqs[k] = this.srcKeyExps[k].getFieldIndex(srcDs);
                ++k;
            }
        } else {
            int fcount = this.srcRefCount = this.srcNewExps.length;
            String[] oldFieldNames = new String[fcount];
            int i = 0;
            while (i < fcount) {
                oldFieldNames[i] = this.srcNewExps[i].getFieldName();
                ++i;
            }
            int k = 0;
            while (k < keyCount) {
                this.keySeqs[k] = -1;
                String keyName = this.srcKeyExps[k].getFieldName();
                int i2 = 0;
                while (i2 < fcount) {
                    if (keyName.equals(oldFieldNames[i2])) {
                        this.keySeqs[k] = i2;
                        break;
                    }
                    ++i2;
                }
                ++k;
            }
            i = 0;
            while (i < fcount) {
                if (this.srcNewNames != null && this.srcNewNames[i] != null) {
                    fieldList.add(this.srcNewNames[i]);
                } else {
                    fieldList.add(oldFieldNames[i]);
                }
                ++i;
            }
        }
        this.newSeqs = new int[this.tableCount];
        int t = 0;
        while (t < this.tableCount) {
            Expression[] curNewExps = this.newExps[t];
            this.newSeqs[t] = fieldList.size();
            if (curNewExps != null) {
                String[] curNewNames = this.newNames[t];
                int count = curNewExps.length;
                int i = 0;
                while (i < count) {
                    if (curNewNames != null && curNewNames[i] != null) {
                        fieldList.add(curNewNames[i]);
                    } else {
                        fieldList.add(curNewExps[i].getFieldName());
                    }
                    ++i;
                }
            }
            ++t;
        }
        int fcount = fieldList.size();
        if (srcDs == null || srcDs.getFieldCount() != fcount) {
            String[] fnames = new String[fcount];
            fieldList.toArray(fnames);
            this.resultDs = new DataStruct(fnames);
        } else {
            this.resultDs = srcDs;
        }
        int capacity = this.srcSequence.length();
        Sequence[] sequenceArray = this.sequences;
        int n3 = this.sequences.length;
        n = 0;
        while (n < n3) {
            Sequence sequence = sequenceArray[n];
            if (sequence != null && sequence.length() > capacity) {
                capacity = sequence.length();
            }
            ++n;
        }
        this.hashUtil = new HashUtil(capacity);
        this.hashTable = new PrimaryJoinNode[this.hashUtil.getCapacity()];
        int t2 = 0;
        while (t2 < this.tableCount) {
            this.addTable(this.sequences[t2], this.keyExps[t2], this.newExps[t2], t2, this.ctx);
            ++t2;
        }
    }

    private void addTable(Sequence sequence, Expression[] keyExps, Expression[] newExps, int tableSeq, Context ctx) {
        block26: {
            if (sequence == null || sequence.length() == 0) {
                return;
            }
            HashUtil hashUtil = this.hashUtil;
            PrimaryJoinNode[] hashTable = this.hashTable;
            int tableCount = this.tableCount;
            int keyCount = keyExps.length;
            if (newExps != null && newExps.length > 0) {
                int newCount = newExps.length;
                Expression[] expressionArray = newExps;
                int n = newExps.length;
                int n2 = 0;
                while (n2 < n) {
                    Expression exp = expressionArray[n2];
                    if (exp.getHome() instanceof Gather) {
                        sequence = sequence.groups(keyExps, null, newExps, null, null, ctx);
                        int q = 1;
                        keyExps = new Expression[keyCount];
                        int i = 0;
                        while (i < keyCount) {
                            keyExps[i] = new Expression("#" + q);
                            ++i;
                            ++q;
                        }
                        newExps = new Expression[newCount];
                        i = 0;
                        while (i < newCount) {
                            newExps[i] = new Expression("#" + q);
                            ++i;
                            ++q;
                        }
                        break;
                    }
                    ++n2;
                }
            }
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(sequence);
            stack.push(current);
            try {
                if (newExps == null || newExps.length == 0) {
                    int len = sequence.length();
                    Object[] newValues = new Object[]{};
                    int i = 1;
                    while (i <= len) {
                        block25: {
                            current.setCurrent(i);
                            Object[] keys = new Object[keyCount];
                            int c = 0;
                            while (c < keyCount) {
                                keys[c] = keyExps[c].calculate(ctx);
                                ++c;
                            }
                            int hash = hashUtil.hashCode(keys, keyCount);
                            PrimaryJoinNode entry = hashTable[hash];
                            while (entry != null) {
                                if (Variant.compareArrays(entry.keyValues, keys, keyCount) == 0) {
                                    if (entry.newValues[tableSeq] != null) {
                                        MessageManager mm = EngineMessage.get();
                                        String str = "[";
                                        int k = 0;
                                        while (k < keyCount) {
                                            if (k != 0) {
                                                str = String.valueOf(str) + ",";
                                            }
                                            str = String.valueOf(str) + Variant.toString(keys[k]);
                                            ++k;
                                        }
                                        str = String.valueOf(str) + "]";
                                        throw new RQException(String.valueOf(str) + mm.getMessage("engine.dupKeys"));
                                    }
                                    ((PrimaryJoinNode)entry).newValues[tableSeq] = newValues;
                                    break block25;
                                }
                                entry = entry.next;
                            }
                            hashTable[hash] = new PrimaryJoinNode(keys, newValues, tableCount, tableSeq, hashTable[hash]);
                        }
                        ++i;
                    }
                    break block26;
                }
                int newCount = newExps.length;
                int len = sequence.length();
                int i = 1;
                while (i <= len) {
                    block27: {
                        current.setCurrent(i);
                        Object[] keys = new Object[keyCount];
                        int c = 0;
                        while (c < keyCount) {
                            keys[c] = keyExps[c].calculate(ctx);
                            ++c;
                        }
                        Object[] newValues = new Object[newCount];
                        int c2 = 0;
                        while (c2 < newCount) {
                            newValues[c2] = newExps[c2].calculate(ctx);
                            ++c2;
                        }
                        int hash = hashUtil.hashCode(keys, keyCount);
                        PrimaryJoinNode entry = hashTable[hash];
                        while (entry != null) {
                            if (Variant.compareArrays(entry.keyValues, keys, keyCount) == 0) {
                                if (entry.newValues[tableSeq] != null) {
                                    MessageManager mm = EngineMessage.get();
                                    String str = "[";
                                    int k = 0;
                                    while (k < keyCount) {
                                        if (k != 0) {
                                            str = String.valueOf(str) + ",";
                                        }
                                        str = String.valueOf(str) + Variant.toString(keys[k]);
                                        ++k;
                                    }
                                    str = String.valueOf(str) + "]";
                                    throw new RQException(String.valueOf(str) + mm.getMessage("engine.dupKeys"));
                                }
                                ((PrimaryJoinNode)entry).newValues[tableSeq] = newValues;
                                break block27;
                            }
                            entry = entry.next;
                        }
                        hashTable[hash] = new PrimaryJoinNode(keys, newValues, tableCount, tableSeq, hashTable[hash]);
                    }
                    ++i;
                }
            }
            finally {
                stack.pop();
            }
        }
    }

    public Sequence result() {
        this.init();
        if (this.opt != null && this.opt.indexOf(102) != -1) {
            return this.fullJoin();
        }
        return this.join();
    }

    private Sequence join() {
        Table result;
        block28: {
            Sequence srcSequence = this.srcSequence;
            Expression[] srcKeyExps = this.srcKeyExps;
            Expression[] srcNewExps = this.srcNewExps;
            String[] options = this.options;
            Context ctx = this.ctx;
            HashUtil hashUtil = this.hashUtil;
            PrimaryJoinNode[] hashTable = this.hashTable;
            int[] newSeqs = this.newSeqs;
            int tableCount = this.tableCount;
            int srcRefCount = this.srcRefCount;
            DataStruct resultDs = this.resultDs;
            int[] joinTypes = new int[tableCount];
            int t = 0;
            while (t < tableCount) {
                String option = options[t];
                joinTypes[t] = option == null ? 0 : (option.equals("null") ? (this.newExps[t] != null && this.newExps[t].length > 0 ? 1 : 2) : 0);
                ++t;
            }
            int len = srcSequence.length();
            int keyCount = srcKeyExps.length;
            Object[] keys = new Object[keyCount];
            result = new Table(resultDs, len + 1024);
            ComputeStack stack = ctx.getComputeStack();
            Current current = new Current(srcSequence);
            stack.push(current);
            try {
                if (srcNewExps == null || srcNewExps.length == 0) {
                    int i = 1;
                    while (i <= len) {
                        block27: {
                            Object sr;
                            current.setCurrent(i);
                            int c = 0;
                            while (c < keyCount) {
                                keys[c] = srcKeyExps[c].calculate(ctx);
                                ++c;
                            }
                            int hash = hashUtil.hashCode(keys, keyCount);
                            PrimaryJoinNode entry = hashTable[hash];
                            while (entry != null) {
                                if (Variant.compareArrays(entry.keyValues, keys, keyCount) == 0) {
                                    int t2 = 0;
                                    while (t2 < tableCount) {
                                        if (!(entry.newValues[t2] == null ? joinTypes[t2] == 0 : joinTypes[t2] == 2)) {
                                            ++t2;
                                            continue;
                                        }
                                        break block27;
                                    }
                                    Record r = (Record)result.newLast();
                                    Object[] values = r.getFieldValues();
                                    sr = (BaseRecord)srcSequence.getMem(i);
                                    System.arraycopy(((BaseRecord)sr).getFieldValues(), 0, values, 0, srcRefCount);
                                    int t3 = 0;
                                    while (t3 < tableCount) {
                                        Object[] vals = entry.newValues[t3];
                                        if (vals != null) {
                                            System.arraycopy(vals, 0, values, newSeqs[t3], vals.length);
                                        }
                                        ++t3;
                                    }
                                    break block27;
                                }
                                entry = entry.next;
                            }
                            sr = joinTypes;
                            int values = joinTypes.length;
                            int r = 0;
                            while (r < values) {
                                int t4 = sr[r];
                                if (t4 != 0) {
                                    ++r;
                                    continue;
                                }
                                break block27;
                            }
                            Record r2 = (Record)result.newLast();
                            Object[] values2 = r2.getFieldValues();
                            BaseRecord sr2 = (BaseRecord)srcSequence.getMem(i);
                            System.arraycopy(sr2.getFieldValues(), 0, values2, 0, srcRefCount);
                        }
                        ++i;
                    }
                    break block28;
                }
                int newCount = srcNewExps.length;
                int i = 1;
                while (i <= len) {
                    block29: {
                        current.setCurrent(i);
                        int c = 0;
                        while (c < keyCount) {
                            keys[c] = srcKeyExps[c].calculate(ctx);
                            ++c;
                        }
                        int hash = hashUtil.hashCode(keys, keyCount);
                        PrimaryJoinNode entry = hashTable[hash];
                        while (entry != null) {
                            if (Variant.compareArrays(entry.keyValues, keys, keyCount) == 0) {
                                int t5 = 0;
                                while (t5 < tableCount) {
                                    if (!(entry.newValues[t5] == null ? joinTypes[t5] == 0 : joinTypes[t5] == 2)) {
                                        ++t5;
                                        continue;
                                    }
                                    break block29;
                                }
                                Record r = (Record)result.newLast();
                                Object[] values = r.getFieldValues();
                                int f = 0;
                                while (f < newCount) {
                                    values[f] = srcNewExps[f].calculate(ctx);
                                    ++f;
                                }
                                int t6 = 0;
                                while (t6 < tableCount) {
                                    Object[] vals = entry.newValues[t6];
                                    if (vals != null) {
                                        System.arraycopy(vals, 0, values, newSeqs[t6], vals.length);
                                    }
                                    ++t6;
                                }
                                break block29;
                            }
                            entry = entry.next;
                        }
                        int[] nArray = joinTypes;
                        int values = joinTypes.length;
                        int r = 0;
                        while (r < values) {
                            int t7 = nArray[r];
                            if (t7 != 0) {
                                ++r;
                                continue;
                            }
                            break block29;
                        }
                        Record r3 = (Record)result.newLast();
                        Object[] values3 = r3.getFieldValues();
                        int f = 0;
                        while (f < newCount) {
                            values3[f] = srcNewExps[f].calculate(ctx);
                            ++f;
                        }
                    }
                    ++i;
                }
            }
            finally {
                stack.pop();
            }
        }
        return result;
    }

    private Sequence fullJoin() {
        Object[] vals;
        int t;
        Sequence srcSequence = this.srcSequence;
        Expression[] srcKeyExps = this.srcKeyExps;
        Expression[] srcNewExps = this.srcNewExps;
        Context ctx = this.ctx;
        HashUtil hashUtil = this.hashUtil;
        PrimaryJoinNode[] hashTable = this.hashTable;
        int[] keySeqs = this.keySeqs;
        int[] newSeqs = this.newSeqs;
        int tableCount = this.tableCount;
        int srcRefCount = this.srcRefCount;
        DataStruct resultDs = this.resultDs;
        int len = srcSequence.length();
        int keyCount = srcKeyExps.length;
        Object[] keys = new Object[keyCount];
        Table result = new Table(resultDs, len + 1024);
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(srcSequence);
        stack.push(current);
        try {
            PrimaryJoinNode entry;
            int hash;
            int c;
            if (srcNewExps == null || srcNewExps.length == 0) {
                int i = 1;
                while (i <= len) {
                    current.setCurrent(i);
                    Record r = (Record)result.newLast();
                    Object[] values = r.getFieldValues();
                    BaseRecord sr = (BaseRecord)srcSequence.getMem(i);
                    System.arraycopy(sr.getFieldValues(), 0, values, 0, srcRefCount);
                    c = 0;
                    while (c < keyCount) {
                        keys[c] = srcKeyExps[c].calculate(ctx);
                        ++c;
                    }
                    hash = hashUtil.hashCode(keys, keyCount);
                    entry = hashTable[hash];
                    while (entry != null) {
                        if (Variant.compareArrays(entry.keyValues, keys, keyCount) == 0) {
                            t = 0;
                            while (t < tableCount) {
                                vals = entry.newValues[t];
                                if (vals != null) {
                                    System.arraycopy(vals, 0, values, newSeqs[t], vals.length);
                                }
                                ++t;
                            }
                            entry.isMatch = true;
                            break;
                        }
                        entry = entry.next;
                    }
                    ++i;
                }
            } else {
                int newCount = srcNewExps.length;
                int i = 1;
                while (i <= len) {
                    current.setCurrent(i);
                    Record r = (Record)result.newLast();
                    Object[] values = r.getFieldValues();
                    int f = 0;
                    while (f < newCount) {
                        values[f] = srcNewExps[f].calculate(ctx);
                        ++f;
                    }
                    c = 0;
                    while (c < keyCount) {
                        keys[c] = srcKeyExps[c].calculate(ctx);
                        ++c;
                    }
                    hash = hashUtil.hashCode(keys, keyCount);
                    entry = hashTable[hash];
                    while (entry != null) {
                        if (Variant.compareArrays(entry.keyValues, keys, keyCount) == 0) {
                            t = 0;
                            while (t < tableCount) {
                                vals = entry.newValues[t];
                                if (vals != null) {
                                    System.arraycopy(vals, 0, values, newSeqs[t], vals.length);
                                }
                                ++t;
                            }
                            entry.isMatch = true;
                            break;
                        }
                        entry = entry.next;
                    }
                    ++i;
                }
            }
        }
        finally {
            stack.pop();
        }
        PrimaryJoinNode[] primaryJoinNodeArray = hashTable;
        int n = hashTable.length;
        int n2 = 0;
        while (n2 < n) {
            PrimaryJoinNode entry = primaryJoinNodeArray[n2];
            while (entry != null) {
                if (!entry.isMatch) {
                    Record r = (Record)result.newLast();
                    Object[] values = r.getFieldValues();
                    t = 0;
                    while (t < tableCount) {
                        vals = entry.newValues[t];
                        if (vals != null) {
                            System.arraycopy(vals, 0, values, newSeqs[t], vals.length);
                        }
                        ++t;
                    }
                    int f = 0;
                    while (f < keyCount) {
                        if (keySeqs[f] != -1) {
                            values[keySeqs[f]] = entry.keyValues[f];
                        }
                        ++f;
                    }
                }
                entry = entry.next;
            }
            ++n2;
        }
        return result;
    }

    private static class PrimaryJoinNode {
        private Object[] keyValues;
        private Object[][] newValues;
        private PrimaryJoinNode next;
        private boolean isMatch = false;

        public PrimaryJoinNode(Object[] keyValues, Object[] curNewValues, int tableCount, int tableSeq, PrimaryJoinNode next) {
            this.keyValues = keyValues;
            this.newValues = new Object[tableCount][];
            this.newValues[tableSeq] = curNewValues;
            this.next = next;
        }
    }
}

