/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.IRecord;
import com.scudata.thread.MultithreadUtil;
import com.scudata.util.Variant;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBase1
implements Externalizable,
IRecord {
    private static final long serialVersionUID = 33619973L;
    protected Object[] elementData;
    protected int size;

    public ListBase1(int initialCapacity) {
        this.elementData = initialCapacity > 0 ? new Object[initialCapacity + 1] : new Object[1];
    }

    public ListBase1() {
        this(10);
    }

    public ListBase1(Object[] v) {
        this.size = v.length;
        this.elementData = new Object[this.size + 1];
        System.arraycopy(v, 0, this.elementData, 1, this.size);
    }

    public ListBase1(ListBase1 src) {
        this.size = src.size;
        this.elementData = new Object[this.size + 1];
        for (int i = 1; i <= this.size; ++i) {
            this.elementData[i] = src.get(i);
        }
    }

    public void trimToSize() {
        int newLen = this.size + 1;
        if (newLen < this.elementData.length) {
            Object[] oldData = this.elementData;
            this.elementData = new Object[newLen];
            System.arraycopy(oldData, 1, this.elementData, 1, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldSize = this.elementData.length;
        if (oldSize <= minCapacity) {
            Object[] oldData = this.elementData;
            int newSize = oldSize * 3 / 2;
            if (newSize <= minCapacity) {
                newSize = minCapacity + 1;
            }
            this.elementData = new Object[newSize];
            System.arraycopy(oldData, 1, this.elementData, 1, this.size);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object elem) {
        for (int i = 1; i <= this.size; ++i) {
            if (!Variant.isEquals(elem, this.elementData[i])) continue;
            return true;
        }
        return false;
    }

    public boolean objectContains(Object elem) {
        for (int i = 1; i <= this.size; ++i) {
            if (elem != this.elementData[i]) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Object elem, Comparator<Object> comparator) {
        for (int i = 1; i <= this.size; ++i) {
            if (comparator.compare(elem, this.elementData[i]) != 0) continue;
            return true;
        }
        return false;
    }

    public void sort(Comparator<Object> comparator) {
        MultithreadUtil.sort(this.elementData, 1, this.size + 1, comparator);
    }

    public int binarySearch(Object elem, Comparator<Object> comparator) {
        return this.binarySearch(elem, 1, this.size, comparator);
    }

    public int binarySearch(Object elem) {
        Object[] elementData = this.elementData;
        int low = 1;
        int high = this.size();
        while (low <= high) {
            int mid = low + high >> 1;
            int cmp = Variant.compare(elementData[mid], elem, true);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low;
    }

    public int binarySearch(Object elem, int low, int high, Comparator<Object> comparator) {
        Object[] elementData = this.elementData;
        while (low <= high) {
            int mid = low + high >> 1;
            int cmp = comparator.compare(elementData[mid], elem);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low;
    }

    public int indexOf(Object elem, int start, int end) {
        for (int i = start; i <= end; ++i) {
            if (!Variant.isEquals(elem, this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public int firstIndexOf(Object elem) {
        for (int i = 1; i <= this.size; ++i) {
            if (!Variant.isEquals(elem, this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public int firstIndexOf(Object elem, boolean isSorted) {
        if (isSorted) {
            int index = this.binarySearch(elem);
            if (index < 1) {
                return -1;
            }
            Object[] elementData = this.elementData;
            while (index > 1 && Variant.isEquals(elem, elementData[index - 1])) {
                --index;
            }
            return index;
        }
        for (int i = 1; i <= this.size; ++i) {
            if (!Variant.isEquals(elem, this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object elem) {
        for (int i = this.size; i > 0; --i) {
            if (!Variant.isEquals(elem, this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object elem, Comparator<Object> comparator, boolean isSorted) {
        if (isSorted) {
            int index = this.binarySearch(elem, comparator);
            if (index < 1) {
                return -1;
            }
            Object[] elementData = this.elementData;
            while (index < this.size && comparator.compare(elem, elementData[index + 1]) == 0) {
                ++index;
            }
            return index;
        }
        for (int i = this.size; i > 0; --i) {
            if (comparator.compare(elem, this.elementData[i]) != 0) continue;
            return i;
        }
        return -1;
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.elementData, 1, result, 0, this.size);
        return result;
    }

    public Object[] toArray(Object[] a) {
        System.arraycopy(this.elementData, 1, a, 0, this.size);
        return a;
    }

    Object[] _$1() {
        return this.elementData;
    }

    public Object get(int index) {
        return this.elementData[index];
    }

    public void set(int index, Object element) {
        this.elementData[index] = element;
    }

    public void add(Object o) {
        this.ensureCapacity(this.size + 1);
        this.elementData[++this.size] = o;
    }

    public void add(int index, Object element) {
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index + 1);
        this.elementData[index] = element;
        ++this.size;
    }

    public Object remove(int index) {
        Object oldValue = this.elementData[index];
        System.arraycopy(this.elementData, index + 1, this.elementData, index, this.size - index);
        this.elementData[this.size--] = null;
        return oldValue;
    }

    public void remove(int[] seqs) {
        int delCount = 0;
        int i = 0;
        int len = seqs.length;
        while (i < len) {
            int moveCount;
            int cur = seqs[i];
            if ((moveCount = ++i < len ? seqs[i] - cur - 1 : this.size - cur) > 0) {
                System.arraycopy(this.elementData, cur + 1, this.elementData, cur - delCount, moveCount);
            }
            ++delCount;
        }
        for (i = 0; i < delCount; ++i) {
            this.elementData[this.size--] = null;
        }
    }

    public void clear() {
        Object[] elementData = this.elementData;
        int count = this.size;
        for (int i = 1; i <= count; ++i) {
            elementData[i] = null;
        }
        this.size = 0;
    }

    public void addAll(Object[] a) {
        int numNew = a.length;
        this.ensureCapacity(this.size + numNew);
        System.arraycopy(a, 0, this.elementData, this.size + 1, numNew);
        this.size += numNew;
    }

    public void addAll(ListBase1 src) {
        int numNew = src.size;
        this.ensureCapacity(this.size + numNew);
        System.arraycopy(src.elementData, 1, this.elementData, this.size + 1, numNew);
        this.size += numNew;
    }

    public void addAll(ListBase1 src, int count) {
        this.ensureCapacity(this.size + count);
        System.arraycopy(src.elementData, 1, this.elementData, this.size + 1, count);
        this.size += count;
    }

    public void addSection(ListBase1 src, int srcIndex) {
        int numNew = src.size - srcIndex + 1;
        this.ensureCapacity(this.size + numNew);
        System.arraycopy(src.elementData, srcIndex, this.elementData, this.size + 1, numNew);
        this.size += numNew;
    }

    public void addSection(ListBase1 src, int srcStart, int srcEnd) {
        int numNew = srcEnd - srcStart;
        this.ensureCapacity(this.size + numNew);
        System.arraycopy(src.elementData, srcStart, this.elementData, this.size + 1, numNew);
        this.size += numNew;
    }

    public void addAll(int index, Object[] a) {
        int numNew = a.length;
        this.ensureCapacity(this.size + numNew);
        System.arraycopy(this.elementData, index, this.elementData, index + numNew, this.size - index + 1);
        System.arraycopy(a, 0, this.elementData, index, numNew);
        this.size += numNew;
    }

    public void addAll(int index, ListBase1 src) {
        int numNew = src.size;
        this.ensureCapacity(this.size + numNew);
        System.arraycopy(this.elementData, index, this.elementData, index + numNew, this.size - index + 1);
        System.arraycopy(src.elementData, 1, this.elementData, index, numNew);
        this.size += numNew;
    }

    public void addAll(int index, ListBase1 src, int count) {
        this.ensureCapacity(this.size + count);
        System.arraycopy(this.elementData, index, this.elementData, index + count, this.size - index + 1);
        System.arraycopy(src.elementData, 1, this.elementData, index, count);
        this.size += count;
    }

    public void removeRange(int fromIndex, int toIndex) {
        System.arraycopy(this.elementData, toIndex + 1, this.elementData, fromIndex, this.size - toIndex);
        int newSize = this.size - (toIndex - fromIndex + 1);
        while (this.size != newSize) {
            this.elementData[this.size--] = null;
        }
    }

    public void reserve(int start, int end) {
        int newSize = end - start + 1;
        System.arraycopy(this.elementData, start, this.elementData, 1, newSize);
        while (this.size != newSize) {
            this.elementData[this.size--] = null;
        }
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        out.writeInt(this.size);
        out.writeInt(this.elementData.length);
        for (int i = 1; i <= this.size; ++i) {
            out.writeObject(this.elementData[i], true);
        }
        return out.toByteArray();
    }

    @Override
    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord in = new ByteArrayInputRecord(buf);
        this.size = in.readInt();
        int length = in.readInt();
        Object[] elementData = new Object[length];
        this.elementData = elementData;
        for (int i = 1; i <= this.size; ++i) {
            elementData[i] = in.readObject(true);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        Object[] elementData = this.elementData;
        out.writeInt(this.size);
        out.writeInt(elementData.length);
        for (int i = 1; i <= this.size; ++i) {
            out.writeObject(elementData[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.size = in.readInt();
        int length = in.readInt();
        Object[] elementData = new Object[length];
        this.elementData = elementData;
        for (int i = 1; i <= this.size; ++i) {
            elementData[i] = in.readObject();
        }
    }
}

