/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.common.IOUtils;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.Env;
import com.scudata.dm.FileRandomOutputStream;
import com.scudata.dm.IFile;
import com.scudata.dm.JobSpace;
import com.scudata.dm.RandomOutputStream;
import com.scudata.dw.ComTable;
import com.scudata.resources.EngineMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.List;

public class LocalFile
implements IFile {
    private String _$5;
    private String _$4;
    private String _$3;
    private Context _$2;
    private Integer _$1;

    public LocalFile(String fileName, String opt) {
        this._$5 = fileName;
        this._$4 = opt;
    }

    public LocalFile(String fileName, String opt, Context ctx) {
        this._$5 = fileName;
        this._$4 = opt;
        this._$2 = ctx;
    }

    public LocalFile(String fileName, String opt, Integer partition) {
        this._$5 = fileName;
        this._$4 = opt;
        if (partition != null && partition >= 0) {
            this._$1 = partition;
            int index = fileName.lastIndexOf(92);
            if (index == -1) {
                index = fileName.lastIndexOf(47);
            }
            this._$5 = index == -1 ? partition.toString() + "." + fileName : fileName.substring(0, index + 1) + partition.toString() + "." + fileName.substring(index + 1);
        }
    }

    public void setParent(String parent) {
        this._$3 = parent;
    }

    public void setFileName(String fileName) {
        this._$5 = fileName;
    }

    private boolean _$3() {
        return this._$4 != null && this._$4.indexOf(115) != -1;
    }

    private File _$2() {
        JobSpace js;
        if (this._$2 != null && (js = this._$2.getJobSpace()) != null) {
            return js.getAppHome();
        }
        return null;
    }

    public File file() {
        if (this._$3 != null) {
            return new File(this._$3, this._$5);
        }
        File appHome = this._$2();
        if (appHome != null) {
            String mainPath = Env.getMainPath();
            if (mainPath != null && mainPath.length() > 0) {
                File tmpFile = new File(appHome, mainPath);
                return new File(tmpFile, this._$5);
            }
            return new File(appHome, this._$5);
        }
        if (IOUtils.isAbsolutePath(this._$5)) {
            return new File(this._$5);
        }
        String mainPath = Env.getMainPath();
        if (mainPath != null && mainPath.length() > 0) {
            return new File(mainPath, this._$5);
        }
        return new File(this._$5);
    }

    public File getFile() {
        File tmpFile;
        String mainPath;
        String[] paths;
        File file;
        if (this._$3 != null && (file = new File(this._$3, this._$5)).exists()) {
            return file;
        }
        File appHome = this._$2();
        if (appHome != null) {
            String mainPath2;
            if (this._$3() && Env.getPaths() != null) {
                for (String path : Env.getPaths()) {
                    File tmpFile2 = new File(appHome, path);
                    if (!(tmpFile2 = new File(tmpFile2, this._$5)).exists()) continue;
                    return tmpFile2;
                }
            }
            if ((mainPath2 = Env.getMainPath()) != null && mainPath2.length() > 0) {
                File tmpFile3 = new File(appHome, mainPath2);
                if ((tmpFile3 = new File(tmpFile3, this._$5)).exists()) {
                    return tmpFile3;
                }
            } else {
                File tmpFile4 = new File(appHome, this._$5);
                if (tmpFile4.exists()) {
                    return tmpFile4;
                }
            }
            return null;
        }
        if (IOUtils.isAbsolutePath(this._$5)) {
            File file2 = new File(this._$5);
            if (file2.exists()) {
                return file2;
            }
            return null;
        }
        if (this._$3() && (paths = Env.getPaths()) != null) {
            int count = paths.length;
            for (int i = 0; i < count; ++i) {
                File tmpFile5 = new File(paths[i], this._$5);
                if (!tmpFile5.exists()) continue;
                return tmpFile5;
            }
        }
        if ((mainPath = Env.getMainPath()) != null && mainPath.length() > 0 && (tmpFile = new File(mainPath, this._$5)).exists()) {
            return tmpFile;
        }
        File file3 = new File(this._$5);
        if (file3.exists()) {
            return file3;
        }
        return null;
    }

    public InputStream getInputStream() {
        try {
            File tmpFile;
            String mainPath;
            File file;
            if (this._$3 != null && (file = new File(this._$3, this._$5)).exists()) {
                return new FileInputStream(file);
            }
            File appHome = this._$2();
            if (appHome != null) {
                File tmpFile2;
                String mainPath2;
                if (this._$3()) {
                    InputStream in = IOUtils.findResource(this._$5);
                    if (in != null) {
                        return in;
                    }
                    in = Env.getStreamFromApp(this._$5);
                    if (in != null) {
                        return in;
                    }
                    String[] paths = Env.getPaths();
                    if (paths != null) {
                        for (String path : paths) {
                            File tmpFile3 = new File(appHome, path);
                            if (!(tmpFile3 = new File(tmpFile3, this._$5)).exists()) continue;
                            return new FileInputStream(tmpFile3);
                        }
                    }
                }
                if ((mainPath2 = Env.getMainPath()) != null && mainPath2.length() > 0) {
                    tmpFile2 = new File(appHome, mainPath2);
                    if ((tmpFile2 = new File(tmpFile2, this._$5)).exists()) {
                        return new FileInputStream(tmpFile2);
                    }
                } else {
                    tmpFile2 = new File(appHome, this._$5);
                    if (tmpFile2.exists()) {
                        return new FileInputStream(tmpFile2);
                    }
                }
                throw new FileNotFoundException(this._$5);
            }
            if (IOUtils.isAbsolutePath(this._$5)) {
                return new FileInputStream(this._$5);
            }
            if (this._$3()) {
                InputStream in = IOUtils.findResource(this._$5);
                if (in != null) {
                    return in;
                }
                in = Env.getStreamFromApp(this._$5);
                if (in != null) {
                    return in;
                }
                String[] paths = Env.getPaths();
                if (paths != null) {
                    int count = paths.length;
                    for (int i = 0; i < count; ++i) {
                        File tmpFile4 = new File(paths[i], this._$5);
                        if (!tmpFile4.exists()) continue;
                        return new FileInputStream(tmpFile4);
                    }
                }
            }
            if ((mainPath = Env.getMainPath()) != null && mainPath.length() > 0 && (tmpFile = new File(mainPath, this._$5)).exists()) {
                return new FileInputStream(tmpFile);
            }
            return new FileInputStream(this._$5);
        }
        catch (FileNotFoundException e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    public OutputStream getOutputStream(boolean isAppend) {
        try {
            File file = this._$1();
            File parentFile = file.getParentFile();
            if (parentFile != null) {
                parentFile.mkdirs();
            }
            return new FileOutputStream(file, isAppend);
        }
        catch (FileNotFoundException e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    public RandomOutputStream getRandomOutputStream(boolean isAppend) {
        try {
            File file = this._$1();
            file.getParentFile().mkdirs();
            RandomAccessFile randomFile = new RandomAccessFile(file, "rw");
            if (!isAppend) {
                randomFile.setLength(0L);
            } else {
                randomFile.seek(randomFile.length());
            }
            return new FileRandomOutputStream(randomFile);
        }
        catch (IOException e) {
            throw new RQException(e);
        }
    }

    private File _$1() {
        if (this._$3 != null) {
            return new File(this._$3, this._$5);
        }
        File appHome = this._$2();
        if (appHome != null) {
            String mainPath = Env.getMainPath();
            if (mainPath != null && mainPath.length() > 0) {
                File tmpFile = new File(appHome, mainPath);
                return new File(tmpFile, this._$5);
            }
            return new File(appHome, this._$5);
        }
        if (IOUtils.isAbsolutePath(this._$5)) {
            return new File(this._$5);
        }
        String mainPath = Env.getMainPath();
        if (mainPath != null && mainPath.length() > 0) {
            return new File(mainPath, this._$5);
        }
        return new File(this._$5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        InputStream is = null;
        try {
            is = this.getInputStream();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public long size() {
        File file = this.getFile();
        if (file != null) {
            return file.length();
        }
        return 0L;
    }

    public long lastModified() {
        File file = this.getFile();
        if (file != null) {
            return file.lastModified();
        }
        return 0L;
    }

    private boolean _$2(File file) {
        if (this._$5.endsWith(".ctx")) {
            ComTable table = null;
            try {
                table = ComTable.open(file, this._$2);
                List<File> files = table.getFiles(false, true);
                table.close();
                for (File f : files) {
                    f.delete();
                }
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean delete() {
        File file = this.getFile();
        if (file != null) {
            this._$2(file);
            return file.delete();
        }
        return false;
    }

    public boolean deleteDir() {
        File file = this.getFile();
        if (file == null) {
            return false;
        }
        return LocalFile._$1(file);
    }

    private static boolean _$1(File file) {
        File[] subs = file.listFiles();
        if (subs != null) {
            for (File sub : subs) {
                LocalFile._$1(sub);
            }
        }
        return file.delete();
    }

    private void _$1(File file, File destFile, boolean isCopy, boolean auto) {
        if (file.isDirectory()) {
            return;
        }
        if (this._$5.endsWith(".ctx")) {
            try {
                int i;
                ComTable table = ComTable.open(file, this._$2);
                List<File> files = table.getFiles(false, auto);
                table.close();
                int fcount = files.size();
                if (fcount == 0) {
                    return;
                }
                File[] destFiles = new File[fcount];
                String dest = destFile.getAbsolutePath();
                int pos = file.getAbsolutePath().length();
                for (i = 0; i < fcount; ++i) {
                    String name = files.get(i).getAbsolutePath().substring(pos);
                    destFiles[i] = new File(dest + name);
                }
                for (i = 0; i < fcount; ++i) {
                    if (isCopy) {
                        LocalFile.copyFile(files.get(i), destFiles[i]);
                        continue;
                    }
                    destFiles[i].delete();
                    files.get(i).renameTo(destFiles[i]);
                }
            }
            catch (IOException e) {
                throw new RQException(e);
            }
        }
    }

    public boolean move(String dest, String opt) {
        boolean result;
        File destFile;
        boolean isDir;
        File file = this.getFile();
        if (file == null || !file.exists()) {
            Logger.debug("move file error: Source file doesn't exist.");
            return false;
        }
        boolean isCover = false;
        boolean isCopy = false;
        boolean isMain = false;
        boolean auto = false;
        if (opt != null) {
            if (opt.indexOf(121) != -1) {
                isCover = true;
            }
            if (opt.indexOf(99) != -1) {
                isCopy = true;
            }
            if (opt.indexOf(112) != -1) {
                isMain = true;
            }
            if (opt.indexOf(97) != -1) {
                auto = true;
            }
        }
        if (!(isDir = (destFile = new File(dest)).isDirectory()) && !destFile.isFile() && dest.length() > 1) {
            char c = dest.charAt(dest.length() - 1);
            boolean bl = isDir = c == '/' || c == '\\';
        }
        if (!isDir && this._$1 != null && this._$1 >= 0) {
            int index = dest.lastIndexOf(92);
            if (index == -1) {
                index = dest.lastIndexOf(47);
            }
            dest = index == -1 ? this._$1.toString() + "." + dest : dest.substring(0, index + 1) + this._$1.toString() + "." + dest.substring(index + 1);
            destFile = new File(dest);
        }
        if (!destFile.isAbsolute()) {
            if (isMain) {
                File appHome = this._$2();
                String mainPath = Env.getMainPath();
                if (appHome != null) {
                    if (mainPath != null && mainPath.length() > 0) {
                        destFile = new File(appHome, mainPath);
                        destFile = new File(destFile, dest);
                    } else {
                        destFile = new File(appHome, dest);
                    }
                } else if (mainPath != null && mainPath.length() > 0) {
                    destFile = new File(mainPath, dest);
                }
            } else {
                destFile = new File(file.getParentFile(), dest);
            }
        } else if (this._$2() != null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("file.fileNotExist", dest));
        }
        if (isDir && !file.isDirectory()) {
            destFile = new File(destFile, file.getName());
        }
        if (!isCover && destFile.exists()) {
            Logger.debug("move file error: The target file already exists.");
            return false;
        }
        File parent = destFile.getParentFile();
        if (parent != null && !(result = parent.mkdirs())) {
            Logger.debug("move file error: mkdirs failed.");
        }
        this._$1(file, destFile, isCopy, auto);
        if (isCopy) {
            if (file.isDirectory()) {
                return LocalFile.copyDirectory(file, destFile);
            }
            return LocalFile.copyFile(file, destFile);
        }
        destFile.delete();
        return file.renameTo(destFile);
    }

    public String createTempFile(String prefix) {
        try {
            File file = this.getFile();
            if (file == null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("file.fileNotExist", this._$5));
            }
            if (file.isDirectory()) {
                File tmpFile = File.createTempFile(prefix, "", file);
                return tmpFile.getAbsolutePath();
            }
            String suffix = "";
            String name = file.getName();
            int index = name.lastIndexOf(46);
            if (index != -1) {
                suffix = name.substring(index);
            }
            file = file.getParentFile();
            File tmpFile = File.createTempFile(prefix, suffix, file);
            return tmpFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    public static String removeMainPath(String pathName, Context ctx) {
        String main;
        File home = null;
        JobSpace js = ctx.getJobSpace();
        if (js != null) {
            home = js.getAppHome();
        }
        if ((main = Env.getMainPath()) != null && main.length() > 0) {
            home = home == null ? new File(main) : new File(home, main);
        } else if (home == null) {
            return pathName;
        }
        String strHome = home.getAbsolutePath();
        int len = strHome.length();
        if (pathName.length() > len && pathName.substring(0, len).equalsIgnoreCase(strHome)) {
            char c = pathName.charAt(len);
            if (!(c != '\\' && c != '/' || pathName.length() <= ++len || (c = pathName.charAt(len)) != '\\' && c != '/')) {
                ++len;
            }
            return pathName.substring(len);
        }
        return pathName;
    }

    public static boolean copyDirectory(File s, File t) {
        File destDir = new File(t, s.getName());
        destDir.mkdirs();
        boolean result = true;
        File[] files = s.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    if (LocalFile.copyFile(file, new File(destDir, file.getName()))) continue;
                    result = false;
                    continue;
                }
                if (!file.isDirectory() || LocalFile.copyDirectory(file, destDir)) continue;
                result = false;
            }
        }
        return result;
    }

    public static boolean copyFile(File s, File t) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(s);
            fos = new FileOutputStream(t);
            FileChannel in = fis.getChannel();
            FileChannel out = fos.getChannel();
            long total = in.size();
            for (long count = 0L; count < total; count += in.transferTo(count, total - count, out)) {
            }
            out.close();
        }
        catch (IOException e) {
            throw new RQException(e);
        }
        finally {
            IOException ie = null;
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    ie = e;
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    ie = e;
                }
            }
            if (ie != null) {
                throw new RQException(ie);
            }
        }
        return true;
    }

    public void setFileSize(long size) {
        File file = this.getFile();
        if (file != null) {
            try {
                RandomAccessFile rf = new RandomAccessFile(file, "rw");
                rf.setLength(size);
                rf.close();
            }
            catch (IOException e) {
                throw new RQException(e);
            }
        }
    }

    public Integer getPartition() {
        return this._$1;
    }

    public RandomAccessFile getRandomAccessFile() {
        File file = this.file();
        try {
            if (file.canWrite()) {
                return new RandomAccessFile(file, "rw");
            }
            return new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    public boolean isCloudFile() {
        return false;
    }
}

