/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.array.IArray;
import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.IRecord;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Record
extends BaseRecord
implements Externalizable,
IRecord {
    private static final long serialVersionUID = 0x2010002L;
    protected DataStruct ds;
    protected Object[] values;

    public Record() {
    }

    public Record(DataStruct ds) {
        this.ds = ds;
        this.values = new Object[ds.getFieldCount()];
    }

    public Record(DataStruct ds, Object[] initVals) {
        this.ds = ds;
        this.values = new Object[ds.getFieldCount()];
        System.arraycopy(initVals, 0, this.values, 0, initVals.length);
    }

    public Object getCurrent() {
        return this;
    }

    public int getCurrentIndex() {
        throw new RuntimeException();
    }

    public Sequence getCurrentSequence() {
        return null;
    }

    public boolean isInStack(ComputeStack stack) {
        return stack.isInComputeStack(this);
    }

    public void popStack() {
    }

    public DataStruct dataStruct() {
        return this.ds;
    }

    public void setDataStruct(DataStruct ds) {
        this.ds = ds;
    }

    public int[] getPKIndex() {
        return this.ds.getPKIndex();
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        int count = this.values.length;
        out.writeInt(count);
        Object[] values = this.values;
        for (int i = 0; i < count; ++i) {
            out.writeObject(values[i], true);
        }
        out.writeRecord(this.ds);
        return out.toByteArray();
    }

    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord in = new ByteArrayInputRecord(buf);
        int count = in.readInt();
        Object[] values = new Object[count];
        this.values = values;
        for (int i = 0; i < count; ++i) {
            values[i] = in.readObject(true);
        }
        if (in.available() > 0) {
            this.ds = new DataStruct();
            in.readRecord(this.ds);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeObject(this.ds);
        out.writeObject(this.values);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.ds = (DataStruct)in.readObject();
        this.values = (Object[])in.readObject();
    }

    public int getFieldCount() {
        return this.values.length;
    }

    public String[] getFieldNames() {
        return this.dataStruct().getFieldNames();
    }

    void _$1(DataStruct newDs, Object[] newValues) {
        int newCount = newValues.length;
        if (this.values.length != newCount) {
            this.values = new Object[newCount];
        }
        System.arraycopy(newValues, 0, this.values, 0, newCount);
        this.ds = newDs;
    }

    public void derive(DataStruct newDs) {
        Object[] vals = new Object[newDs.getFieldCount()];
        System.arraycopy(this.values, 0, vals, 0, this.values.length);
        this.values = vals;
        this.ds = newDs;
    }

    public int getFieldIndex(String name) {
        return this.dataStruct().getFieldIndex(name);
    }

    public Object[] getFieldValues() {
        return this.values;
    }

    public Object getFieldValue(int index) {
        if (index < 0) {
            int i = index + this.values.length;
            if (i < 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(index + mm.getMessage("ds.fieldNotExist"));
            }
            return this.values[i];
        }
        if (index < this.values.length) {
            return this.values[index];
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(index + 1 + mm.getMessage("ds.fieldNotExist"));
    }

    public Object getFieldValue2(int index) {
        if (index < 0) {
            int i = index + this.values.length;
            if (i >= 0) {
                return this.values[i];
            }
            return null;
        }
        if (index < this.values.length) {
            return this.values[index];
        }
        return null;
    }

    public Object getNormalFieldValue(int index) {
        return this.values[index];
    }

    public void getNormalFieldValue(int index, IArray out) {
        out.push(this.values[index]);
    }

    public void setNormalFieldValue(int index, Object val) {
        this.values[index] = val;
    }

    public Object getFieldValue(String name) {
        int index = this.dataStruct().getFieldIndex(name);
        if (index != -1) {
            return this.values[index];
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(name + mm.getMessage("ds.fieldNotExist"));
    }

    public void set(int index, Object val) {
        if (index < 0) {
            int i = index + this.values.length;
            if (i < 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(index + mm.getMessage("ds.fieldNotExist"));
            }
            this.values[i] = val;
        } else if (index < this.values.length) {
            this.values[index] = val;
        } else {
            MessageManager mm = EngineMessage.get();
            throw new RQException(index + 1 + mm.getMessage("ds.fieldNotExist"));
        }
    }

    public void set2(int index, Object val) {
        if (index < 0) {
            int i = index + this.values.length;
            if (i >= 0) {
                this.values[i] = val;
            }
        } else if (index < this.values.length) {
            this.values[index] = val;
        }
    }

    public void set(String name, Object val) {
        int index = this.dataStruct().getFieldIndex(name);
        if (index == -1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(name + mm.getMessage("ds.fieldNotExist"));
        }
        this.set(index, val);
    }

    public int compare(BaseRecord r) {
        if (r == this) {
            return 0;
        }
        if (r == null) {
            return 1;
        }
        Object[] vals1 = this.values;
        int len1 = vals1.length;
        int len2 = r.getFieldCount();
        int minLen = len1 > len2 ? len2 : len1;
        for (int i = 0; i < minLen; ++i) {
            int result = Variant.compare(vals1[i], r.getNormalFieldValue(i), true);
            if (result == 0) continue;
            return result;
        }
        return len1 == len2 ? 0 : (len1 > len2 ? 1 : -1);
    }

    public int compare(int[] fields, Object[] fvalues) {
        int len = fields.length;
        for (int i = 0; i < len; ++i) {
            int result = Variant.compare(this.getFieldValue(fields[i]), fvalues[i], true);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public boolean isEquals(BaseRecord r) {
        if (r == null) {
            return false;
        }
        if (r == this) {
            return true;
        }
        int count = this.values.length;
        Object[] vals = r.getFieldValues();
        if (vals.length != count) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (Variant.isEquals(this.values[i], vals[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isEquals(BaseRecord r, int[] index) {
        Object[] vals = r.getFieldValues();
        for (int i = 0; i < index.length; ++i) {
            if (Variant.isEquals(this.values[index[i]], vals[index[i]])) continue;
            return false;
        }
        return true;
    }

    public String toString(String opt) {
        char sep = ',';
        boolean addQuotation = false;
        boolean bTitle = false;
        if (opt != null) {
            if (opt.indexOf(116) != -1) {
                sep = '\t';
            }
            if (opt.indexOf(113) != -1) {
                addQuotation = true;
            }
            if (opt.indexOf(102) != -1) {
                bTitle = true;
            }
        }
        int fcount = this.getFieldCount();
        StringBuffer sb = new StringBuffer(20 * fcount);
        if (bTitle) {
            DataStruct ds = this.dataStruct();
            for (int f = 0; f < fcount; ++f) {
                if (f > 0) {
                    sb.append(sep);
                }
                if (addQuotation) {
                    sb.append('\"');
                    sb.append(ds.getFieldName(f));
                    sb.append('\"');
                    continue;
                }
                sb.append(ds.getFieldName(f));
            }
        } else {
            boolean bFirst = true;
            Object[] values = this.values;
            for (int f = 0; f < fcount; ++f) {
                Object obj = values[f];
                if (!Variant.canConvertToString(obj)) continue;
                if (bFirst) {
                    bFirst = false;
                } else {
                    sb.append(sep);
                }
                if (addQuotation && obj instanceof String) {
                    sb.append('\"');
                    sb.append((String)obj);
                    sb.append('\"');
                    continue;
                }
                sb.append(Variant.toString(obj));
            }
        }
        return sb.toString();
    }

    public boolean isSameDataStruct(BaseRecord cur) {
        return this.ds == cur.dataStruct();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(Expression[] exps, String[] fields, Context ctx) {
        ComputeStack stack = ctx.getComputeStack();
        stack.push(this);
        try {
            int fcount = fields.length;
            for (int f = 0; f < fcount; ++f) {
                int findex = this.getFieldIndex(fields[f]);
                if (findex < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(fields[f] + mm.getMessage("ds.fieldNotExist"));
                }
                this.setNormalFieldValue(findex, exps[f].calculate(ctx));
            }
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence calc(Expression[] exps, Context ctx) {
        ComputeStack stack = ctx.getComputeStack();
        stack.push(this);
        try {
            int count = exps.length;
            Sequence seq = new Sequence(count);
            for (int i = 0; i < count; ++i) {
                seq.add(exps[i].calculate(ctx));
            }
            Sequence sequence = seq;
            return sequence;
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Expression exp, Context ctx) {
        if (exp == null) {
            return;
        }
        ComputeStack stack = ctx.getComputeStack();
        stack.push(this);
        try {
            exp.calculate(ctx);
        }
        finally {
            stack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Expression[] assignExps, Expression[] exps, Context ctx) {
        if (exps == null || exps.length == 0) {
            return;
        }
        int colCount = exps.length;
        if (assignExps == null) {
            assignExps = new Expression[colCount];
        } else if (assignExps.length != colCount) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("run" + mm.getMessage("function.invalidParam"));
        }
        ComputeStack stack = ctx.getComputeStack();
        stack.push(this);
        try {
            for (int c = 0; c < colCount; ++c) {
                if (assignExps[c] == null) {
                    exps[c].calculate(ctx);
                    continue;
                }
                assignExps[c].assign(exps[c].calculate(ctx), ctx);
            }
        }
        finally {
            stack.pop();
        }
    }

    public void set(BaseRecord r) {
        Object[] vals = r.getFieldValues();
        System.arraycopy(vals, 0, this.values, 0, vals.length);
    }

    public void setStart(int index, BaseRecord r) {
        Object[] vals = r.getFieldValues();
        System.arraycopy(vals, 0, this.values, index, vals.length);
    }

    public void setStart(int index, Object[] objs) {
        System.arraycopy(objs, 0, this.values, index, objs.length);
    }

    public void setStart(int index, Object[] objs, int len) {
        System.arraycopy(objs, 0, this.values, index, len);
    }

    public Object value() {
        int[] pkIndex = this.ds.getPKIndex();
        if (pkIndex == null) {
            Object[] values = this.values;
            Sequence seq = new Sequence(values.length);
            for (Object obj : values) {
                if (obj instanceof BaseRecord) {
                    obj = ((BaseRecord)obj).key();
                }
                if (obj instanceof Sequence) {
                    seq.addAll((Sequence)obj);
                    continue;
                }
                seq.add(obj);
            }
            return seq;
        }
        int keyCount = pkIndex.length - this.ds.getTimeKeyCount();
        if (keyCount == 1) {
            Object obj = this.getNormalFieldValue(pkIndex[0]);
            if (obj instanceof BaseRecord) {
                return ((BaseRecord)obj).key();
            }
            return obj;
        }
        Sequence keySeries = new Sequence(keyCount);
        for (int i = 0; i < keyCount; ++i) {
            Object obj = this.getNormalFieldValue(pkIndex[i]);
            if (obj instanceof BaseRecord) {
                obj = ((BaseRecord)obj).key();
            }
            if (obj instanceof Sequence) {
                keySeries.addAll((Sequence)obj);
                continue;
            }
            keySeries.add(obj);
        }
        return keySeries;
    }

    public Object key() {
        int[] pkIndex = this.ds.getPKIndex();
        if (pkIndex == null) {
            return null;
        }
        int keyCount = pkIndex.length - this.ds.getTimeKeyCount();
        if (keyCount == 1) {
            Object obj = this.getNormalFieldValue(pkIndex[0]);
            if (obj instanceof BaseRecord) {
                return ((BaseRecord)obj).key();
            }
            return obj;
        }
        Sequence keySeries = new Sequence(keyCount);
        for (int i = 0; i < keyCount; ++i) {
            Object obj = this.getNormalFieldValue(pkIndex[i]);
            if (obj instanceof BaseRecord) {
                obj = ((BaseRecord)obj).key();
            }
            if (obj instanceof Sequence) {
                keySeries.addAll((Sequence)obj);
                continue;
            }
            keySeries.add(obj);
        }
        return keySeries;
    }

    public Object getPKValue() {
        int[] pkIndex = this.ds.getPKIndex();
        if (pkIndex == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("ds.lessKey"));
        }
        int keyCount = pkIndex.length - this.ds.getTimeKeyCount();
        if (keyCount == 1) {
            Object obj = this.getNormalFieldValue(pkIndex[0]);
            if (obj instanceof BaseRecord) {
                return ((BaseRecord)obj).getPKValue();
            }
            return obj;
        }
        Sequence keySeries = new Sequence(keyCount);
        for (int i = 0; i < keyCount; ++i) {
            Object obj = this.getNormalFieldValue(pkIndex[i]);
            if (obj instanceof BaseRecord) {
                obj = ((BaseRecord)obj).getPKValue();
            }
            if (obj instanceof Sequence) {
                keySeries.addAll((Sequence)obj);
                continue;
            }
            keySeries.add(obj);
        }
        return keySeries;
    }

    public void paste(BaseRecord sr, boolean isName) {
        if (sr == null) {
            return;
        }
        Object[] vals = sr.getFieldValues();
        if (isName) {
            DataStruct ds = this.dataStruct();
            String[] srcNames = sr.dataStruct().getFieldNames();
            int count = srcNames.length;
            for (int i = 0; i < count; ++i) {
                int index = ds.getFieldIndex(srcNames[i]);
                if (index < 0) continue;
                this.values[index] = vals[i];
            }
        } else {
            int minCount = this.values.length > vals.length ? vals.length : this.values.length;
            System.arraycopy(vals, 0, this.values, 0, minCount);
        }
    }

    public void paste(Sequence series) {
        if (series == null) {
            return;
        }
        Object[] values = this.values;
        int fcount = series.length();
        if (fcount > values.length) {
            fcount = values.length;
        }
        for (int f = 0; f < fcount; ++f) {
            values[f] = series.get(f + 1);
        }
    }

    public void paste(Sequence series, int start) {
        Object[] values = this.values;
        int fcount = series.length() - start + 1;
        if (fcount > values.length) {
            fcount = values.length;
        }
        for (int f = 0; f < fcount; ++f) {
            values[f] = series.get(f + start);
        }
    }

    public boolean checkReference() {
        for (Object val : this.values) {
            if (val instanceof BaseRecord || val instanceof Table) {
                return true;
            }
            if (!(val instanceof Sequence) || !((Sequence)val).hasRecord()) continue;
            return true;
        }
        return false;
    }

    public Sequence prior(String field, BaseRecord p, int maxLevel) {
        int f = this.ds.getFieldIndex(field);
        if (f == -1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(field + mm.getMessage("ds.fieldNotExist"));
        }
        return this.prior(f, p, maxLevel);
    }

    public Sequence prior(int f, BaseRecord p, int maxLevel) {
        if (this == p) {
            return new Sequence(0);
        }
        Sequence seq = new Sequence();
        BaseRecord r = this;
        if (maxLevel > 0) {
            for (int i = 0; i < maxLevel; ++i) {
                Object obj = ((BaseRecord)r).getNormalFieldValue(f);
                if (obj == p) {
                    seq.add(r);
                    return seq;
                }
                if (obj == null) {
                    return null;
                }
                if (!(obj instanceof BaseRecord)) {
                    return null;
                }
                seq.add(r);
                r = (BaseRecord)obj;
            }
            return null;
        }
        while (true) {
            Object obj;
            if ((obj = ((BaseRecord)r).getNormalFieldValue(f)) == p) {
                seq.add(r);
                return seq;
            }
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof BaseRecord)) break;
            seq.add(r);
            r = (BaseRecord)obj;
        }
        return null;
    }

    public boolean hasTimeKey() {
        return this.ds.getTimeKeyCount() > 0;
    }

    public Record toRecord() {
        return this;
    }
}

