/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.IndexTable;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.resources.EngineMessage;

public class SeqIndexTable
extends IndexTable {
    private Sequence _$2;
    private int _$1;

    public SeqIndexTable(Sequence code) {
        this._$2 = code;
        this._$1 = code.length();
    }

    public SeqIndexTable(Sequence code, int field) {
        int len = code.length();
        Sequence result = new Sequence(len);
        for (int i = 1; i <= len; ++i) {
            BaseRecord r = (BaseRecord)code.getMem(i);
            Object v = r.getNormalFieldValue(field);
            if (!(v instanceof Number)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needIntExp"));
            }
            int seq = ((Number)v).intValue();
            if (seq <= result.length() && result.getMem(seq) != null) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(seq + mm.getMessage("engine.dupKeys"));
            }
            result.set(seq, r);
        }
        this._$2 = result;
        this._$1 = result.length();
    }

    public Object find(Object key) {
        int seq;
        if (key instanceof Number && (seq = ((Number)key).intValue()) > 0 && seq <= this._$1) {
            return this._$2.getMem(seq);
        }
        return null;
    }

    public Object find(Object[] keys) {
        return this.find(keys[0]);
    }

    public int findPos(Object key) {
        int seq;
        if (key instanceof Number && (seq = ((Number)key).intValue()) > 0 && seq <= this._$1 && this._$2.isTrue(seq)) {
            return seq;
        }
        return 0;
    }

    public int findPos(Object[] keys) {
        return this.findPos(keys[0]);
    }

    public int[] findAllPos(IArray key) {
        int len = key.size();
        int codeLen = this._$1;
        int[] pos = new int[len + 1];
        Sequence code = this._$2;
        if (code instanceof Table) {
            for (int i = 1; i <= len; ++i) {
                int seq;
                if (key.isNull(i) || (seq = key.getInt(i)) <= 0 || seq > codeLen) continue;
                pos[i] = seq;
            }
        } else {
            IArray mems = code.getMems();
            for (int i = 1; i <= len; ++i) {
                int seq;
                if (key.isNull(i) || (seq = key.getInt(i)) <= 0 || seq > codeLen || !mems.isTrue(seq)) continue;
                pos[i] = seq;
            }
        }
        return pos;
    }

    public int[] findAllPos(IArray[] keys) {
        return this.findAllPos(keys[0]);
    }

    public int[] findAllPos(IArray key, BoolArray signArray) {
        int len = key.size();
        int codeLen = this._$1;
        int[] pos = new int[len + 1];
        Sequence code = this._$2;
        if (code instanceof Table) {
            for (int i = 1; i <= len; ++i) {
                int seq;
                if (!signArray.isTrue(i) || key.isNull(i) || (seq = key.getInt(i)) <= 0 || seq > codeLen) continue;
                pos[i] = seq;
            }
        } else {
            IArray mems = code.getMems();
            for (int i = 1; i <= len; ++i) {
                int seq;
                if (!signArray.isTrue(i) || key.isNull(i) || (seq = key.getInt(i)) <= 0 || seq > codeLen || !mems.isTrue(seq)) continue;
                pos[i] = seq;
            }
        }
        return pos;
    }

    public int[] findAllPos(IArray[] keys, BoolArray signArray) {
        return this.findAllPos(keys[0], signArray);
    }
}

