/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.resources.EngineMessage;
import com.scudata.util.HashUtil;
import com.scudata.util.Variant;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialBytes
implements Externalizable,
Comparable<SerialBytes> {
    private static final long serialVersionUID = 39923715L;
    private static final long _$4 = -1L;
    private static final String[] _$3 = new String[16];
    private long _$2;
    private long _$1;

    public SerialBytes() {
    }

    public SerialBytes(byte[] bytes, int len) {
        int index = 0;
        for (byte b : bytes) {
            if (++index <= 8) {
                this._$2 |= (0xFFL & (long)b) << (8 - index) * 8;
                continue;
            }
            this._$1 |= (0xFFL & (long)b) << (16 - index) * 8;
        }
    }

    public SerialBytes(long value1, long value2) {
        this._$2 = value1;
        this._$1 = value2;
    }

    public SerialBytes(Number num, int len) {
        if (len > 16) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("serialbytes.outOfLimit"));
        }
        if (len <= 8) {
            this._$2 = num.longValue() << (8 - len) * 8;
        } else {
            BigInteger bi = Variant.toBigInteger(num);
            byte[] bytes = bi.toByteArray();
            int blen = bytes.length;
            if (blen > len) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("serialbytes.biLenMismatch"));
            }
            int index = len - blen;
            for (byte b : bytes) {
                if (++index <= 8) {
                    this._$2 |= (0xFFL & (long)b) << (8 - index) * 8;
                    continue;
                }
                this._$1 |= (0xFFL & (long)b) << (16 - index) * 8;
            }
        }
    }

    public SerialBytes(Number[] vals, int[] lens) {
        int len = 0;
        for (int i = 0; i < vals.length; ++i) {
            MessageManager mm;
            int curLen = lens[i];
            if (curLen <= 8) {
                long curVal = vals[i].longValue() & -1L >>> 8 - curLen;
                if (len < 8) {
                    if ((len += curLen) <= 8) {
                        this._$2 |= curVal << (8 - len) * 8;
                        continue;
                    }
                    this._$2 |= curVal >>> (len - 8) * 8;
                    this._$1 = curVal << (16 - len) * 8;
                    continue;
                }
                if ((len += curLen) > 16) {
                    MessageManager mm2 = EngineMessage.get();
                    throw new RQException(mm2.getMessage("serialbytes.outOfLimit"));
                }
                this._$1 |= curVal << (16 - len) * 8;
                continue;
            }
            BigInteger bi = Variant.toBigInteger(vals[i]);
            byte[] bytes = bi.toByteArray();
            int blen = bytes.length;
            if (blen > curLen) {
                mm = EngineMessage.get();
                throw new RQException(mm.getMessage("serialbytes.biLenMismatch"));
            }
            len += curLen - blen;
            for (byte b : bytes) {
                if (++len <= 8) {
                    this._$2 |= (0xFFL & (long)b) << (8 - len) * 8;
                    continue;
                }
                this._$1 |= (0xFFL & (long)b) << (16 - len) * 8;
            }
            if (len <= 16) continue;
            mm = EngineMessage.get();
            throw new RQException(mm.getMessage("serialbytes.outOfLimit"));
        }
    }

    public int length() {
        return 16;
    }

    public int hashCode() {
        return HashUtil.hashCode(this._$2 + this._$1);
    }

    public String toString() {
        String str2;
        String str1 = Long.toHexString(this._$2);
        int strLen = str1.length();
        if (strLen < 16) {
            str1 = _$3[16 - strLen] + str1;
        }
        if ((strLen = (str2 = Long.toHexString(this._$1)).length()) < 16) {
            return str1 + _$3[16 - strLen] + str2;
        }
        return str1 + str2;
    }

    public byte[] toByteArray() {
        int i;
        byte[] bytes = new byte[16];
        for (i = 16; i > 8; --i) {
            bytes[i - 1] = (byte)(this._$1 >>> (16 - i) * 8);
        }
        while (i > 0) {
            bytes[i - 1] = (byte)(this._$2 >>> (8 - i) * 8);
            --i;
        }
        return bytes;
    }

    public long getByte(int q) {
        if (q < 1 || q > 16) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(q + mm.getMessage("engine.indexOutofBound"));
        }
        if (q <= 8) {
            return this._$2 >>> (8 - q) * 8 & 0xFFL;
        }
        return this._$1 >>> (16 - q) * 8 & 0xFFL;
    }

    public long getBytes(int start, int end) {
        if (start < 1 || end < start || end > 16) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(start + "," + end + mm.getMessage("engine.indexOutofBound"));
        }
        if (start <= 8) {
            if (end <= 8) {
                return this._$2 << (start - 1) * 8 >>> (7 + start - end) * 8;
            }
            long result = this._$2 << (start - 1) * 8 >>> (start - 1) * 8;
            return result << (end - 8) * 8 | this._$1 >>> (16 - end) * 8;
        }
        return this._$1 << (start - 9) * 8 >>> (7 + start - end) * 8;
    }

    public static int compare(long value1, long value2, long otherValue1, long otherValue2) {
        if (value1 == otherValue1) {
            if (value2 == otherValue2) {
                return 0;
            }
            if (value2 < 0L) {
                if (otherValue2 >= 0L) {
                    return 1;
                }
                return value2 > otherValue2 ? 1 : -1;
            }
            if (otherValue2 < 0L) {
                return -1;
            }
            return value2 > otherValue2 ? 1 : -1;
        }
        if (value1 < 0L) {
            if (otherValue1 >= 0L) {
                return 1;
            }
            return value1 > otherValue1 ? 1 : -1;
        }
        if (otherValue1 < 0L) {
            return -1;
        }
        return value1 > otherValue1 ? 1 : -1;
    }

    @Override
    public int compareTo(SerialBytes o) {
        return SerialBytes.compare(this._$2, this._$1, o._$2, o._$1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SerialBytes) {
            return this.equals((SerialBytes)obj);
        }
        return false;
    }

    public long getValue1() {
        return this._$2;
    }

    public long getValue2() {
        return this._$1;
    }

    public boolean equals(SerialBytes other) {
        return this._$2 == other._$2 && this._$1 == other._$1;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this._$2);
        out.writeLong(this._$1);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._$2 = in.readLong();
        this._$1 = in.readLong();
    }

    static {
        String str = "";
        for (int i = 0; i < 16; ++i) {
            SerialBytes._$3[i] = str;
            str = str + '0';
        }
    }
}

