/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.array.IArray;
import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.IntArrayList;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DataStruct;
import com.scudata.dm.HashIndexTable;
import com.scudata.dm.IndexTable;
import com.scudata.dm.Record;
import com.scudata.dm.SeqIndexTable;
import com.scudata.dm.Sequence;
import com.scudata.dm.SortIndexTable;
import com.scudata.dm.TimeIndexTable;
import com.scudata.dm.comparator.RecordFieldComparator;
import com.scudata.dm.lllIlIIllIlIIIII;
import com.scudata.dw.MemoryTable;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.MultithreadUtil;
import com.scudata.util.Variant;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

public class Table
extends Sequence {
    private static final long serialVersionUID = 33619972L;
    protected DataStruct ds;
    protected transient IndexTable indexTable;

    public Table() {
    }

    protected Table(boolean createArray) {
        super(createArray);
    }

    public Table(String[] fields) {
        this(new DataStruct(fields));
    }

    public Table(DataStruct ds) {
        this.ds = ds;
    }

    public Table(String[] fields, int initialCapacity) {
        this(new DataStruct(fields), initialCapacity);
    }

    public Table(DataStruct ds, int initialCapacity) {
        super(initialCapacity);
        this.ds = ds;
    }

    public Table(Table src) {
        super(src.length());
        DataStruct ds;
        this.ds = ds = src.dataStruct();
        int len = src.length();
        for (int i = 1; i <= len; ++i) {
            BaseRecord rec = src.getRecord(i);
            this.newLast(rec.getFieldValues());
        }
    }

    public int hashCode() {
        return this.mems.hashCode();
    }

    public boolean hasRecord() {
        return true;
    }

    public void add(Object val) {
        if (!(val instanceof BaseRecord) || ((BaseRecord)val).dataStruct() != this.ds) {
            throw new RQException("'add' function is unimplemented in Table!");
        }
        this.mems.add(val);
    }

    public void insert(int pos, Object val) {
        if (!(val instanceof BaseRecord) || ((BaseRecord)val).dataStruct() != this.ds) {
            throw new RQException("'insert' function is unimplemented in Table!");
        }
        super.insert(pos, val);
    }

    public void set(int pos, Object val) {
        if (!(val instanceof BaseRecord) || ((BaseRecord)val).dataStruct() != this.ds) {
            throw new RQException("'set' function is unimplemented in Table!");
        }
        super.set(pos, val);
    }

    public Object modify(int pos, Object val, String opt) {
        throw new RQException("'modify' function is unimplemented in Table!");
    }

    public BaseRecord getRecord(int pos) {
        if (pos < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos + mm.getMessage("engine.indexOutofBound"));
        }
        if (pos > this.length()) {
            this.insert(pos);
        }
        return (BaseRecord)this.mems.get(pos);
    }

    public BaseRecord newLast() {
        Record r = new Record(this.ds);
        this.mems.add(r);
        return r;
    }

    public BaseRecord newLast(Object[] initVals) {
        Record r = new Record(this.ds, initVals);
        this.mems.add(r);
        return r;
    }

    public DataStruct dataStruct() {
        return this.ds;
    }

    public Table create() {
        Table table = new Table(this.ds);
        return table;
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputRecord out = new ByteArrayOutputRecord();
        out.writeRecord(this.ds);
        IArray mems = this.getMems();
        int len = mems.size();
        out.writeInt(len);
        for (int i = 1; i <= len; ++i) {
            Record r = (Record)mems.get(i);
            out.writeRecord(r);
        }
        return out.toByteArray();
    }

    public void fillRecord(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputRecord in = new ByteArrayInputRecord(buf);
        this.ds = (DataStruct)in.readRecord(new DataStruct());
        int len = in.readInt();
        this.insert(0, len, null);
        IArray mems = this.getMems();
        for (int i = 1; i <= len; ++i) {
            Record r = (Record)mems.get(i);
            in.readRecord(r);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(1);
        out.writeObject(this.ds);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        in.readByte();
        this.ds = (DataStruct)in.readObject();
    }

    public boolean isPmt() {
        return true;
    }

    public boolean isPurePmt() {
        return true;
    }

    public boolean isTrue(int index) {
        return true;
    }

    public Table fieldsValues(String[] fieldNames) {
        IArray mems = this.getMems();
        int len = mems.size();
        int newCount = fieldNames.length;
        int[] index = new int[newCount];
        String[] newNames = new String[newCount];
        for (int i = 0; i < newCount; ++i) {
            int q = this.ds.getFieldIndex(fieldNames[i]);
            if (q < 0) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(fieldNames[i] + mm.getMessage("ds.fieldNotExist"));
            }
            index[i] = q;
            newNames[i] = this.ds.getFieldName(q);
        }
        Table table = new Table(newNames, len);
        for (int i = 1; i <= len; ++i) {
            BaseRecord nr = table.newLast();
            Record r = (Record)mems.get(i);
            for (int f = 0; f < newCount; ++f) {
                nr.setNormalFieldValue(f, r.getFieldValue(index[f]));
            }
        }
        return table;
    }

    public void alter(String[] fields) {
        DataStruct oldDs = this.ds;
        int newCount = fields.length;
        int[] index = new int[newCount];
        for (int i = 0; i < newCount; ++i) {
            index[i] = oldDs.getFieldIndex(fields[i]);
            if (index[i] == -1) continue;
            fields[i] = oldDs.getFieldName(index[i]);
        }
        DataStruct newDs = oldDs.create(fields);
        IArray mems = this.getMems();
        Object[] newValues = new Object[newCount];
        int len = mems.size();
        for (int i = 1; i <= len; ++i) {
            Record r = (Record)mems.get(i);
            for (int c = 0; c < newCount; ++c) {
                newValues[c] = index[c] == -1 ? null : r.getFieldValue(index[c]);
            }
            r._$1(newDs, newValues);
        }
        this.ds = newDs;
    }

    public void alter(String[] fields, String[] oldFields) {
        int i;
        boolean isSame;
        if (fields == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("alter" + mm.getMessage("function.paramValNull"));
        }
        DataStruct oldDs = this.ds;
        int newCount = fields.length;
        int[] index = new int[newCount];
        boolean bl = isSame = newCount == oldDs.getFieldCount();
        if (oldFields == null) {
            for (i = 0; i < newCount; ++i) {
                index[i] = oldDs.getFieldIndex(fields[i]);
                if (index[i] == i) continue;
                isSame = false;
            }
        } else {
            for (i = 0; i < newCount; ++i) {
                if (oldFields[i] == null) {
                    index[i] = oldDs.getFieldIndex(fields[i]);
                    if (index[i] == i) continue;
                    isSame = false;
                    continue;
                }
                index[i] = oldDs.getFieldIndex(oldFields[i]);
                if (index[i] == i && oldFields[i].equals(fields[i])) continue;
                isSame = false;
            }
        }
        if (isSame) {
            return;
        }
        DataStruct newDs = oldDs.create(fields);
        IArray mems = this.getMems();
        Object[] newValues = new Object[newCount];
        int len = mems.size();
        for (int i2 = 1; i2 <= len; ++i2) {
            Record r = (Record)mems.get(i2);
            for (int c = 0; c < newCount; ++c) {
                newValues[c] = index[c] == -1 ? null : r.getFieldValue(index[c]);
            }
            r._$1(newDs, newValues);
        }
        this.ds = newDs;
    }

    public void rename(String[] srcFields, String[] newFields) {
        this.ds.rename(srcFields, newFields);
    }

    public boolean isEquals(Sequence table) {
        return table == this;
    }

    public int count() {
        return this.getMems().size();
    }

    public int icount(String opt) {
        return this.getMems().size();
    }

    public Sequence id(String opt) {
        return this;
    }

    public int cmp(Sequence table) {
        return table == this ? 0 : -1;
    }

    public int compareTo(Sequence table) {
        return table == this ? 0 : -1;
    }

    public BaseRecord insert(int pos) {
        if (pos == 0) {
            return this.newLast();
        }
        IArray mems = this.getMems();
        int oldCount = mems.size();
        if (pos < 0) {
            if ((pos += oldCount + 1) < 1) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(pos - oldCount - 1 + mm.getMessage("engine.indexOutofBound"));
            }
            Record r = new Record(this.ds);
            mems.insert(pos, r);
            return r;
        }
        if (pos > oldCount) {
            int count = pos - oldCount;
            Object[] rs = new Record[count];
            for (int i = 0; i < count; ++i) {
                rs[i] = new Record(this.ds);
            }
            mems.addAll(rs);
            return rs[count - 1];
        }
        Record r = new Record(this.ds);
        mems.insert(pos, r);
        return r;
    }

    public BaseRecord insert(int pos, Object[] values) {
        if (pos == 0) {
            return this.newLast(values);
        }
        if (pos < 0 && (pos += this.mems.size() + 1) < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos - this.mems.size() - 1 + mm.getMessage("engine.indexOutofBound"));
        }
        Record r = new Record(this.ds, values);
        this.mems.insert(pos, r);
        return r;
    }

    public Sequence insert(int pos, int count, String opt) {
        IArray mems = this.getMems();
        int oldCount = mems.size();
        if (pos < 0 && (pos += oldCount + 1) < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos - oldCount - 1 + mm.getMessage("engine.indexOutofBound"));
        }
        boolean returnNew = opt != null && opt.indexOf(110) != -1;
        Sequence result = returnNew ? new Sequence(count) : this;
        if (count < 1) {
            return result;
        }
        int last = oldCount + 1;
        if (pos == 0) {
            pos = last;
        } else if (pos > last) {
            count += pos - last;
            pos = last;
        }
        DataStruct ds = this.ds;
        Object[] rs = new Record[count];
        for (int i = 0; i < count; ++i) {
            rs[i] = new Record(ds);
        }
        if (pos <= oldCount) {
            mems.insertAll(pos, rs);
        } else {
            mems.addAll(rs);
        }
        if (returnNew) {
            result.addAll(rs);
        }
        return result;
    }

    public void insert(int pos, Object[] values, String[] fields) {
        if (values == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("insert" + mm.getMessage("function.invalidParam"));
        }
        if (pos == 0) {
            this.newLast();
            this.modify(this.length(), values, fields);
        } else if (pos < 0 && (pos += this.mems.size() + 1) < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos - this.mems.size() - 1 + mm.getMessage("engine.indexOutofBound"));
        }
        this.insert(pos);
        this.modify(pos, values, fields);
    }

    public BaseRecord insert(int pos, Expression[] exps, String[] fields, Context ctx) {
        if (exps == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("insert" + mm.getMessage("function.invalidParam"));
        }
        if (pos == 0) {
            this.newLast();
            return this.modify(this.length(), exps, fields, ctx);
        }
        if (pos < 0 && (pos += this.mems.size() + 1) < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos - this.mems.size() - 1 + mm.getMessage("engine.indexOutofBound"));
        }
        this.insert(pos);
        return this.modify(pos, exps, fields, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseRecord sortedInsert(Expression[] exps, String[] fields, Context ctx) {
        int index;
        Record r = new Record(this.ds);
        ComputeStack stack = ctx.getComputeStack();
        stack.push(r);
        try {
            int count = exps.length;
            if (fields == null) {
                for (int i = 0; i < count; ++i) {
                    if (exps[i] == null) continue;
                    r.set(i, exps[i].calculate(ctx));
                }
            } else {
                if (fields.length != count) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("insert" + mm.getMessage("function.invalidParam"));
                }
                int prevIndex = -1;
                for (int i = 0; i < count; ++i) {
                    if (fields[i] == null) {
                        ++prevIndex;
                    } else {
                        prevIndex = r.getFieldIndex(fields[i]);
                        if (prevIndex < 0) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(fields[i] + mm.getMessage("ds.fieldNotExist"));
                        }
                    }
                    r.set(prevIndex, exps[i].calculate(ctx));
                }
            }
        }
        finally {
            stack.pop();
        }
        if ((index = this.pfindByKey(r.getPKValue(), true)) < 0) {
            this.mems.insert(-index, r);
            return r;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence sortedInsert(Sequence src, Expression[] exps, String[] fields, String opt, Context ctx) {
        int i;
        int count = exps.length;
        int fcount = this.ds.getFieldCount();
        if (count == 0 || count > fcount) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("insert" + mm.getMessage("function.invalidParam"));
        }
        int mlen = src.length();
        boolean returnNew = opt != null && opt.indexOf(110) != -1;
        Sequence result = returnNew ? new Sequence(mlen) : this;
        if (mlen == 0) {
            return result;
        }
        int[] index = new int[count];
        if (fields != null) {
            if (fields.length != count) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("insertfunction.paramCountNotMatch"));
            }
            for (i = 0; i < count; ++i) {
                if (fields[i] == null) {
                    if (i == 0) {
                        index[i] = 0;
                        continue;
                    }
                    index[i] = index[i - 1] + 1;
                    if (index[i] != fcount) continue;
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("insert" + mm.getMessage("function.invalidParam"));
                }
                index[i] = this.ds.getFieldIndex(fields[i]);
                if (index[i] >= 0) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException(fields[i] + mm.getMessage("ds.fieldNotExist"));
            }
        } else {
            for (i = 0; i < count; ++i) {
                index[i] = i;
            }
        }
        DataStruct ds = this.ds;
        Record r = new Record(ds);
        ComputeStack stack = ctx.getComputeStack();
        Current srcCurrent = new Current(src);
        stack.push(r);
        stack.push(srcCurrent);
        try {
            for (int i2 = 1; i2 <= mlen; ++i2) {
                srcCurrent.setCurrent(i2);
                for (int c = 0; c < count; ++c) {
                    if (exps[c] == null) continue;
                    r.setNormalFieldValue(index[c], exps[c].calculate(ctx));
                }
                int p = this.pfindByKey(r.getPKValue(), true);
                if (p >= 0) continue;
                Record tmp = new Record(ds);
                tmp.set(r);
                this.mems.insert(-p, tmp);
                if (!returnNew) continue;
                result.add(tmp);
            }
        }
        finally {
            stack.pop();
            stack.pop();
        }
        return result;
    }

    public Sequence sortedInsert(Sequence src, String opt) {
        boolean isName = false;
        boolean returnNew = false;
        if (opt != null) {
            if (opt.indexOf(102) != -1) {
                isName = true;
            }
            if (opt.indexOf(110) != -1) {
                returnNew = true;
            }
        }
        if (src == null || src.length() == 0) {
            if (returnNew) {
                return new Sequence(0);
            }
            return this;
        }
        IArray srcMems = src.getMems();
        int count = srcMems.size();
        if (!src.isPmt()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPmt"));
        }
        DataStruct ds = this.ds;
        Sequence result = returnNew ? new Sequence(count) : this;
        if (isName) {
            Record prev = null;
            int sameCount = 0;
            int[] srcIndex = null;
            int[] index = null;
            for (int i = 1; i <= count; ++i) {
                int p;
                Record sr = (Record)srcMems.get(i);
                if (sr == null) continue;
                Record r = new Record(ds);
                if (prev != null && prev.isSameDataStruct(sr)) {
                    for (int c = 0; c < sameCount; ++c) {
                        r.setNormalFieldValue((int)index[c], sr.getFieldValue(srcIndex[c]));
                    }
                } else {
                    String[] srcNames = sr.dataStruct().getFieldNames();
                    int colCount = srcNames.length;
                    prev = sr;
                    sameCount = 0;
                    srcIndex = new int[colCount];
                    index = new int[colCount];
                    for (int c = 0; c < colCount; ++c) {
                        int tmp = ds.getFieldIndex(srcNames[c]);
                        if (tmp < 0) continue;
                        r.setNormalFieldValue(tmp, sr.getFieldValue(c));
                        srcIndex[sameCount] = c;
                        index[sameCount] = tmp;
                        ++sameCount;
                    }
                }
                if ((p = this.pfindByKey(r.getPKValue(), true)) >= 0) continue;
                this.mems.insert(-p, r);
                if (!returnNew) continue;
                result.add(r);
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                BaseRecord sr = (BaseRecord)srcMems.get(i);
                Record r = new Record(ds);
                r.paste(sr, false);
                int p = this.pfindByKey(r.getPKValue(), true);
                if (p >= 0) continue;
                this.mems.insert(-p, r);
                if (!returnNew) continue;
                result.add(r);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence insert(int pos, Sequence src, Expression[] exps, Expression[] optExps, String[] fields, String opt, Context ctx) {
        int i;
        if (src == null || exps == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("insert" + mm.getMessage("function.invalidParam"));
        }
        IArray mems = this.getMems();
        if (pos == 0) {
            pos = mems.size() + 1;
        } else if (pos < 0 && (pos += mems.size() + 1) < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos - mems.size() - 1 + mm.getMessage("engine.indexOutofBound"));
        }
        int count = exps.length;
        if (optExps == null) {
            optExps = new Expression[count];
        }
        int fcount = this.ds.getFieldCount();
        if (count == 0 || count > fcount) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("insert" + mm.getMessage("function.invalidParam"));
        }
        int mlen = src.length();
        boolean returnNew = opt != null && opt.indexOf(110) != -1;
        Sequence result = returnNew ? new Sequence(mlen) : this;
        if (mlen == 0) {
            return result;
        }
        int[] index = new int[count];
        if (fields != null) {
            if (fields.length != count) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("insertfunction.paramCountNotMatch"));
            }
            for (i = 0; i < count; ++i) {
                if (fields[i] == null) {
                    if (i == 0) {
                        index[i] = 0;
                        continue;
                    }
                    index[i] = index[i - 1] + 1;
                    if (index[i] != fcount) continue;
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("insert" + mm.getMessage("function.invalidParam"));
                }
                index[i] = this.ds.getFieldIndex(fields[i]);
                if (index[i] >= 0) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException(fields[i] + mm.getMessage("ds.fieldNotExist"));
            }
        } else {
            for (i = 0; i < count; ++i) {
                index[i] = i;
            }
        }
        this.insert(pos, mlen, null);
        Object[] values = new Object[count];
        Object[] lastOptVals = new Object[count];
        for (int i2 = 0; i2 < count; ++i2) {
            lastOptVals[i2] = new Object();
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        Current srcCurrent = new Current(src);
        stack.push(srcCurrent);
        try {
            int i3 = 1;
            while (i3 <= mlen) {
                BaseRecord r = (BaseRecord)mems.get(pos);
                if (returnNew) {
                    result.add(r);
                }
                current.setCurrent(pos);
                srcCurrent.setCurrent(i3);
                for (int c = 0; c < count; ++c) {
                    if (optExps[c] == null) {
                        if (exps[c] == null) continue;
                        r.setNormalFieldValue(index[c], exps[c].calculate(ctx));
                        continue;
                    }
                    Object optVal = optExps[c].calculate(ctx);
                    if (!Variant.isEquals(optVal, lastOptVals[c])) {
                        lastOptVals[c] = optVal;
                        if (exps[c] != null) {
                            values[c] = exps[c].calculate(ctx);
                        }
                    }
                    r.setNormalFieldValue(index[c], values[c]);
                }
                ++i3;
                ++pos;
            }
        }
        finally {
            stack.pop();
            stack.pop();
        }
        return result;
    }

    public void insert(int pos, Table table) {
        if (table == null || table.length() == 0) {
            return;
        }
        IArray mems = this.getMems();
        int oldCount = mems.size();
        if (pos == 0) {
            pos = oldCount + 1;
        } else if (pos < 0 && (pos += oldCount + 1) < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos - oldCount - 1 + mm.getMessage("engine.indexOutofBound"));
        }
        if (table.ds.getFieldCount() != this.ds.getFieldCount()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dsNotMatch"));
        }
        IArray addMems = table.getMems();
        int addCount = addMems.size();
        DataStruct ds = this.ds;
        for (int i = 1; i <= addCount; ++i) {
            Record r = (Record)addMems.get(i);
            r.setDataStruct(ds);
        }
        if (pos > oldCount) {
            this.insert(oldCount + 1, pos - oldCount - 1, null);
        }
        mems.insertAll(pos, addMems);
        addMems.clear();
    }

    public Sequence append(Sequence seq) {
        DataStruct ds = this.ds;
        DataStruct ds2 = seq.dataStruct();
        if (ds2 == ds) {
            this.getMems().addAll(seq.getMems());
            return this;
        }
        if (ds2 != null && ds2.isCompatible(ds2)) {
            IArray mems = this.getMems();
            IArray addMems = seq.getMems();
            int addCount = addMems.size();
            for (int i = 1; i <= addCount; ++i) {
                Record r = (Record)addMems.get(i);
                r.setDataStruct(ds);
            }
            mems.addAll(addMems);
            return this;
        }
        Sequence result = new Sequence(this.length() + seq.length());
        result.addAll(this);
        result.addAll(seq);
        return result;
    }

    public void append(Table table, String opt) {
        int i;
        if (table == null) {
            return;
        }
        if (table.ds.getFieldCount() != this.ds.getFieldCount()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dsNotMatch"));
        }
        IArray addMems = table.getMems();
        IArray mems = this.getMems();
        int oldCount = mems.size();
        if (opt != null && opt.indexOf(112) != -1 && this.getPrimary() != null) {
            IntArrayList posArray = new IntArrayList();
            for (i = 1; i <= oldCount; ++i) {
                int pos = table.pfindByKey(((BaseRecord)mems.get(i)).getPKValue(), false);
                if (pos <= 0) continue;
                posArray.addInt(i);
            }
            int delCount = posArray.size();
            if (delCount > 0) {
                int[] index = posArray.toIntArray();
                mems.remove(index);
                oldCount = mems.size();
            }
        }
        DataStruct ds = this.ds;
        int addCount = addMems.size();
        for (i = 1; i <= addCount; ++i) {
            Record r = (Record)addMems.get(i);
            r.setDataStruct(ds);
        }
        mems.addAll(addMems);
        addMems.clear();
    }

    public void append(Table[] tables, String opt) {
        if (tables == null || tables.length == 0) {
            return;
        }
        if (opt != null && opt.indexOf(112) != -1 && this.getPrimary() != null) {
            int len = tables.length;
            for (int i = 0; i < len; ++i) {
                this.append(tables[i], opt);
            }
            return;
        }
        int fcount = this.ds.getFieldCount();
        int total = 0;
        int len = tables.length;
        for (int i = 0; i < len; ++i) {
            Table table = tables[i];
            if (table == null) continue;
            if (table.ds.getFieldCount() != fcount) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.dsNotMatch"));
            }
            total += table.length();
        }
        IArray mems = this.getMems();
        mems.ensureCapacity(mems.size() + total);
        DataStruct ds = this.ds;
        for (Table table : tables) {
            if (table == null) continue;
            IArray addMems = table.getMems();
            int addCount = addMems.size();
            for (int m = 1; m <= addCount; ++m) {
                Record r = (Record)addMems.get(m);
                r.setDataStruct(ds);
            }
            mems.addAll(addMems);
            addMems.clear();
        }
    }

    public Sequence split(int from, int to) {
        if (from < 1 || to < from || to > this.length()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(from + ":" + to + mm.getMessage("engine.indexOutofBound"));
        }
        Table table = new Table(this.ds, to - from + 1);
        IArray resultMems = table.getMems();
        IArray mems = this.getMems();
        for (int i = from; i <= to; ++i) {
            resultMems.push(mems.get(i));
        }
        mems.removeRange(from, to);
        return table;
    }

    public void modify(int pos, Object[] values, String[] fields) {
        if (values == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("modify" + mm.getMessage("function.invalidParam"));
        }
        if (pos == 0) {
            pos = this.length() + 1;
        } else if (pos < 0 && (pos += this.length() + 1) < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos - this.length() - 1 + mm.getMessage("engine.indexOutofBound"));
        }
        BaseRecord r = this.getRecord(pos);
        if (fields == null) {
            r.setStart(0, values);
        } else {
            int count = values.length;
            if (fields.length != count) {
                MessageManager mm = EngineMessage.get();
                throw new RQException("modify" + mm.getMessage("function.invalidParam"));
            }
            int prevIndex = -1;
            for (int i = 0; i < count; ++i) {
                if (fields[i] == null) {
                    ++prevIndex;
                } else {
                    prevIndex = r.getFieldIndex(fields[i]);
                    if (prevIndex < 0) {
                        MessageManager mm = EngineMessage.get();
                        throw new RQException(fields[i] + mm.getMessage("ds.fieldNotExist"));
                    }
                }
                r.set(prevIndex, values[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseRecord modify(int pos, Expression[] exps, String[] fields, Context ctx) {
        if (exps == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("modify" + mm.getMessage("function.invalidParam"));
        }
        if (pos == 0) {
            pos = this.length() + 1;
        } else if (pos < 0 && (pos += this.length() + 1) < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos - this.length() - 1 + mm.getMessage("engine.indexOutofBound"));
        }
        BaseRecord r = this.getRecord(pos);
        int count = exps.length;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            current.setCurrent(pos);
            if (fields == null) {
                for (int i = 0; i < count; ++i) {
                    if (exps[i] == null) continue;
                    r.set(i, exps[i].calculate(ctx));
                }
            } else {
                if (fields.length != count) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("modify" + mm.getMessage("function.invalidParam"));
                }
                int prevIndex = -1;
                for (int i = 0; i < count; ++i) {
                    if (fields[i] == null) {
                        ++prevIndex;
                    } else {
                        prevIndex = r.getFieldIndex(fields[i]);
                        if (prevIndex < 0) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(fields[i] + mm.getMessage("ds.fieldNotExist"));
                        }
                    }
                    r.set(prevIndex, exps[i].calculate(ctx));
                }
            }
        }
        finally {
            stack.pop();
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence modify(int pos, Sequence src, Expression[] exps, Expression[] optExps, String[] fields, String opt, Context ctx) {
        int i;
        if (src == null || exps == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("modify" + mm.getMessage("function.invalidParam"));
        }
        if (pos == 0) {
            pos = this.length() + 1;
        } else if (pos < 0 && (pos += this.length() + 1) < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos - this.length() - 1 + mm.getMessage("engine.indexOutofBound"));
        }
        int count = exps.length;
        if (optExps == null) {
            optExps = new Expression[count];
        }
        int fcount = this.ds.getFieldCount();
        if (count == 0 || count > fcount) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("modify" + mm.getMessage("function.invalidParam"));
        }
        int mlen = src.length();
        boolean returnNew = opt != null && opt.indexOf(110) != -1;
        Sequence result = returnNew ? new Sequence(mlen) : this;
        if (mlen == 0) {
            return result;
        }
        int[] index = new int[count];
        if (fields != null) {
            if (fields.length != count) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("modifyfunction.paramCountNotMatch"));
            }
            for (i = 0; i < count; ++i) {
                if (fields[i] == null) {
                    if (i == 0) {
                        index[i] = 0;
                        continue;
                    }
                    index[i] = index[i - 1] + 1;
                    if (index[i] != fcount) continue;
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("insert" + mm.getMessage("function.invalidParam"));
                }
                index[i] = this.ds.getFieldIndex(fields[i]);
                if (index[i] >= 0) continue;
                MessageManager mm = EngineMessage.get();
                throw new RQException(fields[i] + mm.getMessage("ds.fieldNotExist"));
            }
        } else {
            for (i = 0; i < count; ++i) {
                index[i] = i;
            }
        }
        int last = pos + mlen - 1;
        this.getRecord(last);
        Object[] values = new Object[count];
        Object[] lastOptVals = new Object[count];
        for (int i2 = 0; i2 < count; ++i2) {
            lastOptVals[i2] = new Object();
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        Current srcCurrent = new Current(src);
        stack.push(srcCurrent);
        try {
            IArray mems = this.getMems();
            int i3 = 1;
            while (i3 <= mlen) {
                BaseRecord r = (BaseRecord)mems.get(pos);
                if (returnNew) {
                    result.add(r);
                }
                current.setCurrent(pos);
                srcCurrent.setCurrent(i3);
                for (int c = 0; c < count; ++c) {
                    if (optExps[c] == null) {
                        if (exps[c] != null) {
                            r.setNormalFieldValue(index[c], exps[c].calculate(ctx));
                            continue;
                        }
                        r.setNormalFieldValue(index[c], null);
                        continue;
                    }
                    Object optVal = optExps[c].calculate(ctx);
                    if (!Variant.isEquals(optVal, lastOptVals[c])) {
                        lastOptVals[c] = optVal;
                        if (exps[c] != null) {
                            values[c] = exps[c].calculate(ctx);
                        }
                    }
                    r.setNormalFieldValue(index[c], values[c]);
                }
                ++i3;
                ++pos;
            }
        }
        finally {
            stack.pop();
            stack.pop();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Expression[] assignExps, Expression[] exps, String opt, Context ctx) {
        if (opt != null) {
            if (opt.indexOf(109) != -1) {
                MultithreadUtil.run(this, assignExps, exps, ctx);
            } else if (opt.indexOf(122) != -1) {
                int colCount = exps.length;
                int[] fields = new int[colCount];
                for (int i = 0; i < colCount; ++i) {
                    if (assignExps[i] != null) {
                        fields[i] = assignExps[i].getFieldIndex(this.ds);
                        if (fields[i] != -1) continue;
                    }
                    super.run(assignExps, exps, ctx);
                    return;
                }
                ComputeStack stack = ctx.getComputeStack();
                Current current = new Current(this);
                stack.push(current);
                IArray mems = this.getMems();
                try {
                    for (int i = this.length(); i > 0; --i) {
                        current.setCurrent(i);
                        BaseRecord r = (BaseRecord)mems.get(i);
                        for (int c = 0; c < colCount; ++c) {
                            r.setNormalFieldValue(fields[c], exps[c].calculate(ctx));
                        }
                    }
                }
                finally {
                    stack.pop();
                }
            } else {
                this.run(assignExps, exps, ctx);
            }
        } else {
            this.run(assignExps, exps, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Expression[] assignExps, Expression[] exps, Context ctx) {
        int colCount = exps.length;
        int[] fields = new int[colCount];
        for (int i = 0; i < colCount; ++i) {
            if (assignExps[i] != null) {
                fields[i] = assignExps[i].getFieldIndex(this.ds);
                if (fields[i] != -1) continue;
            }
            super.run(assignExps, exps, ctx);
            return;
        }
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        IArray mems = this.getMems();
        try {
            int len = this.length();
            for (int i = 1; i <= len; ++i) {
                current.setCurrent(i);
                BaseRecord r = (BaseRecord)mems.get(i);
                for (int c = 0; c < colCount; ++c) {
                    r.setNormalFieldValue(fields[c], exps[c].calculate(ctx));
                }
            }
        }
        finally {
            stack.pop();
        }
    }

    public Sequence record(int pos, Sequence src, String opt) {
        if (pos < 0 || src == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("record" + mm.getMessage("function.invalidParam"));
        }
        int fieldCount = this.ds.getFieldCount();
        IArray srcMems = src.getMems();
        int srcSize = srcMems.size();
        int recordCount = srcSize / fieldCount;
        int mod = srcSize % fieldCount;
        if (mod != 0) {
            ++recordCount;
        }
        boolean isInsert = false;
        boolean returnNew = false;
        if (opt != null) {
            if (opt.indexOf(105) != -1) {
                isInsert = true;
            }
            if (opt.indexOf(110) != -1) {
                returnNew = true;
            }
        }
        Sequence result = returnNew ? new Sequence(recordCount) : this;
        if (recordCount == 0) {
            return result;
        }
        IArray mems = this.getMems();
        if (pos == 0) {
            pos = mems.size() + 1;
        }
        if (isInsert) {
            this.insert(pos, recordCount, null);
        } else {
            this.getRecord(pos + recordCount - 1);
        }
        if (mod == 0) {
            int seq = 1;
            int last = pos + recordCount;
            for (int i = pos; i < last; ++i) {
                BaseRecord r = (BaseRecord)mems.get(i);
                if (returnNew) {
                    result.add(r);
                }
                for (int f = 0; f < fieldCount; ++f) {
                    r.setNormalFieldValue(f, srcMems.get(seq++));
                }
            }
        } else {
            int seq = 1;
            int last = pos + recordCount - 1;
            for (int i = pos; i < last; ++i) {
                BaseRecord r = (BaseRecord)mems.get(i);
                if (returnNew) {
                    result.add(r);
                }
                for (int f = 0; f < fieldCount; ++f) {
                    r.setNormalFieldValue(f, srcMems.get(seq++));
                }
            }
            BaseRecord r = (BaseRecord)mems.get(last);
            if (returnNew) {
                result.add(r);
            }
            int f = 0;
            while (seq <= srcSize) {
                r.setNormalFieldValue(f, srcMems.get(seq++));
                ++f;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Expression[] assignExps, Expression[] exps, String opt, Context ctx, Sequence[] syncSequences) {
        int i;
        int colCount = exps.length;
        int[] fields = new int[colCount];
        for (int i2 = 0; i2 < colCount; ++i2) {
            if (assignExps[i2] != null) {
                fields[i2] = assignExps[i2].getFieldIndex(this.ds);
                if (fields[i2] != -1) continue;
            }
            super.run(assignExps, exps, opt, ctx, syncSequences);
            return;
        }
        IArray mems = this.getMems();
        int syncCount = syncSequences.length;
        ComputeStack stack = ctx.getComputeStack();
        Current[] currents = new Current[syncCount + 1];
        currents[0] = new Current(this);
        stack.push(currents[0]);
        for (i = 1; i <= syncCount; ++i) {
            currents[i] = new Current(syncSequences[i - 1]);
            stack.push(currents[i]);
        }
        try {
            int len = this.length();
            for (i = 1; i <= len; ++i) {
                for (Current current : currents) {
                    current.setCurrent(i);
                }
                BaseRecord r = (BaseRecord)mems.get(i);
                for (int c = 0; c < colCount; ++c) {
                    r.setNormalFieldValue(fields[c], exps[c].calculate(ctx));
                }
            }
        }
        finally {
            for (i = 0; i <= syncCount; ++i) {
                stack.pop();
            }
        }
    }

    public void paste(Sequence[] vals, String[] fields, int pos, String opt) {
        boolean isInsert;
        if (pos < 0) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos + mm.getMessage("engine.indexOutofBound"));
        }
        IArray mems = this.getMems();
        int maxLen = 0;
        for (Sequence seq : vals) {
            if (seq == null || seq.length() <= maxLen) continue;
            maxLen = seq.length();
        }
        boolean bl = isInsert = opt != null && opt.indexOf(105) != -1;
        if (pos == 0) {
            pos = mems.size() + 1;
            isInsert = true;
        }
        if (isInsert) {
            this.insert(pos, maxLen, null);
        } else if (pos > mems.size()) {
            return;
        }
        int len = mems.size() - pos + 1;
        int prevField = -1;
        int fcount = vals.length;
        for (int f = 0; f < fcount; ++f) {
            if (vals[f] == null) continue;
            IArray valMems = vals[f].getMems();
            int curLen = valMems.size();
            if (curLen > len) {
                curLen = len;
            }
            if (fields == null || fields[f] == null) {
                if (++prevField >= this.ds.getFieldCount()) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(f + mm.getMessage("ds.fieldNotExist"));
                }
            } else {
                prevField = this.ds.getFieldIndex(fields[f]);
                if (prevField < 0) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(fields[f] + mm.getMessage("ds.fieldNotExist"));
                }
            }
            int i = 1;
            int j = pos;
            while (i <= curLen) {
                BaseRecord r = (BaseRecord)mems.get(j);
                r.setNormalFieldValue(prevField, valMems.get(i));
                ++i;
                ++j;
            }
        }
    }

    protected int pos(Object obj) {
        IArray mems = this.getMems();
        int size = mems.size();
        for (int i = 1; i <= size; ++i) {
            if (mems.get(i) != obj) continue;
            return i;
        }
        return 0;
    }

    public Sequence delete(Sequence sequence, String opt) {
        int i;
        if (sequence == null || sequence.length() == 0) {
            if (opt == null || opt.indexOf(110) == -1) {
                return this;
            }
            return new Sequence(0);
        }
        int srcCount = this.length();
        int[] index = sequence.toIndexArray(srcCount);
        int delCount = 0;
        if (index == null) {
            IArray delMems = sequence.getMems();
            int count = delMems.size();
            index = new int[count];
            for (i = 1; i <= count; ++i) {
                int seq;
                Object obj = delMems.get(i);
                if (!(obj instanceof BaseRecord) || (seq = this.pos(obj)) <= 0) continue;
                index[delCount] = seq;
                ++delCount;
            }
            if (delCount == 0) {
                if (opt == null || opt.indexOf(110) == -1) {
                    return this;
                }
                return new Sequence(0);
            }
            if (delCount < count) {
                int[] tmp = new int[delCount];
                System.arraycopy(index, 0, tmp, 0, delCount);
                index = tmp;
            }
            Arrays.sort(index);
        } else {
            delCount = index.length;
        }
        IArray mems = this.getMems();
        if (opt == null || opt.indexOf(110) == -1) {
            mems.remove(index);
            this.rebuildIndexTable();
            return this;
        }
        Sequence result = new Sequence(delCount);
        for (i = 0; i < delCount; ++i) {
            result.add(mems.get(index[i]));
        }
        mems.remove(index);
        this.rebuildIndexTable();
        return result;
    }

    public Sequence modify(int pos, Sequence src, boolean isInsert, String opt) {
        int i;
        Sequence result;
        IArray mems = this.getMems();
        if (pos == 0) {
            pos = mems.size() + 1;
        } else if (pos < 0 && (pos += mems.size() + 1) < 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(pos - mems.size() - 1 + mm.getMessage("engine.indexOutofBound"));
        }
        boolean isName = false;
        boolean returnNew = false;
        if (opt != null) {
            if (opt.indexOf(102) != -1) {
                isName = true;
            }
            if (opt.indexOf(110) != -1) {
                returnNew = true;
            }
        }
        if (src == null || src.length() == 0) {
            if (returnNew) {
                return new Sequence(0);
            }
            return this;
        }
        IArray srcMems = src.getMems();
        int count = srcMems.size();
        if (!src.isPmt()) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPmt"));
        }
        if (isInsert) {
            this.insert(pos, count, null);
        } else {
            this.getRecord(pos + count - 1);
        }
        if (returnNew) {
            result = new Sequence(count);
            int end = pos + count;
            for (i = pos; i < end; ++i) {
                result.add(mems.get(i));
            }
        } else {
            result = this;
        }
        if (isName) {
            DataStruct ds = this.ds;
            BaseRecord prev = null;
            int sameCount = 0;
            int[] srcIndex = null;
            int[] index = null;
            int i2 = 1;
            while (i2 <= count) {
                BaseRecord sr = (BaseRecord)srcMems.get(i2);
                if (sr != null) {
                    BaseRecord r = (BaseRecord)mems.get(pos);
                    if (prev != null && prev.isSameDataStruct(sr)) {
                        for (int c = 0; c < sameCount; ++c) {
                            r.setNormalFieldValue((int)index[c], sr.getFieldValue(srcIndex[c]));
                        }
                    } else {
                        String[] srcNames = sr.dataStruct().getFieldNames();
                        int colCount = srcNames.length;
                        prev = sr;
                        sameCount = 0;
                        srcIndex = new int[colCount];
                        index = new int[colCount];
                        for (int c = 0; c < colCount; ++c) {
                            int tmp = ds.getFieldIndex(srcNames[c]);
                            if (tmp < 0) continue;
                            r.setNormalFieldValue(tmp, sr.getFieldValue(c));
                            srcIndex[sameCount] = c;
                            index[sameCount] = tmp;
                            ++sameCount;
                        }
                    }
                }
                ++i2;
                ++pos;
            }
        } else {
            i = 1;
            while (i <= count) {
                BaseRecord sr = (BaseRecord)srcMems.get(i);
                BaseRecord r = (BaseRecord)mems.get(pos);
                r.paste(sr, false);
                ++i;
                ++pos;
            }
        }
        return result;
    }

    public void setPrimary(String[] fields) {
        this.ds.setPrimary(fields);
        this.indexTable = null;
    }

    public void setPrimary(String[] fields, String opt) {
        this.ds.setPrimary(fields, opt);
        this.indexTable = null;
    }

    public void createIndexTable(String opt) {
        this.createIndexTable(this.length(), opt);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void createIndexTable(int capacity, String opt) {
        int[] fields = this.ds.getPKIndex();
        if (fields == null) {
            this.ds.setPrimary(null, opt);
            if (this.ds.isSeqKey()) {
                this.indexTable = new SeqIndexTable(this);
                return;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("ds.lessKey"));
        }
        if (this.ds.getTimeKeyCount() == 1) {
            this.indexTable = new TimeIndexTable(this, fields, capacity);
            return;
        }
        if (this.ds.isSeqKey()) {
            this.indexTable = new SeqIndexTable(this);
            return;
        }
        if (fields.length == 1 && opt != null && opt.indexOf(115) != -1) {
            lllIlIIllIlIIIII sbi = new lllIlIIllIlIIIII();
            sbi.create(this, fields[0]);
            this.indexTable = sbi;
            return;
        }
        if (opt != null && opt.indexOf(98) != -1) {
            this.indexTable = new SortIndexTable(this, fields);
            return;
        }
        this.indexTable = this.newIndexTable(fields, capacity, opt);
    }

    public void rebuildIndexTable() {
        if (this.indexTable != null) {
            if (this.indexTable instanceof HashIndexTable) {
                this.createIndexTable(((HashIndexTable)this.indexTable).getCapacity(), null);
            } else {
                this.createIndexTable("s");
            }
        }
    }

    public void setIndexTable(IndexTable indexTable) {
        this.indexTable = indexTable;
    }

    public IndexTable getIndexTable() {
        return this.indexTable;
    }

    public IndexTable getIndexTable(Expression exp, Context ctx) {
        if (exp == null) {
            return this.indexTable;
        }
        if (this.indexTable == null) {
            return null;
        }
        int[] index = this.ds.getPKIndex();
        if (index != null && index.length == 1 && index[0] == exp.getFieldIndex(this.ds)) {
            return this.indexTable;
        }
        return null;
    }

    public IndexTable getIndexTable(Expression[] exps, Context ctx) {
        if (exps == null) {
            return this.indexTable;
        }
        if (this.indexTable == null) {
            return null;
        }
        int keyCount = exps.length;
        int[] index = this.ds.getPKIndex();
        if (index == null || index.length != keyCount) {
            return null;
        }
        for (int i = 0; i < keyCount; ++i) {
            if (index[i] == exps[i].getFieldIndex(this.ds)) continue;
            return null;
        }
        return this.indexTable;
    }

    public void deleteIndexTable() {
        this.indexTable = null;
    }

    public String[] getPrimary() {
        return this.ds.getPrimary();
    }

    public void sortFields(int[] colIndex) {
        RecordFieldComparator comparator = new RecordFieldComparator(colIndex);
        this.mems.sort(comparator);
    }

    public boolean checkReference() {
        IArray mems = this.getMems();
        int len = mems.size();
        for (int i = 1; i <= len; ++i) {
            Record r = (Record)mems.get(i);
            if (!r.checkReference()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        IArray mems = this.getMems();
        int len = mems.size();
        if (len > 10) {
            len = 10;
        }
        StringBuffer sb = new StringBuffer(50 * len);
        String[] names = this.ds.getFieldNames();
        int fcount = names.length;
        int f = 0;
        while (true) {
            sb.append(names[f++]);
            if (f >= fcount) break;
            sb.append('\t');
        }
        sb.append("\r\n");
        for (int i = 1; i <= len; ++i) {
            BaseRecord r = (BaseRecord)mems.get(i);
            f = 0;
            while (true) {
                String str = Variant.toString(r.getFieldValue(f));
                sb.append(str);
                if (++f >= fcount) break;
                sb.append('\t');
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public boolean containField(String fieldName) {
        return this.ds.getFieldIndex(fieldName) != -1;
    }

    public int getFieldCount() {
        return this.ds.getFieldCount();
    }

    public DataStruct getFirstRecordDataStruct() {
        return this.ds;
    }

    public Sequence memory(String option) {
        Table srcTable = this;
        if (option != null && option.indexOf(111) != -1) {
            return new MemoryTable(srcTable);
        }
        Table table = srcTable.derive("o");
        return new MemoryTable(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table derive(String[] names, Expression[] exps, String opt, Context ctx) {
        if (opt == null || opt.indexOf(111) == -1) {
            return super.derive(names, exps, opt, ctx);
        }
        if (opt.indexOf(105) != -1) {
            Table table = super.derive(names, exps, opt, ctx);
            this.ds = table.ds;
            this.mems = table.mems;
            this.rebuildIndexTable();
            return this;
        }
        int addColCount = exps.length;
        for (int i = 0; i < addColCount; ++i) {
            if (names[i] == null || names[i].length() == 0) {
                if (exps[i] == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("derive" + mm.getMessage("function.invalidParam"));
                }
                names[i] = exps[i].getFieldName(this.ds);
                continue;
            }
            if (exps[i] != null) continue;
            exps[i] = Expression.NULL;
        }
        String[] oldNames = this.ds.getFieldNames();
        int oldColCount = oldNames.length;
        int newColCount = oldColCount + addColCount;
        String[] totalNames = new String[newColCount];
        System.arraycopy(oldNames, 0, totalNames, 0, oldColCount);
        System.arraycopy(names, 0, totalNames, oldColCount, addColCount);
        DataStruct newDs = this.ds.create(totalNames);
        IArray mems = this.getMems();
        int len = mems.size();
        for (int i = 1; i <= len; ++i) {
            Record r = (Record)mems.get(i);
            r.derive(newDs);
        }
        this.ds = newDs;
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this);
        stack.push(current);
        try {
            if (opt.indexOf(122) == -1) {
                for (int i = 1; i <= len; ++i) {
                    Record r = (Record)mems.get(i);
                    current.setCurrent(i);
                    for (int c = 0; c < addColCount; ++c) {
                        r.setNormalFieldValue(c + oldColCount, exps[c].calculate(ctx));
                    }
                }
            } else {
                for (int i = len; i > 0; --i) {
                    Record r = (Record)mems.get(i);
                    current.setCurrent(i);
                    for (int c = 0; c < addColCount; ++c) {
                        r.setNormalFieldValue(c + oldColCount, exps[c].calculate(ctx));
                    }
                }
            }
        }
        finally {
            stack.pop();
        }
        return this;
    }

    public void setDataStruct(DataStruct ds) {
        this.ds = ds;
    }
}

