/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.array.BoolArray;
import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.IndexTable;
import com.scudata.dm.ListBase1;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import com.scudata.util.HashUtil;
import com.scudata.util.Variant;

public class TimeIndexTable
extends IndexTable {
    private Sequence _$4;
    private HashUtil _$3;
    private ListBase1[] _$2;
    private int _$1;

    public TimeIndexTable(Sequence code, int[] fields, int capacity) {
        HashUtil hashUtil = new HashUtil(capacity);
        this._$4 = code;
        this._$3 = hashUtil;
        ListBase1[] groups = new ListBase1[hashUtil.getCapacity()];
        this._$2 = groups;
        int INIT_GROUPSIZE = HashUtil.getInitGroupSize();
        int totalKeyCount = fields.length;
        int keyCount = totalKeyCount - 1;
        this._$1 = totalKeyCount;
        int count = totalKeyCount + 1;
        int len = code.length();
        for (int i = 1; i <= len; ++i) {
            BaseRecord r = (BaseRecord)code.getMem(i);
            Object[] keys = new Object[count];
            for (int c = 0; c < totalKeyCount; ++c) {
                keys[c] = r.getNormalFieldValue(fields[c]);
            }
            keys[totalKeyCount] = i;
            int hash = hashUtil.hashCode(keys, keyCount);
            if (groups[hash] == null) {
                groups[hash] = new ListBase1(INIT_GROUPSIZE);
                groups[hash].add(keys);
                continue;
            }
            int index = HashUtil.bsearch_a(groups[hash], keys, totalKeyCount);
            if (index < 1) {
                groups[hash].add(-index, keys);
                continue;
            }
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.dupKeys"));
        }
    }

    private TimeIndexTable(Sequence code, HashUtil hashUtil, ListBase1[] entries, int totalKeyCount) {
        this._$4 = code;
        this._$3 = hashUtil;
        this._$2 = entries;
        this._$1 = totalKeyCount;
    }

    public int getCapacity() {
        return this._$3.getCapacity();
    }

    public Object find(Object key) {
        int hash = this._$3.hashCode(key);
        ListBase1 table = this._$2[hash];
        if (table == null) {
            return null;
        }
        int index = HashUtil.bsearch_a(table, key);
        if (index > 0) {
            Object[] r;
            int i = index + 1;
            int size = table.size;
            while (i <= size && Variant.isEquals((r = (Object[])table.get(i))[0], key)) {
                index = i++;
            }
            Object[] r2 = (Object[])table.get(index);
            return this._$4.getMem((Integer)r2[this._$1]);
        }
        return null;
    }

    public Object find(Object[] keys) {
        int count = keys.length;
        if (count == this._$1) {
            Object[] r;
            int hash = this._$3.hashCode(keys, count - 1);
            ListBase1 table = this._$2[hash];
            if (table == null) {
                return null;
            }
            int index = HashUtil.bsearch_a(table, keys, count);
            if (index > 0) {
                Object[] r2 = (Object[])table.get(index);
                return this._$4.getMem((Integer)r2[count]);
            }
            if ((index = -index - 1) > 0 && Variant.compareArrays(r = (Object[])table.get(index), keys, count - 1) == 0) {
                return this._$4.getMem((Integer)r[count]);
            }
            return null;
        }
        int hash = this._$3.hashCode(keys, count);
        ListBase1 table = this._$2[hash];
        if (table == null) {
            return null;
        }
        int index = HashUtil.bsearch_a(table, keys, count);
        if (index > 0) {
            Object[] r;
            int i = index + 1;
            int size = table.size;
            while (i <= size && Variant.compareArrays(r = (Object[])table.get(i), keys, count) == 0) {
                index = i++;
            }
            Object[] r3 = (Object[])table.get(index);
            return this._$4.getMem((Integer)r3[this._$1]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table select(Expression exp, Context ctx) {
        Sequence code = this._$4;
        ListBase1[] entries = this._$2;
        int len = code.length();
        int capacity = entries.length;
        ListBase1[] resultEntries = new ListBase1[capacity];
        Table result = new Table(code.dataStruct(), len);
        IArray mems = result.getMems();
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(code);
        stack.push(current);
        try {
            for (int i = 0; i < capacity; ++i) {
                ListBase1 entry = entries[i];
                if (entry == null) continue;
                int size = entry.size();
                ListBase1 resultEntry = new ListBase1(size);
                for (int j = 1; j <= size; ++j) {
                    Object[] r = (Object[])entry.get(j);
                    current.setCurrent((Integer)r[this._$1]);
                    Object b = exp.calculate(ctx);
                    if (!Variant.isTrue(b)) continue;
                    mems.add(current.getCurrent());
                    resultEntry.add(r);
                }
                if (resultEntry.size <= 0) continue;
                resultEntries[i] = resultEntry;
            }
        }
        finally {
            stack.pop();
        }
        result.trimToSize();
        TimeIndexTable indexTable = new TimeIndexTable(result, this._$3, resultEntries, this._$1);
        result.setIndexTable(indexTable);
        return result;
    }

    public int findPos(Object key) {
        int hash = this._$3.hashCode(key);
        ListBase1 table = this._$2[hash];
        if (table == null) {
            return 0;
        }
        int index = HashUtil.bsearch_a(table, key);
        if (index > 0) {
            Object[] r;
            int i = index + 1;
            int size = table.size;
            while (i <= size && Variant.isEquals((r = (Object[])table.get(i))[0], key)) {
                index = i++;
            }
            Object[] r2 = (Object[])table.get(index);
            return (Integer)r2[this._$1];
        }
        return 0;
    }

    public int findPos(Object[] keys) {
        int count = keys.length;
        if (count == this._$1) {
            Object[] r;
            int hash = this._$3.hashCode(keys, count - 1);
            ListBase1 table = this._$2[hash];
            if (table == null) {
                return 0;
            }
            int index = HashUtil.bsearch_a(table, keys, count);
            if (index > 0) {
                Object[] r2 = (Object[])table.get(index);
                return (Integer)r2[count];
            }
            if ((index = -index - 1) > 0 && Variant.compareArrays(r = (Object[])table.get(index), keys, count - 1) == 0) {
                return (Integer)r[count];
            }
            return 0;
        }
        int hash = this._$3.hashCode(keys, count);
        ListBase1 table = this._$2[hash];
        if (table == null) {
            return 0;
        }
        int index = HashUtil.bsearch_a(table, keys, count);
        if (index > 0) {
            Object[] r;
            int i = index + 1;
            int size = table.size;
            while (i <= size && Variant.compareArrays(r = (Object[])table.get(i), keys, count) == 0) {
                index = i++;
            }
            Object[] r3 = (Object[])table.get(index);
            return (Integer)r3[this._$1];
        }
        return 0;
    }

    public int[] findAllPos(IArray key) {
        if (key == null) {
            return null;
        }
        int len = key.size();
        int[] pos = new int[len + 1];
        for (int i = 1; i <= len; ++i) {
            Object obj = key.get(i);
            pos[i] = this.findPos(obj);
        }
        return pos;
    }

    public int[] findAllPos(IArray[] keys) {
        if (keys == null) {
            return null;
        }
        int keyCount = keys.length;
        int len = keys[0].size();
        int[] pos = new int[len + 1];
        Object[] objs = new Object[keyCount];
        for (int i = 1; i <= len; ++i) {
            for (int c = 0; c < keyCount; ++c) {
                objs[c] = keys[c].get(i);
            }
            pos[i] = this.findPos(objs);
        }
        return pos;
    }

    public int[] findAllPos(IArray key, BoolArray signArray) {
        if (key == null) {
            return null;
        }
        int len = key.size();
        int[] pos = new int[len + 1];
        for (int i = 1; i <= len; ++i) {
            if (signArray.isFalse(i)) continue;
            Object obj = key.get(i);
            pos[i] = this.findPos(obj);
        }
        return pos;
    }

    public int[] findAllPos(IArray[] keys, BoolArray signArray) {
        if (keys == null) {
            return null;
        }
        int keyCount = keys.length;
        int len = keys[0].size();
        int[] pos = new int[len + 1];
        Object[] objs = new Object[keyCount];
        for (int i = 1; i <= len; ++i) {
            if (signArray.isFalse(i)) continue;
            for (int c = 0; c < keyCount; ++c) {
                objs[c] = keys[c].get(i);
            }
            pos[i] = this.findPos(objs);
        }
        return pos;
    }
}

