/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.dm;

import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.dm.Env;
import com.scudata.dm.Machines;
import com.scudata.dm.Sequence;
import com.scudata.parallel.UnitClient;
import com.scudata.resources.ParallelMessage;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZoneLoader {
    private Integer _$6 = null;
    private String _$5 = null;
    private int _$4 = 0;
    private Machines _$3 = null;
    private transient ArrayList<UnitClient> _$2 = new ArrayList();
    static MessageManager _$1 = ParallelMessage.get();

    public void setArgs(Integer i, String j) {
        this._$6 = i;
        this._$5 = j;
    }

    public void setArgs(Integer n, Machines hs, String j) {
        if (n != null && n > 0) {
            this._$4 = n;
        }
        this._$3 = hs;
        this._$5 = j;
    }

    public static void connectNodes(ArrayList<UnitClient> nodes) throws Exception {
        for (int i = 0; i < nodes.size(); ++i) {
            UnitClient uc = nodes.get(i);
            uc.connect();
        }
    }

    public static void closeNodes(ArrayList<UnitClient> nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            UnitClient uc = nodes.get(i);
            uc.close();
        }
    }

    public ArrayList<UnitClient> listLiveClients(boolean deadAsNull) throws Exception {
        ArrayList<UnitClient> liveNodes = new ArrayList<UnitClient>();
        StringBuffer reason = new StringBuffer();
        for (int i = 0; i < this._$3.size(); ++i) {
            UnitClient uc = new UnitClient(this._$3.getHost(i), this._$3.getPort(i));
            if (uc.isAlive(reason)) {
                liveNodes.add(uc);
                continue;
            }
            if (!deadAsNull) continue;
            liveNodes.add(null);
        }
        return liveNodes;
    }

    public Object execute() {
        if (this._$3 != null) {
            return this._$1();
        }
        if (this._$6 == null) {
            return Env.getAreaNo(this._$5);
        }
        Env.setAreaNo(this._$5, this._$6);
        return true;
    }

    private Sequence _$1() {
        ArrayList<UnitClient> liveNodes = null;
        try {
            int i;
            Sequence nodes = new Sequence();
            if (this._$4 == 0) {
                ArrayList<UnitClient> stateNodes = this.listLiveClients(true);
                for (UnitClient uc : stateNodes) {
                    String desc = uc == null ? null : uc.toString();
                    nodes.add(desc);
                }
                Sequence i$ = nodes;
                return i$;
            }
            liveNodes = this.listLiveClients(false);
            if (liveNodes.isEmpty()) {
                Logger.debug(new Exception(_$1.getMessage("ZoneLoader.noAlives")));
                Sequence stateNodes = null;
                return stateNodes;
            }
            if (liveNodes.size() < this._$4) {
                Logger.debug(new Exception(_$1.getMessage("ZoneLoader.notEnoughAlives", liveNodes.size())));
                Sequence stateNodes = null;
                return stateNodes;
            }
            ZoneLoader.connectNodes(liveNodes);
            ArrayList<Integer> areaNos = new ArrayList<Integer>();
            for (int i2 = 0; i2 < liveNodes.size(); ++i2) {
                UnitClient uc = liveNodes.get(i2);
                Integer areaNo = uc.getAreaNo(this._$5);
                areaNos.add(areaNo);
            }
            boolean lackZone = false;
            for (i = 1; i <= this._$4; ++i) {
                Integer zone = i;
                int index = areaNos.indexOf(zone);
                if (index == -1) {
                    nodes.add(null);
                    Logger.debug("Data zone: " + i + " is not found.");
                    lackZone = true;
                    continue;
                }
                UnitClient uc = liveNodes.get(index);
                nodes.add(uc);
                Logger.debug("Found zone: " + i + " on " + uc);
                this._$2.add(uc);
            }
            if (lackZone) {
                block12: for (i = 1; i <= this._$4; ++i) {
                    UnitClient uc = (UnitClient)nodes.get(i);
                    if (uc != null) continue;
                    for (int n = 0; n < liveNodes.size(); ++n) {
                        uc = liveNodes.get(n);
                        if (this._$2.contains(uc)) continue;
                        uc.initNode(i, this._$4, this._$5);
                        nodes.set(i, uc);
                        this._$2.add(uc);
                        continue block12;
                    }
                }
            }
            Sequence sequence = nodes;
            return sequence;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception x) {
            throw new RuntimeException(x.getMessage(), x);
        }
        finally {
            if (liveNodes != null) {
                ZoneLoader.closeNodes(liveNodes);
            }
        }
    }
}

